/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kotlinx.coroutines.DisposableHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.EventLoopBase;
import org.jetbrains.kotlin.kotlinx.coroutines.TimeSourceKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\r\u0010\u0018\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0019J\u001c\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u00060\u0002j\u0002`\u0003H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u0016H\u0016J\u000e\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\bJ\b\u0010#\u001a\u00020\u000eH\u0002J\b\u0010$\u001a\u00020\u0016H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0004R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/DefaultExecutor;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/EventLoopBase;", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Runnable;", "()V", "ACTIVE", "", "DEFAULT_KEEP_ALIVE", "", "FRESH", "KEEP_ALIVE_NANOS", "SHUTDOWN_ACK", "SHUTDOWN_REQ", "_thread", "Ljava/lang/Thread;", "_thread$annotations", "debugStatus", "isCompleted", "", "()Z", "isShutdownRequested", "acknowledgeShutdownIfNeeded", "", "createThreadSync", "ensureStarted", "ensureStarted$kotlinx_coroutines_core", "invokeOnTimeout", "Lorg/jetbrains/kotlin/kotlinx/coroutines/DisposableHandle;", "timeMillis", "block", "isCorrectThread", "notifyStartup", "run", "shutdown", "timeout", "thread", "unpark", "kotlinx-coroutines-core"})
public final class DefaultExecutor
extends EventLoopBase
implements Runnable {
    private static final long DEFAULT_KEEP_ALIVE = 1000L;
    private static final long KEEP_ALIVE_NANOS;
    private static volatile Thread _thread;
    private static final int FRESH = 0;
    private static final int ACTIVE = 1;
    private static final int SHUTDOWN_REQ = 2;
    private static final int SHUTDOWN_ACK = 3;
    private static volatile int debugStatus;
    public static final DefaultExecutor INSTANCE;

    @Override
    protected boolean isCompleted() {
        return false;
    }

    private static /* synthetic */ void _thread$annotations() {
    }

    private final boolean isShutdownRequested() {
        int debugStatus = DefaultExecutor.debugStatus;
        return debugStatus == 2 || debugStatus == 3;
    }

    @Override
    @NotNull
    public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block) {
        EventLoopBase.DelayedRunnableTask delayedRunnableTask;
        Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
        EventLoopBase.DelayedRunnableTask it = delayedRunnableTask = new EventLoopBase.DelayedRunnableTask(timeMillis, block);
        INSTANCE.schedule$kotlinx_coroutines_core(it);
        return delayedRunnableTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TimeSourceKt.getTimeSource().registerTimeLoopThread();
        try {
            long shutdownNanos = Long.MAX_VALUE;
            if (!this.notifyStartup()) {
                return;
            }
            while (true) {
                Thread.interrupted();
                long parkNanos = this.processNextEvent();
                if (parkNanos == Long.MAX_VALUE) {
                    if (shutdownNanos == Long.MAX_VALUE) {
                        long tillShutdown;
                        long now = TimeSourceKt.getTimeSource().nanoTime();
                        if (shutdownNanos == Long.MAX_VALUE) {
                            shutdownNanos = now + KEEP_ALIVE_NANOS;
                        }
                        if ((tillShutdown = shutdownNanos - now) <= 0L) {
                            return;
                        }
                        parkNanos = RangesKt.coerceAtMost((long)parkNanos, (long)tillShutdown);
                    } else {
                        parkNanos = RangesKt.coerceAtMost((long)parkNanos, (long)KEEP_ALIVE_NANOS);
                    }
                }
                if (parkNanos <= 0L) continue;
                if (this.isShutdownRequested()) {
                    return;
                }
                TimeSourceKt.getTimeSource().parkNanos(this, parkNanos);
            }
        }
        finally {
            _thread = null;
            this.acknowledgeShutdownIfNeeded();
            TimeSourceKt.getTimeSource().unregisterTimeLoopThread();
            if (!this.isEmpty()) {
                this.thread();
            }
        }
    }

    private final Thread thread() {
        Thread thread = _thread;
        if (thread == null) {
            thread = this.createThreadSync();
        }
        return thread;
    }

    private final synchronized Thread createThreadSync() {
        Thread thread = _thread;
        if (thread == null) {
            Thread thread2;
            Thread $receiver;
            _thread = $receiver = (thread2 = new Thread((Runnable)this, "org.jetbrains.kotlin.kotlinx.coroutines.DefaultExecutor"));
            $receiver.setDaemon(true);
            $receiver.start();
            thread = thread2;
        }
        return thread;
    }

    @Override
    protected void unpark() {
        TimeSourceKt.getTimeSource().unpark(this.thread());
    }

    @Override
    protected boolean isCorrectThread() {
        return true;
    }

    public final synchronized void ensureStarted$kotlinx_coroutines_core() {
        boolean bl;
        boolean bl2 = bl = _thread == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        boolean bl3 = bl = debugStatus == 0 || debugStatus == 3;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        debugStatus = 0;
        this.createThreadSync();
        while (debugStatus == 0) {
            DefaultExecutor defaultExecutor = this;
            if (defaultExecutor == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)defaultExecutor).wait();
        }
    }

    private final synchronized boolean notifyStartup() {
        if (this.isShutdownRequested()) {
            return false;
        }
        debugStatus = 1;
        DefaultExecutor defaultExecutor = this;
        if (defaultExecutor == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)defaultExecutor).notifyAll();
        return true;
    }

    public final synchronized void shutdown(long timeout) {
        long deadline = System.currentTimeMillis() + timeout;
        if (!this.isShutdownRequested()) {
            debugStatus = 2;
        }
        while (debugStatus != 3 && _thread != null) {
            if (_thread != null) {
                Thread thread;
                Thread it = thread;
                TimeSourceKt.getTimeSource().unpark(it);
            }
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) break;
            DefaultExecutor defaultExecutor = this;
            if (defaultExecutor == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)defaultExecutor).wait(timeout);
        }
        debugStatus = 0;
    }

    private final synchronized void acknowledgeShutdownIfNeeded() {
        if (!this.isShutdownRequested()) {
            return;
        }
        debugStatus = 3;
        this.resetAll();
        DefaultExecutor defaultExecutor = this;
        if (defaultExecutor == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)defaultExecutor).notifyAll();
    }

    private DefaultExecutor() {
    }

    static {
        Long l;
        TimeUnit timeUnit;
        DefaultExecutor defaultExecutor;
        INSTANCE = defaultExecutor = new DefaultExecutor();
        TimeUnit timeUnit2 = TimeUnit.MILLISECONDS;
        try {
            timeUnit = timeUnit2;
            l = Long.getLong("org.jetbrains.kotlin.kotlinx.coroutines.DefaultExecutor.keepAlive", 1000L);
        }
        catch (SecurityException e) {
            timeUnit = timeUnit2;
            l = 1000L;
        }
        Long l2 = l;
        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"try {\n            java.l\u2026AULT_KEEP_ALIVE\n        }");
        KEEP_ALIVE_NANOS = timeUnit.toNanos(l2);
    }
}

