/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.javax.inject.Inject;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeProjection;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImplKt;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.FunctionPlaceholders;
import org.jetbrains.kotlin.types.FunctionPlaceholdersKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final DoubleColonExpressionResolver doubleColonExpressionResolver;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final FunctionPlaceholders functionPlaceholders;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    private ExpressionTypingServices expressionTypingServices;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull DoubleColonExpressionResolver doubleColonExpressionResolver, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull FunctionPlaceholders functionPlaceholders, @NotNull ModuleDescriptor moduleDescriptor) {
        this.typeResolver = typeResolver;
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.functionPlaceholders = functionPlaceholders;
        this.moduleDescriptor = moduleDescriptor;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        this.expressionTypingServices = expressionTypingServices;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull KotlinType actualType, @NotNull KotlinType expectedType) {
        if (FunctionPlaceholdersKt.isFunctionPlaceholder(actualType)) {
            KotlinType functionType = ConstraintSystemBuilderImplKt.createTypeForFunctionPlaceholder(actualType, expectedType);
            return KotlinTypeChecker.DEFAULT.isSubtypeOf(functionType, expectedType);
        }
        return KotlinTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof KtLambdaExpression) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        this.checkTypesForFunctionArgumentsWithNoCallee(context);
        for (KtTypeProjection ktTypeProjection : context.call.getTypeArguments()) {
            KtTypeReference typeReference = ktTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(ktTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    private void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context)) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context, KtExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context) != null;
    }

    public static boolean isCallableReferenceArgument(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        return ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context) != null;
    }

    public static boolean isFunctionLiteralOrCallableReference(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        return ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context) || ArgumentTypeResolver.isCallableReferenceArgument(expression2, context);
    }

    @Nullable
    public static KtFunction getFunctionLiteralArgumentIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        KtExpression deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (deparenthesizedExpression instanceof KtLambdaExpression) {
            return ((KtLambdaExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof KtFunction) {
            return (KtFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static KtCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull KtExpression expression2, @NotNull ResolutionContext context) {
        KtExpression deparenthesizedExpression = KtPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (deparenthesizedExpression instanceof KtCallableReferenceExpression) {
            return (KtCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public KotlinTypeInfo getArgumentTypeInfo(@Nullable KtExpression expression2, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        KotlinTypeInfo recordedTypeInfo;
        if (expression2 == null) {
            return TypeInfoFactoryKt.noTypeInfo(context);
        }
        KtFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (functionLiteralArgument != null) {
            return this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, resolveArgumentsMode, suspendFunctionTypeExpected);
        }
        KtCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (callableReferenceExpression != null) {
            return this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context, resolveArgumentsMode);
        }
        if (ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) {
            Object newContext = context.replaceContextDependency(ContextDependency.INDEPENDENT);
            return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        }
        if (UnsignedTypes.INSTANCE.isUnsignedType(context.expectedType)) {
            this.convertSignedConstantToUnsigned(expression2, context);
        }
        if ((recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context.trace.getBindingContext())) != null) {
            return recordedTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
    }

    private void convertSignedConstantToUnsigned(@NotNull KtExpression expression2, @NotNull CallResolutionContext<?> context) {
        CompileTimeConstant<?> constant = context.trace.get(BindingContext.COMPILE_TIME_VALUE, expression2);
        if (!(constant instanceof IntegerValueTypeConstant) || !ArgumentTypeResolver.constantCanBeConvertedToUnsigned(constant)) {
            return;
        }
        IntegerValueTypeConstant unsignedConstant = IntegerValueTypeConstant.convertToUnsignedConstant((IntegerValueTypeConstant)constant, this.moduleDescriptor);
        context.trace.record(BindingContext.COMPILE_TIME_VALUE, expression2, unsignedConstant);
        this.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, unsignedConstant.getUnknownIntegerType(), expression2);
    }

    public static boolean constantCanBeConvertedToUnsigned(@NotNull CompileTimeConstant<?> constant) {
        return !constant.isError() && constant.getParameters().isPure();
    }

    @NotNull
    public KotlinTypeInfo getCallableReferenceTypeInfo(@NotNull KtExpression expression2, @NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context, true);
            return TypeInfoFactoryKt.createTypeInfo(type2);
        }
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
    }

    @Nullable
    public KotlinType getShapeTypeOfCallableReference(@NotNull KtCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, boolean expectedTypeIsUnknown) {
        Pair<DoubleColonLHS, OverloadResolutionResults<?>> pair = this.doubleColonExpressionResolver.resolveCallableReference(callableReferenceExpression, ExpressionTypingContext.newContext(context), ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        DoubleColonLHS lhs = (DoubleColonLHS)pair.getFirst();
        OverloadResolutionResults overloadResolutionResults = (OverloadResolutionResults)pair.getSecond();
        if (overloadResolutionResults == null) {
            return null;
        }
        if (ArgumentTypeResolver.isSingleAndPossibleTransformToSuccess(overloadResolutionResults)) {
            ResolvedCall resolvedCall2 = OverloadResolutionResultsUtil.getResultingCall(overloadResolutionResults, context);
            if (resolvedCall2 == null) {
                return null;
            }
            return DoubleColonExpressionResolver.Companion.createKCallableTypeForReference((CallableDescriptor)resolvedCall2.getResultingDescriptor(), lhs, this.reflectionTypes, context.scope.getOwnerDescriptor());
        }
        if (expectedTypeIsUnknown) {
            return this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false);
        }
        return FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
    }

    private static boolean isSingleAndPossibleTransformToSuccess(@NotNull OverloadResolutionResults<?> overloadResolutionResults) {
        if (!overloadResolutionResults.isSingleResult()) {
            return false;
        }
        ResolvedCall call2 = (ResolvedCall)CollectionsKt.singleOrNull(overloadResolutionResults.getResultingCalls());
        return call2 != null && call2.getStatus().possibleTransformToSuccess();
    }

    @NotNull
    public KotlinTypeInfo getFunctionLiteralTypeInfo(@NotNull KtExpression expression2, @NotNull KtFunction functionLiteral, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode, boolean suspendFunctionTypeExpected) {
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            KotlinType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, true, suspendFunctionTypeExpected);
            return TypeInfoFactoryKt.createTypeInfo(type2, context);
        }
        return this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
    }

    @Nullable
    public KotlinType getShapeTypeOfFunctionLiteral(@NotNull KtFunction function2, @NotNull LexicalScope scope, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown, boolean suspendFunctionTypeExpected) {
        boolean isFunctionLiteral = function2 instanceof KtFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? this.functionPlaceholders.createFunctionPlaceholderType(Collections.emptyList(), false) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), null, Collections.emptyList(), null, TypeUtils.DONT_CARE);
        }
        List<KtParameter> valueParameters2 = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList<KotlinType> parameterTypes = new ArrayList<KotlinType>(valueParameters2.size());
        ArrayList<Name> parameterNames = new ArrayList<Name>(valueParameters2.size());
        for (KtParameter parameter : valueParameters2) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope, temporaryTrace, TypeUtils.DONT_CARE));
            Name name = parameter.getNameAsName();
            if (name == null) {
                name = SpecialNames.NO_NAME_PROVIDED;
            }
            parameterNames.add(name);
        }
        KotlinType returnType2 = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        KotlinType receiverType = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? this.functionPlaceholders.createFunctionPlaceholderType(parameterTypes, true) : FunctionTypesKt.createFunctionType(this.builtIns, Annotations.Companion.getEMPTY(), receiverType, parameterTypes, parameterNames, returnType2, suspendFunctionTypeExpected);
    }

    @Nullable
    public KotlinType resolveTypeRefWithDefault(@Nullable KtTypeReference returnTypeRef, @NotNull LexicalScope scope, @NotNull BindingTrace trace, @Nullable KotlinType defaultValue) {
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        Call call2 = context.call;
        for (ValueArgument valueArgument : call2.getValueArguments()) {
            KtExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null || ArgumentTypeResolver.isCollectionLiteralInsideAnnotation(expression2, context)) continue;
            CallResolutionContext newContext = (CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, resolveArgumentsMode, false);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context, @NotNull KtExpression expression2) {
        return this.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, expression2);
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KtExpression expression2) {
        KotlinType type2 = trace.getType(expression2);
        return type2 != null ? this.updateResultArgumentTypeIfNotDenotable(trace, statementFilter, expectedType, type2, expression2) : null;
    }

    @Nullable
    public KotlinType updateResultArgumentTypeIfNotDenotable(@NotNull BindingTrace trace, @NotNull StatementFilter statementFilter, @NotNull KotlinType expectedType, @NotNull KotlinType targetType, @NotNull KtExpression expression2) {
        TypeConstructor typeConstructor2 = targetType.getConstructor();
        if (!typeConstructor2.isDenotable() && typeConstructor2 instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor = (IntegerValueTypeConstructor)typeConstructor2;
            KotlinType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, expectedType);
            this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, statementFilter, trace);
            return primitiveType;
        }
        return null;
    }

    private static boolean isCollectionLiteralInsideAnnotation(KtExpression expression2, CallResolutionContext<?> context) {
        return expression2 instanceof KtCollectionLiteralExpression && context.call.getCallElement() instanceof KtAnnotationEntry;
    }
}

