/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javaslang.Function1;
import javaslang.Tuple2;
import javaslang.collection.Iterator;
import javaslang.collection.Seq;
import javaslang.collection.Set;
import javaslang.collection.Traversable;
import javaslang.control.Option;

public interface Map<K, V>
extends Serializable,
Function1<K, V>,
Traversable<Tuple2<K, V>> {
    public static <K, V> Map<K, V> narrow(Map<? extends K, ? extends V> map2) {
        return map2;
    }

    @Override
    default public V apply(K key) {
        return this.get(key).getOrElseThrow(NoSuchElementException::new);
    }

    public <K2, V2> Map<K2, V2> bimap(Function<? super K, ? extends K2> var1, Function<? super V, ? extends V2> var2);

    public boolean containsKey(K var1);

    public <K2, V2> Map<K2, V2> flatMap(BiFunction<? super K, ? super V, ? extends Iterable<Tuple2<K2, V2>>> var1);

    public Option<V> get(K var1);

    public Set<K> keySet();

    public <K2, V2> Map<K2, V2> map(BiFunction<? super K, ? super V, Tuple2<K2, V2>> var1);

    public <V2> Map<K, V2> mapValues(Function<? super V, ? extends V2> var1);

    public Map<K, V> put(K var1, V var2);

    public Map<K, V> put(Tuple2<? extends K, ? extends V> var1);

    public Map<K, V> remove(K var1);

    public Map<K, V> removeAll(Iterable<? extends K> var1);

    @Override
    public int size();

    public java.util.Map<K, V> toJavaMap();

    public Seq<V> values();

    default public boolean contains(Tuple2<K, V> element) {
        return this.get(element._1).map((? super T v2) -> Objects.equals(v2, element._2)).getOrElse(false);
    }

    public Map<K, V> distinct();

    public Map<K, V> distinctBy(Comparator<? super Tuple2<K, V>> var1);

    public <U> Map<K, V> distinctBy(Function<? super Tuple2<K, V>, ? extends U> var1);

    public Map<K, V> drop(long var1);

    public Map<K, V> dropRight(long var1);

    public Map<K, V> dropUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> dropWhile(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> filter(Predicate<? super Tuple2<K, V>> var1);

    public <C> Map<C, ? extends Map<K, V>> groupBy(Function<? super Tuple2<K, V>, ? extends C> var1);

    public Iterator<? extends Map<K, V>> grouped(long var1);

    public Map<K, V> init();

    public Option<? extends Map<K, V>> initOption();

    @Override
    default public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator();

    @Override
    default public int length() {
        return this.size();
    }

    default public <U> Seq<U> map(Function<? super Tuple2<K, V>, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.iterator().map(mapper).toStream();
    }

    public Map<K, V> merge(Map<? extends K, ? extends V> var1);

    public <U extends V> Map<K, V> merge(Map<? extends K, U> var1, BiFunction<? super V, ? super U, ? extends V> var2);

    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> partition(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> peek(Consumer<? super Tuple2<K, V>> var1);

    public Map<K, V> replace(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> replaceAll(Tuple2<K, V> var1, Tuple2<K, V> var2);

    public Map<K, V> retainAll(Iterable<? extends Tuple2<K, V>> var1);

    public Map<K, V> scan(Tuple2<K, V> var1, BiFunction<? super Tuple2<K, V>, ? super Tuple2<K, V>, ? extends Tuple2<K, V>> var2);

    public Iterator<? extends Map<K, V>> sliding(long var1);

    public Iterator<? extends Map<K, V>> sliding(long var1, long var3);

    public Tuple2<? extends Map<K, V>, ? extends Map<K, V>> span(Predicate<? super Tuple2<K, V>> var1);

    @Override
    default public Spliterator<Tuple2<K, V>> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.length(), 1040);
    }

    public Map<K, V> tail();

    public Option<? extends Map<K, V>> tailOption();

    public Map<K, V> take(long var1);

    public Map<K, V> takeRight(long var1);

    public Map<K, V> takeUntil(Predicate<? super Tuple2<K, V>> var1);

    public Map<K, V> takeWhile(Predicate<? super Tuple2<K, V>> var1);
}

