/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public class BuildCacheKeyInputs {
    private final ImplementationSnapshot taskImplementation;
    private final List<ImplementationSnapshot> actionImplementations;
    private final ImmutableSortedMap<String, HashCode> inputValueHashes;
    private final ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles;
    private final ImmutableSortedMap<String, String> nonCacheableInputProperties;
    private final ImmutableSortedSet<String> outputPropertyNames;

    public BuildCacheKeyInputs(@Nullable ImplementationSnapshot taskImplementation, @Nullable ImmutableList<ImplementationSnapshot> actionImplementations, @Nullable ImmutableSortedMap<String, HashCode> inputValueHashes, @Nullable ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFiles, @Nullable ImmutableSortedMap<String, String> nonCacheableInputProperties, @Nullable ImmutableSortedSet<String> outputPropertyNames) {
        this.taskImplementation = taskImplementation;
        this.actionImplementations = actionImplementations;
        this.inputValueHashes = inputValueHashes;
        this.inputFiles = inputFiles;
        this.nonCacheableInputProperties = nonCacheableInputProperties;
        this.outputPropertyNames = outputPropertyNames;
    }

    @Nullable
    public ImplementationSnapshot getTaskImplementation() {
        return this.taskImplementation;
    }

    @Nullable
    public List<ImplementationSnapshot> getActionImplementations() {
        return this.actionImplementations;
    }

    @Nullable
    public ImmutableSortedMap<String, HashCode> getInputValueHashes() {
        return this.inputValueHashes;
    }

    @Nullable
    public ImmutableSortedMap<String, CurrentFileCollectionFingerprint> getInputFiles() {
        return this.inputFiles;
    }

    @Nullable
    public ImmutableSortedMap<String, String> getNonCacheableInputProperties() {
        return this.nonCacheableInputProperties;
    }

    @Nullable
    public ImmutableSortedSet<String> getOutputPropertyNames() {
        return this.outputPropertyNames;
    }

    public String toString() {
        return "BuildCacheKeyInputs{taskImplementation=" + this.taskImplementation + ", actionImplementations=" + this.actionImplementations + ", inputValueHashes=" + this.inputValueHashes + ", inputFiles=" + this.inputFiles + ", nonCacheableInputProperties=" + this.nonCacheableInputProperties + ", outputPropertyNames=" + this.outputPropertyNames + '}';
    }
}

