/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.stubs.elements;

import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.stubs.IndexSink;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubInputStream;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubOutputStream;
import org.jetbrains.kotlin.com.intellij.util.io.StringRef;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.stubs.KotlinObjectStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementType;
import org.jetbrains.kotlin.psi.stubs.elements.StubIndexService;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.Utils;

public class KtObjectElementType
extends KtStubElementType<KotlinObjectStub, KtObjectDeclaration> {
    public KtObjectElementType(@NotNull @NonNls String debugName) {
        super(debugName, KtObjectDeclaration.class, KotlinObjectStub.class);
    }

    @Override
    @NotNull
    public KotlinObjectStub createStub(@NotNull KtObjectDeclaration psi, StubElement parentStub) {
        String name = psi.getName();
        FqName fqName2 = KtPsiUtilKt.safeFqNameForLazyResolve(psi);
        List<String> superNames = KtPsiUtilKt.getSuperNames(psi);
        return new KotlinObjectStubImpl(parentStub, StringRef.fromString(name), fqName2, Utils.INSTANCE.wrapStrings(superNames), psi.isTopLevel(), psi.isCompanion(), psi.isLocal(), psi.isObjectLiteral());
    }

    @Override
    public void serialize(@NotNull KotlinObjectStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        dataStream.writeName(stub.getName());
        FqName fqName2 = stub.getFqName();
        dataStream.writeName(fqName2 != null ? fqName2.toString() : null);
        dataStream.writeBoolean(stub.isTopLevel());
        dataStream.writeBoolean(stub.isCompanion());
        dataStream.writeBoolean(stub.isLocal());
        dataStream.writeBoolean(stub.isObjectLiteral());
        List<String> superNames = stub.getSuperNames();
        dataStream.writeVarInt(superNames.size());
        for (String name : superNames) {
            dataStream.writeName(name);
        }
    }

    @Override
    @NotNull
    public KotlinObjectStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        StringRef name = dataStream.readName();
        StringRef fqNameStr = dataStream.readName();
        FqName fqName2 = fqNameStr != null ? new FqName(fqNameStr.toString()) : null;
        boolean isTopLevel = dataStream.readBoolean();
        boolean isCompanion = dataStream.readBoolean();
        boolean isLocal = dataStream.readBoolean();
        boolean isObjectLiteral = dataStream.readBoolean();
        int superCount = dataStream.readVarInt();
        StringRef[] superNames = StringRef.createArray(superCount);
        for (int i = 0; i < superCount; ++i) {
            superNames[i] = dataStream.readName();
        }
        return new KotlinObjectStubImpl(parentStub, name, fqName2, superNames, isTopLevel, isCompanion, isLocal, isObjectLiteral);
    }

    @Override
    public void indexStub(@NotNull KotlinObjectStub stub, @NotNull IndexSink sink) {
        StubIndexService.getInstance().indexObject(stub, sink);
    }
}

