/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal;

import java.util.Objects;
import org.gradle.api.model.ObjectFactory;
import org.gradle.nativeplatform.MachineArchitecture;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;

public class DefaultTargetMachineFactory
implements TargetMachineFactory {
    private final ObjectFactory objectFactory;

    public DefaultTargetMachineFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public TargetMachine host() {
        DefaultNativePlatform host = DefaultNativePlatform.host();
        OperatingSystemFamily operatingSystemFamily = (OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, host.getOperatingSystem().toFamilyName());
        MachineArchitecture machineArchitecture = (MachineArchitecture)this.objectFactory.named(MachineArchitecture.class, host.getArchitecture().getName());
        return new TargetMachineImpl(operatingSystemFamily, machineArchitecture);
    }

    @Override
    public TargetMachine getWindows() {
        return new TargetMachineImpl((OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, "windows"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachine getLinux() {
        return new TargetMachineImpl((OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, "linux"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachine getMacOS() {
        return new TargetMachineImpl((OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, "macos"), this.getDefaultArchitecture());
    }

    @Override
    public TargetMachine os(String operatingSystemFamily) {
        return new TargetMachineImpl((OperatingSystemFamily)this.objectFactory.named(OperatingSystemFamily.class, operatingSystemFamily), this.getDefaultArchitecture());
    }

    private MachineArchitecture getDefaultArchitecture() {
        return (MachineArchitecture)this.objectFactory.named(MachineArchitecture.class, DefaultNativePlatform.host().getArchitecture().getName());
    }

    private class TargetMachineImpl
    implements TargetMachine {
        private final OperatingSystemFamily operatingSystemFamily;
        private final MachineArchitecture architecture;

        public TargetMachineImpl(OperatingSystemFamily operatingSystemFamily, MachineArchitecture architecture) {
            this.operatingSystemFamily = operatingSystemFamily;
            this.architecture = architecture;
        }

        @Override
        public OperatingSystemFamily getOperatingSystemFamily() {
            return this.operatingSystemFamily;
        }

        @Override
        public MachineArchitecture getArchitecture() {
            return this.architecture;
        }

        @Override
        public TargetMachine getX86() {
            return new TargetMachineImpl(this.operatingSystemFamily, (MachineArchitecture)DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, "x86"));
        }

        @Override
        public TargetMachine getX86_64() {
            return new TargetMachineImpl(this.operatingSystemFamily, (MachineArchitecture)DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, "x86-64"));
        }

        @Override
        public TargetMachine architecture(String architecture) {
            return new TargetMachineImpl(this.operatingSystemFamily, (MachineArchitecture)DefaultTargetMachineFactory.this.objectFactory.named(MachineArchitecture.class, architecture));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TargetMachineImpl that = (TargetMachineImpl)o;
            return Objects.equals(this.operatingSystemFamily, that.operatingSystemFamily) && Objects.equals(this.architecture, that.architecture);
        }

        public int hashCode() {
            return Objects.hash(this.operatingSystemFamily, this.architecture);
        }

        public String toString() {
            return this.operatingSystemFamily.getName() + ":" + this.architecture.getName();
        }
    }
}

