/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.bundling;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.CopySpec;
import org.gradle.api.internal.file.copy.CopyActionExecuter;
import org.gradle.api.tasks.AbstractCopyTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.GUtil;

public abstract class AbstractArchiveTask
extends AbstractCopyTask {
    private File destinationDir;
    private String customName;
    private String baseName;
    private String appendix;
    private String version;
    private String extension;
    private String classifier = "";
    private boolean preserveFileTimestamps = true;
    private boolean reproducibleFileOrder;

    @Internal(value="Represented as part of archivePath")
    public String getArchiveName() {
        if (this.customName != null) {
            return this.customName;
        }
        String name = (String)GUtil.elvis((Object)this.getBaseName(), (Object)"") + this.maybe(this.getBaseName(), this.getAppendix());
        name = name + this.maybe(name, this.getVersion());
        name = name + this.maybe(name, this.getClassifier());
        name = name + (GUtil.isTrue((Object)this.getExtension()) ? "." + this.getExtension() : "");
        return name;
    }

    public void setArchiveName(String name) {
        this.customName = name;
    }

    private String maybe(String prefix, String value) {
        if (GUtil.isTrue((Object)value)) {
            if (GUtil.isTrue((Object)prefix)) {
                return "-".concat(value);
            }
            return value;
        }
        return "";
    }

    @OutputFile
    public File getArchivePath() {
        File destinationDir = this.getDestinationDir();
        if (destinationDir == null) {
            throw new InvalidUserDataException("The destinationDir property must be set. Please apply the base plugin or set it explicitly.");
        }
        return new File(destinationDir, this.getArchiveName());
    }

    @Internal(value="Represented as part of archivePath")
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @Internal(value="Represented as part of archiveName")
    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    @Internal(value="Represented as part of archiveName")
    public String getAppendix() {
        return this.appendix;
    }

    public void setAppendix(String appendix) {
        this.appendix = appendix;
    }

    @Internal(value="Represented as part of archiveName")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Internal(value="Represented as part of archiveName")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Internal(value="Represented as part of archiveName")
    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    @Override
    public AbstractArchiveTask into(Object destPath) {
        super.into(destPath);
        return this;
    }

    @Override
    public AbstractArchiveTask into(Object destPath, Closure configureClosure) {
        super.into(destPath, configureClosure);
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Action<? super CopySpec> copySpec) {
        super.into(destPath, copySpec);
        return this;
    }

    @Input
    public boolean isPreserveFileTimestamps() {
        return this.preserveFileTimestamps;
    }

    public void setPreserveFileTimestamps(boolean preserveFileTimestamps) {
        this.preserveFileTimestamps = preserveFileTimestamps;
    }

    @Input
    public boolean isReproducibleFileOrder() {
        return this.reproducibleFileOrder;
    }

    public void setReproducibleFileOrder(boolean reproducibleFileOrder) {
        this.reproducibleFileOrder = reproducibleFileOrder;
    }

    @Override
    protected CopyActionExecuter createCopyActionExecuter() {
        Instantiator instantiator = this.getInstantiator();
        org.gradle.internal.nativeplatform.filesystem.FileSystem fileSystem = this.getFileSystem();
        return new CopyActionExecuter(instantiator, (FileSystem)fileSystem, this.isReproducibleFileOrder());
    }
}

