/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.TaskDestroyablePropertySpec;
import org.gradle.api.internal.tasks.TaskInputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskInputPropertySpec;
import org.gradle.api.internal.tasks.TaskLocalStatePropertySpec;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.internal.reflect.Instantiator;

public class PropertyAssociationTaskFactory
implements ITaskFactory {
    private final ITaskFactory delegate;
    private final PropertyWalker propertyWalker;

    public PropertyAssociationTaskFactory(ITaskFactory delegate, PropertyWalker propertyWalker) {
        this.delegate = delegate;
        this.propertyWalker = propertyWalker;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new PropertyAssociationTaskFactory(this.delegate.createChild(project, instantiator), this.propertyWalker);
    }

    @Override
    public <S extends Task> S create(TaskIdentity<S> taskIdentity, Object ... args) {
        S task = this.delegate.create(taskIdentity, args);
        TaskPropertyUtils.visitProperties(this.propertyWalker, (TaskInternal)task, new Listener((Task)task));
        return task;
    }

    private static class Listener
    implements PropertyVisitor {
        private final Task task;

        public Listener(Task task) {
            this.task = task;
        }

        @Override
        public boolean visitOutputFilePropertiesOnly() {
            return true;
        }

        @Override
        public void visitInputFileProperty(TaskInputFilePropertySpec inputFileProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitInputProperty(TaskInputPropertySpec inputProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitDestroyableProperty(TaskDestroyablePropertySpec destroyableProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitLocalStateProperty(TaskLocalStatePropertySpec localStateProperty) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitOutputFileProperty(TaskOutputFilePropertySpec property) {
            property.attachProducer(this.task);
        }
    }
}

