/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskActionFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.reflect.Instantiator;

public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final TaskClassInfoStore taskClassInfoStore;
    private final ITaskFactory taskFactory;

    public AnnotationProcessingTaskFactory(TaskClassInfoStore taskClassInfoStore, ITaskFactory taskFactory) {
        this.taskClassInfoStore = taskClassInfoStore;
        this.taskFactory = taskFactory;
    }

    @Override
    public ITaskFactory createChild(ProjectInternal project, Instantiator instantiator) {
        return new AnnotationProcessingTaskFactory(this.taskClassInfoStore, this.taskFactory.createChild(project, instantiator));
    }

    @Override
    public <S extends Task> S create(TaskIdentity<S> taskIdentity, Object ... args) {
        return this.process(this.taskFactory.create(taskIdentity, args));
    }

    private <S extends Task> S process(S task) {
        TaskClassInfo taskClassInfo = this.taskClassInfoStore.getTaskClassInfo(task.getClass());
        if (taskClassInfo.isIncremental()) {
            task.getOutputs().upToDateWhen((Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task element) {
                    return true;
                }
            });
        }
        for (TaskActionFactory actionFactory : taskClassInfo.getTaskActionFactories()) {
            ((TaskInternal)task).prependParallelSafeAction(actionFactory.create());
        }
        if (taskClassInfo.isCacheable()) {
            task.getOutputs().cacheIf("Annotated with @CacheableTask", Specs.SATISFIES_ALL);
        }
        return task;
    }
}

