/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.notify;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import org.gradle.BuildAdapter;
import org.gradle.BuildListener;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.internal.operations.notify.BuildOperationFinishedNotification;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener;
import org.gradle.internal.operations.notify.BuildOperationNotificationListener2;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.operations.notify.BuildOperationProgressNotification;
import org.gradle.internal.operations.notify.BuildOperationStartedNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildOperationNotificationBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildOperationNotificationBridge.class);
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final ListenerManager listenerManager;
    private State state;
    private final BuildOperationNotificationValve valve = new BuildOperationNotificationValve(){

        public void start() {
            if (BuildOperationNotificationBridge.this.state != null) {
                throw new IllegalStateException("build operation notification valve already started");
            }
            BuildOperationNotificationBridge.this.state = new State();
            BuildOperationNotificationBridge.this.buildOperationListenerManager.addListener(BuildOperationNotificationBridge.this.state.buildOperationListener);
        }

        public void stop() {
            if (BuildOperationNotificationBridge.this.state != null) {
                BuildOperationNotificationBridge.this.state.stop();
                BuildOperationNotificationBridge.this.state = null;
            }
        }
    };
    private final BuildListener buildListener = new BuildAdapter(){

        public void buildStarted(Gradle gradle) {
            if (gradle.getParent() == null) {
                gradle.rootProject((Action)new Action<Project>(){

                    public void execute(Project project) {
                        project.afterEvaluate((Action)new Action<Project>(){

                            public void execute(Project project) {
                                State s = BuildOperationNotificationBridge.this.state;
                                if (s != null && s.notificationListener == null) {
                                    BuildOperationNotificationBridge.this.valve.stop();
                                }
                            }
                        });
                    }
                });
            }
        }
    };
    private final BuildOperationNotificationListenerRegistrar registrar = new BuildOperationNotificationListenerRegistrar(){

        public void registerBuildScopeListener(BuildOperationNotificationListener notificationListener) {
            State state = this.requireState();
            BuildOperationNotificationListener2 adapted = BuildOperationNotificationBridge.adapt(notificationListener);
            state.assignSingleListener(adapted);
            BuildOperationNotificationBridge.this.buildOperationListenerManager.removeListener(state.buildOperationListener);
            state.buildOperationListener = new Adapter(adapted);
            BuildOperationNotificationBridge.this.buildOperationListenerManager.addListener(state.buildOperationListener);
            state.replayAndAttachListener = null;
        }

        public void registerBuildScopeListenerAndReceiveStoredOperations(BuildOperationNotificationListener notificationListener) {
            this.register(BuildOperationNotificationBridge.adapt(notificationListener));
        }

        public void register(BuildOperationNotificationListener2 listener) {
            State state = this.requireState();
            state.assignSingleListener(listener);
            state.replayAndAttachListener.attach(listener);
        }

        private State requireState() {
            State s = BuildOperationNotificationBridge.this.state;
            if (s == null) {
                throw new IllegalStateException("state is null");
            }
            return s;
        }
    };

    public BuildOperationNotificationBridge(BuildOperationListenerManager buildOperationListenerManager, ListenerManager listenerManager) {
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.listenerManager = listenerManager;
        listenerManager.addListener((Object)this.buildListener);
    }

    public BuildOperationNotificationListenerRegistrar getRegistrar() {
        return this.registrar;
    }

    public BuildOperationNotificationValve getValve() {
        return this.valve;
    }

    private static BuildOperationNotificationListener2 adapt(final BuildOperationNotificationListener listener) {
        return new BuildOperationNotificationListener2(){

            public void started(BuildOperationStartedNotification notification) {
                listener.started(notification);
            }

            public void progress(BuildOperationProgressNotification notification) {
            }

            public void finished(BuildOperationFinishedNotification notification) {
                listener.finished(notification);
            }
        };
    }

    private static class Finished
    implements BuildOperationFinishedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;
        private final Object result;
        private final Throwable failure;

        private Finished(long timestamp, Object id, Object parentId, Object details, Object result, Throwable failure) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
            this.result = result;
            this.failure = failure;
        }

        public long getNotificationOperationFinishedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        @Nullable
        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public Object getNotificationOperationResult() {
            return this.result;
        }

        public Throwable getNotificationOperationFailure() {
            return this.failure;
        }

        public String toString() {
            return "BuildOperationFinishedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + ", result=" + this.result + ", failure=" + this.failure + '}';
        }
    }

    private static class Progress
    implements BuildOperationProgressNotification {
        private final Object id;
        private final long timestamp;
        private final Object details;

        public Progress(Object id, long timestamp, Object details) {
            this.id = id;
            this.timestamp = timestamp;
            this.details = details;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public long getNotificationOperationProgressTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationProgressDetails() {
            return this.details;
        }
    }

    private static class Started
    implements BuildOperationStartedNotification {
        private final long timestamp;
        private final Object id;
        private final Object parentId;
        private final Object details;

        private Started(long timestamp, Object id, Object parentId, Object details) {
            this.timestamp = timestamp;
            this.id = id;
            this.parentId = parentId;
            this.details = details;
        }

        public long getNotificationOperationStartedTimestamp() {
            return this.timestamp;
        }

        public Object getNotificationOperationId() {
            return this.id;
        }

        public Object getNotificationOperationParentId() {
            return this.parentId;
        }

        public Object getNotificationOperationDetails() {
            return this.details;
        }

        public String toString() {
            return "BuildOperationStartedNotification{id=" + this.id + ", parentId=" + this.parentId + ", timestamp=" + this.timestamp + ", details=" + this.details + '}';
        }
    }

    private static class ReplayAndAttachListener
    implements BuildOperationNotificationListener2 {
        private RecordingListener recordingListener = new RecordingListener();
        private volatile BuildOperationNotificationListener2 listener = this.recordingListener;
        private final AtomicBoolean needLock = new AtomicBoolean(true);
        private final Lock lock = new ReentrantLock();

        private ReplayAndAttachListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void attach(BuildOperationNotificationListener2 realListener) {
            this.lock.lock();
            try {
                for (Object storedEvent : this.recordingListener.storedEvents) {
                    if (storedEvent instanceof BuildOperationStartedNotification) {
                        realListener.started((BuildOperationStartedNotification)storedEvent);
                        continue;
                    }
                    if (storedEvent instanceof BuildOperationProgressNotification) {
                        realListener.progress((BuildOperationProgressNotification)storedEvent);
                        continue;
                    }
                    if (!(storedEvent instanceof BuildOperationFinishedNotification)) continue;
                    realListener.finished((BuildOperationFinishedNotification)storedEvent);
                }
                this.listener = realListener;
                this.recordingListener = null;
            }
            finally {
                this.lock.unlock();
                this.needLock.set(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void started(BuildOperationStartedNotification notification) {
            if (this.needLock.get()) {
                this.lock.lock();
                try {
                    this.listener.started(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.started(notification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void progress(BuildOperationProgressNotification notification) {
            if (this.needLock.get()) {
                this.lock.lock();
                try {
                    this.listener.progress(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.progress(notification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void finished(BuildOperationFinishedNotification notification) {
            if (this.needLock.get()) {
                this.lock.lock();
                try {
                    this.listener.finished(notification);
                }
                finally {
                    this.lock.unlock();
                }
            } else {
                this.listener.finished(notification);
            }
        }

        public void reset() {
        }
    }

    private static class RecordingListener
    implements BuildOperationNotificationListener2 {
        private final Queue<Object> storedEvents = new ConcurrentLinkedQueue<Object>();

        private RecordingListener() {
        }

        public void started(BuildOperationStartedNotification notification) {
            this.storedEvents.add(notification);
        }

        public void progress(BuildOperationProgressNotification notification) {
            this.storedEvents.add(notification);
        }

        public void finished(BuildOperationFinishedNotification notification) {
            this.storedEvents.add(notification);
        }
    }

    private static class Adapter
    implements BuildOperationListener {
        private final BuildOperationNotificationListener2 notificationListener;
        private final Map<Object, Object> parents = new ConcurrentHashMap<Object, Object>();
        private final Map<Object, Object> active = new ConcurrentHashMap<Object, Object>();

        private Adapter(BuildOperationNotificationListener2 notificationListener) {
            this.notificationListener = notificationListener;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            OperationIdentifier id = buildOperation.getId();
            Object parentId = buildOperation.getParentId();
            if (parentId != null) {
                if (this.active.containsKey(parentId)) {
                    this.parents.put(id, parentId);
                } else if ((parentId = this.parents.get(parentId)) != null) {
                    this.parents.put(id, parentId);
                }
            }
            if (buildOperation.getDetails() == null) {
                return;
            }
            this.active.put(id, "");
            Started notification = new Started(startEvent.getStartTime(), id, parentId, buildOperation.getDetails());
            try {
                this.notificationListener.started((BuildOperationStartedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }

        private void maybeThrow(Throwable e) {
            if (e instanceof Error && !(e instanceof LinkageError)) {
                throw (Error)e;
            }
        }

        public void progress(OperationIdentifier buildOperationId, OperationProgressEvent progressEvent) {
            Object details = progressEvent.getDetails();
            if (details == null) {
                return;
            }
            Object owner = this.findOwner(buildOperationId);
            if (owner == null) {
                return;
            }
            this.notificationListener.progress((BuildOperationProgressNotification)new Progress(owner, progressEvent.getTime(), details));
        }

        private Object findOwner(Object id) {
            if (this.active.containsKey(id)) {
                return id;
            }
            return this.parents.get(id);
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            OperationIdentifier id = buildOperation.getId();
            Object parentId = this.parents.remove(id);
            if (this.active.remove(id) == null) {
                return;
            }
            Finished notification = new Finished(finishEvent.getEndTime(), id, parentId, buildOperation.getDetails(), finishEvent.getResult(), finishEvent.getFailure());
            try {
                this.notificationListener.finished((BuildOperationFinishedNotification)notification);
            }
            catch (Throwable e) {
                LOGGER.debug("Build operation notification listener threw an error on " + notification, e);
                this.maybeThrow(e);
            }
        }
    }

    private class State {
        private ReplayAndAttachListener replayAndAttachListener = new ReplayAndAttachListener();
        private BuildOperationListener buildOperationListener = new Adapter(this.replayAndAttachListener);
        private BuildOperationNotificationListener2 notificationListener;

        private State() {
        }

        private void assignSingleListener(BuildOperationNotificationListener2 notificationListener) {
            if (this.notificationListener != null) {
                throw new IllegalStateException("listener is already registered (implementation class " + this.notificationListener.getClass().getName() + ")");
            }
            this.notificationListener = notificationListener;
        }

        private void stop() {
            BuildOperationNotificationBridge.this.buildOperationListenerManager.removeListener(((BuildOperationNotificationBridge)BuildOperationNotificationBridge.this).state.buildOperationListener);
            BuildOperationNotificationBridge.this.listenerManager.removeListener((Object)BuildOperationNotificationBridge.this.buildListener);
        }
    }
}

