/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.userinput;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.userinput.UserInputHandler;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.UserInputRequestEvent;
import org.gradle.internal.logging.events.UserInputResumeEvent;

public class DefaultUserInputHandler
implements UserInputHandler {
    private static final List<String> YES_NO_CHOICES = Lists.newArrayList((Object[])new String[]{"yes", "no"});
    private final OutputEventListener outputEventBroadcaster;
    private final UserInputReader userInputReader;

    public DefaultUserInputHandler(OutputEventListener outputEventBroadcaster, UserInputReader userInputReader) {
        this.outputEventBroadcaster = outputEventBroadcaster;
        this.userInputReader = userInputReader;
    }

    public Boolean askYesNoQuestion(String question) {
        this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputRequestEvent(this.createPrompt(question)));
        try {
            while (true) {
                String input;
                if (this.isInputCancelled(input = this.userInputReader.readInput())) {
                    Boolean bl = null;
                    return bl;
                }
                String sanitizedInput = this.sanitizeInput(input);
                if (!YES_NO_CHOICES.contains(sanitizedInput)) continue;
                Boolean bl = BooleanUtils.toBoolean((String)sanitizedInput);
                return bl;
            }
        }
        finally {
            this.outputEventBroadcaster.onOutput((OutputEvent)new UserInputResumeEvent());
        }
    }

    private String createPrompt(String question) {
        StringBuilder prompt = new StringBuilder();
        prompt.append(question);
        prompt.append(" [");
        prompt.append(StringUtils.join(YES_NO_CHOICES, (String)", "));
        prompt.append("]");
        return prompt.toString();
    }

    private boolean isInputCancelled(String input) {
        return input == null;
    }

    private String sanitizeInput(String input) {
        return CharMatcher.JAVA_ISO_CONTROL.removeFrom((CharSequence)StringUtils.trim((String)input));
    }
}

