/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.NamedDomainObjectContainerConfigureDelegate;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.TaskIdentity;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.RealizableTaskCollection;
import org.gradle.api.internal.tasks.RealizeTaskBuildOperationType;
import org.gradle.api.internal.tasks.RegisterTaskBuildOperationType;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.internal.tasks.TaskStatistics;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.initialization.ProjectAccessListener;
import org.gradle.internal.Cast;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.Transformers;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.type.ModelType;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private static final Object[] NO_ARGS = new Object[0];
    public static final String EAGERLY_CREATE_LAZY_TASKS_PROPERTY = "org.gradle.internal.tasks.eager";
    private static final Set<String> VALID_TASK_ARGUMENTS = ImmutableSet.of((Object)"action", (Object)"dependsOn", (Object)"description", (Object)"group", (Object)"name", (Object)"overwrite", (Object[])new String[]{"type", "constructorArgs"});
    private static final Set<String> MANDATORY_TASK_ARGUMENTS = ImmutableSet.of((Object)"name", (Object)"type");
    private final ITaskFactory taskFactory;
    private final ProjectAccessListener projectAccessListener;
    private final BuildOperationExecutor buildOperationExecutor;
    private final TaskStatistics statistics;
    private final boolean eagerlyCreateLazyTasks;
    private final Map<String, TaskProvider<? extends Task>> placeholders = Maps.newLinkedHashMap();
    private MutableModelNode modelNode;
    private static final RegisterTaskBuildOperationType.Result REGISTER_RESULT = new RegisterTaskBuildOperationType.Result(){};
    private static final RealizeTaskBuildOperationType.Result REALIZE_RESULT = new RealizeTaskBuildOperationType.Result(){};

    public DefaultTaskContainer(ProjectInternal project, Instantiator instantiator, ITaskFactory taskFactory, ProjectAccessListener projectAccessListener, TaskStatistics statistics, BuildOperationExecutor buildOperationExecutor) {
        super(Task.class, instantiator, project);
        this.taskFactory = taskFactory;
        this.projectAccessListener = projectAccessListener;
        this.statistics = statistics;
        this.eagerlyCreateLazyTasks = Boolean.getBoolean(EAGERLY_CREATE_LAZY_TASKS_PROPERTY);
        this.buildOperationExecutor = buildOperationExecutor;
    }

    public Task create(Map<String, ?> options) {
        boolean replace;
        Map<String, ?> factoryOptions = options;
        if (options.containsKey("overwrite")) {
            factoryOptions = new HashMap(options);
            Object replaceStr = factoryOptions.remove("overwrite");
            replace = "true".equals(replaceStr.toString());
        } else {
            replace = false;
        }
        final Map<String, ?> actualArgs = DefaultTaskContainer.checkTaskArgsAndCreateDefaultValues(factoryOptions);
        String name = actualArgs.get("name").toString();
        if (!GUtil.isTrue((Object)name)) {
            throw new InvalidUserDataException("The task name must be provided.");
        }
        final Class type = (Class)Cast.uncheckedCast(actualArgs.get("type"));
        final TaskIdentity identity = TaskIdentity.create(name, type, this.project);
        return (Task)this.buildOperationExecutor.call((CallableBuildOperation)new CallableBuildOperation<Task>(){

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, replace, true);
            }

            public Task call(BuildOperationContext context) {
                Object action;
                Object group;
                Object description;
                Object[] constructorArgs = DefaultTaskContainer.getConstructorArgs(actualArgs);
                TaskInternal task = (TaskInternal)DefaultTaskContainer.this.createTask(identity, constructorArgs);
                DefaultTaskContainer.this.statistics.eagerTask(type);
                Object dependsOnTasks = actualArgs.get("dependsOn");
                if (dependsOnTasks != null) {
                    task.dependsOn(new Object[]{dependsOnTasks});
                }
                if ((description = actualArgs.get("description")) != null) {
                    task.setDescription(description.toString());
                }
                if ((group = actualArgs.get("group")) != null) {
                    task.setGroup(group.toString());
                }
                if ((action = actualArgs.get("action")) instanceof Action) {
                    Action taskAction = (Action)Cast.uncheckedCast(action);
                    task.doFirst(taskAction);
                } else if (action != null) {
                    Closure closure = (Closure)action;
                    task.doFirst(closure);
                }
                DefaultTaskContainer.this.addTask(task, replace);
                context.setResult((Object)REALIZE_RESULT);
                return task;
            }
        });
    }

    private static Object[] getConstructorArgs(Map<String, ?> args) {
        Object constructorArgs = args.get("constructorArgs");
        if (constructorArgs instanceof List) {
            List asList = (List)constructorArgs;
            return asList.toArray(new Object[asList.size()]);
        }
        if (constructorArgs instanceof Object[]) {
            return (Object[])constructorArgs;
        }
        if (constructorArgs != null) {
            throw new IllegalArgumentException(String.format("%s must be a List or Object[].  Received %s", "constructorArgs", constructorArgs.getClass()));
        }
        return NO_ARGS;
    }

    private static Map<String, ?> checkTaskArgsAndCreateDefaultValues(Map<String, ?> args) {
        DefaultTaskContainer.validateArgs(args);
        if (!args.keySet().containsAll(MANDATORY_TASK_ARGUMENTS)) {
            HashMap argsWithDefaults = Maps.newHashMap(args);
            DefaultTaskContainer.setIfNull(argsWithDefaults, "name", "");
            DefaultTaskContainer.setIfNull(argsWithDefaults, "type", DefaultTask.class);
            return argsWithDefaults;
        }
        return args;
    }

    private static void validateArgs(Map<String, ?> args) {
        if (!VALID_TASK_ARGUMENTS.containsAll(args.keySet())) {
            HashMap unknownArguments = new HashMap(args);
            unknownArguments.keySet().removeAll(VALID_TASK_ARGUMENTS);
            throw new InvalidUserDataException(String.format("Could not create task '%s': Unknown argument(s) in task definition: %s", args.get("name"), unknownArguments.keySet()));
        }
    }

    private static void setIfNull(Map<String, Object> map, String key, Object defaultValue) {
        if (map.get(key) == null) {
            map.put(key, defaultValue);
        }
    }

    private <T extends Task> void addTask(T task, boolean replaceExisting) {
        String name = task.getName();
        DefaultTaskCollection.DefaultTaskProvider placeholderProvider = (DefaultTaskCollection.DefaultTaskProvider)this.placeholders.remove(name);
        if (placeholderProvider != null) {
            placeholderProvider.removed = true;
            if (!replaceExisting) {
                if (this.modelNode != null) {
                    this.modelNode.removeLink(name);
                }
                this.warnAboutPlaceholderDeprecation(name);
            }
        }
        if (replaceExisting) {
            Task existing = (Task)this.findByNameWithoutRules(name);
            if (existing != null) {
                this.remove(existing);
            } else {
                DefaultTaskCollection.DefaultTaskProvider taskProvider = (DefaultTaskCollection.DefaultTaskProvider)this.findByNameLaterWithoutRules(name);
                if (taskProvider != null) {
                    taskProvider.removed = true;
                }
            }
        } else if (this.hasWithName(name)) {
            this.duplicateTask(name);
        }
        this.add(task);
    }

    private <T extends Task> T duplicateTask(String task) {
        throw new InvalidUserDataException(String.format("Cannot add task '%s' as a task with that name already exists.", task));
    }

    public <U extends Task> U maybeCreate(String name, Class<U> type) throws InvalidUserDataException {
        Task existing = this.findByName(name);
        if (existing != null) {
            return (U)((Task)Transformers.cast(type).transform((Object)existing));
        }
        return this.create(name, type);
    }

    public Task create(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.create(options).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type) {
        return this.create(name, type, NO_ARGS);
    }

    public <T extends Task> T create(String name, final Class<T> type, final Object ... constructorArgs) throws InvalidUserDataException {
        final TaskIdentity<T> identity = TaskIdentity.create(name, type, this.project);
        return (T)((Task)this.buildOperationExecutor.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                Task task = DefaultTaskContainer.this.createTask(identity, constructorArgs);
                DefaultTaskContainer.this.statistics.eagerTask(type);
                DefaultTaskContainer.this.addTask(task, false);
                context.setResult((Object)REALIZE_RESULT);
                return task;
            }

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, false, true);
            }
        }));
    }

    private <T extends Task> T createTask(TaskIdentity<T> identity, Object ... constructorArgs) throws InvalidUserDataException {
        for (int i = 0; i < constructorArgs.length; ++i) {
            if (constructorArgs[i] != null) continue;
            throw new NullPointerException(String.format("Received null for %s constructor argument #%s", identity.type.getName(), i + 1));
        }
        return this.taskFactory.create(identity, constructorArgs);
    }

    public Task create(String name) {
        return this.create(name, DefaultTask.class);
    }

    public Task create(String name, Action<? super Task> configureAction) throws InvalidUserDataException {
        Task task = this.create(name);
        configureAction.execute((Object)task);
        return task;
    }

    public Task maybeCreate(String name) {
        Task task = this.findByName(name);
        if (task != null) {
            return task;
        }
        return this.create(name);
    }

    public Task replace(String name) {
        return this.replace(name, DefaultTask.class);
    }

    public Task create(String name, Closure configureClosure) {
        return this.create(name).configure(configureClosure);
    }

    public <T extends Task> T create(String name, Class<T> type, Action<? super T> configuration) throws InvalidUserDataException {
        T task = this.create(name, type);
        configuration.execute(task);
        return task;
    }

    public TaskProvider<Task> register(String name, Action<? super Task> configurationAction) throws InvalidUserDataException {
        return (TaskProvider)Cast.uncheckedCast(this.register(name, DefaultTask.class, configurationAction));
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type, Action<? super T> configurationAction) throws InvalidUserDataException {
        return this.registerTask(name, type, configurationAction, NO_ARGS);
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type) throws InvalidUserDataException {
        return this.register(name, type, NO_ARGS);
    }

    public TaskProvider<Task> register(String name) throws InvalidUserDataException {
        return (TaskProvider)Cast.uncheckedCast(this.register(name, DefaultTask.class));
    }

    public <T extends Task> TaskProvider<T> register(String name, Class<T> type, Object ... constructorArgs) {
        return this.registerTask(name, type, null, constructorArgs);
    }

    private <T extends Task> TaskProvider<T> registerTask(String name, Class<T> type, final @Nullable Action<? super T> configurationAction, final Object ... constructorArgs) {
        if (this.hasWithName(name)) {
            this.duplicateTask(name);
        }
        final TaskIdentity<T> identity = TaskIdentity.create(name, type, this.project);
        TaskProvider provider = (TaskProvider)this.buildOperationExecutor.call(new CallableBuildOperation<TaskProvider<T>>(){

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.registerDescriptor(identity);
            }

            public TaskProvider<T> call(BuildOperationContext context) {
                DefaultTaskCollection.DefaultTaskProvider provider = (DefaultTaskCollection.DefaultTaskProvider)Cast.uncheckedCast((Object)DefaultTaskContainer.this.getInstantiator().newInstance(TaskCreatingProvider.class, new Object[]{DefaultTaskContainer.this, identity, configurationAction, constructorArgs}));
                DefaultTaskContainer.this.addLater(provider);
                context.setResult((Object)REGISTER_RESULT);
                return provider;
            }
        });
        if (this.eagerlyCreateLazyTasks) {
            provider.get();
        }
        return provider;
    }

    public <T extends Task> T replace(String name, Class<T> type) {
        final TaskIdentity<T> identity = TaskIdentity.create(name, type, this.project);
        return (T)((Task)this.buildOperationExecutor.call(new CallableBuildOperation<T>(){

            public T call(BuildOperationContext context) {
                Object task = DefaultTaskContainer.this.taskFactory.create(identity, new Object[0]);
                DefaultTaskContainer.this.addTask(task, true);
                context.setResult((Object)REALIZE_RESULT);
                return task;
            }

            public BuildOperationDescriptor.Builder description() {
                return DefaultTaskContainer.realizeDescriptor(identity, true, true);
            }
        }));
    }

    public Task findByPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        ProjectInternal project = this.project.findProject(Strings.isNullOrEmpty((String)projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        this.projectAccessListener.beforeRequestingTaskByPath(project);
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path);
    }

    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }

    public TaskContainerInternal configure(Closure configureClosure) {
        return ConfigureUtil.configureSelf(configureClosure, this, new NamedDomainObjectContainerConfigureDelegate(configureClosure, (NamedDomainObjectContainer)this));
    }

    @Override
    public NamedEntityInstantiator<Task> getEntityInstantiator() {
        return this.taskFactory;
    }

    @Override
    public DynamicObject getTasksAsDynamicObject() {
        return this.getElementsAsDynamicObject();
    }

    @Override
    public SortedSet<String> getNames() {
        SortedSet<String> names = super.getNames();
        if (this.placeholders.isEmpty() && this.modelNode == null) {
            return names;
        }
        TreeSet<String> allNames = new TreeSet<String>(names);
        allNames.addAll(this.placeholders.keySet());
        if (this.modelNode != null) {
            allNames.addAll(this.modelNode.getLinkNames());
        }
        return allNames;
    }

    @Override
    public void realize() {
        this.flushPlaceholders();
        if (this.modelNode != null) {
            this.project.getModelRegistry().realizeNode(this.modelNode.getPath());
        }
    }

    @Override
    public void discoverTasks() {
        this.project.fireDeferredConfiguration();
        if (this.modelNode != null) {
            this.project.getModelRegistry().atStateOrLater(this.modelNode.getPath(), ModelNode.State.SelfClosed);
        }
    }

    private void flushPlaceholders() {
        Iterator<TaskProvider<? extends Task>> iterator = this.placeholders.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().get();
            iterator.remove();
        }
    }

    @Override
    public void prepareForExecution(Task task) {
        assert (task.getProject() == this.project);
        if (this.modelNode != null && this.modelNode.hasLink(task.getName())) {
            this.realizeTask(MODEL_PATH.child(task.getName()), ModelNode.State.GraphClosed);
        }
    }

    private boolean maybeCreateTasks(String name) {
        TaskProvider<? extends Task> placeholder = this.placeholders.remove(name);
        if (placeholder != null) {
            placeholder.get();
            return true;
        }
        if (this.modelNode != null && this.modelNode.hasLink(name)) {
            this.realizeTask(MODEL_PATH.child(name), ModelNode.State.Initialized);
            return true;
        }
        return false;
    }

    @Override
    public Task findByName(String name) {
        Task task = (Task)super.findByName(name);
        if (task != null) {
            return task;
        }
        if (!this.maybeCreateTasks(name)) {
            return null;
        }
        this.placeholders.remove(name);
        return (Task)super.findByNameWithoutRules(name);
    }

    private Task realizeTask(ModelPath taskPath, ModelNode.State minState) {
        return (Task)this.project.getModelRegistry().atStateOrLater(taskPath, ModelType.of(Task.class), minState);
    }

    @Override
    public <T extends Task> void addPlaceholderAction(final String placeholderName, Class<T> taskType, final Action<? super T> configure) {
        if (this.findByNameWithoutRules(placeholderName) == null) {
            final TaskIdentity<T> identity = TaskIdentity.create(placeholderName, taskType, this.project);
            this.buildOperationExecutor.run(new RunnableBuildOperation(){

                public void run(BuildOperationContext context) {
                    TaskCreatingProvider provider = (TaskCreatingProvider)Cast.uncheckedCast((Object)DefaultTaskContainer.this.getInstantiator().newInstance(TaskCreatingProvider.class, new Object[]{DefaultTaskContainer.this, identity, configure, NO_ARGS}));
                    DefaultTaskContainer.this.placeholders.put(placeholderName, provider);
                    DefaultTaskContainer.this.deferredElementKnown(placeholderName, provider);
                    context.setResult((Object)REGISTER_RESULT);
                }

                public BuildOperationDescriptor.Builder description() {
                    return DefaultTaskContainer.registerDescriptor(identity);
                }
            });
        } else {
            this.warnAboutPlaceholderDeprecation(placeholderName);
        }
    }

    private void warnAboutPlaceholderDeprecation(String placeholderName) {
        DeprecationLogger.nagUserOfDeprecated((String)("Creating a custom task named '" + placeholderName + "'"), (String)("You can configure the existing task using the '" + placeholderName + " { }' syntax or create your custom task under a different name.'"));
    }

    public <U extends Task> NamedDomainObjectContainer<U> containerWithType(Class<U> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<? extends Class<? extends Task>> getCreateableTypes() {
        return Collections.singleton(this.getType());
    }

    public void setModelNode(MutableModelNode modelNode) {
        this.modelNode = modelNode;
    }

    @Override
    public void whenElementKnown(Action<? super DefaultNamedDomainObjectCollection.ElementInfo<Task>> action) {
        super.whenElementKnown(action);
        for (Map.Entry<String, TaskProvider<? extends Task>> entry : this.placeholders.entrySet()) {
            this.deferredElementKnown(entry.getKey(), (Provider)entry.getValue());
        }
    }

    @Override
    public <S extends Task> TaskCollection<S> withType(Class<S> type) {
        Instantiator instantiator = this.getInstantiator();
        return (TaskCollection)Cast.uncheckedCast((Object)instantiator.newInstance(RealizableTaskCollection.class, new Object[]{type, super.withType(type), this.modelNode, instantiator}));
    }

    private static BuildOperationDescriptor.Builder realizeDescriptor(TaskIdentity<?> identity, boolean replacement, boolean eager) {
        return BuildOperationDescriptor.displayName((String)("Realize task " + identity.identityPath)).details((Object)new RealizeDetails(identity, replacement, eager));
    }

    private static BuildOperationDescriptor.Builder registerDescriptor(TaskIdentity<?> identity) {
        return BuildOperationDescriptor.displayName((String)("Register task " + identity.identityPath)).details((Object)new RegisterDetails(identity));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RegisterDetails
    implements RegisterTaskBuildOperationType.Details {
        private final TaskIdentity<?> identity;

        RegisterDetails(TaskIdentity<?> identity) {
            this.identity = identity;
        }

        @Override
        public String getBuildPath() {
            return this.identity.buildPath.toString();
        }

        @Override
        public String getTaskPath() {
            return this.identity.projectPath.toString();
        }

        @Override
        public long getTaskId() {
            return this.identity.uniqueId;
        }

        @Override
        public boolean isReplacement() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RealizeDetails
    implements RealizeTaskBuildOperationType.Details {
        private final TaskIdentity<?> identity;
        private final boolean replacement;
        private final boolean eager;

        RealizeDetails(TaskIdentity<?> identity, boolean replacement, boolean eager) {
            this.identity = identity;
            this.replacement = replacement;
            this.eager = eager;
        }

        @Override
        public String getBuildPath() {
            return this.identity.buildPath.toString();
        }

        @Override
        public String getTaskPath() {
            return this.identity.projectPath.toString();
        }

        @Override
        public long getTaskId() {
            return this.identity.uniqueId;
        }

        @Override
        public boolean isReplacement() {
            return this.replacement;
        }

        @Override
        public boolean isEager() {
            return this.eager;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TaskCreatingProvider<I extends Task>
    extends DefaultTaskCollection.DefaultTaskProvider<I> {
        private Object[] constructorArgs;
        private I task;
        private Throwable cause;
        private ImmutableActionSet<I> onCreate;

        public TaskCreatingProvider(@Nullable TaskIdentity<I> identity, Action<? super I> configureAction, Object ... constructorArgs) {
            super(DefaultTaskContainer.this, identity);
            this.constructorArgs = constructorArgs;
            this.onCreate = ImmutableActionSet.empty().mergeFrom(DefaultTaskContainer.this.getEventRegister().getAddActions());
            DefaultTaskContainer.this.statistics.lazyTask();
            if (configureAction != null) {
                this.configure(configureAction);
            }
        }

        public void configure(Action<? super I> action) {
            if (this.task != null) {
                action.execute(this.task);
                return;
            }
            this.onCreate = this.onCreate.mergeFrom(DefaultTaskContainer.this.getEventRegister().getAddActions()).add(action);
        }

        public I getOrNull() {
            if (this.cause != null) {
                throw this.createIllegalStateException();
            }
            if (this.task == null) {
                this.task = (Task)this.getType().cast(DefaultTaskContainer.this.findByNameWithoutRules(this.getName()));
                if (this.task == null) {
                    DefaultTaskContainer.this.buildOperationExecutor.run(new RunnableBuildOperation(){

                        public void run(BuildOperationContext context) {
                            try {
                                TaskCreatingProvider.this.onCreate = TaskCreatingProvider.this.onCreate.mergeFrom(DefaultTaskContainer.this.getEventRegister().getAddActions());
                                TaskCreatingProvider.this.task = DefaultTaskContainer.this.createTask(TaskCreatingProvider.this.identity, TaskCreatingProvider.this.constructorArgs);
                                DefaultTaskContainer.this.realized(TaskCreatingProvider.this);
                                DefaultTaskContainer.this.statistics.lazyTaskRealized(TaskCreatingProvider.this.getType());
                                DefaultTaskContainer.this.add(TaskCreatingProvider.this.task, (Action)TaskCreatingProvider.this.onCreate);
                                context.setResult((Object)REALIZE_RESULT);
                            }
                            catch (RuntimeException ex) {
                                TaskCreatingProvider.this.cause = ex;
                                throw TaskCreatingProvider.this.createIllegalStateException();
                            }
                            finally {
                                TaskCreatingProvider.access$2002(TaskCreatingProvider.this, null);
                                TaskCreatingProvider.this.onCreate = ImmutableActionSet.empty();
                            }
                        }

                        public BuildOperationDescriptor.Builder description() {
                            return DefaultTaskContainer.realizeDescriptor(TaskCreatingProvider.this.identity, false, false);
                        }
                    });
                }
            }
            return this.task;
        }

        private IllegalStateException createIllegalStateException() {
            return new IllegalStateException(String.format("Could not create task '%s' (%s)", this.getName(), this.getType().getSimpleName()), this.cause);
        }

        static /* synthetic */ Object[] access$2002(TaskCreatingProvider x0, Object[] x1) {
            x0.constructorArgs = x1;
            return x1;
        }
    }
}

