/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.plugin.management.internal.DefaultPluginRequests;
import org.gradle.plugin.management.internal.PluginRequests;

public class BuildDefinition {
    @Nullable
    private final String name;
    @Nullable
    private final File buildRootDir;
    private final StartParameter startParameter;
    private final PluginRequests injectedSettingsPlugins;

    private BuildDefinition(@Nullable String name, @Nullable File buildRootDir, StartParameter startParameter, PluginRequests injectedSettingsPlugins) {
        this.name = name;
        this.buildRootDir = buildRootDir;
        this.startParameter = startParameter;
        this.injectedSettingsPlugins = injectedSettingsPlugins;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public File getBuildRootDir() {
        return this.buildRootDir;
    }

    public StartParameter getStartParameter() {
        return this.startParameter;
    }

    public PluginRequests getInjectedPluginRequests() {
        return this.injectedSettingsPlugins;
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, String name, File buildRootDir) {
        return new BuildDefinition(name, buildRootDir, BuildDefinition.configure(startParameter, buildRootDir), DefaultPluginRequests.EMPTY);
    }

    public static BuildDefinition fromStartParameterForBuild(StartParameter startParameter, File buildRootDir, PluginRequests pluginRequests) {
        return new BuildDefinition(null, buildRootDir, BuildDefinition.configure(startParameter, buildRootDir), pluginRequests);
    }

    private static StartParameter configure(StartParameter startParameter, File buildRootDir) {
        StartParameter includedBuildStartParam = startParameter.newBuild();
        includedBuildStartParam.setCurrentDir(buildRootDir);
        includedBuildStartParam.setSearchUpwards(false);
        includedBuildStartParam.setConfigureOnDemand(false);
        includedBuildStartParam.setInitScripts(startParameter.getInitScripts());
        return includedBuildStartParam;
    }

    public static BuildDefinition fromStartParameter(StartParameter startParameter) {
        return new BuildDefinition(null, null, startParameter, DefaultPluginRequests.EMPTY);
    }

    public BuildDefinition newInstance() {
        return new BuildDefinition(this.name, this.buildRootDir, this.startParameter.newInstance(), this.injectedSettingsPlugins);
    }
}

