/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ComponentMetadataListerDetails;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.repositories.AuthenticationContainer;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepositoryMetaDataProvider;
import org.gradle.api.artifacts.repositories.RepositoryLayout;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.InstantiatorFactory;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ModuleVersionPublisher;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextManager;
import org.gradle.api.internal.artifacts.ivyservice.IvyContextualMetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ConfiguredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.IvyXmlModuleDescriptorParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.ModuleMetadataParser;
import org.gradle.api.internal.artifacts.repositories.AbstractAuthenticationSupportedRepository;
import org.gradle.api.internal.artifacts.repositories.PublicationAwareRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.repositories.layout.AbstractRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.DefaultIvyPatternRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.GradleRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.IvyRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.MavenRepositoryLayout;
import org.gradle.api.internal.artifacts.repositories.layout.ResolvedPattern;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultArtifactMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultGradleModuleMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.DefaultIvyDescriptorMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.ImmutableMetadataSources;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.metadata.IvyMutableModuleMetadataFactory;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataSource;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.PatternBasedResolver;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransport;
import org.gradle.api.internal.artifacts.repositories.transport.RepositoryTransportFactory;
import org.gradle.api.internal.changedetection.state.isolation.IsolatableFactory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.MutableIvyModuleResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.caching.ImplicitInputsCapturingInstantiator;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.FileStore;
import org.gradle.internal.resource.local.LocallyAvailableResourceFinder;
import org.gradle.util.ConfigureUtil;

public class DefaultIvyArtifactRepository
extends AbstractAuthenticationSupportedRepository
implements IvyArtifactRepository,
ResolutionAwareRepository,
PublicationAwareRepository {
    private Object baseUrl;
    private AbstractRepositoryLayout layout;
    private final AdditionalPatternsRepositoryLayout additionalPatternsLayout;
    private final FileResolver fileResolver;
    private final RepositoryTransportFactory transportFactory;
    private final LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder;
    private final MetaDataProvider metaDataProvider;
    private final Instantiator instantiator;
    private final FileStore<ModuleComponentArtifactIdentifier> artifactFileStore;
    private final FileStore<String> externalResourcesFileStore;
    private final IvyContextManager ivyContextManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final InstantiatorFactory instantiatorFactory;
    private final FileResourceRepository fileResourceRepository;
    private final ModuleMetadataParser moduleMetadataParser;
    private final IvyMutableModuleMetadataFactory metadataFactory;
    private final IsolatableFactory isolatableFactory;
    private final IvyMetadataSources metadataSources = new IvyMetadataSources();

    public DefaultIvyArtifactRepository(FileResolver fileResolver, RepositoryTransportFactory transportFactory, LocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> locallyAvailableResourceFinder, FileStore<ModuleComponentArtifactIdentifier> artifactFileStore, FileStore<String> externalResourcesFileStore, AuthenticationContainer authenticationContainer, IvyContextManager ivyContextManager, ImmutableModuleIdentifierFactory moduleIdentifierFactory, InstantiatorFactory instantiatorFactory, FileResourceRepository fileResourceRepository, ModuleMetadataParser moduleMetadataParser, FeaturePreviews featurePreviews, IvyMutableModuleMetadataFactory metadataFactory, IsolatableFactory isolatableFactory) {
        super(instantiatorFactory.decorate(), authenticationContainer);
        this.fileResolver = fileResolver;
        this.transportFactory = transportFactory;
        this.locallyAvailableResourceFinder = locallyAvailableResourceFinder;
        this.artifactFileStore = artifactFileStore;
        this.externalResourcesFileStore = externalResourcesFileStore;
        this.additionalPatternsLayout = new AdditionalPatternsRepositoryLayout(fileResolver);
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiatorFactory = instantiatorFactory;
        this.fileResourceRepository = fileResourceRepository;
        this.moduleMetadataParser = moduleMetadataParser;
        this.metadataFactory = metadataFactory;
        this.isolatableFactory = isolatableFactory;
        this.layout = new GradleRepositoryLayout();
        this.metaDataProvider = new MetaDataProvider();
        this.instantiator = instantiatorFactory.decorate();
        this.ivyContextManager = ivyContextManager;
        this.metadataSources.setDefaults(featurePreviews);
    }

    @Override
    public String getDisplayName() {
        URI url = this.getUrl();
        if (url == null) {
            return super.getDisplayName();
        }
        return super.getDisplayName() + '(' + url + ')';
    }

    @Override
    public ModuleVersionPublisher createPublisher() {
        return this.createRealResolver();
    }

    @Override
    public ConfiguredModuleComponentRepository createResolver() {
        return this.createRealResolver();
    }

    protected IvyResolver createRealResolver() {
        URI uri = this.getUrl();
        LinkedHashSet<String> schemes = new LinkedHashSet<String>();
        this.layout.addSchemes(uri, schemes);
        this.additionalPatternsLayout.addSchemes(uri, schemes);
        IvyResolver resolver = this.createResolver(schemes);
        this.layout.apply(uri, resolver);
        this.additionalPatternsLayout.apply(uri, resolver);
        return resolver;
    }

    private IvyResolver createResolver(Set<String> schemes) {
        if (schemes.isEmpty()) {
            throw new InvalidUserDataException("You must specify a base url or at least one artifact pattern for an Ivy repository.");
        }
        return this.createResolver(this.transportFactory.createTransport(schemes, this.getName(), this.getConfiguredAuthentication()));
    }

    private IvyResolver createResolver(RepositoryTransport transport) {
        ImplicitInputsCapturingInstantiator injector = this.createInjectorForMetadataSuppliers(transport, this.instantiatorFactory, this.getUrl(), this.externalResourcesFileStore);
        InstantiatingAction<ComponentMetadataSupplierDetails> supplierFactory = this.createComponentMetadataSupplierFactory(injector, this.isolatableFactory);
        InstantiatingAction<ComponentMetadataListerDetails> listerFactory = this.createComponentMetadataVersionLister(injector, this.isolatableFactory);
        return new IvyResolver(this.getName(), transport, this.locallyAvailableResourceFinder, this.metaDataProvider.dynamicResolve, this.artifactFileStore, this.moduleIdentifierFactory, supplierFactory, listerFactory, this.createMetadataSources(), IvyMetadataArtifactProvider.INSTANCE, injector);
    }

    public void metadataSources(Action<? super IvyArtifactRepository.MetadataSources> configureAction) {
        this.metadataSources.reset();
        configureAction.execute((Object)this.metadataSources);
    }

    private ImmutableMetadataSources createMetadataSources() {
        ImmutableList.Builder sources = ImmutableList.builder();
        if (this.metadataSources.gradleMetadata) {
            sources.add((Object)new DefaultGradleModuleMetadataSource(this.moduleMetadataParser, this.metadataFactory, true));
        }
        if (this.metadataSources.ivyDescriptor) {
            sources.add((Object)new DefaultIvyDescriptorMetadataSource(IvyMetadataArtifactProvider.INSTANCE, this.createIvyDescriptorParser(), this.fileResourceRepository, this.moduleIdentifierFactory));
        }
        if (this.metadataSources.artifact) {
            sources.add((Object)new DefaultArtifactMetadataSource(this.metadataFactory));
        }
        return new DefaultImmutableMetadataSources((Iterable<MetadataSource<?>>)sources.build());
    }

    private MetaDataParser<MutableIvyModuleResolveMetadata> createIvyDescriptorParser() {
        return new IvyContextualMetaDataParser<MutableIvyModuleResolveMetadata>(this.ivyContextManager, new IvyXmlModuleDescriptorParser(new IvyModuleDescriptorConverter(this.moduleIdentifierFactory), this.moduleIdentifierFactory, this.fileResourceRepository, this.metadataFactory));
    }

    public URI getUrl() {
        return this.baseUrl == null ? null : this.fileResolver.resolveUri(this.baseUrl);
    }

    public void setUrl(URI url) {
        this.baseUrl = url;
    }

    public void setUrl(Object url) {
        this.baseUrl = url;
    }

    public void artifactPattern(String pattern) {
        this.additionalPatternsLayout.artifactPatterns.add(pattern);
    }

    public void ivyPattern(String pattern) {
        this.additionalPatternsLayout.ivyPatterns.add(pattern);
    }

    public void layout(String layoutName) {
        this.layout = "ivy".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(IvyRepositoryLayout.class, new Object[0]) : ("maven".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(MavenRepositoryLayout.class, new Object[0]) : ("pattern".equals(layoutName) ? (AbstractRepositoryLayout)this.instantiator.newInstance(DefaultIvyPatternRepositoryLayout.class, new Object[0]) : (AbstractRepositoryLayout)this.instantiator.newInstance(GradleRepositoryLayout.class, new Object[0])));
    }

    public void layout(String layoutName, Closure config) {
        this.layout(layoutName, (Action<? extends RepositoryLayout>)ConfigureUtil.configureUsing((Closure)config));
    }

    public void layout(String layoutName, Action<? extends RepositoryLayout> config) {
        this.layout(layoutName);
        config.execute((Object)this.layout);
    }

    public IvyArtifactRepositoryMetaDataProvider getResolve() {
        return this.metaDataProvider;
    }

    private static class IvyMetadataSources
    implements IvyArtifactRepository.MetadataSources {
        boolean gradleMetadata;
        boolean ivyDescriptor;
        boolean artifact;

        private IvyMetadataSources() {
        }

        void setDefaults(FeaturePreviews featurePreviews) {
            this.ivyDescriptor();
            if (featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.GRADLE_METADATA)) {
                this.gradleMetadata();
            } else {
                this.artifact();
            }
        }

        void reset() {
            this.gradleMetadata = false;
            this.ivyDescriptor = false;
            this.artifact = false;
        }

        public void gradleMetadata() {
            this.gradleMetadata = true;
        }

        public void ivyDescriptor() {
            this.ivyDescriptor = true;
        }

        public void artifact() {
            this.artifact = true;
        }
    }

    private static class MetaDataProvider
    implements IvyArtifactRepositoryMetaDataProvider {
        boolean dynamicResolve;

        private MetaDataProvider() {
        }

        public boolean isDynamicMode() {
            return this.dynamicResolve;
        }

        public void setDynamicMode(boolean mode) {
            this.dynamicResolve = mode;
        }
    }

    private static class AdditionalPatternsRepositoryLayout
    extends AbstractRepositoryLayout {
        private final FileResolver fileResolver;
        private final Set<String> artifactPatterns = new LinkedHashSet<String>();
        private final Set<String> ivyPatterns = new LinkedHashSet<String>();

        public AdditionalPatternsRepositoryLayout(FileResolver fileResolver) {
            this.fileResolver = fileResolver;
        }

        @Override
        public void apply(URI baseUri, PatternBasedResolver resolver) {
            for (String artifactPattern : this.artifactPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(artifactPattern, this.fileResolver);
                resolver.addArtifactLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
            Set<String> usedIvyPatterns = this.ivyPatterns.isEmpty() ? this.artifactPatterns : this.ivyPatterns;
            for (String ivyPattern : usedIvyPatterns) {
                ResolvedPattern resolvedPattern = new ResolvedPattern(ivyPattern, this.fileResolver);
                resolver.addDescriptorLocation(resolvedPattern.baseUri, resolvedPattern.pattern);
            }
        }

        @Override
        public void addSchemes(URI baseUri, Set<String> schemes) {
            for (String pattern : this.artifactPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
            for (String pattern : this.ivyPatterns) {
                schemes.add(new ResolvedPattern((String)pattern, (FileResolver)this.fileResolver).scheme);
            }
        }
    }
}

