/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ComponentMetadata;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.artifacts.ivy.IvyModuleDescriptor;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.MetadataResolutionContext;
import org.gradle.api.internal.artifacts.dsl.DefaultComponentMetadataContext;
import org.gradle.api.internal.artifacts.dsl.SpecConfigurableRule;
import org.gradle.api.internal.artifacts.dsl.WrappingComponentMetadataContext;
import org.gradle.api.internal.artifacts.ivyservice.DefaultIvyModuleDescriptor;
import org.gradle.api.internal.artifacts.ivyservice.NamespaceId;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.UserProvidedMetadata;
import org.gradle.api.internal.artifacts.repositories.resolver.ComponentMetadataDetailsAdapter;
import org.gradle.api.internal.artifacts.repositories.resolver.DependencyConstraintMetadataImpl;
import org.gradle.api.internal.artifacts.repositories.resolver.DirectDependencyMetadataImpl;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.action.ConfigurableRule;
import org.gradle.internal.action.ConfigurableRules;
import org.gradle.internal.action.DefaultConfigurableRules;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.IvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.MutableModuleComponentResolveMetadata;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.caching.ComponentMetadataRuleExecutor;
import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.SpecRuleAction;
import org.gradle.internal.typeconversion.NotationParser;

public class DefaultComponentMetadataProcessor
implements ComponentMetadataProcessor {
    private static final Transformer<ModuleComponentResolveMetadata, WrappingComponentMetadataContext> DETAILS_TO_RESULT = new Transformer<ModuleComponentResolveMetadata, WrappingComponentMetadataContext>(){

        public ModuleComponentResolveMetadata transform(WrappingComponentMetadataContext componentMetadataContext) {
            return componentMetadataContext.getMutableMetadata().asImmutable();
        }
    };
    private final Instantiator instantiator;
    private final NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser;
    private final NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser;
    private final ImmutableAttributesFactory attributesFactory;
    private final ComponentMetadataRuleExecutor ruleExecutor;
    private final MetadataResolutionContext metadataResolutionContext;
    private final Set<SpecRuleAction<? super ComponentMetadataDetails>> rules;
    private final Set<SpecConfigurableRule> classBasedRules;

    public DefaultComponentMetadataProcessor(Set<SpecRuleAction<? super ComponentMetadataDetails>> rules, Set<SpecConfigurableRule> classBasedRules, Instantiator instantiator, NotationParser<Object, DirectDependencyMetadataImpl> dependencyMetadataNotationParser, NotationParser<Object, DependencyConstraintMetadataImpl> dependencyConstraintMetadataNotationParser, ImmutableAttributesFactory attributesFactory, ComponentMetadataRuleExecutor ruleExecutor, MetadataResolutionContext resolutionContext) {
        this.rules = rules;
        this.classBasedRules = classBasedRules;
        this.instantiator = instantiator;
        this.dependencyMetadataNotationParser = dependencyMetadataNotationParser;
        this.dependencyConstraintMetadataNotationParser = dependencyConstraintMetadataNotationParser;
        this.attributesFactory = attributesFactory;
        this.ruleExecutor = ruleExecutor;
        this.metadataResolutionContext = resolutionContext;
    }

    @Override
    public ModuleComponentResolveMetadata processMetadata(ModuleComponentResolveMetadata metadata) {
        ModuleComponentResolveMetadata updatedMetadata;
        if (this.rules.isEmpty() && this.classBasedRules.isEmpty()) {
            updatedMetadata = metadata;
        } else if (this.rules.isEmpty()) {
            updatedMetadata = this.processClassRuleWithCaching(metadata, this.metadataResolutionContext);
        } else {
            MutableModuleComponentResolveMetadata mutableMetadata = metadata.asMutable();
            ComponentMetadataDetails details = (ComponentMetadataDetails)this.instantiator.newInstance(ComponentMetadataDetailsAdapter.class, new Object[]{mutableMetadata, this.instantiator, this.dependencyMetadataNotationParser, this.dependencyConstraintMetadataNotationParser});
            this.processAllRules(metadata, details, metadata.getModuleVersionId());
            updatedMetadata = mutableMetadata.asImmutable();
        }
        if (!updatedMetadata.getStatusScheme().contains(updatedMetadata.getStatus())) {
            throw new ModuleVersionResolveException(updatedMetadata.getModuleVersionId(), String.format("Unexpected status '%s' specified for %s. Expected one of: %s", updatedMetadata.getStatus(), updatedMetadata.getId().getDisplayName(), updatedMetadata.getStatusScheme()));
        }
        return updatedMetadata;
    }

    @Override
    public ComponentMetadata processMetadata(ComponentMetadata metadata) {
        ComponentMetadata updatedMetadata;
        if (this.rules.isEmpty() && this.classBasedRules.isEmpty()) {
            updatedMetadata = metadata;
        } else {
            ShallowComponentMetadataAdapter details = new ShallowComponentMetadataAdapter(metadata, this.attributesFactory);
            this.processAllRules(null, details, metadata.getId());
            updatedMetadata = details.asImmutable();
        }
        if (!updatedMetadata.getStatusScheme().contains(updatedMetadata.getStatus())) {
            throw new ModuleVersionResolveException(updatedMetadata.getId(), String.format("Unexpected status '%s' specified for %s. Expected one of: %s", updatedMetadata.getStatus(), updatedMetadata.getId().toString(), updatedMetadata.getStatusScheme()));
        }
        return updatedMetadata;
    }

    private void processAllRules(ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details, ModuleVersionIdentifier id) {
        for (SpecRuleAction<? super ComponentMetadataDetails> rule : this.rules) {
            this.processRule(rule, metadata, details);
        }
        this.processClassRule(metadata, details, id, this.metadataResolutionContext.getInjectingInstantiator());
    }

    private void processClassRule(ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details, ModuleVersionIdentifier id, Instantiator instantiator) {
        InstantiatingAction<ComponentMetadataContext> action = this.collectRulesAndCreateAction(id, instantiator);
        DefaultComponentMetadataContext componentMetadataContext = new DefaultComponentMetadataContext(details, metadata);
        try {
            action.execute((Object)componentMetadataContext);
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", details.getId()), (Throwable)e);
        }
    }

    private ModuleComponentResolveMetadata processClassRuleWithCaching(final ModuleComponentResolveMetadata metadata, MetadataResolutionContext metadataResolutionContext) {
        InstantiatingAction<ComponentMetadataContext> action = this.collectRulesAndCreateAction(metadata.getModuleVersionId(), metadataResolutionContext.getInjectingInstantiator());
        try {
            return this.ruleExecutor.execute(metadata, action, DETAILS_TO_RESULT, new Transformer<WrappingComponentMetadataContext, ModuleComponentResolveMetadata>(){

                public WrappingComponentMetadataContext transform(ModuleComponentResolveMetadata moduleVersionIdentifier) {
                    return new WrappingComponentMetadataContext(metadata, DefaultComponentMetadataProcessor.this.instantiator, (NotationParser<Object, DirectDependencyMetadataImpl>)DefaultComponentMetadataProcessor.this.dependencyMetadataNotationParser, (NotationParser<Object, DependencyConstraintMetadataImpl>)DefaultComponentMetadataProcessor.this.dependencyConstraintMetadataNotationParser);
                }
            }, metadataResolutionContext.getCachePolicy());
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", metadata.getModuleVersionId()), (Throwable)e);
        }
    }

    private InstantiatingAction<ComponentMetadataContext> collectRulesAndCreateAction(ModuleVersionIdentifier id, Instantiator instantiator) {
        ArrayList<ConfigurableRule<ComponentMetadataContext>> rules = new ArrayList<ConfigurableRule<ComponentMetadataContext>>();
        for (SpecConfigurableRule classBasedRule : this.classBasedRules) {
            if (!classBasedRule.getSpec().isSatisfiedBy((Object)id)) continue;
            rules.add(classBasedRule.getConfigurableRule());
        }
        return new InstantiatingAction((ConfigurableRules)new DefaultConfigurableRules(rules), instantiator, (InstantiatingAction.ExceptionHandler)new ExceptionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRule(SpecRuleAction<? super ComponentMetadataDetails> specRuleAction, ModuleComponentResolveMetadata metadata, ComponentMetadataDetails details) {
        if (!specRuleAction.getSpec().isSatisfiedBy((Object)details)) {
            return;
        }
        ArrayList inputs = Lists.newArrayList();
        RuleAction<? super ComponentMetadataDetails> action = specRuleAction.getAction();
        for (Class<?> inputType : action.getInputTypes()) {
            if (inputType == IvyModuleDescriptor.class) {
                if (!(metadata instanceof IvyModuleResolveMetadata)) {
                    return;
                }
                IvyModuleResolveMetadata ivyMetadata = (IvyModuleResolveMetadata)metadata;
                inputs.add(new DefaultIvyModuleDescriptor((Map<NamespaceId, String>)ivyMetadata.getExtraAttributes(), ivyMetadata.getBranch(), ivyMetadata.getStatus()));
                continue;
            }
            throw new IllegalStateException();
        }
        try {
            DefaultComponentMetadataProcessor i$ = this;
            synchronized (i$) {
                action.execute((ComponentMetadataDetails)details, inputs);
            }
        }
        catch (InvalidUserCodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", details.getId()), (Throwable)e);
        }
    }

    static class ShallowComponentMetadataAdapter
    implements ComponentMetadataDetails {
        private final ModuleVersionIdentifier id;
        private boolean changing;
        private List<String> statusScheme;
        private AttributeContainerInternal attributes;

        public ShallowComponentMetadataAdapter(ComponentMetadata source, ImmutableAttributesFactory attributesFactory) {
            this.id = source.getId();
            this.changing = source.isChanging();
            this.statusScheme = source.getStatusScheme();
            this.attributes = attributesFactory.mutable((AttributeContainerInternal)source.getAttributes());
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public void setStatus(String status) {
            this.attributes.attribute(ProjectInternal.STATUS_ATTRIBUTE, (Object)status);
        }

        public void setStatusScheme(List<String> statusScheme) {
            this.statusScheme = statusScheme;
        }

        public void withVariant(String name, Action<? super VariantMetadata> action) {
        }

        public void allVariants(Action<? super VariantMetadata> action) {
        }

        public ModuleVersionIdentifier getId() {
            return this.id;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public String getStatus() {
            return (String)this.attributes.getAttribute(ProjectInternal.STATUS_ATTRIBUTE);
        }

        public List<String> getStatusScheme() {
            return this.statusScheme;
        }

        public ComponentMetadataDetails attributes(Action<? super AttributeContainer> action) {
            action.execute((Object)this.attributes);
            return this;
        }

        public AttributeContainer getAttributes() {
            return this.attributes;
        }

        public ComponentMetadata asImmutable() {
            return new UserProvidedMetadata(this.id, this.statusScheme, this.attributes.asImmutable());
        }
    }

    private static class ExceptionHandler
    implements InstantiatingAction.ExceptionHandler<ComponentMetadataContext> {
        private ExceptionHandler() {
        }

        public void handleException(ComponentMetadataContext context, Throwable throwable) {
            throw new InvalidUserCodeException(String.format("There was an error while evaluating a component metadata rule for %s.", context.getDetails().getId()), throwable);
        }
    }
}

