/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal;

import java.io.File;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CleanupActionFactory;
import org.gradle.cache.internal.FixedAgeOldestCacheCleanup;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.util.GFileUtils;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.internal.GitVersionControlSystem;
import org.gradle.vcs.internal.SimpleVersionControlSystem;
import org.gradle.vcs.internal.VcsWorkingDirectoryRoot;
import org.gradle.vcs.internal.VersionControlSystem;
import org.gradle.vcs.internal.VersionControlSystemFactory;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.spec.DirectoryRepositorySpec;

public class DefaultVersionControlSystemFactory
implements VersionControlSystemFactory,
Stoppable {
    private final PersistentCache vcsWorkingDirCache;

    DefaultVersionControlSystemFactory(VcsWorkingDirectoryRoot workingDirectoryRoot, CacheRepository cacheRepository, CleanupActionFactory cleanupActionFactory) {
        this.vcsWorkingDirCache = cacheRepository.cache(workingDirectoryRoot.getDir()).withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).withDisplayName("VCS Checkout Cache").withCleanup(cleanupActionFactory.create((CleanupAction)new FixedAgeOldestCacheCleanup(7L))).open();
    }

    public VersionControlSystem create(VersionControlSpec spec) {
        Object vcs = spec instanceof DirectoryRepositorySpec ? new SimpleVersionControlSystem() : new GitVersionControlSystem();
        return new LockingVersionControlSystem((VersionControlSystem)vcs, (CacheAccess)this.vcsWorkingDirCache);
    }

    public void stop() {
        this.vcsWorkingDirCache.close();
    }

    private static final class LockingVersionControlSystem
    implements VersionControlSystem {
        private final VersionControlSystem delegate;
        private final CacheAccess cacheAccess;

        private LockingVersionControlSystem(VersionControlSystem delegate, CacheAccess cacheAccess) {
            this.delegate = delegate;
            this.cacheAccess = cacheAccess;
        }

        public VersionRef getDefaultBranch(VersionControlSpec spec) {
            try {
                return this.delegate.getDefaultBranch(spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate default branch for '%s'.", spec.getDisplayName()), (Throwable)e);
            }
        }

        @Nullable
        public VersionRef getBranch(VersionControlSpec spec, String branch) {
            try {
                return this.delegate.getBranch(spec, branch);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not locate branch '%s' for '%s'.", branch, spec.getDisplayName()), (Throwable)e);
            }
        }

        public Set<VersionRef> getAvailableVersions(VersionControlSpec spec) {
            try {
                return this.delegate.getAvailableVersions(spec);
            }
            catch (Exception e) {
                throw new GradleException(String.format("Could not list available versions for '%s'.", spec.getDisplayName()), (Throwable)e);
            }
        }

        public File populate(final File versionDir, final VersionRef ref, final VersionControlSpec spec) {
            return (File)this.cacheAccess.useCache((Factory)new Factory<File>(){

                @Nullable
                public File create() {
                    GFileUtils.mkdirs((File)versionDir);
                    GFileUtils.touch((File)versionDir);
                    try {
                        return LockingVersionControlSystem.this.delegate.populate(versionDir, ref, spec);
                    }
                    catch (Exception e) {
                        throw new GradleException(String.format("Could not populate %s from '%s'.", versionDir, spec.getDisplayName()), (Throwable)e);
                    }
                }
            });
        }
    }
}

