/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.operation;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.AbstractBinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.operation.BinaryOperationIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004\r\u000e\u000f\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsicFactory;", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/BinaryOperationIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "leftType", "Lorg/jetbrains/kotlin/types/KotlinType;", "rightType", "getSupportTokens", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "CompareCharToPrimitiveIntrinsic", "CompareToCharIntrinsic", "CompareToFunctionIntrinsic", "CompareToIntrinsic", "js.translator"})
public final class CompareToBOIF
implements BinaryOperationIntrinsicFactory {
    public static final CompareToBOIF INSTANCE;

    @NotNull
    public Set<KtSingleValueToken> getSupportTokens() {
        ImmutableSet<KtSingleValueToken> immutableSet = OperatorConventions.COMPARISON_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(immutableSet, (String)"OperatorConventions.COMPARISON_OPERATIONS");
        return immutableSet;
    }

    @Override
    @Nullable
    public BinaryOperationIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2, @Nullable KotlinType leftType, @Nullable KotlinType rightType) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (DynamicCallsKt.isDynamic(descriptor2)) {
            return CompareToIntrinsic.INSTANCE;
        }
        if (leftType == null || rightType == null) {
            return null;
        }
        if (!KotlinBuiltIns.isBuiltIn(descriptor2)) {
            return null;
        }
        return KotlinBuiltIns.isCharOrNullableChar(rightType) ? (BinaryOperationIntrinsic)CompareToCharIntrinsic.INSTANCE : (KotlinBuiltIns.isCharOrNullableChar(leftType) ? (BinaryOperationIntrinsic)CompareCharToPrimitiveIntrinsic.INSTANCE : (KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(leftType) && KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType(rightType) ? (BinaryOperationIntrinsic)CompareToIntrinsic.INSTANCE : (BinaryOperationIntrinsic)CompareToFunctionIntrinsic.INSTANCE));
    }

    private CompareToBOIF() {
    }

    static {
        CompareToBOIF compareToBOIF;
        INSTANCE = compareToBOIF = new CompareToBOIF();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class CompareToIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression2));
            return new JsBinaryOperation(operator, left, right);
        }

        private CompareToIntrinsic() {
        }

        static {
            CompareToIntrinsic compareToIntrinsic;
            INSTANCE = compareToIntrinsic = new CompareToIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToCharIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class CompareToCharIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToCharIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression2));
            return new JsBinaryOperation(operator, left, JsAstUtils.charToInt(right));
        }

        private CompareToCharIntrinsic() {
        }

        static {
            CompareToCharIntrinsic compareToCharIntrinsic;
            INSTANCE = compareToCharIntrinsic = new CompareToCharIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareCharToPrimitiveIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class CompareCharToPrimitiveIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareCharToPrimitiveIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression2));
            return new JsBinaryOperation(operator, JsAstUtils.charToInt(left), right);
        }

        private CompareCharToPrimitiveIntrinsic() {
        }

        static {
            CompareCharToPrimitiveIntrinsic compareCharToPrimitiveIntrinsic;
            INSTANCE = compareCharToPrimitiveIntrinsic = new CompareCharToPrimitiveIntrinsic();
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/CompareToBOIF$CompareToFunctionIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/operation/AbstractBinaryOperationIntrinsic;", "()V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "left", "right", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class CompareToFunctionIntrinsic
    extends AbstractBinaryOperationIntrinsic {
        public static final CompareToFunctionIntrinsic INSTANCE;

        @Override
        @NotNull
        public JsExpression apply(@NotNull KtBinaryExpression expression2, @NotNull JsExpression left, @NotNull JsExpression right, @NotNull TranslationContext context) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
            Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            JsBinaryOperator operator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken(expression2));
            JsExpression compareTo = JsAstUtils.compareTo(left, right);
            return new JsBinaryOperation(operator, compareTo, new JsIntLiteral(0));
        }

        private CompareToFunctionIntrinsic() {
        }

        static {
            CompareToFunctionIntrinsic compareToFunctionIntrinsic;
            INSTANCE = compareToFunctionIntrinsic = new CompareToFunctionIntrinsic();
        }
    }
}

