/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.indexing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.indexing.IndexId;
import org.jetbrains.kotlin.gnu.trove.TObjectIntHashMap;
import org.jetbrains.kotlin.gnu.trove.TObjectIntProcedure;

public class ID<K, V>
extends IndexId<K, V> {
    private static final ConcurrentIntObjectMap<ID> ourRegistry = ContainerUtil.createConcurrentIntObjectMap();
    private static final TObjectIntHashMap<String> ourNameToIdRegistry = new TObjectIntHashMap();
    private final short myUniqueId;

    private static File getEnumFile() {
        File indexFolder = PathManager.getIndexRoot();
        return new File(indexFolder, "indices.enum");
    }

    protected ID(String name) {
        super(name);
        this.myUniqueId = ID.stringToId(name);
        ID old = ourRegistry.put(this.myUniqueId, this);
        assert (old == null) : "ID with name '" + name + "' is already registered";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static short stringToId(String name) {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            if (ourNameToIdRegistry.containsKey(name)) {
                return (short)ourNameToIdRegistry.get(name);
            }
            int n = ourNameToIdRegistry.size() + 1;
            assert (n <= Short.MAX_VALUE) : "Number of indices exceeded";
            ourNameToIdRegistry.put(name, n);
            ID.writeEnumFile();
            return (short)n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reinitializeDiskStorage() {
        TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
        synchronized (tObjectIntHashMap) {
            ID.writeEnumFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeEnumFile() {
        try {
            File f = ID.getEnumFile();
            try (BufferedWriter w = new BufferedWriter(new FileWriter(f));){
                final String[] names2 = new String[ourNameToIdRegistry.size()];
                ourNameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String key, int value) {
                        names2[value - 1] = key;
                        return true;
                    }
                });
                for (String name : names2) {
                    w.write(name);
                    w.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static <K, V> ID<K, V> create(@NonNls @NotNull String name) {
        ID<K, V> found;
        if (name == null) {
            ID.$$$reportNull$$$0(0);
        }
        ID<K, V> iD = (found = ID.findByName(name)) != null ? found : new ID<K, V>(name);
        if (iD == null) {
            ID.$$$reportNull$$$0(1);
        }
        return iD;
    }

    @Nullable
    public static <K, V> ID<K, V> findByName(@NotNull String name) {
        if (name == null) {
            ID.$$$reportNull$$$0(2);
        }
        return ID.findById(ID.stringToId(name));
    }

    public int hashCode() {
        return this.myUniqueId;
    }

    public String toString() {
        return this.getName();
    }

    public int getUniqueId() {
        return this.myUniqueId;
    }

    public static ID<?, ?> findById(int id) {
        return ourRegistry.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        File indices = ID.getEnumFile();
        try {
            TObjectIntHashMap<String> nameToIdRegistry = new TObjectIntHashMap<String>();
            try (BufferedReader reader = new BufferedReader(new FileReader(indices));){
                int cnt = 0;
                while (true) {
                    ++cnt;
                    String name = reader.readLine();
                    if (name == null) {
                        break;
                    }
                    nameToIdRegistry.put(name, cnt);
                }
            }
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.ensureCapacity(nameToIdRegistry.size());
                nameToIdRegistry.forEachEntry(new TObjectIntProcedure<String>(){

                    @Override
                    public boolean execute(String name, int index2) {
                        ourNameToIdRegistry.put(name, index2);
                        return true;
                    }
                });
            }
        }
        catch (IOException e) {
            TObjectIntHashMap<String> tObjectIntHashMap = ourNameToIdRegistry;
            synchronized (tObjectIntHashMap) {
                ourNameToIdRegistry.clear();
                ID.writeEnumFile();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/indexing/ID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

