/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.DefaultStaticLibraryArchiverSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class CreateStaticLibrary
extends DefaultTask
implements ObjectFilesToBinary {
    private final ConfigurableFileCollection source;
    private final RegularFileProperty outputFile;
    private final ListProperty<String> staticLibArgs;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;

    public CreateStaticLibrary() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.source = this.getProject().files(new Object[0]);
        this.outputFile = this.newOutputFile();
        this.staticLibArgs = this.getProject().getObjects().listProperty(String.class);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @InputFiles
    @SkipWhenEmpty
    public FileCollection getSource() {
        return this.source;
    }

    @Override
    public void source(Object source) {
        this.source.from(new Object[]{source});
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void link() {
        DefaultStaticLibraryArchiverSpec spec = new DefaultStaticLibraryArchiverSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setOutputFile(((RegularFile)this.getOutputFile().get()).getAsFile());
        spec.objectFiles((Iterable<File>)this.getSource());
        spec.args((List)this.getStaticLibArgs().get());
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        spec.setOperationLogger(operationLogger);
        Compiler<StaticLibraryArchiverSpec> compiler = this.createCompiler();
        WorkResult result = BuildOperationLoggingCompilerDecorator.wrap(compiler).execute((CompileSpec)spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<StaticLibraryArchiverSpec> createCompiler() {
        NativePlatformInternal targetPlatform = (NativePlatformInternal)Cast.cast(NativePlatformInternal.class, (Object)this.targetPlatform.get());
        NativeToolChainInternal toolChain = (NativeToolChainInternal)Cast.cast(NativeToolChainInternal.class, (Object)this.getToolChain().get());
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        return toolProvider.newCompiler(StaticLibraryArchiverSpec.class);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Internal
    public RegularFileProperty getBinaryFile() {
        return this.outputFile;
    }

    @Input
    public ListProperty<String> getStaticLibArgs() {
        return this.staticLibArgs;
    }
}

