/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.java.DefaultJavaSourceSet;
import org.gradle.api.internal.java.DefaultJvmResourceSet;
import org.gradle.api.internal.jvm.ClassDirectoryBinarySpecInternal;
import org.gradle.api.internal.jvm.DefaultClassDirectoryBinarySpec;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.SourceSetCompileClasspath;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.jvm.platform.internal.DefaultJavaPlatform;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.plugins.LanguageBasePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.platform.base.BinaryContainer;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultComponentSpecIdentifier;
import org.gradle.platform.base.plugins.BinaryBasePlugin;

class JavaBasePluginRules
implements Plugin<Project> {
    private final ModelRegistry modelRegistry;
    private final Instantiator instantiator;
    private final JavaToolChain javaToolChain;
    private final ITaskFactory taskFactory;

    @Inject
    public JavaBasePluginRules(ModelRegistry modelRegistry, Instantiator instantiator, JavaToolChain javaToolChain, ITaskFactory taskFactory) {
        this.modelRegistry = modelRegistry;
        this.instantiator = instantiator;
        this.javaToolChain = javaToolChain;
        this.taskFactory = taskFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(LanguageBasePlugin.class);
        project.getPluginManager().apply(BinaryBasePlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        BridgedBinaries binaries = this.collectBinariesForSourceSets(project.getTasks(), javaConvention);
        this.modelRegistry.register(ModelRegistrations.bridgedInstance((ModelReference)ModelReference.of((String)"bridgedBinaries", BridgedBinaries.class), (Object)binaries).descriptor("JavaBasePlugin.apply()").hidden(true).build());
    }

    private BridgedBinaries collectBinariesForSourceSets(final TaskContainer tasks, JavaPluginConvention pluginConvention) {
        ProjectInternal project = pluginConvention.getProject();
        ArrayList binaries = Lists.newArrayList();
        pluginConvention.getSourceSets().all((Action)new Action<SourceSet>((Project)project, (List)binaries){
            final /* synthetic */ Project val$project;
            final /* synthetic */ List val$binaries;
            {
                this.val$project = project;
                this.val$binaries = list;
            }

            public void execute(SourceSet sourceSet) {
                TaskProvider resourcesTask = tasks.withType(ProcessResources.class).named(sourceSet.getProcessResourcesTaskName());
                TaskProvider compileTask = tasks.withType(JavaCompile.class).named(sourceSet.getCompileJavaTaskName());
                DefaultComponentSpecIdentifier binaryId = new DefaultComponentSpecIdentifier(this.val$project.getPath(), sourceSet.getName());
                ClassDirectoryBinarySpecInternal binary = (ClassDirectoryBinarySpecInternal)JavaBasePluginRules.this.instantiator.newInstance(DefaultClassDirectoryBinarySpec.class, new Object[]{binaryId, sourceSet, JavaBasePluginRules.this.javaToolChain, DefaultJavaPlatform.current(), JavaBasePluginRules.this.instantiator, JavaBasePluginRules.this.taskFactory});
                SourceSetCompileClasspath compileClasspath = new SourceSetCompileClasspath(sourceSet);
                DefaultJavaSourceSet javaSourceSet = (DefaultJavaSourceSet)((Object)JavaBasePluginRules.this.instantiator.newInstance(DefaultJavaSourceSet.class, new Object[]{binaryId.child("java"), sourceSet.getJava(), compileClasspath}));
                JvmResourceSet resourceSet = (JvmResourceSet)JavaBasePluginRules.this.instantiator.newInstance(DefaultJvmResourceSet.class, new Object[]{binaryId.child("resources"), sourceSet.getResources()});
                binary.addSourceSet((LanguageSourceSet)javaSourceSet);
                binary.addSourceSet((LanguageSourceSet)resourceSet);
                TaskProvider classesTask = tasks.named(sourceSet.getClassesTaskName());
                JavaBasePluginRules.this.attachTasksToBinary(binary, (Provider<? extends Task>)((Provider)compileTask), (Provider<? extends Task>)((Provider)resourcesTask), (Provider<? extends Task>)((Provider)classesTask));
                this.val$binaries.add(binary);
            }
        });
        return new BridgedBinaries(binaries);
    }

    private void attachTasksToBinary(ClassDirectoryBinarySpecInternal binary, Provider<? extends Task> compileTask, Provider<? extends Task> resourcesTask, Provider<? extends Task> classesTask) {
        binary.getTasks().addLater(compileTask);
        binary.getTasks().addLater(resourcesTask);
        binary.getTasks().addLater(classesTask);
        binary.builtBy(new Object[]{classesTask});
    }

    static class BridgedBinaries {
        final List<ClassDirectoryBinarySpecInternal> binaries;

        public BridgedBinaries(List<ClassDirectoryBinarySpecInternal> binaries) {
            this.binaries = binaries;
        }
    }

    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Mutate
        void attachBridgedSourceSets(ProjectSourceSet projectSourceSet, BridgedBinaries bridgedBinaries) {
            for (ClassDirectoryBinarySpecInternal binary : bridgedBinaries.binaries) {
                projectSourceSet.addAll((Collection)binary.getInputs());
            }
        }

        @Mutate
        void attachBridgedBinaries(BinaryContainer binaries, BridgedBinaries bridgedBinaries) {
            for (BinarySpecInternal binarySpecInternal : bridgedBinaries.binaries) {
                binaries.put(binarySpecInternal.getProjectScopedName(), (Object)binarySpecInternal);
            }
        }
    }
}

