/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.locking;

import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyConstraint;

class DependencyLockingNotationConverter {
    private final boolean updating;

    public DependencyLockingNotationConverter(boolean updating) {
        this.updating = updating;
    }

    DependencyConstraint convertToDependencyConstraint(String module) {
        int groupNameSeparatorIndex = module.indexOf(58);
        int nameVersionSeparatorIndex = module.lastIndexOf(58);
        if (groupNameSeparatorIndex < 0 || nameVersionSeparatorIndex == groupNameSeparatorIndex) {
            throw new IllegalArgumentException("The module notation does not respect the lock file format of 'group:name:version' - received '" + module + "'");
        }
        DefaultDependencyConstraint constraint = this.updating ? this.createPreferConstraint(module, groupNameSeparatorIndex, nameVersionSeparatorIndex) : this.createStrictConstraint(module, groupNameSeparatorIndex, nameVersionSeparatorIndex);
        return constraint;
    }

    private DefaultDependencyConstraint createStrictConstraint(String module, int groupNameSeparatorIndex, int nameVersionSeparatorIndex) {
        DefaultDependencyConstraint constraint = DefaultDependencyConstraint.strictConstraint(module.substring(0, groupNameSeparatorIndex), module.substring(groupNameSeparatorIndex + 1, nameVersionSeparatorIndex), module.substring(nameVersionSeparatorIndex + 1));
        constraint.because("dependency was locked to version '" + constraint.getVersion() + "'");
        return constraint;
    }

    private DefaultDependencyConstraint createPreferConstraint(String module, int groupNameSeparatorIndex, int nameVersionSeparatorIndex) {
        DefaultDependencyConstraint constraint = new DefaultDependencyConstraint(module.substring(0, groupNameSeparatorIndex), module.substring(groupNameSeparatorIndex + 1, nameVersionSeparatorIndex), module.substring(nameVersionSeparatorIndex + 1));
        constraint.because("dependency was locked to version '" + constraint.getVersion() + "' (update mode)");
        return constraint;
    }

    String convertToLockNotation(ModuleComponentIdentifier id) {
        return id.getGroup() + ":" + id.getModule() + ":" + id.getVersion();
    }
}

