/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionEventGenerator;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJUnitTestClassProcessor<T extends JUnitSpec>
implements TestClassProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJUnitTestClassProcessor.class);
    protected final T spec;
    protected final IdGenerator<?> idGenerator;
    protected final Clock clock;
    private final ActorFactory actorFactory;
    private Action<String> executor;
    private Actor resultProcessorActor;

    public AbstractJUnitTestClassProcessor(T spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        this.idGenerator = idGenerator;
        this.spec = spec;
        this.actorFactory = actorFactory;
        this.clock = clock;
    }

    public void startProcessing(TestResultProcessor resultProcessor) {
        AttachParentTestResultProcessor resultProcessorChain = new AttachParentTestResultProcessor(resultProcessor);
        TestClassExecutionEventGenerator eventGenerator = new TestClassExecutionEventGenerator((TestResultProcessor)resultProcessorChain, this.idGenerator, this.clock);
        this.resultProcessorActor = this.actorFactory.createBlockingActor((Object)eventGenerator);
        TestResultProcessor threadSafeResultProcessor = (TestResultProcessor)this.resultProcessorActor.getProxy(TestResultProcessor.class);
        TestClassExecutionListener threadSafeTestClassListener = (TestClassExecutionListener)this.resultProcessorActor.getProxy(TestClassExecutionListener.class);
        this.executor = this.createTestExecutor(threadSafeResultProcessor, threadSafeTestClassListener);
    }

    protected abstract Action<String> createTestExecutor(TestResultProcessor var1, TestClassExecutionListener var2);

    public void processTestClass(TestClassRunInfo testClass) {
        LOGGER.debug("Executing test class {}", (Object)testClass.getTestClassName());
        this.executor.execute((Object)testClass.getTestClassName());
    }

    public void stop() {
        this.resultProcessorActor.stop();
    }

    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

