/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.internal.MutableActionSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastingCollectionEventRegister<T>
implements CollectionEventRegister<T> {
    private final MutableActionSet<T> addActions = new MutableActionSet();
    private final MutableActionSet<T> removeActions = new MutableActionSet();
    private final Class<? extends T> baseType;
    private boolean baseTypeSubscribed;
    private Set<Class<?>> subscribedTypes;

    public BroadcastingCollectionEventRegister(Class<? extends T> baseType) {
        this.baseType = baseType;
    }

    @Override
    public boolean isSubscribed(Class<?> type) {
        if (this.baseTypeSubscribed) {
            return true;
        }
        if (this.subscribedTypes != null) {
            if (type == null) {
                return true;
            }
            for (Class<?> subscribedType : this.subscribedTypes) {
                if (!subscribedType.isAssignableFrom(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Action<T> getAddAction() {
        return this.addActions;
    }

    @Override
    public Action<T> getRemoveAction() {
        return this.removeActions;
    }

    @Override
    public void registerEagerAddAction(Class<? extends T> type, Action<? super T> addAction) {
        this.subscribe(type);
        this.addActions.add(addAction);
    }

    @Override
    public void registerLazyAddAction(Action<? super T> addAction) {
        this.addActions.add(addAction);
    }

    @Override
    public void registerRemoveAction(Class<? extends T> type, Action<? super T> removeAction) {
        this.removeActions.add(removeAction);
    }

    private void subscribe(Class<? extends T> type) {
        if (this.baseTypeSubscribed) {
            return;
        }
        if (type.equals(this.baseType)) {
            this.baseTypeSubscribed = true;
            this.subscribedTypes = null;
        } else {
            if (this.subscribedTypes == null) {
                this.subscribedTypes = new HashSet();
            }
            this.subscribedTypes.add(type);
        }
    }
}

