/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.util.CollectionUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExecHandleBuilder
extends AbstractExecHandleBuilder
implements JavaExecSpec {
    private String mainClass;
    private final List<Object> applicationArgs = new ArrayList<Object>();
    private FileCollection classpath;
    private final JavaForkOptions javaOptions;
    private final FileResolver fileResolver;

    public JavaExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
        this.fileResolver = fileResolver;
        this.javaOptions = new DefaultJavaForkOptions(fileResolver);
        this.classpath = new DefaultConfigurableFileCollection(fileResolver, null, new Object[0]);
        this.executable(this.javaOptions.getExecutable());
    }

    public List<String> getAllJvmArgs() {
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.addAll(this.javaOptions.getAllJvmArgs());
        if (!this.classpath.isEmpty()) {
            allArgs.add("-cp");
            allArgs.add(CollectionUtils.join((String)File.pathSeparator, (Iterable)this.classpath.getFiles()));
        }
        return allArgs;
    }

    public void setAllJvmArgs(List<String> arguments) {
        throw new UnsupportedOperationException();
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        throw new UnsupportedOperationException();
    }

    public List<String> getJvmArgs() {
        return this.javaOptions.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.javaOptions.setJvmArgs(arguments);
    }

    public JavaExecHandleBuilder jvmArgs(Iterable<?> arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public JavaExecHandleBuilder jvmArgs(Object ... arguments) {
        this.javaOptions.jvmArgs(arguments);
        return this;
    }

    public Map<String, Object> getSystemProperties() {
        return this.javaOptions.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.javaOptions.setSystemProperties(properties);
    }

    public JavaExecHandleBuilder systemProperties(Map<String, ?> properties) {
        this.javaOptions.systemProperties(properties);
        return this;
    }

    public JavaExecHandleBuilder systemProperty(String name, Object value) {
        this.javaOptions.systemProperty(name, value);
        return this;
    }

    public FileCollection getBootstrapClasspath() {
        return this.javaOptions.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaOptions.setBootstrapClasspath(classpath);
    }

    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.javaOptions.bootstrapClasspath(classpath);
        return this;
    }

    public String getMinHeapSize() {
        return this.javaOptions.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.javaOptions.setMinHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.javaOptions.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaOptions.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public String getMaxHeapSize() {
        return this.javaOptions.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.javaOptions.setMaxHeapSize(heapSize);
    }

    public boolean getEnableAssertions() {
        return this.javaOptions.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.javaOptions.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.javaOptions.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.javaOptions.setDebug(enabled);
    }

    public String getMain() {
        return this.mainClass;
    }

    public JavaExecHandleBuilder setMain(String mainClassName) {
        this.mainClass = mainClassName;
        return this;
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object applicationArg : this.applicationArgs) {
            args.add(applicationArg.toString());
        }
        return args;
    }

    public JavaExecHandleBuilder setArgs(List<String> applicationArgs) {
        this.applicationArgs.clear();
        this.args(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder setArgs(Iterable<?> applicationArgs) {
        this.applicationArgs.clear();
        this.args(applicationArgs);
        return this;
    }

    public JavaExecHandleBuilder args(Object ... args) {
        this.args(Arrays.asList(args));
        return this;
    }

    public JavaExecSpec args(Iterable<?> args) {
        GUtil.addToCollection(this.applicationArgs, (boolean)true, (Iterable[])new Iterable[]{args});
        return this;
    }

    public JavaExecHandleBuilder setClasspath(FileCollection classpath) {
        this.classpath = classpath;
        return this;
    }

    public JavaExecHandleBuilder classpath(Object ... paths) {
        this.classpath = this.classpath.plus((FileCollection)this.fileResolver.resolveFiles(paths));
        return this;
    }

    public FileCollection getClasspath() {
        return this.classpath;
    }

    @Override
    public List<String> getAllArguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(this.getAllJvmArgs());
        arguments.add(this.mainClass);
        arguments.addAll(this.getArgs());
        return arguments;
    }

    public JavaForkOptions copyTo(JavaForkOptions options) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecHandle build() {
        if (this.mainClass == null) {
            throw new IllegalStateException("No main class specified");
        }
        return super.build();
    }

    @Override
    public JavaExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }
}

