/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.trace;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.progress.BuildOperationDescriptor;
import org.gradle.internal.progress.OperationProgressEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializedOperationProgress {
    final Object id;
    final long time;
    final Object details;
    final String detailsClassName;

    SerializedOperationProgress(BuildOperationDescriptor descriptor, OperationProgressEvent progressEvent) {
        this.id = ((OperationIdentifier)descriptor.getId()).getId();
        this.time = progressEvent.getTime();
        this.details = this.transform(progressEvent.getDetails());
        this.detailsClassName = this.details == null ? null : progressEvent.getDetails().getClass().getName();
    }

    private Object transform(Object details) {
        return details;
    }

    SerializedOperationProgress(Map<String, ?> map) {
        this.id = map.get("id");
        this.time = (Long)map.get("time");
        this.details = map.get("details");
        this.detailsClassName = (String)map.get("detailsClassName");
    }

    Map<String, ?> toMap() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (this.details != null) {
            map.put((Object)"details", this.details);
            map.put((Object)"detailsClassName", (Object)this.detailsClassName);
        }
        map.put((Object)"id", this.id);
        map.put((Object)"time", (Object)this.time);
        return map.build();
    }
}

