/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.run;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.deployment.internal.Deployment;
import org.gradle.play.internal.run.PlayApplication;
import org.gradle.play.internal.run.PlayRunSpec;
import org.gradle.play.internal.run.PlayRunWorkerClientProtocol;
import org.gradle.play.internal.run.PlayRunWorkerServerProtocol;
import org.gradle.play.internal.run.PlayWorkerServer;
import org.gradle.play.internal.run.VersionedPlayRunAdapter;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;

public class PlayApplicationRunner {
    private final WorkerProcessFactory workerFactory;
    private final VersionedPlayRunAdapter adapter;

    public PlayApplicationRunner(WorkerProcessFactory workerFactory, VersionedPlayRunAdapter adapter) {
        this.workerFactory = workerFactory;
        this.adapter = adapter;
    }

    public PlayApplication start(PlayRunSpec spec, Deployment deployment) {
        WorkerProcess process = PlayApplicationRunner.createWorkerProcess(spec.getProjectPath(), this.workerFactory, spec, this.adapter);
        process.start();
        PlayRunWorkerServerProtocol workerServer = (PlayRunWorkerServerProtocol)process.getConnection().addOutgoing(PlayRunWorkerServerProtocol.class);
        PlayApplication playApplication = new PlayApplication(deployment, workerServer, process);
        process.getConnection().addIncoming(PlayRunWorkerClientProtocol.class, (Object)playApplication);
        process.getConnection().connect();
        playApplication.waitForRunning();
        return playApplication;
    }

    private static WorkerProcess createWorkerProcess(File workingDir, WorkerProcessFactory workerFactory, PlayRunSpec spec, VersionedPlayRunAdapter adapter) {
        WorkerProcessBuilder builder = workerFactory.create((Action)new PlayWorkerServer(spec, adapter));
        builder.setBaseName("Gradle Play Worker");
        builder.sharedPackages(new String[]{"org.gradle.play.internal.run"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(workingDir);
        javaCommand.setMinHeapSize(spec.getForkOptions().getMemoryInitialSize());
        javaCommand.setMaxHeapSize(spec.getForkOptions().getMemoryMaximumSize());
        javaCommand.setJvmArgs(spec.getForkOptions().getJvmArgs());
        return builder.build();
    }
}

