/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.ComponentResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.EdgeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.SelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DefaultComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentResolveResult;

public class ComponentState
implements ComponentResolutionState,
ComponentResult,
DependencyGraphComponent {
    private final ModuleVersionIdentifier id;
    private final ComponentMetaDataResolver resolver;
    private final Set<NodeState> nodes = new LinkedHashSet<NodeState>();
    private final Long resultId;
    private final ModuleResolveState module;
    private volatile ComponentResolveMetadata metaData;
    private ModuleState state = ModuleState.Selectable;
    private ComponentSelectionReason selectionReason = VersionSelectionReasons.REQUESTED;
    private ModuleVersionResolveException failure;
    private SelectorState selectedBy;
    private DependencyGraphBuilder.VisitState visitState = DependencyGraphBuilder.VisitState.NotSeen;
    Set<SelectorState> allResolvers;

    ComponentState(Long resultId, ModuleResolveState module, ModuleVersionIdentifier id, ComponentMetaDataResolver resolver) {
        this.resultId = resultId;
        this.module = module;
        this.id = id;
        this.resolver = resolver;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public String getVersion() {
        return this.id.getVersion();
    }

    @Override
    public Long getResultId() {
        return this.resultId;
    }

    @Override
    public ModuleVersionIdentifier getId() {
        return this.id;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersion() {
        return this.id;
    }

    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    public DependencyGraphBuilder.VisitState getVisitState() {
        return this.visitState;
    }

    public void setVisitState(DependencyGraphBuilder.VisitState visitState) {
        this.visitState = visitState;
    }

    public Set<NodeState> getNodes() {
        return this.nodes;
    }

    ModuleResolveState getModule() {
        return this.module;
    }

    @Override
    public ComponentResolveMetadata getMetadata() {
        return this.metaData;
    }

    public void restart(ComponentState selected) {
        for (NodeState configuration : this.nodes) {
            configuration.restart(selected);
        }
    }

    public void selectedBy(SelectorState resolver) {
        if (this.selectedBy == null) {
            this.selectedBy = resolver;
            this.allResolvers = Sets.newLinkedHashSet();
        }
        this.allResolvers.add(resolver);
    }

    public boolean fastResolve() {
        if (this.metaData != null || this.failure != null) {
            return true;
        }
        ComponentIdResolveResult idResolveResult = this.selectedBy.getResolveResult();
        if (idResolveResult.getFailure() != null) {
            this.failure = idResolveResult.getFailure();
            return true;
        }
        if (idResolveResult.getMetaData() != null) {
            this.metaData = idResolveResult.getMetaData();
            return true;
        }
        return false;
    }

    public void resolve() {
        if (this.fastResolve()) {
            return;
        }
        ComponentIdResolveResult idResolveResult = this.selectedBy.getResolveResult();
        DefaultBuildableComponentResolveResult result = new DefaultBuildableComponentResolveResult();
        this.resolver.resolve(idResolveResult.getId(), DefaultComponentOverrideMetadata.forDependency(this.selectedBy.getDependencyMetadata()), result);
        if (result.getFailure() != null) {
            this.failure = result.getFailure();
            return;
        }
        this.metaData = result.getMetaData();
    }

    @Override
    public ComponentResolveMetadata getMetaData() {
        if (this.metaData == null) {
            this.resolve();
        }
        return this.metaData;
    }

    @Override
    public ResolvedVersionConstraint getVersionConstraint() {
        return this.selectedBy == null ? null : this.selectedBy.getVersionConstraint();
    }

    @Override
    public boolean isResolved() {
        return this.metaData != null;
    }

    public void setMetaData(ComponentResolveMetadata metaData) {
        this.metaData = metaData;
        this.failure = null;
    }

    public void addConfiguration(NodeState node) {
        this.nodes.add(node);
    }

    @Override
    public ComponentSelectionReason getSelectionReason() {
        return this.selectionReason;
    }

    @Override
    public void setSelectionReason(ComponentSelectionReason reason) {
        this.selectionReason = reason;
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.getMetaData().getComponentId();
    }

    public Set<ComponentState> getDependents() {
        LinkedHashSet<ComponentState> incoming = new LinkedHashSet<ComponentState>();
        for (NodeState configuration : this.nodes) {
            for (EdgeState dependencyEdge : configuration.getIncomingEdges()) {
                incoming.add(dependencyEdge.getFrom().getComponent());
            }
        }
        return incoming;
    }

    boolean isSelected() {
        return this.state == ModuleState.Selected;
    }

    boolean isSelectable() {
        return this.state.isSelectable();
    }

    boolean isCandidateForConflictResolution() {
        return this.state.isCandidateForConflictResolution();
    }

    void evict() {
        this.state = ModuleState.Evicted;
    }

    void select() {
        this.state = ModuleState.Selected;
    }

    void makeSelectable() {
        this.state = ModuleState.Selectable;
    }
}

