/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.ListSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.IncludeDirectives;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.Macro;
import org.gradle.language.nativeplatform.internal.MacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultInclude;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultIncludeDirectives;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.DefaultMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacro;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.UnresolveableMacroFunction;

public class IncludeDirectivesSerializer
implements Serializer<IncludeDirectives> {
    private final Serializer<IncludeType> enumSerializer = new BaseSerializerFactory().getSerializerFor(IncludeType.class);
    private final ListSerializer<Include> includeListSerializer = new ListSerializer((Serializer)new IncludeSerializer(this.enumSerializer));
    private final ListSerializer<Macro> macroListSerializer = new ListSerializer((Serializer)new MacroSerializer(this.enumSerializer));
    private final ListSerializer<MacroFunction> macroFunctionListSerializer = new ListSerializer((Serializer)new MacroFunctionSerializer(this.enumSerializer));

    public IncludeDirectives read(Decoder decoder) throws Exception {
        return new DefaultIncludeDirectives((ImmutableList<Include>)ImmutableList.copyOf((Collection)this.includeListSerializer.read(decoder)), (ImmutableList<Macro>)ImmutableList.copyOf((Collection)this.macroListSerializer.read(decoder)), (ImmutableList<MacroFunction>)ImmutableList.copyOf((Collection)this.macroFunctionListSerializer.read(decoder)));
    }

    public void write(Encoder encoder, IncludeDirectives value) throws Exception {
        this.includeListSerializer.write(encoder, (Collection)value.getAll());
        this.macroListSerializer.write(encoder, (Collection)value.getMacros());
        this.macroFunctionListSerializer.write(encoder, (Collection)value.getMacrosFunctions());
    }

    private static class MacroFunctionSerializer
    implements Serializer<MacroFunction> {
        private static final byte RESOLVED = 1;
        private static final byte UNRESOLVED = 2;
        private final Serializer<IncludeType> enumSerializer;

        MacroFunctionSerializer(Serializer<IncludeType> enumSerializer) {
            this.enumSerializer = enumSerializer;
        }

        public MacroFunction read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            if (tag == 1) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readString();
                return new DefaultMacroFunction(name, parameters, type, value);
            }
            if (tag == 2) {
                String name = decoder.readString();
                int parameters = decoder.readSmallInt();
                return new UnresolveableMacroFunction(name, parameters);
            }
            throw new UnsupportedOperationException();
        }

        public void write(Encoder encoder, MacroFunction value) throws Exception {
            if (value instanceof DefaultMacroFunction) {
                encoder.writeByte((byte)1);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
                this.enumSerializer.write(encoder, (Object)value.getType());
                encoder.writeString((CharSequence)value.getValue());
            } else if (value instanceof UnresolveableMacroFunction) {
                encoder.writeByte((byte)2);
                encoder.writeString((CharSequence)value.getName());
                encoder.writeSmallInt(value.getParameterCount());
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class MacroSerializer
    implements Serializer<Macro> {
        private static final byte RESOLVED = 1;
        private static final byte UNRESOLVED = 2;
        private final Serializer<IncludeType> enumSerializer;

        MacroSerializer(Serializer<IncludeType> enumSerializer) {
            this.enumSerializer = enumSerializer;
        }

        public Macro read(Decoder decoder) throws Exception {
            byte tag = decoder.readByte();
            if (tag == 1) {
                String name = decoder.readString();
                IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
                String value = decoder.readString();
                return new DefaultMacro(name, type, value);
            }
            if (tag == 2) {
                String name = decoder.readString();
                return new UnresolveableMacro(name);
            }
            throw new UnsupportedOperationException();
        }

        public void write(Encoder encoder, Macro value) throws Exception {
            if (value instanceof DefaultMacro) {
                encoder.writeByte((byte)1);
                encoder.writeString((CharSequence)value.getName());
                this.enumSerializer.write(encoder, (Object)value.getType());
                encoder.writeString((CharSequence)value.getValue());
            } else if (value instanceof UnresolveableMacro) {
                encoder.writeByte((byte)2);
                encoder.writeString((CharSequence)value.getName());
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class IncludeSerializer
    implements Serializer<Include> {
        private final Serializer<IncludeType> enumSerializer;

        private IncludeSerializer(Serializer<IncludeType> enumSerializer) {
            this.enumSerializer = enumSerializer;
        }

        public Include read(Decoder decoder) throws Exception {
            String value = decoder.readString();
            boolean isImport = decoder.readBoolean();
            IncludeType type = (IncludeType)this.enumSerializer.read(decoder);
            return DefaultInclude.create(value, isImport, type);
        }

        public void write(Encoder encoder, Include value) throws Exception {
            encoder.writeString((CharSequence)value.getValue());
            encoder.writeBoolean(value.isImport());
            this.enumSerializer.write(encoder, (Object)value.getType());
        }
    }
}

