/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.kotlin.com.intellij.psi.ElementDescriptionLocation;
import org.jetbrains.kotlin.com.intellij.psi.ElementDescriptionProvider;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;

public class ElementDescriptionUtil {
    private ElementDescriptionUtil() {
    }

    @NotNull
    public static String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location2) {
        String result2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        for (ElementDescriptionProvider provider : Extensions.getExtensions(ElementDescriptionProvider.EP_NAME)) {
            String result3 = provider.getElementDescription(element, location2);
            if (result3 == null) continue;
            String string = result3;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
            }
            return string;
        }
        ElementDescriptionProvider defaultProvider = location2.getDefaultProvider();
        if (defaultProvider != null && (result2 = defaultProvider.getElementDescription(element, location2)) != null) {
            String string = result2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
            }
            return string;
        }
        String string = element.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        return string;
    }
}

