/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.util.List;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.DefaultCompilerVersion;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.nativeplatform.internal.CompilerOutputFileNamingSchemeFactory;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.StaticLibraryArchiverSpec;
import org.gradle.nativeplatform.platform.internal.OperatingSystemInternal;
import org.gradle.nativeplatform.toolchain.internal.AbstractPlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultCommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.DefaultMutableCommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.OutputCleaningCompiler;
import org.gradle.nativeplatform.toolchain.internal.SystemIncludesAwarePlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.ToolType;
import org.gradle.nativeplatform.toolchain.internal.compilespec.AssembleSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.CppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.compilespec.ObjectiveCppPCHCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.gcc.ArStaticLibraryArchiver;
import org.gradle.nativeplatform.toolchain.internal.gcc.Assembler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CppCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.CppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccLinker;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCppCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.ObjectiveCppPCHCompiler;
import org.gradle.nativeplatform.toolchain.internal.gcc.metadata.GccMetadata;
import org.gradle.nativeplatform.toolchain.internal.metadata.CompilerType;
import org.gradle.nativeplatform.toolchain.internal.tools.GccCommandLineToolConfigurationInternal;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolRegistry;
import org.gradle.nativeplatform.toolchain.internal.tools.ToolSearchPath;
import org.gradle.process.internal.ExecActionFactory;

class GccPlatformToolProvider
extends AbstractPlatformToolProvider
implements SystemIncludesAwarePlatformToolProvider {
    private final ToolSearchPath toolSearchPath;
    private final ToolRegistry toolRegistry;
    private final ExecActionFactory execActionFactory;
    private final CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory;
    private final boolean useCommandFile;
    private final WorkerLeaseService workerLeaseService;
    private final CompilerType compilerType;
    private final GccMetadata gccMetadata;

    GccPlatformToolProvider(BuildOperationExecutor buildOperationExecutor, OperatingSystemInternal targetOperatingSystem, ToolSearchPath toolSearchPath, ToolRegistry toolRegistry, ExecActionFactory execActionFactory, CompilerOutputFileNamingSchemeFactory compilerOutputFileNamingSchemeFactory, boolean useCommandFile, WorkerLeaseService workerLeaseService, CompilerType compilerType, GccMetadata gccMetadata) {
        super(buildOperationExecutor, targetOperatingSystem);
        this.toolRegistry = toolRegistry;
        this.toolSearchPath = toolSearchPath;
        this.compilerOutputFileNamingSchemeFactory = compilerOutputFileNamingSchemeFactory;
        this.useCommandFile = useCommandFile;
        this.execActionFactory = execActionFactory;
        this.workerLeaseService = workerLeaseService;
        this.compilerType = compilerType;
        this.gccMetadata = gccMetadata;
    }

    protected Compiler<CppCompileSpec> createCppCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppCompiler cppCompiler = new CppCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cppCompilerTool), this.context(cppCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CppCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppCompileSpec>(cppCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createCppPCHCompiler() {
        GccCommandLineToolConfigurationInternal cppCompilerTool = this.toolRegistry.getTool(ToolType.CPP_COMPILER);
        CppPCHCompiler cppPCHCompiler = new CppPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cppCompilerTool), this.context(cppCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CppPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CppPCHCompileSpec>(cppPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    private <T extends NativeCompileSpec> VersionAwareCompiler<T> versionAwareCompiler(Compiler<T> compiler) {
        return new VersionAwareCompiler(compiler, (CompilerVersion)new DefaultCompilerVersion(this.compilerType.getIdentifier(), this.gccMetadata.getVendor(), this.gccMetadata.getVersion()));
    }

    protected Compiler<CCompileSpec> createCCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CCompiler cCompiler = new CCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cCompilerTool), this.context(cCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CCompileSpec>(cCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createCPCHCompiler() {
        GccCommandLineToolConfigurationInternal cCompilerTool = this.toolRegistry.getTool(ToolType.C_COMPILER);
        CPCHCompiler cpchCompiler = new CPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(cCompilerTool), this.context(cCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<CPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<CPCHCompileSpec>(cpchCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    protected Compiler<ObjectiveCppCompileSpec> createObjectiveCppCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppCompiler objectiveCppCompiler = new ObjectiveCppCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCppCompilerTool), this.context(objectiveCppCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCppCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCppCompileSpec>(objectiveCppCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createObjectiveCppPCHCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCppCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVECPP_COMPILER);
        ObjectiveCppPCHCompiler objectiveCppPCHCompiler = new ObjectiveCppPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCppCompilerTool), this.context(objectiveCppCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCppPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCppPCHCompileSpec>(objectiveCppPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    protected Compiler<ObjectiveCCompileSpec> createObjectiveCCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCCompiler objectiveCCompiler = new ObjectiveCCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCCompilerTool), this.context(objectiveCCompilerTool), this.getObjectFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCCompileSpec>(objectiveCCompiler, this.compilerOutputFileNamingSchemeFactory, this.getObjectFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    @Override
    protected Compiler<?> createObjectiveCPCHCompiler() {
        GccCommandLineToolConfigurationInternal objectiveCCompilerTool = this.toolRegistry.getTool(ToolType.OBJECTIVEC_COMPILER);
        ObjectiveCPCHCompiler objectiveCPCHCompiler = new ObjectiveCPCHCompiler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(objectiveCCompilerTool), this.context(objectiveCCompilerTool), this.getPCHFileExtension(), this.useCommandFile, this.workerLeaseService);
        OutputCleaningCompiler<ObjectiveCPCHCompileSpec> outputCleaningCompiler = new OutputCleaningCompiler<ObjectiveCPCHCompileSpec>(objectiveCPCHCompiler, this.compilerOutputFileNamingSchemeFactory, this.getPCHFileExtension());
        return this.versionAwareCompiler(outputCleaningCompiler);
    }

    protected Compiler<AssembleSpec> createAssembler() {
        GccCommandLineToolConfigurationInternal assemblerTool = this.toolRegistry.getTool(ToolType.ASSEMBLER);
        return new Assembler(this.buildOperationExecutor, this.compilerOutputFileNamingSchemeFactory, this.commandLineTool(assemblerTool), this.context(assemblerTool), this.getObjectFileExtension(), false, this.workerLeaseService);
    }

    protected Compiler<LinkerSpec> createLinker() {
        GccCommandLineToolConfigurationInternal linkerTool = this.toolRegistry.getTool(ToolType.LINKER);
        return new GccLinker(this.buildOperationExecutor, this.commandLineTool(linkerTool), this.context(linkerTool), this.useCommandFile, this.workerLeaseService);
    }

    protected Compiler<StaticLibraryArchiverSpec> createStaticLibraryArchiver() {
        GccCommandLineToolConfigurationInternal staticLibArchiverTool = this.toolRegistry.getTool(ToolType.STATIC_LIB_ARCHIVER);
        return new ArStaticLibraryArchiver(this.buildOperationExecutor, this.commandLineTool(staticLibArchiverTool), this.context(staticLibArchiverTool), this.workerLeaseService);
    }

    private CommandLineToolInvocationWorker commandLineTool(GccCommandLineToolConfigurationInternal tool) {
        ToolType key = tool.getToolType();
        String exeName = tool.getExecutable();
        return new DefaultCommandLineToolInvocationWorker(key.getToolName(), this.toolSearchPath.locate(key, exeName).getTool(), this.execActionFactory);
    }

    private CommandLineToolContext context(GccCommandLineToolConfigurationInternal toolConfiguration) {
        DefaultMutableCommandLineToolContext baseInvocation = new DefaultMutableCommandLineToolContext();
        baseInvocation.addPath(this.toolSearchPath.getPath());
        baseInvocation.addEnvironmentVar("CYGWIN", "nodosfilewarning");
        baseInvocation.setArgAction(toolConfiguration.getArgAction());
        return baseInvocation;
    }

    private String getPCHFileExtension() {
        return ".h.gch";
    }

    @Override
    public List<File> getSystemIncludes() {
        return this.gccMetadata.getSystemIncludes();
    }
}

