/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.cache;

import java.io.Closeable;
import org.gradle.api.internal.changedetection.state.InMemoryCacheDecoratorFactory;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisSerializer;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.DefaultClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.cache.GeneralCompileCaches;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;
import org.gradle.api.internal.tasks.compile.incremental.deps.LocalClassSetAnalysisStore;
import org.gradle.api.internal.tasks.compile.incremental.jar.DefaultJarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarClasspathSnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotData;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotDataSerializer;
import org.gradle.api.internal.tasks.compile.incremental.jar.LocalJarClasspathSnapshotStore;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.Serializer;

public class DefaultGeneralCompileCaches
implements GeneralCompileCaches,
Closeable {
    private final ClassAnalysisCache classAnalysisCache;
    private final JarSnapshotCache jarSnapshotCache;
    private final PersistentCache cache;
    private final PersistentIndexedCache<String, JarClasspathSnapshotData> taskJarCache;
    private final PersistentIndexedCache<String, ClassSetAnalysisData> taskCompileCache;

    public DefaultGeneralCompileCaches(CacheRepository cacheRepository, Gradle gradle, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cache = cacheRepository.cache((Object)gradle, "javaCompile").withDisplayName("Java compile cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
        PersistentIndexedCacheParameters classCacheParameters = new PersistentIndexedCacheParameters("classAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new ClassAnalysisSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(400000, true));
        this.classAnalysisCache = new DefaultClassAnalysisCache((PersistentIndexedCache<HashCode, ClassAnalysis>)this.cache.createCache(classCacheParameters));
        PersistentIndexedCacheParameters jarCacheParameters = new PersistentIndexedCacheParameters("jarAnalysis", (Serializer)new HashCodeSerializer(), (Serializer)new JarSnapshotDataSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(20000, true));
        this.jarSnapshotCache = new DefaultJarSnapshotCache((PersistentIndexedCache<HashCode, JarSnapshotData>)this.cache.createCache(jarCacheParameters));
        PersistentIndexedCacheParameters taskJarCacheParameters = new PersistentIndexedCacheParameters("taskJars", String.class, (Serializer)new JarClasspathSnapshotDataSerializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.taskJarCache = this.cache.createCache(taskJarCacheParameters);
        PersistentIndexedCacheParameters taskCompileCacheParameters = new PersistentIndexedCacheParameters("taskHistory", String.class, (Serializer)new ClassSetAnalysisData.Serializer()).cacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.taskCompileCache = this.cache.createCache(taskCompileCacheParameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public ClassAnalysisCache getClassAnalysisCache() {
        return this.classAnalysisCache;
    }

    @Override
    public JarSnapshotCache getJarSnapshotCache() {
        return this.jarSnapshotCache;
    }

    @Override
    public LocalJarClasspathSnapshotStore createLocalJarClasspathSnapshotStore(String taskPath) {
        return new LocalJarClasspathSnapshotStore(taskPath, this.taskJarCache);
    }

    @Override
    public LocalClassSetAnalysisStore createLocalClassSetAnalysisStore(String taskPath) {
        return new LocalClassSetAnalysisStore(taskPath, this.taskCompileCache);
    }
}

