/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder;

import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ResolveState;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableComponentIdResolveResult;

class SelectorState
implements DependencyGraphSelector {
    private final Long id;
    private final DependencyMetadata dependencyMetadata;
    private final DependencyToComponentIdResolver resolver;
    private final ResolveState resolveState;
    private ModuleVersionResolveException failure;
    private ModuleResolveState targetModule;
    private ComponentState selected;
    private BuildableComponentIdResolveResult idResolveResult;
    private VersionSelector versionSelector;

    SelectorState(Long id, DependencyMetadata dependencyMetadata, DependencyToComponentIdResolver resolver, ResolveState resolveState) {
        this.id = id;
        this.dependencyMetadata = dependencyMetadata;
        this.resolver = resolver;
        this.resolveState = resolveState;
        this.targetModule = resolveState.getModule(resolveState.getModuleIdentifierFactory().module(dependencyMetadata.getRequested().getGroup(), dependencyMetadata.getRequested().getName()));
    }

    @Override
    public Long getResultId() {
        return this.id;
    }

    public String toString() {
        return this.dependencyMetadata.toString();
    }

    @Override
    public ComponentSelector getRequested() {
        return this.dependencyMetadata.getSelector();
    }

    ModuleVersionResolveException getFailure() {
        return this.failure != null ? this.failure : this.selected.getFailure();
    }

    public ComponentSelectionReason getSelectionReason() {
        return this.selected == null ? this.idResolveResult.getSelectionReason() : this.selected.getSelectionReason();
    }

    public ComponentState getSelected() {
        return this.targetModule.getSelected();
    }

    public ModuleResolveState getSelectedModule() {
        return this.targetModule;
    }

    public ComponentState resolveModuleRevisionId() {
        if (this.selected != null) {
            return this.selected;
        }
        if (this.failure != null) {
            return null;
        }
        this.idResolveResult = new DefaultBuildableComponentIdResolveResult();
        this.resolver.resolve(this.dependencyMetadata, this.idResolveResult);
        if (this.idResolveResult.getFailure() != null) {
            this.failure = this.idResolveResult.getFailure();
            return null;
        }
        this.selected = this.resolveState.getRevision(this.idResolveResult.getModuleVersionId());
        this.selected.selectedBy(this);
        this.selected.setSelectionReason(this.idResolveResult.getSelectionReason());
        this.targetModule = this.selected.getModule();
        this.targetModule.addSelector(this);
        this.versionSelector = this.idResolveResult.getVersionSelector();
        return this.selected;
    }

    public void restart(ComponentState moduleRevision) {
        this.selected = moduleRevision;
        this.targetModule = moduleRevision.getModule();
    }

    public void reset() {
        this.idResolveResult = null;
        this.selected = null;
        this.targetModule = null;
    }

    public DependencyMetadata getDependencyMetadata() {
        return this.dependencyMetadata;
    }

    public ComponentIdResolveResult getResolveResult() {
        return this.idResolveResult;
    }

    public VersionSelector getVersionSelector() {
        return this.versionSelector;
    }
}

