/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.folding;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.folding.FoldingBuilder;
import org.jetbrains.kotlin.com.intellij.lang.folding.FoldingBuilderEx;
import org.jetbrains.kotlin.com.intellij.openapi.project.DumbService;
import org.jetbrains.kotlin.com.intellij.openapi.project.PossiblyDumbAware;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;

public class CompositeFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    public static final Key<FoldingBuilder> FOLDING_BUILDER = new Key("FOLDING_BUILDER");
    private final List<FoldingBuilder> myBuilders;

    CompositeFoldingBuilder(List<FoldingBuilder> builders) {
        this.myBuilders = builders;
    }

    @NotNull
    public List<FoldingBuilder> getAllBuilders() {
        List<FoldingBuilder> list2 = Collections.unmodifiableList(this.myBuilders);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/lang/folding/CompositeFoldingBuilder", "getAllBuilders"));
        }
        return list2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.myBuilders;
    }

    @Override
    public boolean isDumbAware() {
        for (FoldingBuilder builder : this.myBuilders) {
            if (!DumbService.isDumbAware(builder)) continue;
            return true;
        }
        return false;
    }
}

