/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.presentation.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.icons.AllIcons;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentation;
import org.jetbrains.kotlin.com.intellij.navigation.ItemPresentationProvider;
import org.jetbrains.kotlin.com.intellij.openapi.module.Module;
import org.jetbrains.kotlin.com.intellij.openapi.roots.FileIndexFacade;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;

public class JavaModulePresentationProvider
implements ItemPresentationProvider<PsiJavaModule> {
    private static final Pattern JAR_NAME = Pattern.compile(".+/([^/]+\\.jar)!/.*");

    @Override
    public ItemPresentation getPresentation(final @NotNull PsiJavaModule item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/kotlin/com/intellij/psi/presentation/java/JavaModulePresentationProvider", "getPresentation"));
        }
        return new ItemPresentation(){

            public String getPresentableText() {
                return item.getName();
            }

            @Nullable
            public String getLocationString() {
                Module module2;
                VirtualFile file = PsiImplUtil.getModuleVirtualFile(item);
                FileIndexFacade index2 = FileIndexFacade.getInstance(item.getProject());
                if (index2.isInLibraryClasses(file)) {
                    Matcher matcher = JAR_NAME.matcher(file.getPath());
                    if (matcher.find()) {
                        return matcher.group(1);
                    }
                } else if (index2.isInSource(file) && (module2 = index2.getModuleForFile(file)) != null) {
                    return '[' + module2.getName() + ']';
                }
                return null;
            }

            @Override
            @Nullable
            public Icon getIcon(boolean unused2) {
                return AllIcons.Nodes.JavaModule;
            }
        };
    }
}

