/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.rubygrapefruit.platform.MissingRegistryEntryException;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.FileUtils;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.Ucrt;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.UcrtLocator;
import org.gradle.util.TreeVisitor;
import org.gradle.util.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUcrtLocator
implements UcrtLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultUcrtLocator.class);
    private static final String[] REGISTRY_BASEPATHS = new String[]{"SOFTWARE\\", "SOFTWARE\\Wow6432Node\\"};
    private static final String REGISTRY_ROOTPATH_KIT = "Microsoft\\Windows Kits\\Installed Roots";
    private static final String REGISTRY_KIT_10 = "KitsRoot10";
    private static final String VERSION_USER = "user";
    private static final String NAME_USER = "User-provided UCRT";
    private static final String NAME_KIT = "UCRT";
    private final Map<File, Set<Ucrt>> foundUcrts = new HashMap<File, Set<Ucrt>>();
    private final OperatingSystem os;
    private final WindowsRegistry windowsRegistry;
    private boolean initialised;

    public DefaultUcrtLocator(OperatingSystem os, WindowsRegistry windowsRegistry) {
        this.os = os;
        this.windowsRegistry = windowsRegistry;
    }

    @Override
    public UcrtLocator.SearchResult locateUcrts(File candidate) {
        if (!this.initialised) {
            this.locateUcrtsInRegistry();
            this.initialised = true;
        }
        if (candidate != null) {
            return this.locateUserSpecifiedUcrt(candidate);
        }
        return this.locateDefaultUcrt();
    }

    private void locateUcrtsInRegistry() {
        for (String baseKey : REGISTRY_BASEPATHS) {
            this.locateUcrtsInRegistry(baseKey);
        }
    }

    private void locateUcrtsInRegistry(String baseKey) {
        String[] keys;
        for (String key : keys = new String[]{REGISTRY_KIT_10}) {
            try {
                File ucrtDir = FileUtils.canonicalize((File)new File(this.windowsRegistry.getStringValue(WindowsRegistry.Key.HKEY_LOCAL_MACHINE, baseKey + REGISTRY_ROOTPATH_KIT, key)));
                String[] versionDirs = DefaultUcrtLocator.getUcrtVersionDirs(ucrtDir);
                if (versionDirs.length > 0) {
                    for (String versionDir : versionDirs) {
                        VersionNumber version = VersionNumber.withPatchNumber().parse(versionDir);
                        LOGGER.debug("Found ucrt {} at {}", (Object)version.toString(), (Object)ucrtDir);
                        this.putUcrt(new Ucrt(ucrtDir, "UCRT " + version.getMajor(), version));
                    }
                    continue;
                }
                LOGGER.debug("Ignoring candidate ucrt directory {} as it does not look like a ucrt installation.", (Object)ucrtDir);
            }
            catch (MissingRegistryEntryException missingRegistryEntryException) {
                // empty catch block
            }
        }
    }

    private UcrtLocator.SearchResult locateUserSpecifiedUcrt(File candidate) {
        File ucrtDir = FileUtils.canonicalize((File)candidate);
        String[] versionDirs = DefaultUcrtLocator.getUcrtVersionDirs(ucrtDir);
        if (versionDirs.length > 0) {
            for (String versionDir : versionDirs) {
                VersionNumber version = VersionNumber.withPatchNumber().parse(versionDir);
                LOGGER.debug("Found ucrt {} ({}) at {}", new Object[]{version.toString(), versionDir, ucrtDir});
                if (this.foundUcrts.containsKey(ucrtDir)) continue;
                this.putUcrt(new Ucrt(ucrtDir, NAME_USER, version));
            }
            return new UcrtFound(this.getBestUcrt(candidate));
        }
        return new UcrtNotFound(String.format("The specified installation directory '%s' does not appear to contain a ucrt installation.", candidate));
    }

    private UcrtLocator.SearchResult locateDefaultUcrt() {
        Ucrt selected = this.getBestUcrt();
        return selected == null ? new UcrtNotFound("Could not locate a ucrt installation using the Windows registry.") : new UcrtFound(selected);
    }

    private static String[] getUcrtVersionDirs(File candidate) {
        final Pattern ucrtVersionPattern = Pattern.compile("[0-9]+(\\.[0-9]+)*");
        FileFilter ucrtVersionFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                Matcher matcher = ucrtVersionPattern.matcher(pathname.getName());
                return pathname.isDirectory() && matcher.matches();
            }
        };
        File includeDir = new File(candidate, "Include");
        File libDir = new File(candidate, "Lib");
        if (!includeDir.isDirectory() || !libDir.isDirectory()) {
            return new String[0];
        }
        HashMap<String, File> includeDirs = new HashMap<String, File>();
        for (File dir : includeDir.listFiles(ucrtVersionFilter)) {
            includeDirs.put(dir.getName(), dir);
        }
        HashMap<String, File> libDirs = new HashMap<String, File>();
        for (File dir : libDir.listFiles(ucrtVersionFilter)) {
            libDirs.put(dir.getName(), dir);
        }
        HashSet ucrtVersions = new HashSet();
        ucrtVersions.addAll(includeDirs.keySet());
        ucrtVersions.addAll(libDirs.keySet());
        ArrayList<String> result = new ArrayList<String>();
        for (String version : ucrtVersions) {
            File inc = (File)includeDirs.get(version);
            File lib = (File)includeDirs.get(version);
            if (inc == null || lib == null) continue;
            File ucrtInc = new File(inc, "ucrt");
            File ucrtLib = new File(lib, "ucrt");
            if (!ucrtInc.isDirectory() || !ucrtLib.isDirectory()) continue;
            result.add(version);
        }
        return result.toArray(new String[result.size()]);
    }

    private void putUcrt(Ucrt ucrt) {
        Set<Ucrt> ucrts = this.foundUcrts.get(ucrt.getBaseDir());
        if (ucrts == null) {
            ucrts = new HashSet<Ucrt>();
            this.foundUcrts.put(ucrt.getBaseDir(), ucrts);
        }
        ucrts.add(ucrt);
    }

    private Ucrt getBestUcrt(File baseDir) {
        TreeSet<Ucrt> candidates = new TreeSet<Ucrt>(new DescendingUcrtVersionComparator());
        Set<Ucrt> ucrts = this.foundUcrts.get(baseDir);
        if (ucrts != null) {
            candidates.addAll(ucrts);
        }
        return candidates.isEmpty() ? null : (Ucrt)candidates.iterator().next();
    }

    private Ucrt getBestUcrt() {
        TreeSet<Ucrt> candidates = new TreeSet<Ucrt>(new DescendingUcrtVersionComparator());
        for (Set<Ucrt> ucrts : this.foundUcrts.values()) {
            candidates.addAll(ucrts);
        }
        return candidates.isEmpty() ? null : (Ucrt)candidates.iterator().next();
    }

    private static class DescendingUcrtVersionComparator
    implements Comparator<Ucrt> {
        private DescendingUcrtVersionComparator() {
        }

        @Override
        public int compare(Ucrt o1, Ucrt o2) {
            return o2.getVersion().compareTo(o1.getVersion());
        }
    }

    private static class UcrtNotFound
    implements UcrtLocator.SearchResult {
        private final String message;

        private UcrtNotFound(String message) {
            this.message = message;
        }

        @Override
        public Ucrt getUcrt() {
            return null;
        }

        public boolean isAvailable() {
            return false;
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)this.message);
        }
    }

    private static class UcrtFound
    implements UcrtLocator.SearchResult {
        private final Ucrt ucrt;

        public UcrtFound(Ucrt ucrt) {
            this.ucrt = ucrt;
        }

        @Override
        public Ucrt getUcrt() {
            return this.ucrt;
        }

        public boolean isAvailable() {
            return true;
        }

        public void explain(TreeVisitor<? super String> visitor) {
        }
    }
}

