/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.plugins;

import com.google.common.collect.Lists;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.internal.DefaultSwiftLibrary;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.util.GUtil;

@Incubating
public class SwiftLibraryPlugin
implements Plugin<Project> {
    private final FileOperations fileOperations;

    @Inject
    public SwiftLibraryPlugin(FileOperations fileOperations) {
        this.fileOperations = fileOperations;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        TaskContainer tasks = project.getTasks();
        ConfigurationContainer configurations = project.getConfigurations();
        ObjectFactory objectFactory = project.getObjects();
        SwiftLibrary library = (SwiftLibrary)project.getExtensions().create(SwiftLibrary.class, "library", DefaultSwiftLibrary.class, new Object[]{"main", objectFactory, this.fileOperations, project.getProviders(), configurations});
        project.getComponents().add((Object)library);
        project.getComponents().add((Object)library.getDebugSharedLibrary());
        project.getComponents().add((Object)library.getReleaseSharedLibrary());
        PropertyState<String> module = library.getModule();
        module.set((Object)GUtil.toCamelCase((CharSequence)project.getName()));
        SwiftCompile compileDebug = (SwiftCompile)tasks.getByName("compileDebugSwift");
        compileDebug.setCompilerArgs(Lists.newArrayList((Object[])new String[]{"-g", "-enable-testing"}));
        SwiftCompile compileRelease = (SwiftCompile)tasks.getByName("compileReleaseSwift");
        LinkSharedLibrary linkDebug = (LinkSharedLibrary)tasks.getByName("linkDebug");
        LinkSharedLibrary linkRelease = (LinkSharedLibrary)tasks.getByName("linkRelease");
        tasks.getByName("assemble").dependsOn(new Object[]{linkDebug});
        Configuration implementation = library.getImplementationDependencies();
        Configuration api = library.getApiDependencies();
        Configuration debugApiElements = (Configuration)configurations.create("debugSwiftApiElements");
        debugApiElements.extendsFrom(new Configuration[]{api});
        debugApiElements.setCanBeResolved(false);
        debugApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
        debugApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugApiElements.getOutgoing().artifact((Object)compileDebug.getObjectFileDirectory());
        Configuration debugLinkElements = (Configuration)configurations.create("debugLinkElements");
        debugLinkElements.extendsFrom(new Configuration[]{implementation});
        debugLinkElements.setCanBeResolved(false);
        debugLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        debugLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugLinkElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        Configuration debugRuntimeElements = (Configuration)configurations.create("debugRuntimeElements");
        debugRuntimeElements.extendsFrom(new Configuration[]{implementation});
        debugRuntimeElements.setCanBeResolved(false);
        debugRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        debugRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
        debugRuntimeElements.getOutgoing().artifact((Object)linkDebug.getBinaryFile());
        Configuration releaseApiElements = (Configuration)configurations.create("releaseSwiftApiElements");
        releaseApiElements.extendsFrom(new Configuration[]{api});
        releaseApiElements.setCanBeResolved(false);
        releaseApiElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "swift-api"));
        releaseApiElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseApiElements.getOutgoing().artifact((Object)compileRelease.getObjectFileDirectory());
        Configuration releaseLinkElements = (Configuration)configurations.create("releaseLinkElements");
        releaseLinkElements.extendsFrom(new Configuration[]{implementation});
        releaseLinkElements.setCanBeResolved(false);
        releaseLinkElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-link"));
        releaseLinkElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseLinkElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
        Configuration releaseRuntimeElements = (Configuration)configurations.create("releaseRuntimeElements");
        releaseRuntimeElements.extendsFrom(new Configuration[]{implementation});
        releaseRuntimeElements.setCanBeResolved(false);
        releaseRuntimeElements.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)objectFactory.named(Usage.class, "native-runtime"));
        releaseRuntimeElements.getAttributes().attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)false);
        releaseRuntimeElements.getOutgoing().artifact((Object)linkRelease.getBinaryFile());
    }
}

