/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.ResolveArtifactsBuildOperationType;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.transform.ArtifactTransforms;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.progress.BuildOperationDescriptor;

public class DefaultLenientConfiguration
implements LenientConfiguration,
VisitedArtifactSet {
    private final ConfigurationInternal configuration;
    private final Set<UnresolvedDependency> unresolvedDependencies;
    private final VisitedArtifactsResults artifactResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final TransientConfigurationResultsLoader transientConfigurationResultsFactory;
    private final ArtifactTransforms artifactTransforms;
    private final AttributeContainerInternal implicitAttributes;
    private final BuildOperationExecutor buildOperationExecutor;
    private SelectedArtifactResults artifactsForThisConfiguration;

    public DefaultLenientConfiguration(ConfigurationInternal configuration, Set<UnresolvedDependency> unresolvedDependencies, VisitedArtifactsResults artifactResults, VisitedFileDependencyResults fileDependencyResults, TransientConfigurationResultsLoader transientConfigurationResultsLoader, ArtifactTransforms artifactTransforms, BuildOperationExecutor buildOperationExecutor) {
        this.configuration = configuration;
        this.implicitAttributes = configuration.getAttributes().asImmutable();
        this.unresolvedDependencies = unresolvedDependencies;
        this.artifactResults = artifactResults;
        this.fileDependencyResults = fileDependencyResults;
        this.transientConfigurationResultsFactory = transientConfigurationResultsLoader;
        this.artifactTransforms = artifactTransforms;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    private SelectedArtifactResults getSelectedArtifacts() {
        if (this.artifactsForThisConfiguration == null) {
            this.artifactsForThisConfiguration = this.artifactResults.select((Spec<? super ComponentIdentifier>)Specs.satisfyAll(), this.artifactTransforms.variantSelector(this.implicitAttributes, false));
        }
        return this.artifactsForThisConfiguration;
    }

    public SelectedArtifactSet select() {
        return this.select((Spec<? super Dependency>)Specs.satisfyAll(), this.implicitAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false);
    }

    public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec) {
        return this.select(dependencySpec, this.implicitAttributes, (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false);
    }

    @Override
    public SelectedArtifactSet select(final Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean allowNoMatchingVariants) {
        VariantSelector selector = this.artifactTransforms.variantSelector(requestedAttributes, allowNoMatchingVariants);
        final SelectedArtifactResults artifactResults = this.artifactResults.select(componentSpec, selector);
        return new SelectedArtifactSet(){

            @Override
            public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
                for (UnresolvedDependency unresolvedDependency : DefaultLenientConfiguration.this.unresolvedDependencies) {
                    visitor.visitFailure(unresolvedDependency.getProblem());
                }
                artifactResults.getArtifacts().collectBuildDependencies(visitor);
            }

            @Override
            public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
                if (!DefaultLenientConfiguration.this.unresolvedDependencies.isEmpty()) {
                    for (UnresolvedDependency unresolvedDependency : DefaultLenientConfiguration.this.unresolvedDependencies) {
                        visitor.visitFailure(unresolvedDependency.getProblem());
                    }
                    if (!continueOnSelectionFailure) {
                        return;
                    }
                }
                DefaultLenientConfiguration.this.visitArtifactsWithBuildOperation((Spec<? super Dependency>)dependencySpec, artifactResults, DefaultLenientConfiguration.this.fileDependencyResults, visitor);
            }
        };
    }

    private ResolveException getFailure() {
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (UnresolvedDependency unresolvedDependency : this.unresolvedDependencies) {
            failures.add(unresolvedDependency.getProblem());
        }
        return new ResolveException(this.configuration.getDisplayName(), failures);
    }

    public boolean hasError() {
        return this.unresolvedDependencies.size() > 0;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.unresolvedDependencies;
    }

    public void rethrowFailure() throws ResolveException {
        if (this.hasError()) {
            throw this.getFailure();
        }
    }

    private TransientConfigurationResults loadTransientGraphResults(SelectedArtifactResults artifactResults) {
        return this.transientConfigurationResultsFactory.create(artifactResults);
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    private Set<DependencyGraphNodeResult> getFirstLevelNodes(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<DependencyGraphNodeResult> matches = new LinkedHashSet<DependencyGraphNodeResult>();
        TransientConfigurationResults graphResults = this.loadTransientGraphResults(this.getSelectedArtifacts());
        for (Map.Entry<ModuleDependency, DependencyGraphNodeResult> entry : graphResults.getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList();
        workQueue.addAll(this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren());
        while (!workQueue.isEmpty()) {
            Set children;
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item) || (children = item.getChildren()) == null) continue;
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    public Set<File> getFiles() {
        return this.getFiles((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        LenientFilesAndArtifactResolveVisitor visitor = new LenientFilesAndArtifactResolveVisitor();
        this.visitArtifactsWithBuildOperation(dependencySpec, this.getSelectedArtifacts(), this.fileDependencyResults, visitor);
        return visitor.files;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        return this.getArtifacts((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        LenientArtifactCollectingVisitor visitor = new LenientArtifactCollectingVisitor();
        this.visitArtifactsWithBuildOperation(dependencySpec, this.getSelectedArtifacts(), this.fileDependencyResults, visitor);
        return visitor.artifacts;
    }

    private void visitArtifactsWithBuildOperation(final Spec<? super Dependency> dependencySpec, final SelectedArtifactResults artifactResults, final VisitedFileDependencyResults fileDependencyResults, final ArtifactVisitor visitor) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults, fileDependencyResults, visitor);
                context.setResult((Object)ResolveArtifactsBuildOperationType.RESULT);
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve files of " + DefaultLenientConfiguration.this.configuration.getIdentityPath();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveArtifactsBuildOperationType.DetailsImpl(DefaultLenientConfiguration.this.configuration.getPath()));
            }
        });
    }

    private void visitArtifacts(Spec<? super Dependency> dependencySpec, SelectedArtifactResults artifactResults, VisitedFileDependencyResults fileDependencyResults, ArtifactVisitor visitor) {
        if (dependencySpec == Specs.SATISFIES_ALL) {
            ParallelResolveArtifactSet.wrap(artifactResults.getArtifacts(), this.buildOperationExecutor).visit(visitor);
            return;
        }
        ArrayList<ResolvedArtifactSet> artifactSets = new ArrayList<ResolvedArtifactSet>();
        if (visitor.includeFiles()) {
            for (Map.Entry<FileCollectionDependency, Integer> entry : fileDependencyResults.getFirstLevelFiles().entrySet()) {
                if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
                artifactSets.add(artifactResults.getArtifactsWithId(entry.getValue()));
            }
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph(artifactSets));
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            walker.add((Object[])new DependencyGraphNodeResult[]{node});
        }
        walker.findValues();
        ParallelResolveArtifactSet.wrap(CompositeResolvedArtifactSet.of(artifactSets), this.buildOperationExecutor).visit(visitor);
    }

    public ConfigurationInternal getConfiguration() {
        return this.configuration;
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren();
    }

    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<DependencyGraphNodeResult, ResolvedArtifact> {
        private final List<ResolvedArtifactSet> dest;

        ResolvedDependencyArtifactsGraph(List<ResolvedArtifactSet> dest) {
            this.dest = dest;
        }

        public void getNodeValues(DependencyGraphNodeResult node, Collection<? super ResolvedArtifact> values, Collection<? super DependencyGraphNodeResult> connectedNodes) {
            connectedNodes.addAll(node.getOutgoingEdges());
            this.dest.add(node.getArtifactsForNode());
        }

        public void getEdgeValues(DependencyGraphNodeResult from, DependencyGraphNodeResult to, Collection<ResolvedArtifact> values) {
        }
    }

    public static class ArtifactResolveException
    extends ResolveException {
        private final String type;
        private final String displayName;

        public ArtifactResolveException(String type, String path, String displayName, Iterable<Throwable> failures) {
            super(path, failures);
            this.type = type;
            this.displayName = displayName;
        }

        public String getMessage() {
            return String.format("Could not resolve all %s for %s.", this.type, this.displayName);
        }
    }

    private static class LenientFilesAndArtifactResolveVisitor
    extends LenientArtifactCollectingVisitor {
        private LenientFilesAndArtifactResolveVisitor() {
        }

        @Override
        public boolean includeFiles() {
            return true;
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            this.files.add(file);
        }
    }

    private static class LenientArtifactCollectingVisitor
    implements ArtifactVisitor {
        final Set<ResolvedArtifact> artifacts = Sets.newLinkedHashSet();
        final Set<File> files = Sets.newLinkedHashSet();

        private LenientArtifactCollectingVisitor() {
        }

        @Override
        public void visitArtifact(AttributeContainer variant, ResolvableArtifact artifact) {
            try {
                ResolvedArtifact resolvedArtifact = artifact.toPublicView();
                this.files.add(resolvedArtifact.getFile());
                this.artifacts.add(resolvedArtifact);
            }
            catch (org.gradle.internal.resolve.ArtifactResolveException artifactResolveException) {
                // empty catch block
            }
        }

        @Override
        public boolean includeFiles() {
            return false;
        }

        @Override
        public boolean requireArtifactFiles() {
            return false;
        }

        @Override
        public void visitFailure(Throwable failure) {
            throw UncheckedException.throwAsUncheckedException((Throwable)failure);
        }

        @Override
        public void visitFile(ComponentArtifactIdentifier artifactIdentifier, AttributeContainer variant, File file) {
            throw new UnsupportedOperationException();
        }
    }
}

