/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.declaration.AbstractDeclarationVisitor;
import org.jetbrains.kotlin.js.translate.declaration.PropertyTranslatorKt;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\"\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/js/translate/declaration/FileDeclarationVisitor;", "Lorg/jetbrains/kotlin/js/translate/declaration/AbstractDeclarationVisitor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "addFunction", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "psi", "Lorg/jetbrains/kotlin/psi/KtElement;", "addProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getter", "setter", "getBackingFieldReference", "visitProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "js.translator"})
public final class FileDeclarationVisitor
extends AbstractDeclarationVisitor {
    private final TranslationContext context;

    @Override
    public void visitProperty(@NotNull KtProperty expression2, @NotNull TranslationContext context) {
        Boolean backingFieldRequired;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PropertyDescriptor propertyDescriptor = BindingUtils.getPropertyDescriptor(context.bindingContext(), expression2);
        JsName innerName = context.getInnerNameForDescriptor(propertyDescriptor);
        Boolean bl = (Boolean)context.bindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        if (bl == null) {
            bl = false;
        }
        Boolean bl2 = backingFieldRequired = bl;
        Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"backingFieldRequired");
        if (bl2.booleanValue() || expression2.getDelegateExpression() != null) {
            JsExpression initializer2 = PropertyTranslatorKt.translateDelegateOrInitializerExpression(context, expression2);
            context.addDeclarationStatement(JsAstUtils.newVar(innerName, null));
            if (initializer2 != null) {
                context.addTopLevelStatement(JsAstUtils.assignment(innerName.makeRef(), initializer2).makeStmt());
            }
        }
        super.visitProperty(expression2, context);
    }

    @Override
    public void addFunction(@NotNull FunctionDescriptor descriptor2, @Nullable JsExpression expression2, @Nullable KtElement psi) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        if (expression2 == null) {
            return;
        }
        UtilsKt.addFunctionButNotExport(this.context, descriptor2, expression2);
        this.context.export(descriptor2);
    }

    @Override
    public void addProperty(@NotNull PropertyDescriptor descriptor2, @NotNull JsExpression getter2, @Nullable JsExpression setter2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)getter2, (String)"getter");
        if (!JsDescriptorUtils.isSimpleFinalProperty(descriptor2)) {
            PropertyGetterDescriptor propertyGetterDescriptor = descriptor2.getGetter();
            if (propertyGetterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor, (String)"descriptor.getter!!");
            UtilsKt.addFunctionButNotExport(this.context, propertyGetterDescriptor, getter2);
            if (setter2 != null) {
                PropertySetterDescriptor propertySetterDescriptor = descriptor2.getSetter();
                if (propertySetterDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)propertySetterDescriptor, (String)"descriptor.setter!!");
                UtilsKt.addFunctionButNotExport(this.context, propertySetterDescriptor, setter2);
            }
        }
        this.context.export(descriptor2);
    }

    @Override
    @NotNull
    public JsExpression getBackingFieldReference(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        JsExpression jsExpression = this.context.getInnerReference(descriptor2);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsExpression, (String)"context.getInnerReference(descriptor)");
        return jsExpression;
    }

    public FileDeclarationVisitor(@NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }
}

