/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.rules;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.gradle.api.internal.changedetection.rules.PropertyDiffListener;

public class SortedMapDiffUtil {
    private SortedMapDiffUtil() {
    }

    public static <K, V> boolean diff(SortedMap<K, ? extends V> previous, SortedMap<K, ? extends V> current, PropertyDiffListener<K, V> diffListener) {
        Iterator<Map.Entry<K, V>> currentEntries = current.entrySet().iterator();
        Iterator<Map.Entry<K, V>> previousEntries = previous.entrySet().iterator();
        Comparator<K> comparator = previous.comparator();
        if (currentEntries.hasNext() && previousEntries.hasNext()) {
            Map.Entry<K, V> currentEntry = currentEntries.next();
            Map.Entry<K, V> previousEntry = previousEntries.next();
            while (true) {
                K currentProperty;
                K previousProperty;
                int compared;
                if ((compared = comparator.compare(previousProperty = previousEntry.getKey(), currentProperty = currentEntry.getKey())) < 0) {
                    if (!diffListener.removed(previousProperty)) {
                        return false;
                    }
                    if (previousEntries.hasNext()) {
                        previousEntry = previousEntries.next();
                        continue;
                    }
                    if (diffListener.added(currentProperty)) break;
                    return false;
                }
                if (compared > 0) {
                    if (!diffListener.added(currentProperty)) {
                        return false;
                    }
                    if (currentEntries.hasNext()) {
                        currentEntry = currentEntries.next();
                        continue;
                    }
                    if (diffListener.removed(previousProperty)) break;
                    return false;
                }
                if (!diffListener.updated(previousProperty, previousEntry.getValue(), currentEntry.getValue())) {
                    return false;
                }
                if (!previousEntries.hasNext() || !currentEntries.hasNext()) break;
                previousEntry = previousEntries.next();
                currentEntry = currentEntries.next();
            }
        }
        while (currentEntries.hasNext()) {
            if (diffListener.added(currentEntries.next().getKey())) continue;
            return false;
        }
        while (previousEntries.hasNext()) {
            if (diffListener.removed(previousEntries.next().getKey())) continue;
            return false;
        }
        return true;
    }
}

