/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.artifacts.transform.DefaultArtifactTransformDependency;
import org.gradle.api.internal.artifacts.transform.TransformInfo;
import org.gradle.api.internal.artifacts.transform.TransformInfoFactory;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.execution.taskgraph.WorkInfoDependencyResolver;

public class TransformInfoDependencyResolver
implements WorkInfoDependencyResolver {
    private final TransformInfoFactory transformInfoFactory;

    public TransformInfoDependencyResolver(TransformInfoFactory transformInfoFactory) {
        this.transformInfoFactory = transformInfoFactory;
    }

    public boolean resolve(Task task, Object node, Action<? super WorkInfo> resolveAction) {
        if (node instanceof DefaultArtifactTransformDependency) {
            DefaultArtifactTransformDependency transformation = (DefaultArtifactTransformDependency)node;
            Collection<TransformInfo> transforms = this.transformInfoFactory.getOrCreate(transformation.getArtifacts(), transformation.getTransform());
            for (TransformInfo transformInfo : transforms) {
                resolveAction.execute((Object)transformInfo);
            }
            return true;
        }
        return false;
    }
}

