#!/usr/bin/env python
from __future__ import print_function
from setuptools import setup


# This version number is independent of that of gr1c!
MAJOR = 0
MINOR = 0
MICRO = 0

gr1c_version = '{major}.{minor}.{micro}'.format(major=MAJOR, minor=MINOR, micro=MICRO)

with open('gr1c/_version.py', 'w') as f:
    f.write("""# Automatically generated by setup.py of gr1c. Do not edit.
version = '{version}'""".format(version=gr1c_version))


setup(name='gr1c',
      version=gr1c_version,
      author='Scott C. Livingston',
      author_email='slivingston@cds.caltech.edu',
      url='https://github.com/slivingston/gr1c',
      license='BSD',
      description='Python wrapper for gr1c',
      packages=['gr1c'],
      install_requires=['requests'],
      entry_points={'console_scripts': ['gr1c = gr1c.cli:main']},
      classifiers=['Programming Language :: Python :: 2',
                   'Programming Language :: Python :: 2.7',
                   'Programming Language :: Python :: 3',
                   'Programming Language :: Python :: 3.4',
                   'Programming Language :: Python :: 3.5',
                   'Programming Language :: Python :: 3.6']
      )
