#!/usr/bin/env python
# -*- coding: utf-8 -*-
# 
# Copyright 2014 <+YOU OR YOUR COMPANY+>.
# 
# This is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
# 
# This software is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this software; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 51 Franklin Street,
# Boston, MA 02110-1301, USA.
# 

from gnuradio import gr, gr_unittest
from gnuradio import blocks
import ofdm_swig as ofdm

import math

class qa_fbmc_polyphase_network_vcvc (gr_unittest.TestCase):

	def setUp (self):
		self.tb = gr.top_block ()

	def tearDown (self):
		self.tb = None

	def test_001_t (self):
		# set up fg
		M=16
		K=4
		times = int(math.pow(2,15))
		src_data = ([1]*M+[0]*(K-1)*M)*times
		expected_prototype_filter = (0,0.000504820139509509,0.00185569526754471,
0.00358484826646434,0.00498686814506629,0.00522199263172251,0.00344537922397931,
-0.00105123852065672,-0.00870071490413885,-0.0195398549561065,-0.0331210682044539,
-0.0484677578235632,-0.0640811037246842,-0.0780013000368594,-0.0879212992035212,
-0.0913461396995765,-0.0857864376690676,-0.0689710134904352,-0.0390612386319907,
0.00515124018841787,0.0640811037246841,0.137235812588184,0.223163866086969,
0.319472152727300,0.422914277480813,0.529546065902812,0.634938948046854,
0.734437077757005,0.823440257008283,0.897692336735326,0.953553967721316,
0.988239458203851,1.00000000000000,0.988239458203851,0.953553967721316,
0.897692336735326,0.823440257008283,0.734437077757006,0.634938948046855,
0.529546065902812,0.422914277480814,0.319472152727300,0.223163866086969,
0.137235812588184,0.0640811037246846,0.00515124018841800,-0.0390612386319904,
-0.0689710134904355,-0.0857864376690676,-0.0913461396995763,-0.0879212992035213,
-0.0780013000368594,-0.0640811037246842,-0.0484677578235633,-0.0331210682044539,
-0.0195398549561064,-0.00870071490413892,-0.00105123852065680,0.00344537922397946,
0.00522199263172234,0.00498686814506611,0.00358484826646439,0.00185569526754479,
0.000504820139509497)*times

		src = blocks.vector_source_c(src_data,vlen=M)
		pfb = ofdm.fbmc_polyphase_network_vcvc(M=M,K=K,lp=M*K-1,reverse=False)
		dst = blocks.vector_sink_c(vlen=M)

		self.tb.connect(src,pfb,dst)

		self.tb.run ()

		result_data = dst.data()
		self.assertComplexTuplesAlmostEqual(expected_prototype_filter,result_data,6)

	def test_002_t (self):
		M=16
		K=4
		times = int(math.pow(2,15))
		src_data = ([1]*M+[0]*(K-1)*M)*times
		expected_prototype_filter = [0,0.000504820139509509,0.00185569526754471,
	0.00358484826646434,0.00498686814506629,0.00522199263172251,0.00344537922397931,
	-0.00105123852065672,-0.00870071490413885,-0.0195398549561065,-0.0331210682044539,
	-0.0484677578235632,-0.0640811037246842,-0.0780013000368594,-0.0879212992035212,
	-0.0913461396995765,-0.0857864376690676,-0.0689710134904352,-0.0390612386319907,
	0.00515124018841787,0.0640811037246841,0.137235812588184,0.223163866086969,
	0.319472152727300,0.422914277480813,0.529546065902812,0.634938948046854,
	0.734437077757005,0.823440257008283,0.897692336735326,0.953553967721316,
	0.988239458203851,1.00000000000000,0.988239458203851,0.953553967721316,
	0.897692336735326,0.823440257008283,0.734437077757006,0.634938948046855,
	0.529546065902812,0.422914277480814,0.319472152727300,0.223163866086969,
	0.137235812588184,0.0640811037246846,0.00515124018841800,-0.0390612386319904,
	-0.0689710134904355,-0.0857864376690676,-0.0913461396995763,-0.0879212992035213,
	-0.0780013000368594,-0.0640811037246842,-0.0484677578235633,-0.0331210682044539,
	-0.0195398549561064,-0.00870071490413892,-0.00105123852065680,0.00344537922397946,
	0.00522199263172234,0.00498686814506611,0.00358484826646439,0.00185569526754479,
	0.000504820139509497]
		expected_result = list()
		for i in range(4):
			expected_result = expected_result+expected_prototype_filter[i*M:(i+1)*M][::-1]
		expected_result = expected_result*times

		src = blocks.vector_source_c(src_data,vlen=M)
		ppn = ofdm.fbmc_polyphase_network_vcvc(M=M,K=K,lp=M*K-1,reverse=True)
		dst = blocks.vector_sink_c(vlen=M)

		self.tb.connect(src,ppn,dst)

		self.tb.run ()

		result_data = dst.data()
		
		# print expected_result
		# print "he"
		# print result_data
		self.assertComplexTuplesAlmostEqual(expected_result,result_data,6)

	def test_003_t(self):
		M=16
		K=4
		times = int(math.pow(2,15))
		src_data=([1]*M+[0]*(K-1+K-1)*M)*times
		expected_result =(0,-4.43844425297788e-05,-0.000144746643340735,-0.000229721033600555,-0.000241702317553115,-0.000172957974118437,-6.73222103053385e-05,9.14652666448277e-06,9.14652666448277e-06,
		-6.73222103053385e-05,-0.000172957974118437,-0.000241702317553115,-0.000229721033600555,-0.000144746643340735,-4.43844425297788e-05,0,0.00783625991964767,0.00654539436047757,0.00471267081533616,0.00262181122104832,
		0.000556673451227360,-0.00122975020053258,-0.00253610256118183,-0.00322421990011527,-0.00322421990011527,-0.00253610256118183,-0.00122975020053258,0.000556673451227360,0.00262181122104832,0.00471267081533616,
		0.00654539436047757,0.00783625991964767,-0.176123682382894,-0.152674599560967,-0.109433864588856,-0.0530536561649278,0.00783761250230873,0.0639763819992001,0.106869635104845,0.130057321518454,0.130057321518454,
		0.106869635104845,0.0639763819992001,0.00783761250230874,-0.0530536561649278,-0.109433864588856,-0.152674599560967,-0.176123682382894, 1.00199249567327,0.953065957717643,0.862661503689506,0.744542392196474,0.616691187210949,
		0.498572075717917,0.408167621689781,0.359241083733907,0.359241083733907,0.408167621689781,0.498572075717917,0.616691187210949,0.744542392196474,0.862661503689506,0.953065957717643,1.00199249567327,-0.153791862895185,
		-0.125833320432338,-0.0741543196240591,-0.00667860625053750,0.0662765852808373,0.133598579920664,0.185071582764320,0.212909272092562,0.212909272092562,0.185071582764320,0.133598579920664,0.0662765852808373,-0.00667860625053750,
		-0.0741543196240591,-0.125833320432338,-0.153791862895185,0.00642159768927916,0.00540196464670620,0.00296544255829090,-0.000521736080186868,-0.00449422338644395,-0.00828583796744916,-0.0112487312403568,-0.0128711129888704,
		-0.0128711129888704,-0.0112487312403568,-0.00828583796744916,-0.00449422338644395,-0.000521736080186868,0.00296544255829090,0.00540196464670620,0.00642159768927916,-4.33067214321215e-05,-0.000169510599148989,
		-0.000315184517035040,-0.000388982198427558,-0.000334631051482936,-0.000166989805838173,3.48181427418232e-05,0.000170010707241308,0.000170010707241308,3.48181427418232e-05,-0.000166989805838173,-0.000334631051482936,
		-0.000388982198427558,-0.000315184517035040,-0.000169510599148989,-4.33067214321215e-05)*times

		src = blocks.vector_source_c(src_data,vlen=M)
		sfb = ofdm.fbmc_polyphase_network_vcvc(M=M,K=K,lp=M*K-1,reverse=False)
		afb = ofdm.fbmc_polyphase_network_vcvc(M=M,K=K,lp=M*K-1,reverse=True)
		dst = blocks.vector_sink_c(vlen=M)

		self.tb.connect(src,sfb,afb,dst)

		self.tb.run()

		result_data = dst.data()

		self.assertComplexTuplesAlmostEqual(expected_result,result_data,6)
		

if __name__ == '__main__':
	gr_unittest.run(qa_fbmc_polyphase_network_vcvc, "qa_fbmc_polyphase_network_vcvc.xml")
