/* -*- c++ -*- */
/* 
 * Copyright 2016 Bastille Networks.
 * 
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

#ifndef INCLUDED_LORA_H
#define INCLUDED_LORA_H

#include <lora/api.h>
#include <gnuradio/block.h>

namespace gr {
  namespace lora {
    const unsigned short whitening_sequence_length = 279;   // Keep updated with the length of the shortest whitening sequence

    // Consensus-generated whitening sequences
    const unsigned short whitening_sequence_sf6_implicit[537] = {0x000d, 0x0005, 0x0005, 0x0005, 0x000d, 0x0005, 0x0004, 0x0001, 0x0036, 0x000f, 0x0013, 0x0017, 0x0037, 0x0004, 0x0035, 0x000a, 0x0008, 0x002a, 0x003a, 0x000e, 0x0014, 0x0034, 0x0017, 0x0019, 0x0004, 0x0013, 0x002c, 0x0022, 0x001a, 0x0038, 0x0010, 0x0025, 0x0036, 0x0014, 0x0010, 0x0032, 0x000b, 0x003a, 0x0006, 0x0000, 0x002d, 0x0026, 0x0037, 0x000e, 0x0022, 0x000c, 0x001a, 0x0032, 0x0033, 0x0009, 0x000d, 0x0030, 0x001b, 0x003f, 0x0022, 0x0016, 0x0000, 0x0008, 0x003b, 0x0027, 0x002e, 0x002e, 0x002a, 0x001c, 0x0018, 0x0029, 0x0028, 0x002b, 0x0020, 0x000d, 0x0001, 0x0025, 0x0029, 0x0028, 0x002b, 0x002e, 0x000d, 0x0036, 0x0008, 0x0022, 0x000a, 0x0022, 0x0025, 0x0029, 0x0035, 0x0001, 0x0021, 0x001a, 0x0031, 0x0019, 0x0008, 0x0013, 0x0019, 0x003e, 0x0005, 0x0004, 0x002a, 0x002d, 0x0037, 0x002c, 0x0005, 0x0030, 0x003f, 0x0031, 0x0003, 0x0009, 0x0024, 0x0000, 0x001f, 0x0035, 0x0012, 0x002c, 0x0027, 0x0013, 0x003f, 0x0021, 0x0013, 0x001c, 0x0038, 0x002b, 0x0036, 0x000d, 0x0030, 0x0033, 0x002f, 0x0025, 0x0026, 0x002e, 0x0018, 0x002b, 0x003b, 0x000e, 0x0038, 0x002c, 0x0030, 0x0000, 0x002b, 0x003b, 0x002c, 0x002e, 0x002b, 0x002e, 0x000d, 0x003b, 0x0021, 0x000b, 0x0025, 0x0000, 0x0004, 0x0013, 0x003a, 0x0004, 0x0020, 0x0009, 0x003d, 0x0003, 0x0016, 0x0011, 0x003a, 0x0000, 0x0027, 0x0006, 0x003d, 0x0020, 0x0037, 0x0005, 0x0019, 0x0021, 0x0017, 0x0006, 0x0014, 0x0033, 0x0033, 0x000e, 0x0024, 0x001b, 0x0030, 0x001b, 0x001a, 0x0035, 0x0008, 0x003b, 0x003a, 0x002c, 0x002e, 0x003f, 0x0032, 0x002d, 0x0007, 0x0013, 0x001b, 0x0023, 0x0009, 0x0024, 0x0000, 0x0018, 0x0032, 0x000f, 0x0000, 0x0000, 0x0024, 0x0031, 0x002b, 0x0009, 0x002c, 0x0022, 0x002d, 0x0020, 0x003e, 0x0022, 0x000c, 0x0028, 0x0031, 0x0008, 0x0016, 0x0020, 0x0034, 0x0002, 0x000b, 0x0015, 0x0000, 0x0018, 0x0015, 0x0033, 0x0010, 0x0008, 0x001f, 0x0034, 0x0018, 0x0028, 0x001e, 0x003e, 0x0020, 0x001a, 0x003e, 0x0022, 0x002a, 0x0029, 0x000e, 0x000a, 0x0002, 0x000b, 0x003c, 0x0020, 0x000d, 0x0037, 0x0012, 0x0018, 0x0020, 0x001e, 0x003f, 0x0002, 0x0032, 0x0008, 0x001d, 0x002e, 0x0006, 0x000d, 0x0031, 0x0020, 0x002b, 0x002f, 0x0011, 0x0030, 0x000f, 0x0036, 0x003f, 0x0009, 0x0002, 0x001e, 0x0002, 0x003c, 0x0011, 0x001f, 0x0004, 0x0036, 0x0022, 0x0002, 0x002a, 0x0034, 0x0002, 0x001d, 0x0035, 0x0005, 0x0031, 0x000e, 0x0026, 0x0026, 0x0005, 0x0012, 0x0034, 0x0002, 0x0008, 0x0028, 0x0010, 0x0002, 0x0037, 0x0015, 0x0010, 0x0011, 0x002a, 0x002e, 0x0000, 0x0021, 0x001d, 0x0022, 0x0012, 0x001c, 0x0020, 0x000b, 0x002d, 0x0008, 0x003c, 0x0010, 0x0008, 0x0012, 0x0020, 0x0009, 0x0031, 0x0021, 0x001e, 0x002c, 0x0013, 0x003f, 0x0026, 0x0006, 0x000d, 0x0013, 0x0029, 0x0038, 0x002a, 0x000b, 0x0015, 0x0011, 0x001b, 0x0005, 0x000b, 0x0025, 0x0000, 0x0029, 0x0013, 0x001b, 0x0022, 0x0002, 0x0014, 0x0031, 0x0008, 0x001e, 0x002e, 0x0024, 0x001a, 0x001a, 0x003b, 0x003f, 0x0002, 0x003a, 0x0018, 0x003d, 0x0004, 0x0017, 0x000a, 0x0022, 0x0022, 0x000d, 0x002d, 0x0000, 0x0032, 0x003a, 0x0033, 0x001e, 0x000f, 0x0013, 0x003f, 0x0022, 0x0002, 0x001c, 0x0005, 0x0005, 0x0037, 0x0027, 0x0034, 0x0002, 0x0000, 0x002f, 0x0030, 0x0019, 0x001b, 0x0011, 0x0010, 0x001a, 0x002f, 0x0018, 0x002a, 0x003e, 0x0035, 0x002d, 0x0021, 0x0009, 0x0014, 0x003b, 0x0022, 0x000c, 0x0000, 0x0001, 0x0003, 0x001f, 0x001c, 0x001f, 0x003f, 0x0023, 0x0014, 0x001b, 0x0023, 0x000b, 0x0016, 0x000c, 0x0033, 0x0008, 0x000a, 0x003c, 0x0000, 0x0014, 0x0036, 0x0036, 0x0020, 0x0009, 0x003a, 0x0026, 0x000a, 0x0036, 0x002f, 0x0004, 0x0025, 0x0000, 0x0028, 0x0020, 0x0011, 0x001d, 0x001c, 0x0039, 0x0038, 0x002e, 0x0014, 0x0038, 0x0002, 0x001f, 0x0033, 0x0005, 0x0001, 0x0009, 0x002f, 0x0025, 0x0006, 0x0012, 0x0006, 0x0018, 0x0025, 0x0030, 0x0038, 0x0021, 0x0035, 0x0004, 0x003d, 0x0033, 0x001f, 0x0025, 0x0030, 0x0038, 0x0014, 0x0035, 0x003b, 0x003c, 0x001b, 0x0039, 0x000a, 0x001f, 0x0037, 0x0001, 0x0029, 0x0026, 0x0026, 0x0016, 0x0022, 0x0022, 0x0019, 0x003f, 0x002b, 0x002a, 0x0035, 0x0007, 0x0015, 0x0010, 0x002e, 0x0029, 0x000c, 0x0033, 0x0015, 0x0002, 0x001e, 0x0017, 0x000d, 0x003c, 0x0028, 0x0025, 0x003f, 0x0032, 0x001d, 0x003e, 0x001f, 0x0033, 0x0022, 0x002e, 0x0016, 0x0005, 0x0004, 0x003c, 0x0038, 0x002c, 0x003d, 0x001b, 0x0017, 0x0011, 0x001d, 0x0016, 0x000e, 0x0037, 0x001c, 0x0037, 0x0037, 0x0017, 0x0011, 0x0035, 0x0032, 0x0008, 0x0031, 0x0007, 0x0019};
    const unsigned short whitening_sequence_sf7_implicit[465] = {0x0007, 0x001b, 0x000b, 0x000b, 0x001b, 0x0003, 0x0009, 0x000e, 0x0004, 0x003b, 0x0004, 0x002e, 0x001a, 0x006a, 0x003a, 0x0005, 0x006c, 0x0028, 0x0063, 0x0011, 0x0044, 0x000c, 0x000a, 0x0048, 0x0062, 0x0016, 0x007f, 0x001c, 0x000b, 0x0029, 0x003e, 0x0052, 0x004f, 0x000f, 0x006b, 0x0047, 0x0060, 0x0034, 0x004a, 0x006f, 0x0066, 0x0015, 0x0028, 0x0020, 0x007a, 0x0041, 0x001e, 0x002f, 0x0048, 0x0040, 0x0073, 0x0047, 0x0056, 0x005c, 0x0057, 0x001a, 0x0048, 0x0000, 0x0030, 0x0050, 0x007e, 0x0047, 0x0078, 0x005f, 0x0060, 0x0030, 0x0030, 0x0050, 0x0059, 0x0042, 0x0028, 0x0027, 0x0073, 0x0077, 0x007a, 0x0055, 0x000a, 0x0025, 0x0032, 0x006c, 0x005a, 0x004c, 0x004e, 0x0045, 0x0034, 0x007d, 0x001e, 0x0076, 0x0006, 0x0015, 0x0019, 0x0060, 0x006f, 0x0009, 0x002a, 0x0045, 0x005f, 0x006b, 0x0064, 0x004a, 0x0022, 0x0038, 0x0071, 0x0056, 0x0047, 0x001e, 0x000c, 0x0028, 0x0053, 0x005a, 0x005a, 0x0056, 0x0045, 0x0019, 0x0061, 0x0010, 0x0001, 0x0031, 0x004c, 0x006d, 0x0078, 0x0001, 0x0050, 0x0010, 0x0062, 0x0011, 0x003c, 0x0061, 0x0014, 0x0058, 0x0023, 0x0077, 0x003e, 0x0065, 0x0004, 0x0071, 0x004e, 0x0025, 0x0058, 0x0013, 0x000f, 0x002f, 0x0071, 0x0014, 0x000f, 0x000b, 0x0025, 0x0068, 0x0063, 0x001a, 0x0048, 0x0011, 0x006d, 0x0029, 0x0020, 0x0032, 0x0067, 0x0010, 0x0037, 0x0054, 0x0030, 0x0053, 0x0036, 0x0034, 0x007e, 0x004c, 0x0049, 0x0054, 0x0013, 0x0075, 0x0058, 0x0056, 0x0029, 0x0027, 0x0022, 0x0042, 0x0044, 0x0029, 0x0040, 0x0043, 0x007e, 0x0040, 0x002b, 0x007b, 0x0069, 0x0007, 0x003d, 0x0038, 0x0030, 0x0075, 0x0021, 0x0012, 0x002b, 0x0002, 0x0037, 0x006f, 0x0030, 0x0050, 0x0034, 0x005e, 0x003c, 0x007b, 0x0021, 0x0076, 0x0071, 0x0052, 0x0046, 0x0046, 0x0042, 0x003f, 0x004a, 0x0012, 0x005b, 0x0045, 0x002d, 0x0079, 0x0063, 0x0013, 0x0075, 0x0008, 0x0018, 0x0025, 0x000f, 0x0048, 0x0064, 0x001a, 0x0067, 0x005f, 0x007c, 0x0041, 0x0065, 0x0035, 0x0022, 0x001c, 0x006b, 0x0017, 0x000c, 0x0028, 0x005d, 0x0007, 0x0069, 0x0026, 0x007d, 0x000e, 0x0061, 0x001b, 0x004d, 0x004f, 0x007d, 0x004d, 0x002f, 0x006f, 0x0061, 0x0010, 0x0018, 0x0068, 0x002a, 0x0005, 0x001f, 0x0024, 0x0036, 0x0070, 0x0034, 0x0017, 0x0037, 0x007c, 0x002a, 0x0065, 0x0040, 0x0012, 0x0053, 0x000c, 0x007e, 0x0064, 0x0059, 0x0007, 0x003d, 0x0063, 0x0017, 0x0065, 0x0053, 0x0052, 0x0012, 0x006c, 0x0021, 0x0039, 0x0075, 0x002c, 0x0042, 0x0014, 0x0049, 0x0051, 0x0023, 0x0033, 0x004c, 0x0022, 0x006a, 0x000c, 0x0079, 0x0003, 0x0053, 0x0057, 0x0023, 0x0021, 0x0029, 0x0003, 0x0036, 0x0065, 0x0058, 0x0043, 0x003a, 0x006e, 0x007e, 0x0065, 0x003b, 0x0077, 0x0025, 0x0033, 0x0009, 0x0069, 0x002f, 0x000f, 0x000b, 0x006c, 0x003a, 0x0068, 0x0072, 0x0006, 0x0020, 0x0033, 0x0032, 0x0027, 0x0032, 0x007d, 0x0048, 0x0050, 0x0053, 0x0077, 0x007f, 0x005f, 0x0041, 0x0012, 0x0039, 0x0077, 0x0016, 0x005e, 0x0044, 0x0049, 0x006d, 0x0004, 0x0027, 0x0042, 0x004b, 0x0022, 0x0054, 0x000b, 0x0072, 0x0059, 0x006a, 0x006e, 0x007c, 0x004e, 0x0024, 0x007b, 0x0066, 0x001c, 0x003a, 0x0062, 0x0001, 0x0010, 0x0013, 0x003c, 0x006f, 0x0005, 0x001b, 0x004f, 0x0072, 0x0074, 0x007b, 0x0052, 0x003e, 0x006f, 0x0016, 0x002c, 0x004b, 0x0002, 0x0056, 0x004c, 0x000a, 0x002c, 0x000d, 0x0031, 0x0076, 0x005c, 0x0028, 0x0071, 0x003b, 0x006f, 0x0017, 0x001b, 0x004d, 0x0009, 0x0042, 0x000d, 0x004a, 0x0007, 0x0000, 0x0012, 0x002e, 0x000d, 0x0028, 0x0033, 0x001f, 0x0064, 0x0000, 0x0041, 0x000d, 0x002b, 0x0023, 0x0027, 0x0050, 0x005c, 0x0033, 0x007c, 0x002b, 0x0022, 0x0035, 0x0039, 0x0068, 0x0003, 0x0055, 0x0001, 0x0035, 0x007b, 0x0027, 0x007f, 0x003a, 0x0061, 0x0044, 0x0076, 0x000f, 0x002f, 0x004f, 0x001f, 0x0033, 0x0077, 0x0034, 0x0003, 0x003f, 0x006e, 0x002d, 0x002b, 0x001a, 0x0064, 0x004e, 0x0077, 0x001d, 0x0037, 0x0009, 0x0026, 0x0008, 0x0024, 0x001b, 0x002f, 0x007c};
    const unsigned short whitening_sequence_sf8_implicit[409] = {0x0033, 0x001f, 0x0017, 0x0017, 0x0037, 0x0007, 0x0013, 0x001d, 0x00be, 0x0094, 0x00cb, 0x0017, 0x00cf, 0x0039, 0x000e, 0x0097, 0x0017, 0x000b, 0x003c, 0x0078, 0x00ae, 0x00bf, 0x00fe, 0x006c, 0x004e, 0x0075, 0x004b, 0x00d1, 0x002f, 0x00fd, 0x001a, 0x00c3, 0x00f3, 0x00c2, 0x00e6, 0x002d, 0x00e4, 0x00bb, 0x00d3, 0x004a, 0x0083, 0x0027, 0x002e, 0x00fc, 0x00b9, 0x0088, 0x0091, 0x003e, 0x0090, 0x0000, 0x00a0, 0x00a3, 0x0087, 0x0032, 0x0001, 0x009c, 0x0010, 0x0000, 0x0020, 0x00a0, 0x00ba, 0x008f, 0x0073, 0x004e, 0x00c3, 0x0063, 0x0065, 0x00ea, 0x0092, 0x0016, 0x0040, 0x0077, 0x0023, 0x00a5, 0x00ef, 0x00bc, 0x0017, 0x0042, 0x00f7, 0x0083, 0x0072, 0x00cd, 0x00bb, 0x00b3, 0x00df, 0x000c, 0x001d, 0x0024, 0x00d8, 0x0070, 0x0003, 0x00c7, 0x0009, 0x0078, 0x0048, 0x0080, 0x0030, 0x0081, 0x00e3, 0x0025, 0x00e0, 0x00b1, 0x00c0, 0x00c0, 0x00f0, 0x00c0, 0x0021, 0x00e3, 0x0027, 0x00e2, 0x00f4, 0x0023, 0x0084, 0x0028, 0x0073, 0x00e7, 0x007d, 0x00ce, 0x000a, 0x00e2, 0x002d, 0x00be, 0x00d5, 0x008b, 0x00de, 0x001d, 0x0060, 0x00cf, 0x00ed, 0x00fa, 0x009f, 0x001b, 0x0004, 0x0050, 0x00e7, 0x0030, 0x00ab, 0x00b7, 0x008e, 0x001d, 0x0079, 0x00c9, 0x00bb, 0x00c1, 0x00b3, 0x0084, 0x00b8, 0x0030, 0x00c5, 0x0036, 0x0003, 0x0001, 0x0011, 0x0002, 0x0024, 0x00e8, 0x002a, 0x00e4, 0x0067, 0x0028, 0x00d2, 0x0044, 0x0079, 0x00f2, 0x00a0, 0x00b0, 0x006f, 0x00fb, 0x0018, 0x0012, 0x0042, 0x00cd, 0x0020, 0x00e0, 0x006b, 0x00bd, 0x00d3, 0x0044, 0x0069, 0x0073, 0x0065, 0x00e1, 0x00f7, 0x00b6, 0x0085, 0x002b, 0x0076, 0x00ec, 0x00ee, 0x00ad, 0x001e, 0x0084, 0x003a, 0x0094, 0x00c8, 0x0091, 0x00a9, 0x00ba, 0x004e, 0x0042, 0x00d5, 0x004a, 0x0035, 0x006a, 0x0033, 0x00d6, 0x0078, 0x000c, 0x000f, 0x003f, 0x005e, 0x00dd, 0x00c2, 0x0025, 0x0050, 0x0052, 0x00ff, 0x00de, 0x00dd, 0x001b, 0x0021, 0x00e2, 0x0044, 0x0005, 0x001b, 0x0017, 0x000e, 0x005c, 0x0062, 0x00e5, 0x0069, 0x002a, 0x00d3, 0x0046, 0x006d, 0x007b, 0x00f4, 0x0081, 0x00e2, 0x00d4, 0x0092, 0x0005, 0x006a, 0x00f5, 0x009d, 0x000a, 0x0031, 0x000b, 0x0000, 0x0020, 0x0060, 0x00e1, 0x009e, 0x001c, 0x00d3, 0x007e, 0x0071, 0x00c2, 0x00e5, 0x00ab, 0x0088, 0x0038, 0x0093, 0x009f, 0x0042, 0x0064, 0x002a, 0x00f6, 0x0024, 0x00f0, 0x0017, 0x0056, 0x00f5, 0x00cb, 0x00f7, 0x00af, 0x0069, 0x00eb, 0x004a, 0x0007, 0x001e, 0x001d, 0x001a, 0x00d4, 0x0076, 0x00d5, 0x00e4, 0x0004, 0x0058, 0x0050, 0x0041, 0x0043, 0x0049, 0x006b, 0x00b8, 0x0060, 0x0040, 0x0061, 0x0063, 0x0067, 0x0066, 0x00f5, 0x0015, 0x00c3, 0x00f4, 0x00c9, 0x00f3, 0x00a7, 0x00f8, 0x0089, 0x005f, 0x0065, 0x0009, 0x0033, 0x0006, 0x00cc, 0x0005, 0x0072, 0x00ca, 0x008b, 0x0062, 0x00e4, 0x00e9, 0x0033, 0x007e, 0x00cd, 0x0025, 0x005c, 0x00e4, 0x00e9, 0x00b3, 0x00a6, 0x00dd, 0x001b, 0x00fe, 0x0051, 0x00b9, 0x0093, 0x0086, 0x008c, 0x001e, 0x005c, 0x0018, 0x0061, 0x0003, 0x0026, 0x002c, 0x0078, 0x004d, 0x007b, 0x00c4, 0x0089, 0x0067, 0x00ee, 0x00fd, 0x00bb, 0x006a, 0x00fd, 0x00a8, 0x0072, 0x006f, 0x00ff, 0x009f, 0x009e, 0x0060, 0x00f1, 0x00a4, 0x00e5, 0x006b, 0x00f7, 0x008f, 0x001e, 0x00e5, 0x00a3, 0x003c, 0x00a9, 0x00f7, 0x00cf, 0x00bf, 0x003e, 0x002b, 0x00ee, 0x0048, 0x0092, 0x001f, 0x001f, 0x001e, 0x00dc, 0x00e7, 0x00b7, 0x00f1, 0x0066, 0x004f, 0x007e, 0x005d, 0x005b, 0x003a, 0x00cc, 0x0096, 0x00ef, 0x00ca, 0x0059, 0x00de, 0x0049, 0x009a, 0x0092, 0x0038, 0x009e, 0x00f2};
    const unsigned short whitening_sequence_sf9_implicit[360] = {0x001b, 0x0067, 0x003f, 0x002f, 0x006b, 0x000f, 0x0027, 0x003b, 0x004c, 0x01db, 0x0077, 0x01ae, 0x00e2, 0x019c, 0x01ad, 0x0177, 0x005f, 0x01fe, 0x0137, 0x012b, 0x00d1, 0x01c6, 0x008f, 0x0121, 0x017f, 0x01bb, 0x0137, 0x002e, 0x00d0, 0x01e2, 0x001f, 0x002b, 0x016b, 0x0116, 0x006c, 0x0089, 0x00c3, 0x01e2, 0x0112, 0x00bc, 0x0040, 0x0146, 0x0045, 0x0198, 0x004b, 0x01c3, 0x0142, 0x0197, 0x0180, 0x00c1, 0x0143, 0x0146, 0x006d, 0x0199, 0x004a, 0x0191, 0x0186, 0x00c4, 0x01ca, 0x0156, 0x0022, 0x009d, 0x00c9, 0x0191, 0x0101, 0x0046, 0x01cf, 0x015c, 0x0035, 0x008e, 0x01ee, 0x0107, 0x012b, 0x0012, 0x01ec, 0x0159, 0x0076, 0x01ae, 0x013c, 0x0105, 0x016a, 0x011c, 0x00e9, 0x0191, 0x0162, 0x0124, 0x0138, 0x0150, 0x014a, 0x0154, 0x0078, 0x0190, 0x0128, 0x0001, 0x01fa, 0x0079, 0x010b, 0x0057, 0x016c, 0x0118, 0x003f, 0x009a, 0x01f6, 0x0029, 0x0129, 0x0013, 0x01e4, 0x0109, 0x00b5, 0x00bb, 0x0166, 0x0008, 0x017d, 0x013a, 0x00b4, 0x01a9, 0x0191, 0x0062, 0x0166, 0x004c, 0x0157, 0x016e, 0x001c, 0x00b8, 0x0193, 0x0067, 0x0126, 0x0045, 0x01d2, 0x0164, 0x0108, 0x0050, 0x0187, 0x006f, 0x0007, 0x0001, 0x01f8, 0x0131, 0x0122, 0x0044, 0x0105, 0x004a, 0x0087, 0x0109, 0x012d, 0x001b, 0x0076, 0x00ac, 0x0110, 0x0040, 0x00a2, 0x018f, 0x010f, 0x005e, 0x00fc, 0x01b9, 0x0158, 0x0160, 0x00b2, 0x0086, 0x011b, 0x0076, 0x01ac, 0x0119, 0x0068, 0x01b0, 0x00b7, 0x0042, 0x0011, 0x0062, 0x0184, 0x0009, 0x0028, 0x0090, 0x0037, 0x0163, 0x0015, 0x00ea, 0x0195, 0x006b, 0x000d, 0x00da, 0x0013, 0x01a5, 0x001f, 0x00fe, 0x01bd, 0x007b, 0x0045, 0x01da, 0x0081, 0x008d, 0x00df, 0x01fe, 0x01bd, 0x003b, 0x0041, 0x01c2, 0x0088, 0x000b, 0x00fd, 0x01bb, 0x0137, 0x002e, 0x0009, 0x00c2, 0x0088, 0x010a, 0x006c, 0x0199, 0x0073, 0x00a6, 0x010d, 0x005a, 0x0184, 0x019a, 0x0146, 0x01cc, 0x0059, 0x01b2, 0x0187, 0x005f, 0x0116, 0x009b, 0x01d6, 0x016c, 0x0118, 0x0170, 0x0082, 0x00c5, 0x0133, 0x009b, 0x01d6, 0x016d, 0x011a, 0x0074, 0x0042, 0x01c4, 0x01b3, 0x01b3, 0x0117, 0x006f, 0x011e, 0x007c, 0x0167, 0x010e, 0x019b, 0x01f5, 0x003d, 0x003a, 0x01b4, 0x0069, 0x01af, 0x000b, 0x0158, 0x00d4, 0x0038, 0x00b1, 0x00a1, 0x0082, 0x0088, 0x00d3, 0x0175, 0x00c2, 0x0131, 0x00a0, 0x0083, 0x0082, 0x000b, 0x00d6, 0x01b2, 0x00e2, 0x0127, 0x000a, 0x00d4, 0x00e9, 0x011e, 0x0054, 0x00bb, 0x00a3, 0x010f, 0x005a, 0x00f4, 0x01eb, 0x019b, 0x0075, 0x00e8, 0x018a, 0x010d, 0x0058, 0x01f1, 0x0120, 0x009a, 0x00f7, 0x00e8, 0x015e, 0x000c, 0x0058, 0x01f1, 0x0120, 0x0091, 0x00f6, 0x00e9, 0x015a, 0x00c4, 0x01d9, 0x01f3, 0x0121, 0x01b6, 0x002e, 0x01e3, 0x0184, 0x00cf, 0x01dc, 0x017a, 0x0137, 0x01f4, 0x012a, 0x0161, 0x018c, 0x008e, 0x00de, 0x017d, 0x013a, 0x0040, 0x01e0, 0x0144, 0x01c8, 0x00a7, 0x0089, 0x01d6, 0x012d, 0x00c3, 0x01c4, 0x0114, 0x01c8, 0x00a7, 0x0089, 0x00d5, 0x01ed, 0x00e6, 0x0187, 0x013c, 0x01db, 0x00ad, 0x009d, 0x00fd, 0x01fe, 0x00ae, 0x0084, 0x01a7, 0x00f0, 0x01aa, 0x00bf, 0x00ca, 0x019e, 0x018a, 0x005b, 0x0180, 0x0031};
    const unsigned short whitening_sequence_sf10_implicit[337] = {0x0000, 0x0000, 0x0000, 0x0003, 0x0006, 0x0046, 0x0067, 0x00cb, 0x032f, 0x01dd, 0x013f, 0x017d, 0x036d, 0x007f, 0x013f, 0x01dd, 0x00c7, 0x020c, 0x00b7, 0x00b7, 0x0002, 0x01c2, 0x01e5, 0x0323, 0x0326, 0x01cf, 0x001c, 0x0165, 0x0165, 0x010b, 0x0365, 0x02b6, 0x03c5, 0x020c, 0x00bc, 0x00bc, 0x0047, 0x0047, 0x01bb, 0x033a, 0x02c7, 0x000b, 0x0009, 0x02f8, 0x0271, 0x0241, 0x00ff, 0x00ff, 0x0298, 0x02b0, 0x00a1, 0x00a3, 0x0087, 0x03cb, 0x00e5, 0x03b1, 0x02ad, 0x02df, 0x02a9, 0x0370, 0x0371, 0x0005, 0x00bc, 0x00bc, 0x008d, 0x02b9, 0x027d, 0x0194, 0x019c, 0x00df, 0x00de, 0x0252, 0x012f, 0x012d, 0x02b7, 0x036a, 0x036a, 0x003f, 0x0079, 0x0093, 0x02dc, 0x0139, 0x0138, 0x0353, 0x024c, 0x0268, 0x02e0, 0x018c, 0x018c, 0x0297, 0x00b9, 0x00b9, 0x0259, 0x00ba, 0x00bb, 0x0216, 0x01a6, 0x01a6, 0x0293, 0x00fa, 0x00fe, 0x037f, 0x031b, 0x01c4, 0x01cc, 0x021b, 0x026b, 0x0269, 0x036b, 0x0077, 0x018c, 0x0332, 0x0366, 0x0144, 0x000a, 0x02f6, 0x024b, 0x0007, 0x0005, 0x00f1, 0x00a1, 0x0101, 0x0101, 0x018c, 0x027c, 0x0245, 0x02ad, 0x0047, 0x0047, 0x0109, 0x00a7, 0x00a6, 0x0276, 0x02fc, 0x0213, 0x0037, 0x0035, 0x01ef, 0x015a, 0x03b0, 0x02c0, 0x01b8, 0x01b9, 0x021b, 0x01bf, 0x01bd, 0x0070, 0x0071, 0x0001, 0x0000, 0x0144, 0x019c, 0x0233, 0x0233, 0x025a, 0x00eb, 0x00e9, 0x0350, 0x0162, 0x0083, 0x00e9, 0x0021, 0x0023, 0x0347, 0x004b, 0x004b, 0x037e, 0x0136, 0x0137, 0x01e9, 0x005c, 0x01af, 0x00e0, 0x0343, 0x01e3, 0x0036, 0x015e, 0x0132, 0x005a, 0x005a, 0x0331, 0x00c2, 0x0272, 0x013a, 0x013a, 0x01f0, 0x0162, 0x034c, 0x023b, 0x0239, 0x03b5, 0x035f, 0x0344, 0x0118, 0x006a, 0x006f, 0x0097, 0x03cd, 0x01c1, 0x01c1, 0x02ec, 0x0149, 0x0149, 0x027e, 0x0039, 0x0038, 0x00c2, 0x002c, 0x0211, 0x0213, 0x00c1, 0x00c1, 0x02f2, 0x0135, 0x0135, 0x035a, 0x02d9, 0x003d, 0x003d, 0x0379, 0x0298, 0x0042, 0x0046, 0x004c, 0x022a, 0x02db, 0x00b5, 0x00b5, 0x020d, 0x020d, 0x0338, 0x02fd, 0x027e, 0x007f, 0x007f, 0x0377, 0x01e5, 0x0344, 0x0031, 0x0033, 0x02f5, 0x007b, 0x007b, 0x0173, 0x0071, 0x014d, 0x0294, 0x03c1, 0x00cb, 0x021f, 0x0051, 0x0051, 0x0019, 0x01f0, 0x01da, 0x00e5, 0x0021, 0x01c5, 0x001a, 0x0313, 0x0316, 0x008e, 0x0339, 0x033f, 0x0107, 0x0106, 0x0096, 0x0097, 0x01fd, 0x033e, 0x009a, 0x0173, 0x0245, 0x0107, 0x0106, 0x001c, 0x001c, 0x01fd, 0x031d, 0x0051, 0x02e6, 0x0043, 0x0043, 0x018f, 0x011b, 0x01ba, 0x0099, 0x0195, 0x0194, 0x02f1, 0x006f, 0x006f, 0x0034, 0x0035, 0x0001, 0x0090, 0x014a, 0x011a, 0x027b, 0x0182, 0x0183, 0x03c6, 0x0396, 0x0070, 0x0070, 0x0162, 0x0158, 0x0030, 0x0031, 0x0185, 0x018f, 0x018f, 0x0168, 0x0177, 0x0162, 0x0158, 0x037a, 0x0032, 0x000e, 0x000f, 0x0134, 0x01fe, 0x017c, 0x016c, 0x00ea, 0x0371, 0x01c9, 0x026d, 0x031d, 0x03e4, 0x0307, 0x016f, 0x0347, 0x00af, 0x00af, 0x039a, 0x008b};
    const unsigned short whitening_sequence_sf11_implicit[303] = {0x0140, 0x0140, 0x0143, 0x0146, 0x00c4, 0x00c1, 0x012b, 0x00d7, 0x00bd, 0x017d, 0x03ad, 0x05dd, 0x016d, 0x00b5, 0x00a2, 0x0342, 0x048f, 0x031e, 0x03a0, 0x0540, 0x0172, 0x0239, 0x01aa, 0x0150, 0x04a2, 0x034d, 0x07a8, 0x05f6, 0x0164, 0x021a, 0x0758, 0x0092, 0x0122, 0x0342, 0x040d, 0x0254, 0x04c8, 0x01ac, 0x0701, 0x0407, 0x0209, 0x0412, 0x0251, 0x0626, 0x0612, 0x04a0, 0x04e2, 0x0740, 0x0280, 0x0602, 0x0775, 0x04a5, 0x0304, 0x00b8, 0x06eb, 0x03f1, 0x05a2, 0x0147, 0x005e, 0x02fa, 0x05cc, 0x01ab, 0x00b1, 0x0767, 0x04ca, 0x01b1, 0x03fc, 0x05a8, 0x01a0, 0x0747, 0x06b9, 0x0352, 0x04a0, 0x0343, 0x0519, 0x00f1, 0x0141, 0x0501, 0x0008, 0x0617, 0x0439, 0x0353, 0x07f9, 0x0531, 0x02f1, 0x04f8, 0x0291, 0x0326, 0x064e, 0x0695, 0x04fc, 0x03fb, 0x032a, 0x06e1, 0x01a3, 0x0544, 0x049f, 0x0237, 0x04b4, 0x03ef, 0x0507, 0x00bb, 0x06bb, 0x0350, 0x00e0, 0x03c4, 0x041e, 0x0279, 0x02d2, 0x06a9, 0x042d, 0x064a, 0x04b1, 0x0361, 0x048a, 0x031c, 0x002c, 0x0005, 0x039e, 0x013a, 0x0650, 0x07e5, 0x02a0, 0x0702, 0x0190, 0x0291, 0x05ca, 0x0598, 0x0131, 0x0264, 0x0605, 0x0646, 0x04fc, 0x01aa, 0x03b0, 0x0166, 0x00d9, 0x0096, 0x000d, 0x020e, 0x02ba, 0x06b6, 0x0546, 0x0498, 0x0115, 0x0322, 0x00a2, 0x0306, 0x017a, 0x042e, 0x00d2, 0x03a8, 0x035c, 0x04ae, 0x050a, 0x0058, 0x0540, 0x039a, 0x01b4, 0x0164, 0x04d9, 0x00bc, 0x04e1, 0x0305, 0x05d0, 0x05c5, 0x01a8, 0x0176, 0x00e3, 0x03ca, 0x06ae, 0x075a, 0x027e, 0x03b6, 0x0364, 0x00ca, 0x019e, 0x0334, 0x076a, 0x0450, 0x060c, 0x0542, 0x060e, 0x061e, 0x0230, 0x056d, 0x0404, 0x02d9, 0x04a5, 0x00d2, 0x008e, 0x0714, 0x0627, 0x064b, 0x05c6, 0x0100, 0x02fe, 0x01a9, 0x03e0, 0x01c2, 0x058e, 0x0214, 0x044d, 0x029b, 0x05a8, 0x01b4, 0x01d5, 0x05ad, 0x0148, 0x0192, 0x07c8, 0x05b1, 0x00f2, 0x036e, 0x05a1, 0x0140, 0x018c, 0x0009, 0x02a3, 0x078b, 0x0533, 0x0618, 0x0472, 0x02e2, 0x0141, 0x0187, 0x054f, 0x0054, 0x03dc, 0x0080, 0x0089, 0x0335, 0x066d, 0x05c8, 0x0251, 0x06aa, 0x03ed, 0x03e0, 0x078f, 0x010e, 0x0415, 0x0224, 0x0375, 0x04a8, 0x0278, 0x01d6, 0x0066, 0x06c5, 0x018f, 0x020e, 0x0514, 0x00f8, 0x0339, 0x05a3, 0x051a, 0x0036, 0x0665, 0x05c4, 0x05e4, 0x0118, 0x0702, 0x0469, 0x01c1, 0x0189, 0x0315, 0x0628, 0x004c, 0x02dd, 0x0642, 0x009e, 0x0769, 0x00f5, 0x01ec, 0x00c9, 0x0692, 0x07e2, 0x020d, 0x0786, 0x0059, 0x06b4, 0x0376, 0x05e9, 0x06aa, 0x075c, 0x0305, 0x007a, 0x01b9, 0x0179, 0x06f9, 0x04f4, 0x002c, 0x0251, 0x0048, 0x0511, 0x0368, 0x0135, 0x01cd, 0x033c, 0x03c0, 0x044c, 0x0308, 0x01c1, 0x0229};
    const unsigned short whitening_sequence_sf12_implicit[279] = {0x0240, 0x0243, 0x0246, 0x0009, 0x001f, 0x016b, 0x0097, 0x01ef, 0x067f, 0x042f, 0x08dd, 0x07ed, 0x0277, 0x0850, 0x09a2, 0x09a2, 0x018f, 0x02d0, 0x02d0, 0x067b, 0x012d, 0x0eeb, 0x04d4, 0x06a8, 0x06b8, 0x018a, 0x018b, 0x08b6, 0x0508, 0x0b28, 0x0151, 0x01a5, 0x064b, 0x0280, 0x0280, 0x0b86, 0x06fc, 0x0630, 0x0f61, 0x0d41, 0x0e80, 0x0b1c, 0x002e, 0x0930, 0x0a4e, 0x0512, 0x012a, 0x0f5f, 0x0fbb, 0x0430, 0x0964, 0x0bdb, 0x01f4, 0x0940, 0x0184, 0x0184, 0x0f14, 0x08b4, 0x076d, 0x076d, 0x0b2c, 0x010c, 0x0219, 0x053c, 0x0b6e, 0x0785, 0x0204, 0x0000, 0x0f41, 0x0f53, 0x0fa2, 0x0c40, 0x018c, 0x0100, 0x0e00, 0x071d, 0x0701, 0x0b48, 0x0193, 0x0e2f, 0x0b5b, 0x08f4, 0x07ff, 0x07fd, 0x0859, 0x0644, 0x0999, 0x0999, 0x0b6a, 0x0b6a, 0x08dc, 0x030d, 0x0103, 0x0fbb, 0x0c51, 0x07e7, 0x07e7, 0x0194, 0x0191, 0x0c90, 0x0e48, 0x0e15, 0x0b2f, 0x0f4a, 0x01b3, 0x0543, 0x000b, 0x090c, 0x0918, 0x0919, 0x09c9, 0x009e, 0x009e, 0x051b, 0x01b1, 0x06fe, 0x054e, 0x0b68, 0x01d0, 0x02e4, 0x02e4, 0x0141, 0x0103, 0x039c, 0x0ef2, 0x0b5f, 0x01b4, 0x01b4, 0x0bc9, 0x00ea, 0x00c2, 0x06b2, 0x0100, 0x0058, 0x0bbf, 0x0839, 0x0bd6, 0x0f49, 0x0eb5, 0x07d8, 0x072e, 0x09e8, 0x02f1, 0x08ea, 0x08ea, 0x0a2d, 0x09d6, 0x0fcb, 0x0a6b, 0x049c, 0x0639, 0x0575, 0x09e8, 0x0141, 0x0100, 0x075b, 0x094f, 0x094f, 0x096b, 0x03dc, 0x02ba, 0x0b59, 0x0095, 0x0efb, 0x0158, 0x0110, 0x0f6d, 0x03c8, 0x03c8, 0x0a3a, 0x09f8, 0x0036, 0x09b4, 0x0214, 0x0b2e, 0x0f4b, 0x0f93, 0x0785, 0x030d, 0x0a90, 0x07d7, 0x00e0, 0x00e0, 0x0898, 0x0898, 0x01c6, 0x01c2, 0x086f, 0x0664, 0x08f9, 0x06d0, 0x08a2, 0x064d, 0x064c, 0x0adf, 0x09db, 0x0064, 0x0feb, 0x0cf2, 0x06a1, 0x06c7, 0x07ce, 0x0397, 0x0ebf, 0x0305, 0x0304, 0x0b97, 0x0e3a, 0x0953, 0x098e, 0x0290, 0x027b, 0x00b7, 0x0b6e, 0x01d7, 0x00a4, 0x00a4, 0x09d2, 0x0228, 0x0000, 0x0bba, 0x090a, 0x0f8b, 0x0c36, 0x0b21, 0x07c8, 0x02bc, 0x026e, 0x0ffb, 0x0a1e, 0x0937, 0x0f64, 0x0bc7, 0x08e9, 0x06d6, 0x08a6, 0x0319, 0x0371, 0x0fe6, 0x02ca, 0x0082, 0x02a6, 0x0082, 0x0482, 0x0a27, 0x04c4, 0x0699, 0x0a39, 0x0b78, 0x0282, 0x0282, 0x0f5a, 0x0d5b, 0x0c53, 0x0bfe, 0x02d0, 0x06e2, 0x00b2, 0x00b2, 0x0448, 0x0a05, 0x0675, 0x09f9, 0x00f8, 0x00f0, 0x0452, 0x0e29, 0x0c3d, 0x0368, 0x0128, 0x069a, 0x06ed, 0x0489, 0x0581, 0x01e1, 0x050d, 0x0781, 0x0781, 0x0168};

    const unsigned short whitening_sequence_sf6_ldr_implicit[801] = {0x000d, 0x0005, 0x0005, 0x0005, 0x000d, 0x0005, 0x0004, 0x0001, 0x000c, 0x0003, 0x0004, 0x0005, 0x000d, 0x0001, 0x0005, 0x0007, 0x0000, 0x0003, 0x000c, 0x0003, 0x0000, 0x0003, 0x000f, 0x0006, 0x0002, 0x000e, 0x000f, 0x0003, 0x0009, 0x0004, 0x0005, 0x000b, 0x0007, 0x000c, 0x000b, 0x0008, 0x0006, 0x000a, 0x0000, 0x000b, 0x000f, 0x000d, 0x0001, 0x000c, 0x0009, 0x0005, 0x0004, 0x0008, 0x000c, 0x0003, 0x0000, 0x0004, 0x000f, 0x0008, 0x0007, 0x000e, 0x0001, 0x0001, 0x000c, 0x0003, 0x0009, 0x0001, 0x0006, 0x0004, 0x0002, 0x000e, 0x0007, 0x0007, 0x0008, 0x0002, 0x0004, 0x000d, 0x000c, 0x0006, 0x000b, 0x0008, 0x0001, 0x0000, 0x000e, 0x0005, 0x000e, 0x000b, 0x000c, 0x0009, 0x000a, 0x000e, 0x0006, 0x0001, 0x000a, 0x000b, 0x0008, 0x0002, 0x000c, 0x0002, 0x000a, 0x0003, 0x0002, 0x000a, 0x000a, 0x0002, 0x0002, 0x000b, 0x000f, 0x0006, 0x000a, 0x000e, 0x000b, 0x000a, 0x0003, 0x000c, 0x0002, 0x000e, 0x0006, 0x000a, 0x000a, 0x0008, 0x0006, 0x000e, 0x0001, 0x000d, 0x0003, 0x000d, 0x0009, 0x000a, 0x0004, 0x0007, 0x000e, 0x0009, 0x000e, 0x000e, 0x0003, 0x0004, 0x0006, 0x000f, 0x000d, 0x0003, 0x0004, 0x0003, 0x0008, 0x0008, 0x0006, 0x000f, 0x0003, 0x0004, 0x000a, 0x000f, 0x000d, 0x0003, 0x0007, 0x000d, 0x0000, 0x000e, 0x000f, 0x0008, 0x000a, 0x0000, 0x0007, 0x000d, 0x000d, 0x0003, 0x0003, 0x0009, 0x0000, 0x000e, 0x000c, 0x0007, 0x0007, 0x000b, 0x0009, 0x0004, 0x0003, 0x0006, 0x000d, 0x0001, 0x0008, 0x000a, 0x000c, 0x0002, 0x0006, 0x000d, 0x000b, 0x0009, 0x0005, 0x000e, 0x0008, 0x0003, 0x000c, 0x000b, 0x0008, 0x0002, 0x000a, 0x000a, 0x0002, 0x000a, 0x000e, 0x0003, 0x0000, 0x0002, 0x000d, 0x000f, 0x000b, 0x000c, 0x000b, 0x000a, 0x000a, 0x000e, 0x000b, 0x000c, 0x0006, 0x000a, 0x0002, 0x000c, 0x0007, 0x0008, 0x0000, 0x000b, 0x0008, 0x0007, 0x0009, 0x000a, 0x0003, 0x000d, 0x0000, 0x0007, 0x000f, 0x0008, 0x000e, 0x0001, 0x0005, 0x0004, 0x000f, 0x000a, 0x0002, 0x000b, 0x0000, 0x000e, 0x0005, 0x0005, 0x000e, 0x0009, 0x0009, 0x0004, 0x000b, 0x0002, 0x000c, 0x0007, 0x0009, 0x000c, 0x0007, 0x0008, 0x0006, 0x000d, 0x000c, 0x0003, 0x000b, 0x0000, 0x0009, 0x0005, 0x0001, 0x000e, 0x000b, 0x0009, 0x0008, 0x0003, 0x0004, 0x0002, 0x0006, 0x0005, 0x0003, 0x0008, 0x0000, 0x0002, 0x0008, 0x0007, 0x000d, 0x000b, 0x0001, 0x0004, 0x0002, 0x000e, 0x000e, 0x000a, 0x000e, 0x0001, 0x000c, 0x0006, 0x0006, 0x0008, 0x0002, 0x000b, 0x0008, 0x000a, 0x0004, 0x0003, 0x000f, 0x000f, 0x0002, 0x000e, 0x000b, 0x0002, 0x000b, 0x000d, 0x0007, 0x0002, 0x0006, 0x000e, 0x000b, 0x0008, 0x000f, 0x0008, 0x0009, 0x0009, 0x000f, 0x000d, 0x0009, 0x0008, 0x0008, 0x0003, 0x0005, 0x000e, 0x0007, 0x0009, 0x0000, 0x0004, 0x0008, 0x0002, 0x0009, 0x0000, 0x0000, 0x0007, 0x0001, 0x0006, 0x000a, 0x000a, 0x0004, 0x000d, 0x0004, 0x0006, 0x000f, 0x0001, 0x000b, 0x0008, 0x0009, 0x0000, 0x000f, 0x000d, 0x000d, 0x0009, 0x000a, 0x000a, 0x0007, 0x0007, 0x0006, 0x000b, 0x0000, 0x0004, 0x0001, 0x0000, 0x0000, 0x0002, 0x0000, 0x0007, 0x0009, 0x0002, 0x000b, 0x000c, 0x0005, 0x000b, 0x000f, 0x000c, 0x000f, 0x0001, 0x000c, 0x0002, 0x0007, 0x000e, 0x000e, 0x000b, 0x0000, 0x000c, 0x0009, 0x0001, 0x0005, 0x000e, 0x0000, 0x0003, 0x0008, 0x0002, 0x0002, 0x000a, 0x000d, 0x000f, 0x0003, 0x000c, 0x000f, 0x0003, 0x0000, 0x0006, 0x000c, 0x0009, 0x0007, 0x000c, 0x0003, 0x000c, 0x0007, 0x000c, 0x0001, 0x000d, 0x0004, 0x0007, 0x0001, 0x000c, 0x000e, 0x000f, 0x000a, 0x0006, 0x000d, 0x0005, 0x000d, 0x0001, 0x000c, 0x0003, 0x0005, 0x0007, 0x0007, 0x0009, 0x0004, 0x0005, 0x000a, 0x000b, 0x000b, 0x0009, 0x0001, 0x0005, 0x0001, 0x0006, 0x0003, 0x0008, 0x000d, 0x000f, 0x0004, 0x0006, 0x0007, 0x0005, 0x000a, 0x000e, 0x0008, 0x0006, 0x0004, 0x0007, 0x000d, 0x0009, 0x000d, 0x0000, 0x0009, 0x0009, 0x0007, 0x000d, 0x000d, 0x0001, 0x0002, 0x000b, 0x0002, 0x000b, 0x0006, 0x000f, 0x0001, 0x0004, 0x0008, 0x0006, 0x0008, 0x0006, 0x000c, 0x0007, 0x0009, 0x0000, 0x0007, 0x0008, 0x000e, 0x000c, 0x0006, 0x000b, 0x000c, 0x0001, 0x0002, 0x000f, 0x0003, 0x000d, 0x000a, 0x000f, 0x0009, 0x0002, 0x0005, 0x0004, 0x0002, 0x0007, 0x000e, 0x000a, 0x000a, 0x0000, 0x000e, 0x000f, 0x0004, 0x0001, 0x0003, 0x0009, 0x0008, 0x000a, 0x000d, 0x0001, 0x0006, 0x000d, 0x0002, 0x000e, 0x0003, 0x0006, 0x000a, 0x000b, 0x0006, 0x0004, 0x000d, 0x0004, 0x000b, 0x0008, 0x0008, 0x0002, 0x0007, 0x0007, 0x000e, 0x000b, 0x0004, 0x000d, 0x000b, 0x0008, 0x0007, 0x0007, 0x0001, 0x0001, 0x0008, 0x0002, 0x000b, 0x0008, 0x0004, 0x000d, 0x0003, 0x000c, 0x0007, 0x0007, 0x0001, 0x0000, 0x000d, 0x000f, 0x000c, 0x0006, 0x0003, 0x000c, 0x0000, 0x0006, 0x000f, 0x0003, 0x0005, 0x0001, 0x000c, 0x0009, 0x000d, 0x0004, 0x0008, 0x000f, 0x000b, 0x000d, 0x0005, 0x0007, 0x000f, 0x0009, 0x0008, 0x000a, 0x0004, 0x0002, 0x0002, 0x0004, 0x0001, 0x0001, 0x0002, 0x000b, 0x0009, 0x0005, 0x000d, 0x000b, 0x0008, 0x0006, 0x000b, 0x000c, 0x000e, 0x000a, 0x0006, 0x0005, 0x000d, 0x0000, 0x0007, 0x000e, 0x0009, 0x0001, 0x0008, 0x000a, 0x0003, 0x0009, 0x0001, 0x0001, 0x0003, 0x0008, 0x0006, 0x0007, 0x0008, 0x0006, 0x0005, 0x000b, 0x0000, 0x0006, 0x0003, 0x000e, 0x000c, 0x0002, 0x0004, 0x0004, 0x000c, 0x0006, 0x000f, 0x0009, 0x0003, 0x0009, 0x000c, 0x000c, 0x000f, 0x0009, 0x000c, 0x0009, 0x0003, 0x000c, 0x000f, 0x0003, 0x000a, 0x000b, 0x0000, 0x0006, 0x000d, 0x0004, 0x000b, 0x0005, 0x0009, 0x0000, 0x000a, 0x0002, 0x0005, 0x0001, 0x0001, 0x0008, 0x000b, 0x0008, 0x0006, 0x000f, 0x0000, 0x0007, 0x0000, 0x0007, 0x0000, 0x0002, 0x0002, 0x000e, 0x0005, 0x0004, 0x000c, 0x0000, 0x0000, 0x0006, 0x000f, 0x000b, 0x000f, 0x000d, 0x0007, 0x000b, 0x0006, 0x000e, 0x000f, 0x0009, 0x000d, 0x0001, 0x000b, 0x0000, 0x000e, 0x000f, 0x0009, 0x0008, 0x0001, 0x0001, 0x000c, 0x000c, 0x0007, 0x0009, 0x0008, 0x0000, 0x0009, 0x0004, 0x0008, 0x0006, 0x000b, 0x000d, 0x0001, 0x0006, 0x000d, 0x0000, 0x000a, 0x0003, 0x0005, 0x0000, 0x0002, 0x0004, 0x0008, 0x0003, 0x000b, 0x0009, 0x0009, 0x0005, 0x0005, 0x000f, 0x0009, 0x0000, 0x000a, 0x000a, 0x0005, 0x0000, 0x0006, 0x0005, 0x000a, 0x000a, 0x0009, 0x0000, 0x0008, 0x0007, 0x0005, 0x000f, 0x0000, 0x0002, 0x0003, 0x0008, 0x0005, 0x0000, 0x000e, 0x0001, 0x000b, 0x000c, 0x0008, 0x0006, 0x0003, 0x000d, 0x0005, 0x000f, 0x0007, 0x0008, 0x000d, 0x0006, 0x0004, 0x0006, 0x0003, 0x0004, 0x0008, 0x0007, 0x000a, 0x000f, 0x0005, 0x0005, 0x000d, 0x0009, 0x0004, 0x0002, 0x0000, 0x000b, 0x0007, 0x000d, 0x0005, 0x0005, 0x0003, 0x000d, 0x0003, 0x000d, 0x000d, 0x0005, 0x0001, 0x0004, 0x000f, 0x000c, 0x0006, 0x0008, 0x000d, 0x0001, 0x0004, 0x0005, 0x0004, 0x0003, 0x000c, 0x0005, 0x0004};
    const unsigned short whitening_sequence_sf7_ldr_implicit[641] = {0x0007, 0x001b, 0x000b, 0x000b, 0x001b, 0x0003, 0x0009, 0x000e, 0x0019, 0x000e, 0x0001, 0x000a, 0x0007, 0x001b, 0x000f, 0x0009, 0x001d, 0x0017, 0x001a, 0x0005, 0x000e, 0x001a, 0x000a, 0x0004, 0x000e, 0x0011, 0x0016, 0x0000, 0x001d, 0x0015, 0x000d, 0x0000, 0x0005, 0x001f, 0x0003, 0x001a, 0x0013, 0x0003, 0x0009, 0x0004, 0x0009, 0x000e, 0x0011, 0x0002, 0x000d, 0x001e, 0x0009, 0x001a, 0x001d, 0x001f, 0x001b, 0x0007, 0x001c, 0x0017, 0x0012, 0x0001, 0x0018, 0x0005, 0x0016, 0x0000, 0x0008, 0x000d, 0x001e, 0x000b, 0x0004, 0x0015, 0x001e, 0x0011, 0x0014, 0x0015, 0x001d, 0x000e, 0x0014, 0x001c, 0x0015, 0x0012, 0x0006, 0x0018, 0x0004, 0x0001, 0x0015, 0x0016, 0x0010, 0x0014, 0x0007, 0x0018, 0x001e, 0x0000, 0x000c, 0x0014, 0x0014, 0x0004, 0x001d, 0x0016, 0x0001, 0x001a, 0x0011, 0x000f, 0x0013, 0x0016, 0x0008, 0x000f, 0x0015, 0x0006, 0x0018, 0x0004, 0x001c, 0x0001, 0x0000, 0x000d, 0x001b, 0x0003, 0x0017, 0x0013, 0x001a, 0x0015, 0x0003, 0x0008, 0x001e, 0x0000, 0x001e, 0x0010, 0x0004, 0x0008, 0x001b, 0x0002, 0x000a, 0x0011, 0x0019, 0x0007, 0x0002, 0x001c, 0x0019, 0x0007, 0x001f, 0x0016, 0x001d, 0x0017, 0x001a, 0x0001, 0x000e, 0x001b, 0x0002, 0x0014, 0x0006, 0x0011, 0x0016, 0x0000, 0x001c, 0x0015, 0x001d, 0x0004, 0x0004, 0x001c, 0x0005, 0x001a, 0x000c, 0x001d, 0x0002, 0x0012, 0x0015, 0x001e, 0x0011, 0x0016, 0x0015, 0x0015, 0x0006, 0x0005, 0x001a, 0x0000, 0x0014, 0x0004, 0x0008, 0x000e, 0x0012, 0x0011, 0x0010, 0x0005, 0x000e, 0x001d, 0x000f, 0x0019, 0x0001, 0x000c, 0x0005, 0x0016, 0x0018, 0x0011, 0x000b, 0x000b, 0x0016, 0x0018, 0x001f, 0x001a, 0x0011, 0x0006, 0x0018, 0x0007, 0x0012, 0x0001, 0x000a, 0x0001, 0x0006, 0x000c, 0x000e, 0x0019, 0x0015, 0x0000, 0x000c, 0x001d, 0x000f, 0x001b, 0x0005, 0x001d, 0x0017, 0x001e, 0x0011, 0x000f, 0x0013, 0x0012, 0x0008, 0x000e, 0x001d, 0x0016, 0x0004, 0x0014, 0x001c, 0x0001, 0x0018, 0x0005, 0x001d, 0x0004, 0x0016, 0x0018, 0x0015, 0x0016, 0x000a, 0x0009, 0x0009, 0x0019, 0x001d, 0x0016, 0x0000, 0x001c, 0x0004, 0x001d, 0x000c, 0x0015, 0x001f, 0x0013, 0x0012, 0x0004, 0x0006, 0x0018, 0x000b, 0x0006, 0x0001, 0x0007, 0x0002, 0x0008, 0x0010, 0x0004, 0x0002, 0x0008, 0x001f, 0x001a, 0x0019, 0x0003, 0x001c, 0x0014, 0x001e, 0x001b, 0x0013, 0x0003, 0x0002, 0x000c, 0x0014, 0x0015, 0x000b, 0x0012, 0x000d, 0x0016, 0x0008, 0x0009, 0x0008, 0x000c, 0x0005, 0x0005, 0x001a, 0x0009, 0x0017, 0x0006, 0x0016, 0x0011, 0x000b, 0x0016, 0x0010, 0x0005, 0x000e, 0x0019, 0x000f, 0x0018, 0x0009, 0x001c, 0x000e, 0x0010, 0x001c, 0x0011, 0x0015, 0x0017, 0x0009, 0x0000, 0x0006, 0x0019, 0x0007, 0x001e, 0x000c, 0x001e, 0x000e, 0x0008, 0x0001, 0x000e, 0x0001, 0x001a, 0x000e, 0x0019, 0x001a, 0x0007, 0x000b, 0x000a, 0x0019, 0x0007, 0x0005, 0x001d, 0x0000, 0x0008, 0x001a, 0x0009, 0x000f, 0x000f, 0x0010, 0x0006, 0x000d, 0x000d, 0x0003, 0x0003, 0x000a, 0x0019, 0x0018, 0x0004, 0x0002, 0x0002, 0x0002, 0x0008, 0x000d, 0x000b, 0x0015, 0x0015, 0x0010, 0x0019, 0x0003, 0x000a, 0x0009, 0x001f, 0x0006, 0x001a, 0x0013, 0x0015, 0x001f, 0x001a, 0x0009, 0x000f, 0x001e, 0x0010, 0x0014, 0x001a, 0x0019, 0x0007, 0x0002, 0x000c, 0x0019, 0x0005, 0x001e, 0x001e, 0x0000, 0x0005, 0x001e, 0x0001, 0x0005, 0x001f, 0x000e, 0x0007, 0x0014, 0x001c, 0x001d, 0x0013, 0x0002, 0x000a, 0x0000, 0x000b, 0x001a, 0x0000, 0x0014, 0x0014, 0x0008, 0x000c, 0x0013, 0x0019, 0x0004, 0x0015, 0x000e, 0x001d, 0x0016, 0x0011, 0x0017, 0x000f, 0x0007, 0x001a, 0x0011, 0x0012, 0x0011, 0x0004, 0x000f, 0x001f, 0x0008, 0x000c, 0x0005, 0x000e, 0x001c, 0x0016, 0x0009, 0x000f, 0x0019, 0x000f, 0x001b, 0x0017, 0x000d, 0x001d, 0x0001, 0x0008, 0x0018, 0x0005, 0x001e, 0x0001, 0x000c, 0x001f, 0x001a, 0x0001, 0x000b, 0x0003, 0x001a, 0x0011, 0x001b, 0x0001, 0x0010, 0x0017, 0x001c, 0x001d, 0x000f, 0x000b, 0x000d, 0x001f, 0x0012, 0x0014, 0x0003, 0x0003, 0x0012, 0x0010, 0x001e, 0x0013, 0x0004, 0x0019, 0x001c, 0x001c, 0x000d, 0x000b, 0x0001, 0x000d, 0x0013, 0x0016, 0x001f, 0x0013, 0x0012, 0x0014, 0x0006, 0x001a, 0x000a, 0x000e, 0x001e, 0x0011, 0x0006, 0x0008, 0x0017, 0x0010, 0x000b, 0x0013, 0x0005, 0x0017, 0x0002, 0x0018, 0x0001, 0x000e, 0x0011, 0x0001, 0x001f, 0x001a, 0x0011, 0x0002, 0x0018, 0x0006, 0x001a, 0x0011, 0x001c, 0x0015, 0x0006, 0x000c, 0x001b, 0x0001, 0x0006, 0x000b, 0x0005, 0x0017, 0x0012, 0x0010, 0x0003, 0x000b, 0x0013, 0x0010, 0x000c, 0x001c, 0x0015, 0x0002, 0x000f, 0x001a, 0x0011, 0x000f, 0x0000, 0x000d, 0x0017, 0x0016, 0x0013, 0x0003, 0x001b, 0x0010, 0x0000, 0x000c, 0x001d, 0x0013, 0x001b, 0x0002, 0x0016, 0x0008, 0x0000, 0x000c, 0x001d, 0x0017, 0x001b, 0x0003, 0x001e, 0x0018, 0x0013, 0x000a, 0x0019, 0x0017, 0x000c, 0x001f, 0x0015, 0x0006, 0x000a, 0x0000, 0x000c, 0x000d, 0x0006, 0x0019, 0x0010, 0x0008, 0x001f, 0x001b, 0x000b, 0x001f, 0x0012, 0x0000, 0x0014, 0x0010, 0x001b, 0x0003, 0x0002, 0x0008, 0x0015, 0x0014, 0x0013, 0x0006, 0x0008, 0x0005, 0x000e, 0x0009, 0x0006, 0x001a, 0x001c, 0x0012, 0x0007, 0x001b, 0x001b, 0x0013, 0x0019, 0x0004, 0x000a, 0x0017, 0x000a, 0x0008, 0x0005, 0x000a, 0x0010, 0x0007, 0x0004, 0x0017, 0x0003, 0x000b, 0x000b, 0x001f, 0x000a, 0x0008, 0x0012, 0x0017, 0x0003, 0x000a, 0x0009, 0x000b, 0x0006, 0x0019, 0x001a, 0x000d, 0x001b, 0x000a, 0x0009, 0x000f, 0x000f, 0x0018, 0x0006, 0x001b, 0x001b};
    const unsigned short whitening_sequence_sf8_ldr_implicit[537] = {0x0033, 0x001f, 0x0017, 0x0017, 0x0037, 0x0007, 0x0013, 0x001d, 0x0002, 0x000d, 0x0032, 0x0005, 0x0031, 0x000f, 0x0003, 0x0035, 0x000c, 0x0030, 0x0039, 0x000b, 0x0024, 0x0002, 0x0007, 0x002c, 0x003f, 0x0036, 0x0005, 0x003a, 0x0014, 0x0011, 0x0036, 0x002b, 0x0012, 0x000d, 0x0002, 0x0014, 0x003f, 0x0021, 0x001f, 0x0002, 0x0009, 0x003b, 0x003f, 0x000f, 0x0038, 0x002f, 0x0034, 0x0012, 0x0022, 0x001c, 0x0021, 0x0022, 0x0004, 0x0010, 0x001a, 0x0017, 0x002a, 0x002c, 0x0030, 0x0009, 0x003a, 0x0029, 0x0028, 0x000d, 0x002c, 0x0020, 0x0028, 0x0008, 0x0009, 0x003c, 0x000e, 0x002b, 0x0018, 0x0028, 0x0008, 0x0038, 0x002f, 0x0022, 0x001c, 0x0012, 0x002d, 0x0033, 0x002f, 0x002e, 0x0010, 0x001f, 0x003a, 0x001c, 0x0012, 0x000c, 0x0000, 0x0030, 0x0027, 0x0000, 0x000f, 0x0027, 0x0008, 0x0039, 0x003b, 0x000f, 0x001d, 0x0037, 0x0031, 0x000a, 0x000e, 0x0034, 0x0021, 0x002a, 0x0036, 0x0003, 0x0007, 0x0009, 0x003b, 0x003e, 0x0005, 0x001a, 0x0035, 0x0005, 0x0010, 0x0028, 0x0022, 0x000d, 0x0022, 0x0004, 0x0038, 0x002b, 0x002b, 0x0038, 0x000c, 0x0020, 0x0038, 0x0009, 0x0000, 0x0018, 0x0026, 0x0026, 0x0018, 0x0038, 0x0009, 0x003a, 0x000b, 0x0038, 0x003d, 0x0018, 0x000a, 0x003d, 0x0023, 0x002e, 0x000f, 0x0036, 0x0031, 0x002f, 0x000a, 0x003c, 0x0021, 0x000a, 0x0017, 0x0017, 0x0021, 0x000a, 0x000b, 0x003e, 0x0025, 0x000a, 0x0032, 0x000f, 0x0024, 0x0012, 0x0027, 0x0016, 0x0025, 0x0002, 0x0000, 0x001c, 0x0039, 0x000c, 0x0036, 0x0004, 0x0010, 0x0011, 0x000f, 0x0030, 0x0001, 0x0029, 0x0038, 0x0029, 0x001a, 0x001d, 0x003e, 0x0027, 0x0024, 0x003a, 0x002c, 0x0021, 0x002a, 0x002c, 0x0011, 0x001d, 0x001e, 0x000e, 0x0019, 0x002a, 0x000c, 0x0038, 0x000a, 0x003a, 0x0019, 0x000a, 0x0001, 0x001b, 0x002f, 0x0026, 0x0022, 0x000c, 0x0027, 0x0002, 0x0003, 0x001e, 0x0035, 0x0023, 0x0028, 0x002c, 0x0037, 0x0002, 0x0006, 0x0014, 0x0031, 0x0003, 0x002c, 0x0020, 0x0014, 0x0019, 0x001a, 0x003c, 0x0011, 0x001b, 0x0019, 0x0039, 0x003d, 0x003d, 0x000e, 0x0035, 0x0023, 0x000e, 0x002e, 0x0022, 0x0017, 0x002c, 0x003a, 0x003c, 0x0001, 0x001a, 0x0010, 0x001d, 0x0015, 0x0030, 0x000e, 0x0025, 0x0022, 0x000c, 0x000a, 0x0038, 0x0036, 0x0026, 0x001d, 0x0032, 0x000d, 0x001a, 0x000f, 0x0034, 0x001e, 0x0003, 0x0016, 0x0015, 0x0003, 0x0036, 0x003a, 0x002f, 0x0018, 0x000b, 0x001e, 0x0035, 0x0013, 0x001f, 0x0020, 0x000c, 0x000b, 0x001b, 0x003f, 0x0037, 0x0007, 0x001e, 0x000c, 0x0030, 0x0026, 0x000e, 0x0013, 0x000f, 0x0006, 0x0014, 0x001a, 0x0039, 0x001a, 0x001a, 0x0025, 0x0013, 0x003f, 0x0007, 0x000a, 0x003c, 0x0029, 0x000c, 0x0033, 0x000e, 0x0014, 0x0031, 0x000b, 0x003c, 0x0022, 0x0032, 0x0024, 0x0001, 0x003a, 0x0005, 0x000b, 0x003e, 0x000d, 0x001e, 0x0038, 0x0028, 0x0018, 0x0039, 0x0026, 0x0006, 0x0034, 0x001f, 0x002d, 0x0023, 0x002e, 0x002c, 0x0034, 0x0005, 0x001b, 0x0016, 0x0035, 0x0002, 0x000c, 0x0030, 0x0038, 0x0029, 0x0004, 0x0014, 0x0010, 0x0009, 0x001a, 0x0035, 0x002d, 0x0020, 0x001f, 0x0027, 0x000d, 0x0033, 0x003f, 0x002f, 0x0019, 0x003b, 0x0012, 0x0011, 0x0012, 0x001c, 0x0001, 0x0032, 0x0003, 0x001a, 0x002e, 0x002d, 0x002f, 0x0037, 0x0037, 0x000f, 0x0002, 0x001e, 0x003a, 0x0039, 0x0016, 0x0004, 0x0000, 0x0010, 0x0006, 0x0014, 0x0029, 0x0024, 0x0038, 0x0039, 0x001b, 0x001f, 0x001a, 0x003d, 0x0005, 0x0030, 0x000b, 0x002f, 0x0026, 0x002c, 0x000e, 0x0034, 0x0015, 0x003d, 0x0001, 0x001a, 0x002d, 0x0002, 0x003a, 0x002d, 0x0037, 0x0027, 0x0002, 0x001c, 0x0031, 0x0023, 0x000d, 0x0034, 0x0032, 0x001a, 0x002a, 0x003c, 0x0031, 0x000b, 0x001e, 0x0033, 0x0009, 0x0007, 0x000b, 0x002e, 0x0024, 0x0008, 0x0016, 0x0015, 0x0005, 0x0018, 0x0000, 0x0018, 0x0029, 0x0002, 0x001f, 0x0035, 0x0032, 0x003f, 0x002e, 0x0034, 0x0031, 0x002b, 0x003f, 0x0027, 0x002f, 0x0004, 0x003b, 0x002e, 0x0004, 0x0018, 0x0011, 0x001f, 0x0031, 0x0022, 0x0005, 0x0003, 0x002e, 0x0004, 0x0027, 0x0002, 0x0020, 0x000b, 0x0014, 0x0010, 0x0019, 0x0033, 0x0030, 0x000f, 0x0008, 0x000b, 0x001b, 0x003f, 0x0017, 0x003f, 0x0024, 0x0000, 0x0028, 0x0000, 0x0023, 0x001f, 0x0027, 0x0006, 0x0039, 0x0029, 0x000f, 0x002a, 0x0007, 0x0006, 0x0034, 0x0001, 0x002d, 0x0022, 0x0030, 0x000b, 0x0011, 0x001a, 0x001d, 0x0013, 0x0034, 0x0003, 0x002b, 0x0010, 0x0007, 0x0017, 0x0037, 0x0027, 0x0011, 0x0019, 0x0001, 0x0024, 0x0037, 0x0016, 0x0015, 0x0013, 0x000e, 0x0032, 0x0025, 0x003b, 0x0033, 0x0007, 0x001a, 0x0013, 0x0011, 0x000d, 0x0022, 0x0017, 0x0037};
    const unsigned short whitening_sequence_sf9_ldr_implicit[465] = {0x001b, 0x0067, 0x003f, 0x002f, 0x006b, 0x000f, 0x0027, 0x003b, 0x005d, 0x006a, 0x0005, 0x006a, 0x003e, 0x0065, 0x006b, 0x005d, 0x0025, 0x001a, 0x0004, 0x0038, 0x0057, 0x005e, 0x007f, 0x0032, 0x0064, 0x0039, 0x0063, 0x0017, 0x007c, 0x004d, 0x002a, 0x0010, 0x0077, 0x005f, 0x006e, 0x001d, 0x004a, 0x0008, 0x0036, 0x0067, 0x0044, 0x0019, 0x0042, 0x0004, 0x0020, 0x0035, 0x007b, 0x002f, 0x0052, 0x0054, 0x0078, 0x0011, 0x0072, 0x0051, 0x0050, 0x001a, 0x0052, 0x0054, 0x0058, 0x0040, 0x0062, 0x0015, 0x0046, 0x0013, 0x006c, 0x0008, 0x0040, 0x0040, 0x0036, 0x0075, 0x006a, 0x004d, 0x0060, 0x0011, 0x0032, 0x0035, 0x0079, 0x004f, 0x0028, 0x0025, 0x0073, 0x0057, 0x007e, 0x005d, 0x000f, 0x0022, 0x007a, 0x0041, 0x001c, 0x0049, 0x0042, 0x0044, 0x0005, 0x003e, 0x002e, 0x0075, 0x0013, 0x0076, 0x001d, 0x003a, 0x0069, 0x000b, 0x0021, 0x0070, 0x0055, 0x007a, 0x0045, 0x004a, 0x0014, 0x0070, 0x0053, 0x0050, 0x0055, 0x005a, 0x0044, 0x0018, 0x005c, 0x0048, 0x0017, 0x0047, 0x0046, 0x001c, 0x0048, 0x0010, 0x0022, 0x0039, 0x0049, 0x0024, 0x0079, 0x0042, 0x0074, 0x0009, 0x002f, 0x0027, 0x007c, 0x0040, 0x0016, 0x005d, 0x000a, 0x0074, 0x001d, 0x006e, 0x0000, 0x003b, 0x005f, 0x006e, 0x004d, 0x000a, 0x0004, 0x0038, 0x0073, 0x0018, 0x0047, 0x001e, 0x000c, 0x0028, 0x0063, 0x001b, 0x0048, 0x0011, 0x0078, 0x0040, 0x0070, 0x0001, 0x0066, 0x0015, 0x0077, 0x0071, 0x0058, 0x0041, 0x0012, 0x0074, 0x004a, 0x000c, 0x004c, 0x0015, 0x0037, 0x005e, 0x000c, 0x0078, 0x0060, 0x0015, 0x002e, 0x0062, 0x0006, 0x003d, 0x004b, 0x0006, 0x0058, 0x0040, 0x000d, 0x0039, 0x004e, 0x002c, 0x0069, 0x0003, 0x0058, 0x0040, 0x0029, 0x0033, 0x0069, 0x0002, 0x0034, 0x0029, 0x0022, 0x0031, 0x0035, 0x0055, 0x0015, 0x005b, 0x0026, 0x007d, 0x0076, 0x0055, 0x000f, 0x0042, 0x0004, 0x0038, 0x0041, 0x0012, 0x005a, 0x004c, 0x003f, 0x0032, 0x0065, 0x003a, 0x0065, 0x001b, 0x0005, 0x0036, 0x0005, 0x0069, 0x002d, 0x000b, 0x0066, 0x001d, 0x005d, 0x004a, 0x0073, 0x007d, 0x0026, 0x003d, 0x002b, 0x0037, 0x0044, 0x0018, 0x0016, 0x0017, 0x0023, 0x0037, 0x007f, 0x000f, 0x0040, 0x0018, 0x005f, 0x0006, 0x006e, 0x002d, 0x006b, 0x0047, 0x006c, 0x0001, 0x0008, 0x0059, 0x0069, 0x0003, 0x0036, 0x002d, 0x0012, 0x0078, 0x0011, 0x001d, 0x0002, 0x0015, 0x003a, 0x0075, 0x004d, 0x0006, 0x0019, 0x0005, 0x0070, 0x0070, 0x0071, 0x0043, 0x000c, 0x0028, 0x0001, 0x006f, 0x0075, 0x005b, 0x0046, 0x005c, 0x0068, 0x0009, 0x0036, 0x002d, 0x0046, 0x001d, 0x004a, 0x0014, 0x0012, 0x0070, 0x006d, 0x006c, 0x006e, 0x000c, 0x0068, 0x0001, 0x0014, 0x0074, 0x006a, 0x0007, 0x0062, 0x0015, 0x003a, 0x0025, 0x004b, 0x000a, 0x003e, 0x0066, 0x004f, 0x000f, 0x006e, 0x004d, 0x0069, 0x0007, 0x0040, 0x005c, 0x002c, 0x0008, 0x0020, 0x0021, 0x002c, 0x0021, 0x0056, 0x0000, 0x0030, 0x0071, 0x0033, 0x0037, 0x0036, 0x0079, 0x000b, 0x0061, 0x0019, 0x0063, 0x0057, 0x005e, 0x0041, 0x001e, 0x002d, 0x0075, 0x0016, 0x007c, 0x0009, 0x0072, 0x0065, 0x0013, 0x0066, 0x0067, 0x0043, 0x0036, 0x005d, 0x000a, 0x0066, 0x0019, 0x004a, 0x0024, 0x007c, 0x0048, 0x0060, 0x0041, 0x0023, 0x003f, 0x003b, 0x0057, 0x0000, 0x0011, 0x0012, 0x0034, 0x006f, 0x0007, 0x0019, 0x004f, 0x0076, 0x007c, 0x0069, 0x0053, 0x007b, 0x004f, 0x005f, 0x0008, 0x0001, 0x0013, 0x0056, 0x000c, 0x002e, 0x0025, 0x0018, 0x007a, 0x0077, 0x007e, 0x006d, 0x005b, 0x0032, 0x007d, 0x0054, 0x0039, 0x004f, 0x000f, 0x004e, 0x000c, 0x0079, 0x0047, 0x0054, 0x0054, 0x001f, 0x004e, 0x002c, 0x0029, 0x0056, 0x0050, 0x0009, 0x0043, 0x000e, 0x002c, 0x0009, 0x0022, 0x0042, 0x001c, 0x0011, 0x007c, 0x0029, 0x0022, 0x0035, 0x002b, 0x0068, 0x0005, 0x0057, 0x0001, 0x003f, 0x006f, 0x002f, 0x007f, 0x002a, 0x0021, 0x0068, 0x003c, 0x000b, 0x0027, 0x001f, 0x002e, 0x007e, 0x0045, 0x0076, 0x0021, 0x0019, 0x0037, 0x0028, 0x0026, 0x0018, 0x003c, 0x0013, 0x002d, 0x0066};
    const unsigned short whitening_sequence_sf10_ldr_implicit[408] = {0x0000, 0x0000, 0x0000, 0x0003, 0x0006, 0x001b, 0x001d, 0x00cb, 0x0077, 0x004f, 0x005f, 0x00db, 0x001f, 0x004f, 0x0077, 0x0026, 0x00ad, 0x00fa, 0x0035, 0x0003, 0x0076, 0x007b, 0x00ad, 0x00fd, 0x00da, 0x0095, 0x008a, 0x0063, 0x00e7, 0x0046, 0x0090, 0x001a, 0x0015, 0x000a, 0x0054, 0x00f3, 0x0087, 0x007c, 0x0048, 0x00c4, 0x0068, 0x0071, 0x0063, 0x0087, 0x0026, 0x00cc, 0x005b, 0x00a8, 0x00b1, 0x00c2, 0x0085, 0x00aa, 0x00ac, 0x00ac, 0x0037, 0x00a4, 0x00a8, 0x00b0, 0x0020, 0x0025, 0x00f2, 0x0038, 0x00ec, 0x003c, 0x0098, 0x0090, 0x0080, 0x006e, 0x00ed, 0x00d4, 0x009b, 0x0048, 0x0070, 0x0001, 0x0042, 0x006c, 0x00f9, 0x0019, 0x0054, 0x00f0, 0x00c1, 0x00e3, 0x0027, 0x007d, 0x00db, 0x00c7, 0x0029, 0x0095, 0x000b, 0x0036, 0x00ec, 0x00cb, 0x003f, 0x00be, 0x00b0, 0x008a, 0x0034, 0x0048, 0x00d1, 0x00b2, 0x0094, 0x009c, 0x00a8, 0x00b4, 0x0088, 0x00f0, 0x0021, 0x0000, 0x0060, 0x0099, 0x00d8, 0x008c, 0x0038, 0x0010, 0x00c0, 0x0075, 0x00c3, 0x0006, 0x0071, 0x0029, 0x00b2, 0x00c4, 0x0009, 0x005f, 0x004f, 0x00f8, 0x0081, 0x0073, 0x00c6, 0x00ad, 0x003a, 0x00ca, 0x003d, 0x0091, 0x000a, 0x0043, 0x0067, 0x002f, 0x00fe, 0x00b5, 0x0092, 0x0002, 0x0034, 0x00e2, 0x00e5, 0x00eb, 0x00b7, 0x001a, 0x004c, 0x0064, 0x0088, 0x0024, 0x00a9, 0x00b2, 0x00a4, 0x0041, 0x0073, 0x0079, 0x0038, 0x00fc, 0x00d8, 0x0091, 0x0082, 0x00f2, 0x0085, 0x0053, 0x00f2, 0x000d, 0x003b, 0x0016, 0x004c, 0x0080, 0x0020, 0x0052, 0x00c7, 0x00fe, 0x00dc, 0x00d9, 0x0013, 0x00b0, 0x0080, 0x0051, 0x0067, 0x000c, 0x0039, 0x0012, 0x0044, 0x0011, 0x0042, 0x0047, 0x00a5, 0x00e9, 0x00f2, 0x00c5, 0x000b, 0x00c3, 0x0027, 0x007f, 0x00e8, 0x0036, 0x008d, 0x00ba, 0x0034, 0x0026, 0x00e4, 0x00da, 0x0099, 0x004d, 0x007a, 0x0015, 0x00ca, 0x0078, 0x00c9, 0x0094, 0x007a, 0x007b, 0x00d7, 0x00cf, 0x001f, 0x00c0, 0x0031, 0x009d, 0x009d, 0x0047, 0x006f, 0x003f, 0x007e, 0x0030, 0x00c0, 0x009a, 0x0078, 0x007e, 0x00dd, 0x00db, 0x0097, 0x00d4, 0x0001, 0x0010, 0x00b3, 0x00cc, 0x0079, 0x0013, 0x0046, 0x008d, 0x002a, 0x00c0, 0x00cc, 0x00ac, 0x00b9, 0x00d2, 0x0005, 0x002f, 0x00fe, 0x0034, 0x007b, 0x0038, 0x0090, 0x0080, 0x0000, 0x00eb, 0x00bf, 0x004c, 0x00d7, 0x00d4, 0x0048, 0x0031, 0x0062, 0x00a2, 0x00b4, 0x006d, 0x006f, 0x0018, 0x0011, 0x0042, 0x00c5, 0x00b1, 0x0082, 0x007e, 0x00dd, 0x00c5, 0x006a, 0x0075, 0x006b, 0x0016, 0x0044, 0x00d9, 0x0039, 0x00bf, 0x009f, 0x00de, 0x009d, 0x00d9, 0x000b, 0x0082, 0x00b8, 0x009e, 0x001c, 0x0018, 0x0050, 0x0012, 0x0054, 0x00a5, 0x00d0, 0x0098, 0x0010, 0x0040, 0x0041, 0x00d5, 0x0003, 0x003f, 0x0009, 0x0005, 0x002a, 0x0074, 0x0069, 0x008a, 0x002c, 0x005e, 0x0050, 0x00fa, 0x00d4, 0x00c9, 0x0093, 0x0035, 0x00d2, 0x00c9, 0x002b, 0x0090, 0x0001, 0x0022, 0x0064, 0x00df, 0x000f, 0x0033, 0x009e, 0x0001, 0x0022, 0x0064, 0x00e9, 0x000f, 0x007e, 0x00c6, 0x001c, 0x0066, 0x00ec, 0x00f9, 0x00b3, 0x00fb, 0x009f, 0x00bd, 0x0010, 0x0078, 0x00d1, 0x0083, 0x0086, 0x0013, 0x0056, 0x008a, 0x006a, 0x0051, 0x0043, 0x0027, 0x006e, 0x00d2, 0x0005, 0x00a1, 0x0095, 0x0053, 0x0047, 0x006f, 0x00ff, 0x0090, 0x0000, 0x00a3, 0x0000, 0x0052, 0x0045, 0x006b, 0x00f7, 0x0001, 0x0062, 0x00b6, 0x0062, 0x0045, 0x006b, 0x0077, 0x00ef, 0x0072, 0x00c5, 0x0098, 0x00ed, 0x007f, 0x00df, 0x00df, 0x009f, 0x0045, 0x0063, 0x0005, 0x00d1, 0x00db, 0x0057, 0x000f, 0x005e, 0x00fe, 0x008d, 0x00ee, 0x0043, 0x0043};
    const unsigned short whitening_sequence_sf11_ldr_implicit[367] = {0x0140, 0x0143, 0x0146, 0x0046, 0x0079, 0x012b, 0x012b, 0x00d7, 0x002f, 0x005f, 0x00eb, 0x0177, 0x005b, 0x002d, 0x0123, 0x00c6, 0x010d, 0x00da, 0x00e1, 0x0153, 0x005b, 0x008c, 0x0127, 0x00ce, 0x011d, 0x00ba, 0x0064, 0x0049, 0x00f7, 0x019a, 0x010f, 0x009e, 0x013d, 0x00ba, 0x0164, 0x0048, 0x00b5, 0x013b, 0x010a, 0x0094, 0x01a9, 0x01d2, 0x0160, 0x0040, 0x0010, 0x017d, 0x01a0, 0x00c0, 0x0181, 0x01c2, 0x012a, 0x00c4, 0x0002, 0x0154, 0x00f0, 0x0160, 0x0140, 0x0080, 0x01bb, 0x01d6, 0x0022, 0x0054, 0x0050, 0x0121, 0x0042, 0x0005, 0x00b9, 0x01f3, 0x0062, 0x0055, 0x0010, 0x00a1, 0x00c3, 0x0107, 0x002d, 0x00fb, 0x00cf, 0x0111, 0x009a, 0x00b5, 0x01eb, 0x0116, 0x002d, 0x00db, 0x019f, 0x0190, 0x008a, 0x0195, 0x01aa, 0x0154, 0x0098, 0x0191, 0x019e, 0x0186, 0x0002, 0x0185, 0x018a, 0x01d4, 0x019a, 0x01b4, 0x00cc, 0x01ae, 0x0112, 0x00a5, 0x01cb, 0x0196, 0x013f, 0x00fe, 0x00c9, 0x01ba, 0x011a, 0x00b4, 0x01e9, 0x0112, 0x0175, 0x007a, 0x0089, 0x0133, 0x000f, 0x009e, 0x01bd, 0x017a, 0x0154, 0x0028, 0x0089, 0x0121, 0x0085, 0x008b, 0x0197, 0x01ee, 0x0054, 0x0029, 0x0099, 0x0120, 0x01c4, 0x0109, 0x0192, 0x01a4, 0x0051, 0x0023, 0x0031, 0x0132, 0x014e, 0x011c, 0x00b8, 0x01b1, 0x0111, 0x00a2, 0x0071, 0x0113, 0x001b, 0x00b6, 0x00ed, 0x01db, 0x0184, 0x01a8, 0x00fc, 0x0051, 0x0013, 0x00a7, 0x01cf, 0x015e, 0x018e, 0x018c, 0x00fc, 0x00f0, 0x0116, 0x00ad, 0x01db, 0x0136, 0x01ba, 0x01d4, 0x007d, 0x00a0, 0x0134, 0x00e8, 0x01d1, 0x0122, 0x01b2, 0x01f4, 0x003d, 0x0009, 0x0035, 0x00ea, 0x0155, 0x002a, 0x0123, 0x00e6, 0x0030, 0x015b, 0x0037, 0x00ef, 0x015f, 0x003e, 0x0121, 0x00c2, 0x0172, 0x0172, 0x0167, 0x004f, 0x011f, 0x003e, 0x0130, 0x00c0, 0x01f2, 0x0032, 0x01ef, 0x005e, 0x003d, 0x00bb, 0x0132, 0x00e4, 0x01f0, 0x0092, 0x00ab, 0x01d6, 0x002c, 0x00d9, 0x0113, 0x00a6, 0x01d5, 0x00d6, 0x0081, 0x0183, 0x0106, 0x00cc, 0x0051, 0x0023, 0x0095, 0x0076, 0x00c5, 0x010b, 0x0196, 0x01ac, 0x00e0, 0x0161, 0x001c, 0x0074, 0x0045, 0x010b, 0x0096, 0x01ad, 0x00a8, 0x01c1, 0x005e, 0x005d, 0x0115, 0x00ab, 0x00d7, 0x01af, 0x0019, 0x0093, 0x0057, 0x014d, 0x01bf, 0x00fe, 0x01fd, 0x013a, 0x0153, 0x0037, 0x0104, 0x01e4, 0x01be, 0x01fc, 0x0178, 0x0070, 0x0176, 0x006c, 0x018d, 0x00a0, 0x011c, 0x01b8, 0x0170, 0x0060, 0x0036, 0x00e5, 0x00dd, 0x00e8, 0x0119, 0x00b2, 0x01e4, 0x014a, 0x0096, 0x01ad, 0x00fa, 0x00fa, 0x0193, 0x00a6, 0x01cc, 0x015a, 0x00d6, 0x012f, 0x01ea, 0x0053, 0x0193, 0x01a6, 0x01cc, 0x0118, 0x0076, 0x006f, 0x016e, 0x0007, 0x01b2, 0x01e6, 0x01cc, 0x0118, 0x007c, 0x0068, 0x0078, 0x0087, 0x00e3, 0x0146, 0x010c, 0x0018, 0x004d, 0x0039, 0x00d8, 0x01d2, 0x0063, 0x0147, 0x000a, 0x009f, 0x0144, 0x001e, 0x018b, 0x0153, 0x0173, 0x0065, 0x004d, 0x009e, 0x01e1, 0x0141, 0x0185, 0x0142, 0x0178, 0x0072, 0x0065, 0x0009, 0x00e9, 0x0143, 0x0197, 0x0146, 0x007b, 0x0072, 0x0064, 0x004a, 0x00e8, 0x0150, 0x019b, 0x014c, 0x00f9, 0x0076, 0x006e, 0x005e, 0x00f6, 0x0174, 0x00db, 0x0164, 0x00ea, 0x017e, 0x000a, 0x0059, 0x004e, 0x0029, 0x01d3, 0x01be, 0x0133};
    const unsigned short whitening_sequence_sf12_ldr_implicit[326] = {0x0240, 0x0243, 0x0246, 0x0050, 0x007d, 0x016b, 0x0097, 0x01ef, 0x019f, 0x019f, 0x0237, 0x01fb, 0x009d, 0x0091, 0x02e3, 0x02e3, 0x004d, 0x00b0, 0x00b0, 0x0199, 0x004c, 0x01e9, 0x0093, 0x0267, 0x0267, 0x02b9, 0x0232, 0x01fd, 0x034e, 0x0151, 0x00e3, 0x00e3, 0x004f, 0x035c, 0x03b9, 0x0102, 0x01ef, 0x03c8, 0x03d1, 0x0362, 0x0285, 0x03ca, 0x03f4, 0x03f8, 0x001d, 0x00c1, 0x03c2, 0x03c4, 0x03c8, 0x0031, 0x0142, 0x039d, 0x014e, 0x0145, 0x00cb, 0x03d7, 0x03ee, 0x01cc, 0x00b9, 0x00b9, 0x000f, 0x000f, 0x02c7, 0x034e, 0x03dd, 0x0237, 0x01cf, 0x01ce, 0x02cd, 0x0375, 0x03ab, 0x0216, 0x0216, 0x015b, 0x0037, 0x03be, 0x0380, 0x004a, 0x03d5, 0x03ea, 0x0214, 0x0358, 0x03f1, 0x03fe, 0x03ce, 0x0100, 0x01c2, 0x03c5, 0x03ca, 0x03dd, 0x03fa, 0x0006, 0x03ed, 0x0064, 0x0389, 0x01d2, 0x01d2, 0x00bf, 0x017f, 0x0262, 0x035c, 0x0193, 0x01e6, 0x038d, 0x005a, 0x015a, 0x0035, 0x0281, 0x026c, 0x02f8, 0x00b1, 0x01a3, 0x01a3, 0x005d, 0x005d, 0x0321, 0x0392, 0x0388, 0x02d0, 0x02d0, 0x0200, 0x015e, 0x007d, 0x007d, 0x034d, 0x0331, 0x02a3, 0x0204, 0x0348, 0x004a, 0x004e, 0x00dd, 0x0066, 0x0066, 0x029b, 0x0277, 0x01a4, 0x02d0, 0x00c0, 0x0182, 0x015f, 0x00e7, 0x038f, 0x025f, 0x00fc, 0x03dc, 0x03f8, 0x0239, 0x0201, 0x02d6, 0x00ed, 0x0399, 0x0072, 0x03ba, 0x02f4, 0x01bd, 0x01bd, 0x001a, 0x02f4, 0x02f4, 0x0291, 0x03d9, 0x03b3, 0x01fe, 0x01cc, 0x01ac, 0x019e, 0x0274, 0x0274, 0x00a8, 0x0171, 0x0294, 0x00ad, 0x0236, 0x01ac, 0x019a, 0x00f7, 0x02d4, 0x0018, 0x007e, 0x007f, 0x022e, 0x019c, 0x01f9, 0x01b2, 0x03c9, 0x03f7, 0x02c6, 0x02f0, 0x0173, 0x00a7, 0x018f, 0x00da, 0x00da, 0x02cb, 0x0343, 0x0112, 0x03cd, 0x03db, 0x0373, 0x0224, 0x004d, 0x004f, 0x0014, 0x00ae, 0x0057, 0x03e4, 0x0388, 0x03f1, 0x01c3, 0x00c4, 0x02a1, 0x01f1, 0x01cb, 0x00d2, 0x03ec, 0x029e, 0x02d3, 0x0043, 0x00bc, 0x00b1, 0x0155, 0x00ea, 0x00ea, 0x03ed, 0x00db, 0x0371, 0x01e7, 0x025c, 0x035e, 0x03fe, 0x033a, 0x02bf, 0x013b, 0x0272, 0x02c2, 0x03a1, 0x034d, 0x03dd, 0x03fa, 0x02bd, 0x02bd, 0x02b8, 0x0046, 0x02f3, 0x02f3, 0x02e5, 0x038f, 0x03d4, 0x0023, 0x0023, 0x019d, 0x039e, 0x032b, 0x0291, 0x0262, 0x0266, 0x0257, 0x008e, 0x0166, 0x02ef, 0x0050, 0x03a3, 0x0203, 0x00cc, 0x00cc, 0x027e, 0x0005, 0x02bd, 0x0259, 0x00f1, 0x03a3, 0x0203, 0x00a5, 0x00a5, 0x0166, 0x03b4, 0x024d, 0x00d9, 0x0370, 0x02a1, 0x0136, 0x020d, 0x020d, 0x0154, 0x0185, 0x01cf, 0x035f, 0x03f9, 0x00cb, 0x00cb, 0x03e5, 0x0084, 0x0084, 0x01a6, 0x018e, 0x035e, 0x02e0, 0x0241, 0x03c5, 0x0246, 0x003d, 0x02b8, 0x01b6, 0x01a7, 0x003c, 0x003c, 0x035a, 0x0282, 0x023f, 0x01bd, 0x023b, 0x01b6, 0x02da, 0x003d, 0x0042, 0x03a2, 0x012e, 0x019f, 0x01fc, 0x01b9, 0x003b, 0x017c, 0x029e, 0x037d, 0x037d};


    // TODO: Explicit Whitening (header is present)
    // Assume all of the following is no good
                                                                  // 0x8, 0x20, 0x1c, 0x12, 0x25, 0x30,  0xf, 0x22, 0x36, 0x89, 0xb2, 0xaa, 0xcc, 0xe0, 0x4a, 0x47, 0xc6, 0x65, 0x24, 0xdf, 0xf0, 0x9, 0x4c, 0xe3, 0x2d, 0xb4, 0xdf, 0xb6, 0x4a, 0x66, 0x11, 0xbb, 0x9f, 0x59, 0x94, 0xb, 0x62, 0xf6, 0x9, 0x12, 0x36, 0x86, 0x79, 0x52, 0xf6, 0x83, 0x35, 0x5e, 0xad, 0xeb, 0x32, 0xe1, 0xac, 0xa7, 0xad, 0xc9, 0xa7, 0xad, 0xb9, 0x92, 0xc7, 0x24, 0x8c, 0x22, 0x8c, 0x3f, 0x8b, 0x91, 0xc, 0x65, 0x29, 0xff, 0x16, 0x1b, 0xf3, 0x6, 0x9, 0x6f, 0xdd, 0x1d, 0x79, 0xf3, 0xc0, 0xc6, 0x43, 0x74, 0x70, 0xcd, 0xbf, 0xd6, 0x8f, 0x35, 0x74, 0xc8, 0xaa, 0xb9, 0xb6, 0x8d, 0x3d, 0x79, 0xa2, 0xbf, 0xb5, 0xad, 0xa9, 0xb7, 0x1b, 0xf1, 0x8b, 0x2, 0xfb, 0x3f, 0xf5, 0x87, 0xbb, 0x33, 0x4f, 0x76, 0x96, 0x4b, 0xcd, 0x2a, 0x37, 0xcd, 0x54, 0x54, 0x25, 0xf2, 0x4a, 0x36, 0xc5, 0x85, 0x3e, 0xc9, 0xe9, 0x9f, 0x31, 0x40, 0xe2, 0x2c, 0xef, 0xb4, 0x97, 0x8d, 0x60, 0xe1, 0x6c, 0xee, 0x9d, 0x10, 0x2, 0xb7, 0x80, 0x6d, 0xb8, 0xb1, 0x49, 0x4a, 0x45, 0x85, 0x6b, 0xb5, 0xdb, 0x90, 0x60, 0xf7, 0x48, 0x2a, 0x94, 0x44, 0xbe, 0x11, 0xbb, 0x3, 0x1e, 0x70, 0x2c, 0xbd, 0x5f, 0xda, 0xb9, 0x91, 0x59, 0x41, 0xd3, 0x45, 0xba, 0x10, 0xf1, 0x31, 0x56, 0xe1, 0x27, 0xb8, 0x71, 0xcc, 0x50, 0xc6, 0x44, 0x27, 0xc8, 0x73, 0x85, 0x98, 0x8f, 0x23, 0x3a, 0xfe, 0x55, 0xa, 0xf9, 0x3c, 0xf, 0x51, 0xbf, 0xe, 0x44, 0x7e, 0x54, 0xca, 0x29, 0xd9, 0xff, 0xfb, 0x10, 0x42, 0xec, 0x14, 0x8a, 0x33, 0xb4, 0xa, 0xb, 0x7d, 0x5e, 0xf8, 0x37, 0xd7, 0x8b, 0xeb, 0x35, 0xcf, 0xe8, 0x10, 0xf5, 0x82, 0x37, 0x34, 0xa5, 0xe5, 0x28, 0xd1, 0xc4, 0x2c, 0x8d, 0x44, 0x87, 0x29, 0x93, 0x3, 0x6c, 0xee, 0x13, 0x7e, 0x39, 0x9d, 0xd9, 0x30, 0xb8, 0xa9, 0x43, 0x43, 0xd5, 0x49, 0x30, 0x67, 0xeb, 0x90, 0xa, 0x7d, 0x71, 0x82, 0x69, 0x5c, 0x98, 0x13, 0x75, 0xcf, 0xaa, 0xfa, 0x1c, 0xfb, 0x75, 0xf0, 0xb0, 0xaf, 0xbc, 0x9b, 0x9f, 0x1b, 0x88, 0x1f, 0xe1, 0x29, 0xff, 0x89, 0x31, 0xc1, 0x71, 0xd6, 0xca, 0xd7, 0x97, 0xc, 0x2f, 0x5d, 0xb4, 0x81, 0x14, 0x1a, 0x24, 0xbf, 0x5d, 0xea, 0xc9, 0x3e, 0x77, 0xcc, 0xe9, 0xf1, 0x0, 0x7, 0x72, 0xd2, 0xc8, 0xbd, 0x93, 0x2, 0x21, 0x6d, 0xdc, 0xa, 0x36, 0x9b, 0x6, 0x23, 0x6f, 0xe8, 0x6e, 0xf8, 0xe5, 0x88, 0x45, 0x7b, 0xf0, 0xa6, 0xda, 0x1e, 0xb6, 0xd, 0x49, 0x52, 0xc6, 0x4, 0x28, 0xd1, 0xa1, 0xf9, 0x1a, 0x56, 0x42, 0x6a, 0x91, 0x93, 0xe0, 0x92, 0x48, 0x57, 0x46, 0x68, 0xdb, 0x2, 0xb8, 0x3, 0x57, 0x46, 0x68, 0x72, 0x2, 0x71, 0xbd, 0x65, 0x4c, 0x7c, 0x5a, 0xfa, 0x59, 0x46, 0xd1, 0x7a, 0x3e, 0xde, 0xd2, 0xa, 0x2c, 0xf5, 0x26, 0x52, 0xf8, 0x55, 0xe, 0x4f, 0x9f, 0x1b, 0xe7, 0x57, 0xee};
    // const unsigned short whitening_sequence_sf8_explicit[417] = {0x8, 0x20, 0x1c, 0x12, 0x25, 0x30,  0xf, 0x22,   52,  201,  118,   77,  119,  218,   84,   78, 0xc2, 0x67, 0x2c, 0xdf, 0xd0, 0x9, 0x4c, 0xe2, 0x2f, 0xbc, 0xdf, 0xb7, 0x4a, 0x62, 0x11, 0xb9, 0x9f, 0x59, 0x94, 0xb, 0x63, 0xf6, 0xa, 0x17, 0x36, 0x85, 0x79, 0x52, 0xf6, 0x86, 0x37, 0x5e, 0xad, 0xeb, 0x33, 0xe1, 0xa4, 0xa7, 0xad, 0xc9, 0xa7, 0xad, 0xb8, 0x91, 0xc7, 0x2c, 0x8f, 0x26, 0x8f, 0x3d, 0x88, 0x90, 0x5, 0x65, 0x28, 0xff, 0x15, 0x18, 0xf3, 0x3, 0xa, 0x6f, 0xdd, 0x1e, 0x79, 0xf3, 0xc0, 0xc6, 0x43, 0x74, 0x70, 0xcd, 0xbe, 0xd6, 0x8a, 0x37, 0x74, 0xc8, 0xaa, 0xb9, 0xb7, 0x8e, 0x3c, 0x79, 0xa2, 0xbe, 0xb4, 0xad, 0xa9, 0xb5, 0x18, 0xf1, 0x88, 0x1, 0xfb, 0x3d, 0xf5, 0x84, 0xbb, 0x31, 0x4f, 0x76, 0x93, 0x4b, 0xcd, 0x2b, 0x36, 0xcd, 0x54, 0x54, 0x25, 0xf2, 0x4a, 0x32, 0xc5, 0x8c, 0x3f, 0xc9, 0xe9, 0x9c, 0x10, 0x40, 0xe2, 0x2c, 0xef, 0xb4, 0x92, 0x8e, 0x60, 0xe1, 0x6c, 0xee, 0x94, 0x13, 0x1, 0xb7, 0x83, 0x6d, 0xb8, 0xb3, 0x49, 0x4a, 0x45, 0x8c, 0x6b, 0xb5, 0xdb, 0xb0, 0x60, 0xf7, 0x48, 0x2a, 0x97, 0x44, 0xbe, 0x12, 0xbb, 0x0, 0x1b, 0x70, 0x2c, 0xbd, 0x5f, 0xda, 0xb9, 0x90, 0x59, 0x41, 0xd3, 0x45, 0xba, 0x13, 0xf1, 0x10, 0x56, 0xe1, 0x27, 0xb8, 0x71, 0xcc, 0x50, 0xc6, 0x44, 0x27, 0xc8, 0x73, 0x8c, 0x9b, 0x8a, 0x23, 0x3a, 0xfe, 0x55, 0xf, 0xf9, 0x34, 0xc, 0x51, 0xbf, 0xd, 0x44, 0x7e, 0x54, 0xca, 0x29, 0xd9, 0xff, 0xfb, 0x11, 0x42, 0xec, 0x1d, 0x89, 0x32, 0xb4, 0xa, 0xb, 0x7d, 0x5e, 0xf8, 0x35, 0xd7, 0x88, 0xeb, 0x35, 0xcf, 0xe8, 0x30, 0xf5, 0x82, 0x37, 0x34, 0xa5, 0xe5, 0x28, 0xd1, 0xc4, 0x2c, 0x8d, 0x44, 0x87, 0x29, 0x93, 0x3, 0x6c, 0xee, 0x11, 0x7e, 0x39, 0x9f, 0xd9, 0x31, 0xb8, 0xa9, 0x43, 0x43, 0xd5, 0x49, 0x31, 0x67, 0xeb, 0x90, 0xa, 0x7d, 0x71, 0x82, 0x69, 0x5c, 0x88, 0x11, 0x75, 0xcf, 0xaa, 0xfa, 0x14, 0xfb, 0x75, 0xf0, 0xb0, 0xaf, 0xbc, 0x99, 0x9e, 0x1a, 0x89, 0x1d, 0xe1, 0x29, 0xff, 0x8b, 0x33, 0xc1, 0x71, 0xd6, 0xca, 0xd7, 0x95, 0xd, 0x2f, 0x5d, 0xb4, 0x80, 0x15, 0x1e, 0x24, 0xbf, 0x5d, 0xea, 0xc9, 0x3e, 0x77, 0xcc, 0xe9, 0xf1, 0x1, 0x5, 0x72, 0xd2, 0xc8, 0xbd, 0x93, 0x6, 0x21, 0x6d, 0xdc, 0xb, 0x37, 0x99, 0x7, 0x23, 0x6f, 0xe8, 0x6e, 0xf8, 0xe5, 0x89, 0x45, 0x7b, 0xf0, 0xa6, 0xda, 0x1f, 0xb6, 0xf, 0x49, 0x52, 0xc6, 0xc, 0x28, 0xd1, 0xa1, 0xf9, 0x1e, 0x56, 0x42, 0x6a, 0x91, 0x93, 0xe0, 0x92, 0x48, 0x57, 0x46, 0x68, 0xdb, 0x6, 0xb8, 0x2, 0x57, 0x46, 0x68, 0x72, 0x6, 0x71, 0xbd, 0x65, 0x4c, 0x7c, 0x5a, 0xfa, 0x59, 0x46, 0xd1, 0x7a, 0x3e, 0xde, 0xd2, 0xb, 0x2c, 0xf5, 0x26, 0x52, 0xf8, 0x55, 0xa, 0x4f, 0x9e, 0x1a, 0xe7, 0x57, 0x4b};
    // const unsigned short whitening_sequence_sf8_explicit[417] = {0x8, 0x20, 0x1c, 0x12, 0x25, 0x30,  0xf, 0x22, 0x36, 0x89, 0xb2, 0xae, 0xcc, 0xe1, 0x4a, 0x47, 0xc2, 0x67, 0x2c, 0xdf, 0xd0, 0x9, 0x4c, 0xe2, 0x2f, 0xbc, 0xdf, 0xb7, 0x4a, 0x62, 0x11, 0xb9, 0x9f, 0x59, 0x94, 0xb, 0x63, 0xf6, 0xa, 0x17, 0x36, 0x85, 0x79, 0x52, 0xf6, 0x86, 0x37, 0x5e, 0xad, 0xeb, 0x33, 0xe1, 0xa4, 0xa7, 0xad, 0xc9, 0xa7, 0xad, 0xb8, 0x91, 0xc7, 0x2c, 0x8f, 0x26, 0x8f, 0x3d, 0x88, 0x90, 0x5, 0x65, 0x28, 0xff, 0x15, 0x18, 0xf3, 0x3, 0xa, 0x6f, 0xdd, 0x1e, 0x79, 0xf3, 0xc0, 0xc6, 0x43, 0x74, 0x70, 0xcd, 0xbe, 0xd6, 0x8a, 0x37, 0x74, 0xc8, 0xaa, 0xb9, 0xb7, 0x8e, 0x3c, 0x79, 0xa2, 0xbe, 0xb4, 0xad, 0xa9, 0xb5, 0x18, 0xf1, 0x88, 0x1, 0xfb, 0x3d, 0xf5, 0x84, 0xbb, 0x31, 0x4f, 0x76, 0x93, 0x4b, 0xcd, 0x2b, 0x36, 0xcd, 0x54, 0x54, 0x25, 0xf2, 0x4a, 0x32, 0xc5, 0x8c, 0x3f, 0xc9, 0xe9, 0x9c, 0x10, 0x40, 0xe2, 0x2c, 0xef, 0xb4, 0x92, 0x8e, 0x60, 0xe1, 0x6c, 0xee, 0x94, 0x13, 0x1, 0xb7, 0x83, 0x6d, 0xb8, 0xb3, 0x49, 0x4a, 0x45, 0x8c, 0x6b, 0xb5, 0xdb, 0xb0, 0x60, 0xf7, 0x48, 0x2a, 0x97, 0x44, 0xbe, 0x12, 0xbb, 0x0, 0x1b, 0x70, 0x2c, 0xbd, 0x5f, 0xda, 0xb9, 0x90, 0x59, 0x41, 0xd3, 0x45, 0xba, 0x13, 0xf1, 0x10, 0x56, 0xe1, 0x27, 0xb8, 0x71, 0xcc, 0x50, 0xc6, 0x44, 0x27, 0xc8, 0x73, 0x8c, 0x9b, 0x8a, 0x23, 0x3a, 0xfe, 0x55, 0xf, 0xf9, 0x34, 0xc, 0x51, 0xbf, 0xd, 0x44, 0x7e, 0x54, 0xca, 0x29, 0xd9, 0xff, 0xfb, 0x11, 0x42, 0xec, 0x1d, 0x89, 0x32, 0xb4, 0xa, 0xb, 0x7d, 0x5e, 0xf8, 0x35, 0xd7, 0x88, 0xeb, 0x35, 0xcf, 0xe8, 0x30, 0xf5, 0x82, 0x37, 0x34, 0xa5, 0xe5, 0x28, 0xd1, 0xc4, 0x2c, 0x8d, 0x44, 0x87, 0x29, 0x93, 0x3, 0x6c, 0xee, 0x11, 0x7e, 0x39, 0x9f, 0xd9, 0x31, 0xb8, 0xa9, 0x43, 0x43, 0xd5, 0x49, 0x31, 0x67, 0xeb, 0x90, 0xa, 0x7d, 0x71, 0x82, 0x69, 0x5c, 0x88, 0x11, 0x75, 0xcf, 0xaa, 0xfa, 0x14, 0xfb, 0x75, 0xf0, 0xb0, 0xaf, 0xbc, 0x99, 0x9e, 0x1a, 0x89, 0x1d, 0xe1, 0x29, 0xff, 0x8b, 0x33, 0xc1, 0x71, 0xd6, 0xca, 0xd7, 0x95, 0xd, 0x2f, 0x5d, 0xb4, 0x80, 0x15, 0x1e, 0x24, 0xbf, 0x5d, 0xea, 0xc9, 0x3e, 0x77, 0xcc, 0xe9, 0xf1, 0x1, 0x5, 0x72, 0xd2, 0xc8, 0xbd, 0x93, 0x6, 0x21, 0x6d, 0xdc, 0xb, 0x37, 0x99, 0x7, 0x23, 0x6f, 0xe8, 0x6e, 0xf8, 0xe5, 0x89, 0x45, 0x7b, 0xf0, 0xa6, 0xda, 0x1f, 0xb6, 0xf, 0x49, 0x52, 0xc6, 0xc, 0x28, 0xd1, 0xa1, 0xf9, 0x1e, 0x56, 0x42, 0x6a, 0x91, 0x93, 0xe0, 0x92, 0x48, 0x57, 0x46, 0x68, 0xdb, 0x6, 0xb8, 0x2, 0x57, 0x46, 0x68, 0x72, 0x6, 0x71, 0xbd, 0x65, 0x4c, 0x7c, 0x5a, 0xfa, 0x59, 0x46, 0xd1, 0x7a, 0x3e, 0xde, 0xd2, 0xb, 0x2c, 0xf5, 0x26, 0x52, 0xf8, 0x55, 0xa, 0x4f, 0x9e, 0x1a, 0xe7, 0x57, 0x4b};

                                                                  // 0x8, 0x20, 0x1c, 0x12, 0x25, 0x30,  0xf, 0x22, 0x36, 0x89, 0xb2, 0xae, 0xc4, 0xe1, 0x4b, 0x45, 0xc2, 0x67, 0x2c, 0xde, 0xd0, 0x9, 0x4d, 0xe2, 0x2f, 0xbc, 0xde, 0xb7, 0x4b, 0x62, 0x11, 0xb9, 0x9f, 0x5b, 0x94, 0xb, 0x63, 0xf2, 0xa, 0x17, 0x36, 0x85, 0x78, 0x53, 0xf2, 0x86, 0x37, 0x5f, 0xac, 0xe9, 0x33, 0xe3, 0xa4, 0xa6, 0xac, 0xcb, 0xa6, 0xac, 0xb8, 0x91, 0xc6, 0x2c, 0x8f, 0x26, 0x8f, 0x3d, 0x88, 0x90, 0x5, 0x67, 0x28, 0xfd, 0x15, 0x18, 0xf1, 0x3, 0xa, 0x6d, 0xdf, 0x1e, 0x78, 0xf1, 0xc0, 0xc2, 0x43, 0x7c, 0x71, 0xcd, 0xbe, 0xd6, 0x8a, 0x37, 0x7c, 0xc8, 0xae, 0xb8, 0xb7, 0x8e, 0x3c, 0x78, 0xa2, 0xbe, 0xb4, 0xad, 0xab, 0xb5, 0x18, 0xf1, 0x88, 0x1, 0xfb, 0x3d, 0xf5, 0x84, 0xb9, 0x31, 0x4f, 0x76, 0x93, 0x4b, 0xcd, 0x2b, 0x36, 0xcd, 0x54, 0x54, 0x24, 0xf2, 0x4a, 0x32, 0xc5, 0x8c, 0x3f, 0xc9, 0xe9, 0x9c, 0x10, 0x40, 0xe2, 0x2d, 0xef, 0xbc, 0x92, 0x8e, 0x60, 0xe1, 0x6c, 0xee, 0x94, 0x13, 0x1, 0xb5, 0x83, 0x6d, 0xb8, 0xb3, 0x49, 0x4a, 0x45, 0x8c, 0x6b, 0xb4, 0xdb, 0xb0, 0x60, 0xf7, 0x48, 0x2b, 0x97, 0x44, 0xbe, 0x12, 0xbb, 0x0, 0x1b, 0x70, 0x2d, 0xbd, 0x5f, 0xda, 0xb9, 0x90, 0x59, 0x41, 0xd3, 0x45, 0xba, 0x13, 0xf1, 0x10, 0x56, 0xe1, 0x27, 0xb8, 0x71, 0xcc, 0x50, 0xc6, 0x44, 0x27, 0xc8, 0x73, 0x8c, 0x9b, 0x8a, 0x23, 0x3e, 0xfe, 0x55, 0xf, 0xf9, 0x34, 0xc, 0x51, 0xbf, 0xd, 0x44, 0x7e, 0x54, 0xca, 0x28, 0xd9, 0xff, 0xfb, 0x11, 0x42, 0xec, 0x1d, 0x89, 0x31, 0xb4, 0xf, 0xe, 0x7d, 0x5e, 0xf8, 0x36, 0xd7, 0x88, 0xeb, 0x37, 0xcf, 0xe8, 0x11, 0xf5, 0x87, 0x36, 0x35, 0xa5, 0xe5, 0x38, 0xd1, 0xc4, 0x2c, 0x8e, 0x44, 0x84, 0x28, 0x91, 0x0, 0x6c, 0xee, 0x12, 0x7e, 0x3b, 0x9c, 0xd9, 0x10, 0xb8, 0xa9, 0x43, 0x43, 0xd5, 0x49, 0x10, 0x67, 0xeb, 0x90, 0xf, 0x7d, 0x71, 0x87, 0x69, 0x5c, 0x99, 0x12, 0x75, 0xcf, 0xaa, 0xfa, 0x1d, 0xfb, 0x75, 0xf0, 0xb0, 0xaf, 0xbc, 0x9a, 0x9d, 0x19, 0x98, 0x1e, 0xe1, 0x29, 0xff, 0x88, 0x30, 0xc1, 0x71, 0xd6, 0xca, 0xd7, 0x97, 0xd, 0x2f, 0x5d, 0xb4, 0x80, 0x1c, 0x1e, 0x24, 0xbf, 0x5d, 0xea, 0xc9, 0x3a, 0x77, 0xcc, 0xe9, 0xf1, 0x1, 0x5, 0x72, 0xd2, 0xc8, 0xbd, 0x93, 0x6, 0x21, 0x6d, 0xdc, 0xb, 0x37, 0x99, 0x7, 0x23, 0x6f, 0xe8, 0x6e, 0xf8, 0xe5, 0x89, 0x45, 0x7b, 0xf0, 0xa6, 0xda, 0x1f, 0xb6, 0xf, 0x49, 0x52, 0xc6, 0xc, 0x28, 0xd1, 0xa1, 0xf9, 0x1e, 0x56, 0x42, 0x6a, 0x91, 0x93, 0xe0, 0x92, 0x48, 0x57, 0x46, 0x68, 0xdb, 0x6, 0xb8, 0x2, 0x57, 0x46, 0x68, 0x72, 0x6, 0x71, 0xbd, 0x65, 0x4c, 0x7c, 0x5a, 0xfa, 0x59, 0x46, 0xd1, 0x7a, 0x3a, 0xde, 0xd2, 0xb, 0x2c, 0xf5, 0x26, 0x52, 0xf8, 0x55, 0xa, 0x4f, 0x9e, 0x1a, 0xe7, 0x57, 0xcc};
    // const unsigned short whitening_sequence_sf8_explicit[417] = {0x23, 0x83, 0x73, 0x49, 0x97, 0xc1, 0x3d, 0x89, 0x36, 0x89, 0xb2, 0xae, 0xc4, 0xe1, 0x4b, 0x45, 0xc2, 0x67, 0x2c, 0xde, 0xd0, 0x09, 0x4d, 0xe2, 0x2f, 0xbc, 0xde, 0xb7, 0x4b, 0x62, 0x11, 0xb9, 0x9f, 0x5b, 0x94, 0x0b, 0x63, 0xf2, 0x0a, 0x17, 0x36, 0x85, 0x78, 0x53, 0xf2, 0x86, 0x37, 0x5f, 0xac, 0xe9, 0x33, 0xe3, 0xa4, 0xa6, 0xac, 0xcb, 0xa6, 0xac, 0xb8, 0x91, 0xc6, 0x2c, 0x8f, 0x26, 0x8f, 0x3d, 0x88, 0x90, 0x05, 0x67, 0x28, 0xfd, 0x15, 0x18, 0xf1, 0x03, 0x0a, 0x6d, 0xdf, 0x1e, 0x78, 0xf1, 0xc0, 0xc2, 0x42, 0x74, 0x71, 0xcc, 0xbe, 0xd7, 0x8a, 0x37, 0x7c, 0xc9, 0xae, 0xb8, 0xb7, 0x8e, 0x3c, 0x78, 0xa3, 0xbe, 0xb4, 0xac, 0xab, 0xb5, 0x18, 0xf0, 0x88, 0x01, 0xfa, 0x3d, 0xf7, 0x84, 0xb9, 0x31, 0x4e, 0x77, 0x93, 0x4b, 0xcc, 0x2b, 0x36, 0xcc, 0x54, 0x54, 0x24, 0xf3, 0x4a, 0x32, 0xc5, 0x8d, 0x3f, 0xc9, 0xe8, 0x94, 0x10, 0x40, 0xe6, 0x2d, 0xef, 0xbc, 0x92, 0x8a, 0x60, 0xe1, 0x6c, 0xee, 0x95, 0x13, 0x01, 0xb5, 0x82, 0x6d, 0xa8, 0xb3, 0x49, 0x4a, 0x45, 0x8d, 0x6b, 0xb4, 0xdb, 0xb0, 0x60, 0xf7, 0x48, 0x2a, 0x96, 0x44, 0xba, 0x12, 0xb9, 0x80, 0x1b, 0x70, 0x2c, 0xbf, 0x5f, 0xda, 0xb8, 0xb0, 0x59, 0x41, 0xd3, 0x45, 0xbb, 0x13, 0xf1, 0x30, 0x56, 0xe1, 0x27, 0xa8, 0x71, 0xcc, 0x50, 0xc6, 0x44, 0x27, 0xc8, 0x73, 0x8d, 0x98, 0x8b, 0x23, 0x3a, 0xfe, 0x55, 0x0a, 0xf9, 0x3c, 0x0f, 0x51, 0xbe, 0x0e, 0x44, 0x7e, 0x54, 0xca, 0x29, 0xd9, 0xff, 0xfb, 0x10, 0x42, 0xec, 0x1c, 0x8a, 0x33, 0xb4, 0x0a, 0x0b, 0x7d, 0x5e, 0xf8, 0x37, 0xd7, 0x8b, 0xeb, 0x35, 0xcf, 0xe8, 0x10, 0xf5, 0x82, 0x37, 0x34, 0xa5, 0xe5, 0x28, 0xd1, 0xc4, 0x2c, 0x8d, 0x44, 0x87, 0x29, 0x92, 0x03, 0x6c, 0xee, 0x13, 0x7e, 0x39, 0x9f, 0xd9, 0x30, 0xb8, 0xa9, 0x43, 0x43, 0xd5, 0x49, 0x30, 0x67, 0xeb, 0x91, 0x0a, 0x7d, 0x71, 0x82, 0x69, 0x5c, 0x88, 0x13, 0x75, 0xcf, 0xaa, 0xfa, 0x1c, 0xfb, 0x75, 0xf0, 0x90, 0xaf, 0xbc, 0x99, 0x9e, 0x1b, 0x89, 0x1f, 0xe1, 0x29, 0xff, 0x8b, 0x31, 0xc1, 0x71, 0xd6, 0xca, 0xd7, 0x95, 0x0d, 0x2f, 0x5d, 0xb4, 0x80, 0x14, 0x1a, 0x24, 0xbf, 0x5d, 0xea, 0xc9, 0x3e, 0x77, 0xcc, 0xe9, 0xf1, 0x01, 0x05, 0x72, 0xd2, 0xc8, 0xbd, 0x92, 0x06, 0x21, 0x6d, 0xdc, 0x0b, 0x36, 0x99, 0x07, 0x23, 0x6f, 0xe8, 0x6e, 0xf8, 0xe5, 0x89, 0x45, 0x7b, 0xf0, 0xa6, 0xda, 0x1e, 0xb6, 0x0f, 0x49, 0x52, 0xc6, 0x0c, 0x28, 0xd1, 0xa1, 0xf9, 0x1a, 0x56, 0x42, 0x6a, 0x93, 0x92, 0xe0, 0x96, 0x48, 0x57, 0x46, 0x68, 0xdb, 0x06, 0xb8, 0x02, 0x57, 0x46, 0x68, 0x72, 0x06, 0x71, 0xbd, 0x65, 0x4c, 0x7c, 0x5a, 0xfa, 0x59, 0x46, 0xd1, 0x7a, 0x3e, 0xde, 0xd2, 0x0a, 0x2c, 0xf5, 0x26, 0x52, 0xf8, 0x55, 0x0e, 0x4f, 0x9e, 0x1b, 0xe7, 0x57, 0x6b};

    // Implicit Whitening (header is omitted)
    // /* Reduced precision match  */ const unsigned short whitening_sequence_sf6_implicit[538] = {0b00001101, 0b00000101, 0b00000101, 0b00000101, 0b00001101, 0b00000101, 0b00000100, 0b00000001, 0b00110110, 0b00001111, 0b00010011, 0b00010111, 0b00110111, 0b00000100, 0b00110101, 0b00001110, 0b00001000, 0b00101010, 0b00111010, 0b00001111, 0b00010100, 0b00110100, 0b00010111, 0b00011001, 0b00000100, 0b00010011, 0b00101100, 0b00100011, 0b00011010, 0b00111000, 0b00010000, 0b00100101, 0b00110110, 0b00010100, 0b00010000, 0b00110010, 0b00001011, 0b00111010, 0b00000111, 0b00000000, 0b00101101, 0b00100110, 0b00110111, 0b00001111, 0b00100010, 0b00001100, 0b00011010, 0b00110010, 0b00110011, 0b00001011, 0b00001101, 0b00110000, 0b00011011, 0b00111111, 0b00100010, 0b00010110, 0b00100000, 0b00001000, 0b00111011, 0b00100111, 0b00101110, 0b00101110, 0b00101010, 0b00011100, 0b00011000, 0b00101001, 0b00101000, 0b00101011, 0b00100001, 0b00001101, 0b00000000, 0b00100111, 0b00101001, 0b00101000, 0b00101011, 0b00101110, 0b00001101, 0b00110110, 0b00001000, 0b00100010, 0b00001110, 0b00100110, 0b00100101, 0b00101001, 0b00110101, 0b00000001, 0b00100011, 0b00011010, 0b00110001, 0b00011001, 0b00001000, 0b00010011, 0b00011001, 0b00111110, 0b00000111, 0b00000100, 0b00101010, 0b00101101, 0b00110111, 0b00101100, 0b00000101, 0b00110000, 0b00111111, 0b00110001, 0b00000001, 0b00001011, 0b00100100, 0b00000000, 0b00011111, 0b00110101, 0b00010010, 0b00101100, 0b00100111, 0b00010011, 0b00111111, 0b00100011, 0b00010011, 0b00011100, 0b00111000, 0b00101011, 0b00110110, 0b00001101, 0b00110000, 0b00110011, 0b00101111, 0b00100101, 0b00100111, 0b00101110, 0b00011000, 0b00101011, 0b00111011, 0b00001111, 0b00111000, 0b00101100, 0b00110000, 0b00000000, 0b00101011, 0b00111011, 0b00101100, 0b00101110, 0b00101011, 0b00101110, 0b00001101, 0b00111011, 0b00100011, 0b00001010, 0b00100101, 0b00100000, 0b00000100, 0b00010011, 0b00111010, 0b00000101, 0b00100001, 0b00001011, 0b00111101, 0b00000001, 0b00010110, 0b00010001, 0b00111010, 0b00100000, 0b00100111, 0b00000010, 0b00111101, 0b00100001, 0b00110111, 0b00000111, 0b00011001, 0b00100011, 0b00010111, 0b00000010, 0b00010100, 0b00110011, 0b00110011, 0b00001111, 0b00100100, 0b00011011, 0b00110000, 0b00011011, 0b00011010, 0b00110101, 0b00001000, 0b00111011, 0b00111010, 0b00101100, 0b00101110, 0b00111111, 0b00110010, 0b00101101, 0b00000110, 0b00010011, 0b00011011, 0b00100010, 0b00001011, 0b00100100, 0b00100000, 0b00011000, 0b00110010, 0b00001111, 0b00000000, 0b00000000, 0b00100100, 0b00110001, 0b00101011, 0b00001011, 0b00101100, 0b00100110, 0b00101101, 0b00100001, 0b00111110, 0b00100110, 0b00001100, 0b00101000, 0b00110001, 0b00001001, 0b00010110, 0b00100001, 0b00110100, 0b00000011, 0b00001010, 0b00010101, 0b00100000, 0b00011000, 0b00010101, 0b00110011, 0b00010000, 0b00001001, 0b00011111, 0b00110100, 0b00011000, 0b00101000, 0b00011110, 0b00111110, 0b00100001, 0b00011010, 0b00111110, 0b00100111, 0b00101010, 0b00101001, 0b00001110, 0b00001110, 0b00000011, 0b00001010, 0b00111100, 0b00100001, 0b00001101, 0b00110111, 0b00010010, 0b00011000, 0b00100001, 0b00011110, 0b00111111, 0b00000011, 0b00110010, 0b00001000, 0b00011101, 0b00101110, 0b00000010, 0b00001101, 0b00110001, 0b00100001, 0b00101011, 0b00101111, 0b00010001, 0b00110000, 0b00001111, 0b00110110, 0b00111111, 0b00001001, 0b00000001, 0b00011110, 0b00000010, 0b00111100, 0b00010001, 0b00011111, 0b00000101, 0b00110110, 0b00100110, 0b00000010, 0b00101010, 0b00110100, 0b00000011, 0b00011101, 0b00110101, 0b00000111, 0b00110001, 0b00001111, 0b00100111, 0b00100110, 0b00000111, 0b00010010, 0b00110100, 0b00000011, 0b00001000, 0b00101000, 0b00010000, 0b00000001, 0b00110111, 0b00010101, 0b00010000, 0b00010001, 0b00101010, 0b00101110, 0b00100000, 0b00100011, 0b00011101, 0b00100110, 0b00010010, 0b00011100, 0b00100001, 0b00001010, 0b00101101, 0b00001000, 0b00111100, 0b00010000, 0b00001001, 0b00010010, 0b00100001, 0b00001011, 0b00110001, 0b00100011, 0b00011110, 0b00101100, 0b00010011, 0b00111111, 0b00100111, 0b00000010, 0b00001100, 0b00010011, 0b00101001, 0b00111000, 0b00101010, 0b00001010, 0b00010101, 0b00010001, 0b00011011, 0b00000111, 0b00001010, 0b00100101, 0b00100000, 0b00101001, 0b00010011, 0b00011011, 0b00100110, 0b00000011, 0b00010100, 0b00110001, 0b00001000, 0b00011110, 0b00101110, 0b00100100, 0b00011010, 0b00011010, 0b00111011, 0b00111111, 0b00000011, 0b00111010, 0b00011000, 0b00111101, 0b00000101, 0b00010111, 0b00001110, 0b00100111, 0b00100110, 0b00001100, 0b00101101, 0b00100000, 0b00110010, 0b00111010, 0b00110011, 0b00011110, 0b00001111, 0b00010011, 0b00111111, 0b00100110, 0b00000011, 0b00011100, 0b00000111, 0b00000111, 0b00110111, 0b00100111, 0b00110100, 0b00000011, 0b00100000, 0b00101111, 0b00110000, 0b00011001, 0b00011011, 0b00010001, 0b00010000, 0b00011010, 0b00101111, 0b00011000, 0b00101010, 0b00111110, 0b00110101, 0b00101101, 0b00100011, 0b00001011, 0b00010100, 0b00111011, 0b00100110, 0b00000100, 0b00100000, 0b00000000, 0b00000001, 0b00011111, 0b00011100, 0b00011111, 0b00111111, 0b00100010, 0b00010100, 0b00011011, 0b00100010, 0b00001011, 0b00010110, 0b00000100, 0b00110011, 0b00001001, 0b00001010, 0b00111100, 0b00000001, 0b00010100, 0b00110110, 0b00110110, 0b00100001, 0b00001001, 0b00111010, 0b00100111, 0b00001110, 0b00110110, 0b00101111, 0b00000101, 0b00100101, 0b00000000, 0b00101000, 0b00100001, 0b00010001, 0b00011101, 0b00011100, 0b00111001, 0b00111000, 0b00101110, 0b00010100, 0b00111000, 0b00000011, 0b00011111, 0b00110011, 0b00000111, 0b00000001, 0b00001001, 0b00101111, 0b00100101, 0b00000110, 0b00010010, 0b00000110, 0b00011000, 0b00100101, 0b00110000, 0b00111000, 0b00100011, 0b00110101, 0b00000101, 0b00111101, 0b00110011, 0b00011111, 0b00100101, 0b00110000, 0b00111000, 0b00010100, 0b00110101, 0b00111011, 0b00111100, 0b00011011, 0b00111001, 0b00001110, 0b00011111, 0b00110111, 0b00000001, 0b00101001, 0b00100111, 0b00100110, 0b00010110, 0b00100111, 0b00100110, 0b00011001, 0b00111111, 0b00101011, 0b00101011, 0b00110101, 0b00000110, 0b00010101, 0b00010000, 0b00101110, 0b00101001, 0b00000100, 0b00110011, 0b00010101, 0b00000001, 0b00011110, 0b00010111, 0b00001100, 0b00111100, 0b00111000, 0b00100101, 0b00111111, 0b00110010, 0b00011101, 0b00111110, 0b00011111, 0b00110011, 0b00100110, 0b00101010, 0b00010110, 0b00000111, 0b00000110, 0b00111100, 0b00111001, 0b00101100, 0b00111101, 0b00011011, 0b00010111, 0b00010001, 0b00011101, 0b00010110, 0b00001101, 0b00110111, 0b00011100, 0b00110111, 0b00110111, 0b00010111, 0b00010001, 0b00110101, 0b00110010, 0b00001001, 0b00110001, 0b00000110, 0b00110101};
	  /* Full precision header    */ //const unsigned short whitening_sequence_sf7_implicit[473] = {0x43, 0x51, 0x43, 0x5b, 0x15, 0x51, 0x18, 0x57, 0x4, 0x3b, 0x4, 0x2e, 0x1b, 0x6a, 0x3a, 0x5, 0x6c, 0x28, 0x63, 0x11, 0x44, 0xc, 0xe, 0x48, 0x62, 0x16, 0x7f, 0x1d, 0xa, 0x29, 0x3e, 0x52, 0x4f, 0xd, 0x6b, 0x47, 0x60, 0x34, 0x4a, 0x6f, 0x66, 0x15, 0x28, 0x20, 0x7a, 0x41, 0x1a, 0x2f, 0x48, 0x40, 0x73, 0x47, 0x56, 0x5c, 0x57, 0x1b, 0x48, 0x0, 0x30, 0x50, 0x7e, 0x47, 0x78, 0x5f, 0x60, 0x30, 0x30, 0x50, 0x59, 0x42, 0x28, 0x27, 0x73, 0x77, 0x7a, 0x55, 0xe, 0x25, 0x32, 0x6c, 0x5a, 0x4c, 0x4e, 0x45, 0x34, 0x7d, 0x1a, 0x76, 0x2, 0x14, 0x18, 0x60, 0x6f, 0xb, 0x2a, 0x45, 0x5f, 0x6b, 0x64, 0x4a, 0x22, 0x38, 0x71, 0x56, 0x47, 0x1a, 0x4, 0x28, 0x53, 0x5a, 0x5a, 0x56, 0x45, 0x18, 0x61, 0x10, 0x0, 0x31, 0x4c, 0x6d, 0x78, 0x0, 0x50, 0x10, 0x62, 0x11, 0x3c, 0x61, 0x14, 0x58, 0x23, 0x77, 0x3e, 0x65, 0x4, 0x71, 0x4e, 0x25, 0x58, 0x13, 0xd, 0x2f, 0x71, 0x1c, 0xd, 0xa, 0x25, 0x68, 0x63, 0x1b, 0x48, 0x11, 0x6d, 0x29, 0x20, 0x32, 0x67, 0x10, 0x37, 0x54, 0x30, 0x53, 0x36, 0x34, 0x7e, 0x4c, 0x49, 0x54, 0x13, 0x75, 0x58, 0x56, 0x29, 0x27, 0x22, 0x46, 0x44, 0x29, 0x41, 0x42, 0x7e, 0x41, 0x2b, 0x7b, 0x69, 0x6, 0x3d, 0x38, 0x30, 0x75, 0x21, 0x12, 0x2b, 0x3, 0x37, 0x6f, 0x30, 0x50, 0x34, 0x5e, 0x3c, 0x7b, 0x21, 0x76, 0x71, 0x52, 0x47, 0x47, 0x46, 0x3f, 0x4a, 0x16, 0x5b, 0x44, 0x2d, 0x79, 0x63, 0x13, 0x75, 0x9, 0x8, 0x25, 0xd, 0x48, 0x64, 0x1b, 0x67, 0x5f, 0x7c, 0x43, 0x65, 0x35, 0x22, 0x1d, 0x6b, 0x15, 0x4, 0x28, 0x5d, 0x6, 0x69, 0x26, 0x7d, 0xf, 0x61, 0x19, 0x4d, 0x4f, 0x7d, 0x4d, 0x2f, 0x6f, 0x61, 0x10, 0x8, 0x68, 0x2a, 0x7, 0x1e, 0x24, 0x36, 0x70, 0x34, 0x15, 0x37, 0x7c, 0x2a, 0x65, 0x41, 0x16, 0x53, 0x4, 0x7e, 0x64, 0x59, 0x6, 0x3d, 0x63, 0x15, 0x64, 0x53, 0x52, 0x12, 0x6d, 0x20, 0x39, 0x77, 0x2c, 0x46, 0x1c, 0x49, 0x51, 0x23, 0x33, 0x4c, 0x22, 0x6b, 0x4, 0x79, 0x1, 0x53, 0x57, 0x23, 0x21, 0x29, 0x1, 0x36, 0x64, 0x58, 0x42, 0x3a, 0x6a, 0x7e, 0x64, 0x39, 0x76, 0x25, 0x33, 0xb, 0x68, 0x2f, 0xd, 0xa, 0x6c, 0x3a, 0x68, 0x73, 0x2, 0x60, 0x33, 0x32, 0x26, 0x32, 0x7d, 0x49, 0x50, 0x52, 0x76, 0x7d, 0x5e, 0x43, 0x12, 0x38, 0x77, 0x17, 0x5a, 0x4c, 0x49, 0x6d, 0x5, 0x27, 0x46, 0x4b, 0x23, 0x54, 0xa, 0x72, 0x58, 0x6a, 0x6a, 0x7c, 0x4e, 0x25, 0x7b, 0x66, 0x1d, 0x3b, 0x66, 0x0, 0x10, 0x13, 0x3c, 0x6e, 0x7, 0x19, 0x4d, 0x73, 0x75, 0x7b, 0x52, 0x3a, 0x6f, 0x17, 0x24, 0x4b, 0x3, 0x57, 0x4c, 0xe, 0x24, 0xc, 0x31, 0x72, 0x5d, 0x29, 0x70, 0x39, 0x6e, 0x15, 0x19, 0x4d, 0xb, 0x46, 0xc, 0x4a, 0x6, 0x40, 0x12, 0x2f, 0xc, 0x29, 0x33, 0x1e, 0x6c, 0x40, 0x43, 0xc, 0x2b, 0x21, 0x26, 0x51, 0x5d, 0x33, 0x74, 0x2b, 0x23, 0x34, 0x39, 0x78, 0x1, 0x54, 0x0, 0x34, 0x7a, 0x26, 0x7d, 0x3b, 0x63, 0x4c, 0x72, 0xf, 0x2d, 0x4f, 0x1e, 0x32, 0x76, 0x3c, 0x1, 0x3e, 0x6a, 0x2c, 0x2a, 0x1a, 0x6c, 0x4e, 0x76, 0x5, 0x39, 0x7, 0x2f, 0x2a, 0x26, 0x1a, 0x4f, 0x11, 0x37, 0x68, 0x17, 0x50, 0x75, 0x19, 0x2d, 0x63};
    /* Reduced precision header */ // const unsigned short whitening_sequence_sf7_implicit[465] = {7, 27, 11, 11, 27, 3, 9, 14, 4, 59, 4, 46, 26, 106, 58, 5, 108, 40, 99, 17, 68, 12, 10, 72, 98, 22, 127, 28, 11, 41, 62, 82, 79, 15, 107, 71, 96, 52, 74, 111, 102, 21, 40, 32, 122, 65, 30, 47, 72, 64, 115, 71, 86, 84, 87, 26, 72, 0, 48, 80, 126, 71, 120, 95, 96, 48, 48, 80, 89, 66, 40, 39, 115, 119, 122, 85, 10, 37, 50, 108, 90, 77, 78, 69, 52, 125, 30, 118, 6, 21, 25, 96, 111, 9, 42, 69, 95, 107, 100, 74, 34, 56, 113, 86, 71, 30, 12, 40, 83, 90, 94, 86, 69, 25, 97, 16, 1, 49, 76, 109, 120, 1, 80, 16, 98, 17, 60, 97, 21, 88, 35, 119, 62, 101, 12, 113, 78, 37, 88, 19, 15, 47, 113, 20, 15, 11, 37, 104, 99, 26, 72, 17, 109, 41, 32, 50, 103, 16, 55, 84, 48, 83, 54, 52, 126, 77, 72, 84, 19, 117, 89, 86, 41, 39, 34, 70, 76, 41, 65, 67, 126, 64, 43, 123, 105, 7, 61, 56, 48, 117, 33, 18, 43, 2, 55, 111, 48, 80, 52, 94, 60, 123, 33, 118, 113, 82, 70, 70, 70, 63, 75, 18, 91, 68, 45, 121, 99, 19, 117, 8, 24, 37, 15, 88, 100, 26, 103, 95, 124, 67, 101, 53, 34, 28, 107, 23, 12, 40, 93, 7, 105, 38, 125, 14, 97, 27, 79, 78, 125, 79, 47, 111, 97, 16, 24, 104, 42, 5, 31, 36, 54, 112, 52, 23, 55, 124, 42, 101, 65, 18, 83, 12, 126, 100, 91, 7, 61, 99, 23, 100, 83, 82, 18, 109, 32, 57, 119, 44, 70, 20, 72, 81, 35, 51, 77, 34, 107, 12, 121, 1, 83, 87, 35, 33, 41, 1, 54, 100, 89, 66, 58, 106, 126, 100, 57, 118, 37, 51, 9, 104, 47, 15, 11, 108, 58, 104, 115, 2, 96, 51, 50, 38, 50, 125, 72, 80, 82, 118, 125, 94, 67, 18, 56, 119, 22, 90, 76, 72, 109, 4, 39, 70, 73, 35, 84, 11, 114, 89, 106, 106, 124, 74, 37, 123, 102, 28, 59, 102, 0, 16, 19, 60, 110, 5, 27, 79, 115, 117, 123, 82, 58, 111, 22, 36, 73, 3, 87, 76, 10, 36, 13, 49, 114, 93, 41, 112, 57, 110, 23, 27, 77, 9, 70, 13, 75, 6, 64, 18, 47, 13, 41, 51, 31, 108, 64, 67, 13, 43, 33, 38, 81, 93, 51, 116, 43, 35, 52, 57, 120, 1, 84, 0, 52, 122, 38, 125, 59, 99, 76, 114, 14, 45, 79, 31, 50, 118, 60, 1, 62, 106, 44, 42, 30, 108, 74, 118, 28, 53, 8, 34, 24, 37, 26, 45, 38};
    // /* Reduced precision match  */ const unsigned short whitening_sequence_sf7_implicit[466] = {0b00000111, 0b00011011, 0b00001011, 0b00001011, 0b00011011, 0b00000011, 0b00001001, 0b00001110, 0b00001100, 0b00111011, 0b00001100, 0b00101110, 0b00011110, 0b01101010, 0b00111010, 0b00000100, 0b01101100, 0b00101000, 0b01100011, 0b00010001, 0b01001100, 0b00001101, 0b00001011, 0b01001000, 0b01100010, 0b00010010, 0b01111111, 0b00010100, 0b00001001, 0b00101001, 0b00111110, 0b01010010, 0b01001111, 0b00001110, 0b01101011, 0b01000110, 0b01100000, 0b00110100, 0b01001010, 0b01101111, 0b01100110, 0b00010111, 0b00101000, 0b00100000, 0b01111010, 0b01000000, 0b00011111, 0b00101111, 0b01001000, 0b00000000, 0b01110011, 0b01000110, 0b01010110, 0b01011100, 0b01010111, 0b00011110, 0b01001000, 0b00000001, 0b00110000, 0b01010000, 0b01111110, 0b01000110, 0b01111000, 0b01011111, 0b01100000, 0b00110000, 0b00110000, 0b01010000, 0b01011001, 0b01000011, 0b00101000, 0b00100111, 0b01110011, 0b01110111, 0b01111010, 0b01010101, 0b00001011, 0b00100101, 0b00110010, 0b01101100, 0b01011010, 0b01001100, 0b01001110, 0b01000101, 0b00110100, 0b01111101, 0b00011111, 0b01110110, 0b00000111, 0b00010111, 0b00011011, 0b01100000, 0b01101111, 0b00001000, 0b00101010, 0b01000101, 0b01011111, 0b01101011, 0b01100100, 0b01001010, 0b00100010, 0b00111000, 0b01110001, 0b01010110, 0b01000111, 0b00011111, 0b00001101, 0b00101000, 0b01010011, 0b01011010, 0b01011010, 0b01010110, 0b01000101, 0b00011011, 0b01100001, 0b00010000, 0b00000011, 0b00110001, 0b01001100, 0b01101101, 0b01111000, 0b00000011, 0b01010000, 0b00110000, 0b01100010, 0b00010000, 0b00111100, 0b01100001, 0b00010111, 0b01011000, 0b00100011, 0b01110111, 0b00111110, 0b01100101, 0b00001101, 0b01110001, 0b01001110, 0b00100101, 0b01011000, 0b00010001, 0b00001110, 0b00101111, 0b01110001, 0b00010101, 0b00001110, 0b00001001, 0b00100101, 0b01101000, 0b01100011, 0b00011110, 0b01001000, 0b00010000, 0b01101101, 0b00101001, 0b00100000, 0b00110010, 0b01100111, 0b00110000, 0b00110111, 0b01010100, 0b00110001, 0b01010011, 0b00110110, 0b00110100, 0b01111110, 0b01001100, 0b01001001, 0b01010100, 0b00010001, 0b01110101, 0b01011000, 0b01010110, 0b00101001, 0b00100111, 0b00100010, 0b01000010, 0b01000100, 0b00101001, 0b01000000, 0b01000011, 0b01111110, 0b01000000, 0b00101011, 0b01111011, 0b01101001, 0b00000111, 0b00111101, 0b00111000, 0b00110001, 0b01110101, 0b00100001, 0b00010011, 0b00101011, 0b00000010, 0b00110111, 0b01101111, 0b00110001, 0b01010000, 0b00110100, 0b01011110, 0b00111100, 0b01111011, 0b00100001, 0b01110110, 0b01110001, 0b01010010, 0b01000110, 0b01000110, 0b01000010, 0b00111111, 0b01001010, 0b00010011, 0b01011011, 0b01000101, 0b00101101, 0b01111001, 0b01100011, 0b00010001, 0b01110101, 0b00001000, 0b00011000, 0b00100101, 0b00001111, 0b01001000, 0b01101100, 0b00011010, 0b01100111, 0b01011111, 0b01111100, 0b01000001, 0b01100100, 0b00110100, 0b00100011, 0b00010100, 0b01101001, 0b00010110, 0b00001100, 0b00101000, 0b01011101, 0b00000111, 0b01101000, 0b00100010, 0b01111100, 0b00001110, 0b01100011, 0b00011011, 0b01001101, 0b01001111, 0b01111100, 0b01001101, 0b00101101, 0b01101110, 0b01100011, 0b00110000, 0b00011000, 0b01111000, 0b00101110, 0b00000101, 0b00011111, 0b00100101, 0b00110111, 0b01010000, 0b00111100, 0b00010110, 0b00110101, 0b01110100, 0b00101110, 0b01100100, 0b01000000, 0b00010011, 0b01010010, 0b00001100, 0b01111111, 0b01101100, 0b01011001, 0b00000111, 0b00111111, 0b01100010, 0b00010110, 0b01101100, 0b01010010, 0b01010110, 0b00010011, 0b01101111, 0b01100000, 0b00111000, 0b01110110, 0b00100100, 0b01000010, 0b00010100, 0b01001001, 0b01010011, 0b00100001, 0b00110010, 0b01001100, 0b00100011, 0b01101001, 0b00001100, 0b01111011, 0b00000011, 0b01010010, 0b01010101, 0b00100001, 0b00100000, 0b00101011, 0b00000011, 0b00110111, 0b01101100, 0b01011000, 0b01000011, 0b00111011, 0b01101011, 0b01111111, 0b01101100, 0b00111000, 0b01110010, 0b00100111, 0b00110010, 0b00001001, 0b01111000, 0b00101101, 0b00001111, 0b00001011, 0b01101101, 0b00111011, 0b01111000, 0b01110001, 0b00000110, 0b01100001, 0b00110010, 0b00110110, 0b00100010, 0b00110110, 0b01111100, 0b01001001, 0b01010001, 0b01010110, 0b01110010, 0b01111100, 0b01011010, 0b01000001, 0b00010011, 0b00101000, 0b01110110, 0b00010110, 0b01011011, 0b01000100, 0b01001001, 0b01101111, 0b00000100, 0b00100110, 0b01000010, 0b01001011, 0b00100001, 0b01011100, 0b00001011, 0b01110011, 0b01011000, 0b01101011, 0b01101011, 0b01110100, 0b01001110, 0b00100111, 0b01111010, 0b01100111, 0b00011100, 0b00111001, 0b01100111, 0b00000001, 0b00110000, 0b00010001, 0b00111101, 0b01101010, 0b00000101, 0b00011011, 0b01001101, 0b01110001, 0b01110111, 0b01111010, 0b01010110, 0b00111011, 0b01101110, 0b00010110, 0b00100101, 0b01001011, 0b00000010, 0b01010101, 0b01000100, 0b00001010, 0b00100101, 0b00001101, 0b00110011, 0b01110011, 0b01011111, 0b00101011, 0b01010000, 0b00111000, 0b01101010, 0b00010111, 0b00011011, 0b01001100, 0b00001001, 0b01000010, 0b00001101, 0b01001010, 0b00000111, 0b00000000, 0b00010011, 0b00101101, 0b00001101, 0b00101011, 0b00110010, 0b00011111, 0b01101101, 0b00000000, 0b01000001, 0b00001101, 0b00101010, 0b00100000, 0b00100010, 0b01010011, 0b01011111, 0b00110010, 0b01110101, 0b00101010, 0b00100001, 0b00111100, 0b00111000, 0b01111001, 0b00000011, 0b01011100, 0b00000001, 0b00111100, 0b01111110, 0b00100010, 0b01111100, 0b00111001, 0b01100010, 0b01000100, 0b01110011, 0b00001110, 0b00101100, 0b01001101, 0b00011111, 0b00110110, 0b01110010, 0b00111101, 0b00000011, 0b00111010, 0b01101011, 0b00100100, 0b00101110, 0b00011110, 0b01101101, 0b01001110, 0b01110010, 0b00011100, 0b00110100, 0b00001000, 0b00100011, 0b00011000, 0b00100111, 0b00011010, 0b00101100, 0b01101110};
    /* Full precision header    */ // const unsigned short whitening_sequence_sf8_implicit[417] = {0xf1, 0x23, 0x91, 0xb9, 0x2f, 0xa7, 0x73, 0x29, 0xbe, 0x94, 0xcb, 0x17, 0xcf, 0x39, 0x0e, 0x97, 0x17, 0x0b, 0x3c, 0x78, 0xae, 0xbf, 0xfe, 0x6c, 0x4e, 0x75, 0x4b, 0xd1, 0x2f, 0xfd, 0x1a, 0xc3, 0xf3, 0xc2, 0xe6, 0x2d, 0xe4, 0xbb, 0xd3, 0x4a, 0x83, 0x27, 0x2e, 0xfc, 0xb9, 0x88, 0x91, 0x3e, 0x90, 0x00, 0xa0, 0xa3, 0x87, 0x36, 0x03, 0x9c, 0x30, 0x01, 0x60, 0xa0, 0xba, 0x8f, 0x73, 0x4e, 0xc3, 0x66, 0x64, 0xea, 0x92, 0x12, 0x40, 0x77, 0x21, 0xa5, 0xef, 0xbc, 0x16, 0x42, 0xf7, 0x81, 0x72, 0xcd, 0xbb, 0xb3, 0xdf, 0x0f, 0x14, 0x25, 0xd8, 0x70, 0x02, 0xc7, 0x18, 0x79, 0x48, 0x00, 0x31, 0x80, 0xe3, 0x27, 0xe0, 0xb1, 0xc0, 0xc0, 0xf0, 0xc0, 0x20, 0xe3, 0x26, 0xe2, 0xf4, 0x21, 0x85, 0x2b, 0x73, 0xe7, 0x7d, 0xce, 0x0b, 0xe2, 0x2c, 0xbe, 0xd5, 0x8b, 0xde, 0x1c, 0x61, 0xcf, 0xed, 0xfa, 0x9f, 0x1e, 0x0c, 0x50, 0xe7, 0x33, 0xa9, 0xb6, 0x8f, 0x14, 0x7b, 0xc9, 0xba, 0xc1, 0xb3, 0x85, 0xb8, 0x31, 0xc5, 0x35, 0x02, 0x03, 0x10, 0x06, 0x25, 0xe9, 0x2e, 0xe4, 0x65, 0x29, 0xd2, 0x44, 0x7b, 0xf2, 0xa0, 0xb0, 0x6e, 0xfb, 0x1b, 0x11, 0x42, 0xcf, 0x60, 0xa0, 0x69, 0xbd, 0xd3, 0x45, 0x68, 0x71, 0x64, 0xe1, 0xf5, 0xb2, 0x87, 0x2a, 0x72, 0xec, 0xef, 0xaf, 0x1d, 0x85, 0x3b, 0x9c, 0xd8, 0x93, 0xa8, 0xbe, 0x4f, 0x43, 0xd7, 0x4e, 0x34, 0x6b, 0x32, 0xd2, 0x79, 0x0f, 0x0e, 0x3e, 0x5a, 0xdc, 0xc6, 0x27, 0x51, 0x56, 0xfe, 0xdf, 0xdc, 0x1a, 0x21, 0xe3, 0x45, 0x04, 0x1a, 0x16, 0x0a, 0x5d, 0x62, 0xe7, 0x68, 0x2a, 0xd1, 0x42, 0x6d, 0x7a, 0xfc, 0x80, 0xe3, 0xd5, 0x96, 0x04, 0x6a, 0xf4, 0x9f, 0x0b, 0x33, 0x09, 0x01, 0x20, 0x60, 0xe0, 0x9a, 0x14, 0xd1, 0x7f, 0x70, 0xc6, 0xe7, 0xa9, 0x89, 0x38, 0x92, 0x9e, 0x43, 0x65, 0x2b, 0xf7, 0x24, 0xf1, 0x16, 0x57, 0xf4, 0xc9, 0xf4, 0xaa, 0x69, 0xee, 0x4e, 0x05, 0x1f, 0x1c, 0x1e, 0xd7, 0x72, 0xd6, 0xe7, 0x0c, 0x48, 0x51, 0x40, 0x41, 0x4b, 0x6b, 0xbb, 0x60, 0xc0, 0x61, 0x63, 0x67, 0x66, 0xfc, 0x17, 0xc2, 0xfd, 0xd8, 0xf6, 0xa4, 0xe9, 0x8a, 0x5e, 0x65, 0x08, 0x32, 0x07, 0xcf, 0x04, 0x73, 0xc9, 0x8e, 0x62, 0xe7, 0xea, 0x32, 0x7e, 0xce, 0x25, 0x5d, 0xe7, 0xea, 0xb0, 0xa5, 0xd4, 0x1a, 0xfb, 0x53, 0xba, 0x96, 0x83, 0x85, 0x1f, 0x5d, 0x19, 0x61, 0x06, 0x26, 0x2c, 0x78, 0x44, 0x7b, 0xcd, 0x8a, 0x67, 0xed, 0xfe, 0xbe, 0x6a, 0xfe, 0xb9, 0x73, 0x6f, 0xfa, 0x9a, 0x9b, 0x60, 0xf2, 0xad, 0xe6, 0x78, 0xf4, 0x8c, 0x1d, 0xe6, 0xa6, 0x3e, 0xb8, 0xf4, 0xca, 0xbc, 0x39, 0x2f, 0xed, 0x4b, 0x97, 0x1c, 0x1c, 0x1d, 0xd5, 0xe2, 0xb2, 0xf2, 0x64, 0x4c, 0x7c, 0x5e, 0x58, 0x38, 0xcf, 0x95, 0xec, 0x7d, 0xd6, 0xc8, 0x12, 0x52, 0x56, 0x8b, 0xfa, 0xd9, 0x48, 0x1d, 0x79, 0x8f, 0x81, 0x3f, 0x9b, 0xa7};
    /* Reduced precision header */ // const unsigned short whitening_sequence_sf8_implicit[417] = {0x33, 0x1f, 0x17, 0x17, 0x37, 0x7, 0x13, 0x1d, 0xbe, 0x94, 0xcb, 0x17, 0xcf, 0x39, 0xe, 0x97, 0x17, 0xb, 0x3c, 0x78, 0xae, 0xbf, 0xfe, 0x6c, 0x4e, 0x75, 0x4b, 0xd1, 0x2f, 0xfd, 0x1a, 0xc3, 0xf3, 0xc2, 0xe6, 0x2d, 0xe4, 0xbb, 0xd3, 0x4a, 0x83, 0x27, 0x2e, 0xfc, 0xb9, 0x88, 0x91, 0x3e, 0x90, 0x0, 0xa0, 0xa3, 0x87, 0x36, 0x3, 0x9c, 0x30, 0x1, 0x60, 0xa0, 0xba, 0x8f, 0x73, 0x4e, 0xc3, 0x66, 0x64, 0xea, 0x92, 0x12, 0x40, 0x77, 0x21, 0xa5, 0xef, 0xbc, 0x16, 0x42, 0xf7, 0x81, 0x72, 0xcd, 0xbb, 0xb3, 0xdf, 0xf, 0x14, 0x25, 0xd8, 0x70, 0x2, 0xc7, 0x18, 0x79, 0x48, 0x0, 0x31, 0x80, 0xe3, 0x27, 0xe0, 0xb1, 0xc0, 0xc0, 0xf0, 0xc0, 0x20, 0xe3, 0x26, 0xe2, 0xf4, 0x21, 0x85, 0x2b, 0x73, 0xe7, 0x7d, 0xce, 0xb, 0xe2, 0x2c, 0xbe, 0xd5, 0x8b, 0xde, 0x1c, 0x61, 0xcf, 0xed, 0xfa, 0x9f, 0x1e, 0xc, 0x50, 0xe7, 0x33, 0xa9, 0xb6, 0x8f, 0x14, 0x7b, 0xc9, 0xba, 0xc1, 0xb3, 0x85, 0xb8, 0x31, 0xc5, 0x35, 0x2, 0x3, 0x10, 0x6, 0x25, 0xe9, 0x2e, 0xe4, 0x65, 0x29, 0xd2, 0x44, 0x7b, 0xf2, 0xa0, 0xb0, 0x6e, 0xfb, 0x1b, 0x11, 0x42, 0xcf, 0x60, 0xa0, 0x69, 0xbd, 0xd3, 0x45, 0x68, 0x71, 0x64, 0xe1, 0xf5, 0xb2, 0x87, 0x2a, 0x72, 0xec, 0xef, 0xaf, 0x1d, 0x85, 0x3b, 0x9c, 0xd8, 0x93, 0xa8, 0xbe, 0x4f, 0x43, 0xd7, 0x4e, 0x34, 0x6b, 0x32, 0xd2, 0x79, 0xf, 0xe, 0x3e, 0x5a, 0xdc, 0xc6, 0x27, 0x51, 0x56, 0xfe, 0xdf, 0xdc, 0x1a, 0x20, 0xe3, 0x45, 0x4, 0x1a, 0x16, 0xa, 0x5d, 0x66, 0xe7, 0x68, 0x2e, 0xd1, 0x42, 0x6f, 0x7a, 0xfc, 0x80, 0xe3, 0xd5, 0x96, 0x4, 0x6b, 0xf4, 0x9f, 0xb, 0x33, 0x9, 0x1, 0x60, 0x61, 0xe0, 0x9a, 0x14, 0xd1, 0x7f, 0x70, 0xc6, 0xe7, 0xa9, 0x89, 0x28, 0x92, 0x9e, 0x43, 0x64, 0x2a, 0xf7, 0x25, 0xf1, 0x16, 0x57, 0xf4, 0xc9, 0xf5, 0xae, 0x68, 0xea, 0x4e, 0x5, 0x1f, 0x1c, 0x1e, 0xd5, 0x72, 0xd7, 0xe5, 0xc, 0x48, 0x51, 0x40, 0x41, 0x4b, 0x69, 0xb9, 0x61, 0xc0, 0x63, 0x62, 0x65, 0x67, 0xf4, 0x17, 0xc2, 0xfc, 0xc8, 0xf2, 0xa5, 0xe8, 0x8b, 0x5e, 0x64, 0x8, 0x32, 0x7, 0xcd, 0x4, 0x73, 0xcb, 0x8a, 0x66, 0xe5, 0xeb, 0x32, 0x7f, 0xcf, 0x27, 0x5d, 0xe5, 0xeb, 0xb1, 0xa7, 0xdc, 0x1a, 0xfa, 0x53, 0xbb, 0x92, 0x82, 0x84, 0x1f, 0x5d, 0x19, 0x63, 0x2, 0x22, 0x24, 0x79, 0x4c, 0x7a, 0xcd, 0x8b, 0x65, 0xed, 0xfe, 0xba, 0x6b, 0xfe, 0xb8, 0x73, 0x6e, 0xfa, 0x9e, 0x9a, 0x61, 0xf2, 0xad, 0xe6, 0x69, 0xf4, 0x8d, 0x1f, 0xe6, 0xa6, 0x3d, 0xb8, 0xf4, 0xca, 0xbc, 0x3a, 0x2a, 0xed, 0x4b, 0x96, 0x1d, 0x1d, 0x1f, 0xd5, 0xe2, 0xb2, 0xf2, 0x67, 0x4c, 0x7d, 0x5e, 0x58, 0x3b, 0xcf, 0x97, 0xec, 0xc9, 0x48, 0xdd, 0x4a, 0x9b, 0x96, 0x28, 0x9a, 0xe0};
    // /* Reduced precision match  */const unsigned short whitening_sequence_sf8_implicit[410] = {0b00110011, 0b00011111, 0b00010111, 0b00010111, 0b00110111, 0b00000111, 0b00010011, 0b00011101, 0b10111110, 0b10010100, 0b11001011, 0b00010111, 0b11001111, 0b00111001, 0b00001110, 0b10010111, 0b00010111, 0b00001011, 0b00111100, 0b01111000, 0b10101110, 0b10111111, 0b11111110, 0b01101100, 0b01001110, 0b01110101, 0b01001011, 0b11010001, 0b00101111, 0b11111101, 0b00011010, 0b11000011, 0b11110011, 0b11000010, 0b11100110, 0b00101101, 0b11100100, 0b10111011, 0b11010011, 0b01001010, 0b10000011, 0b00100111, 0b00101110, 0b11111100, 0b10111001, 0b10001000, 0b10010001, 0b00111110, 0b10010000, 0b00000000, 0b10100000, 0b10100011, 0b10000111, 0b00110111, 0b00000011, 0b10011100, 0b00110001, 0b00000001, 0b01100000, 0b10100000, 0b10111010, 0b10001111, 0b01110011, 0b01001110, 0b11000011, 0b01100110, 0b01100100, 0b11101010, 0b10010010, 0b00010011, 0b01000000, 0b01110111, 0b00100001, 0b10100101, 0b11101111, 0b10111100, 0b00010010, 0b01000010, 0b11110111, 0b10000001, 0b01110010, 0b11001101, 0b10111011, 0b10110011, 0b11011111, 0b00001111, 0b00010100, 0b00100101, 0b11011000, 0b01110000, 0b00000010, 0b11000111, 0b00011000, 0b01111001, 0b01001000, 0b00000000, 0b00110001, 0b10000000, 0b11100011, 0b00100111, 0b11100000, 0b10110001, 0b11000000, 0b11000000, 0b11110000, 0b11000000, 0b00100000, 0b11100011, 0b00100110, 0b11100010, 0b11110100, 0b00100001, 0b10000101, 0b00101011, 0b01110011, 0b11100111, 0b01111101, 0b11001110, 0b00001011, 0b11100010, 0b00101100, 0b10111110, 0b11010101, 0b10001011, 0b11011110, 0b00011100, 0b01100001, 0b11001111, 0b11101101, 0b11111010, 0b10011111, 0b00011110, 0b00001100, 0b01010000, 0b11100111, 0b00110011, 0b10101001, 0b10110110, 0b10001111, 0b00010100, 0b01111011, 0b11001001, 0b10111010, 0b11000001, 0b10110011, 0b10000101, 0b10111000, 0b00110001, 0b11000101, 0b00110101, 0b00000010, 0b00000011, 0b00010000, 0b00000110, 0b00100101, 0b11101001, 0b00101110, 0b11100100, 0b01100101, 0b00101001, 0b11010010, 0b01000100, 0b01111011, 0b11110010, 0b10100000, 0b10110000, 0b01101110, 0b11111011, 0b00011011, 0b00010001, 0b01000010, 0b11001111, 0b01100000, 0b10100000, 0b01101001, 0b10111101, 0b11010011, 0b01000101, 0b01101000, 0b01110001, 0b01100100, 0b11100001, 0b11110101, 0b10110010, 0b10000111, 0b00101010, 0b01110010, 0b11101100, 0b11101111, 0b10101111, 0b00011101, 0b10000101, 0b00111011, 0b10011100, 0b11011000, 0b10010011, 0b10101000, 0b10111110, 0b01001111, 0b01000011, 0b11010111, 0b01001110, 0b00110100, 0b01101011, 0b00110010, 0b11010010, 0b01111001, 0b00001111, 0b00001110, 0b00111110, 0b01011010, 0b11011100, 0b11000110, 0b00100111, 0b01010001, 0b01010110, 0b11111110, 0b11011111, 0b11011100, 0b00011010, 0b00100000, 0b11100011, 0b01000101, 0b00000100, 0b00011010, 0b00010110, 0b00001010, 0b01011101, 0b01100110, 0b11100111, 0b01101000, 0b00101110, 0b11010001, 0b01000010, 0b01101111, 0b01111010, 0b11111100, 0b10000000, 0b11100011, 0b11010101, 0b10010110, 0b00000100, 0b01101011, 0b11110100, 0b10011111, 0b00001011, 0b00110011, 0b00001001, 0b00000001, 0b01100000, 0b01100001, 0b11100000, 0b10011010, 0b00010100, 0b11010001, 0b01111111, 0b01110000, 0b11000110, 0b11100111, 0b10101001, 0b10001001, 0b00101000, 0b10010010, 0b10011110, 0b01000011, 0b01100100, 0b00101010, 0b11110111, 0b00100101, 0b11110001, 0b00010110, 0b01010111, 0b11110100, 0b11001001, 0b11110101, 0b10101110, 0b01101000, 0b11101010, 0b01001110, 0b00000101, 0b00011111, 0b00011100, 0b00011110, 0b11010101, 0b01110010, 0b11010111, 0b11100101, 0b00001100, 0b01001000, 0b01010001, 0b01000000, 0b01000001, 0b01001011, 0b01101001, 0b10111001, 0b01100001, 0b11000000, 0b01100011, 0b01100010, 0b01100101, 0b01100111, 0b11110100, 0b00010111, 0b11000010, 0b11111100, 0b11001000, 0b11110010, 0b10100101, 0b11101000, 0b10001011, 0b01011110, 0b01100100, 0b00001000, 0b00110010, 0b00000111, 0b11001101, 0b00000100, 0b01110011, 0b11001011, 0b10001010, 0b01100110, 0b11100101, 0b11101011, 0b00110010, 0b01111111, 0b11001111, 0b00100111, 0b01011101, 0b11100101, 0b11101011, 0b10110001, 0b10100111, 0b11011100, 0b00011010, 0b11111010, 0b01010011, 0b10111011, 0b10010010, 0b10000010, 0b10000100, 0b00011111, 0b01011101, 0b00011001, 0b01100011, 0b00000010, 0b00100010, 0b00100100, 0b01111001, 0b01001100, 0b01111010, 0b11001100, 0b10001011, 0b01100101, 0b11101111, 0b11111111, 0b10111010, 0b01101011, 0b11111111, 0b10111000, 0b01110011, 0b01101110, 0b11111110, 0b10011110, 0b10011010, 0b01100001, 0b11110011, 0b10101100, 0b11100111, 0b01101001, 0b11110101, 0b10001101, 0b00011111, 0b11100111, 0b10100010, 0b00111101, 0b10101000, 0b11110101, 0b11001110, 0b10111101, 0b00111010, 0b00101010, 0b11101111, 0b01001001, 0b10010110, 0b00011101, 0b00011101, 0b00011111, 0b11010100, 0b11100110, 0b10110110, 0b11110011, 0b01100111, 0b01001101, 0b01111111, 0b01011111, 0b01011001, 0b00111011, 0b11001101, 0b10010111, 0b11101101, 0b11001011, 0b01011000, 0b11011111, 0b01001011, 0b10011011, 0b10010110, 0b00101000, 0b10011010, 0b11101110};
    // const unsigned short whitening_sequence_sf9_implicit[369] = {0x51, 0x103, 0x173, 0x179, 0x4f, 0x14f, 0xe7, 0xd1, 0x4c, 0x1d9, 0x77, 0x1af, 0xe3, 0x194, 0x1ac, 0x175, 0x5a, 0x1ff, 0x136, 0x129, 0xd0, 0x1c2, 0x8d, 0x123, 0x17e, 0x1b9, 0x136, 0x2c, 0xf0, 0x1e6, 0x1c, 0x2f, 0x16a, 0x115, 0x6e, 0x8b, 0xc6, 0x1e6, 0x117, 0xb4, 0xc1, 0x147, 0x46, 0x199, 0x4e, 0x1c1, 0x146, 0x196, 0x181, 0xc2, 0x142, 0x147, 0x6e, 0x19b, 0x4f, 0x190, 0x187, 0xcd, 0x1ce, 0x152, 0x21, 0x9f, 0xd8, 0x190, 0x0, 0x43, 0x1cd, 0x154, 0x3c, 0x8d, 0x1eb, 0x102, 0x138, 0x11, 0x1ef, 0x15a, 0x73, 0x1ad, 0x137, 0x106, 0x16d, 0x11f, 0xea, 0x1b1, 0x160, 0x12f, 0x13a, 0x173, 0x148, 0x156, 0x7b, 0x1b3, 0x13b, 0x2, 0x1fd, 0x7a, 0x10f, 0x54, 0x167, 0x10b, 0x3a, 0x98, 0x1f1, 0x2a, 0x139, 0x10, 0x1ef, 0x10e, 0xb2, 0xbf, 0x161, 0x19, 0x17a, 0x13d, 0xb6, 0x1ae, 0x1b1, 0x67, 0x161, 0x45, 0x153, 0x16c, 0x17, 0xba, 0x1b0, 0x6c, 0x124, 0x42, 0x1d5, 0x166, 0x10a, 0x52, 0x18c, 0x6b, 0xc, 0x6, 0x1fa, 0x111, 0x125, 0x46, 0x102, 0x4d, 0x83, 0x10e, 0x12a, 0x1f, 0x71, 0xae, 0x112, 0xc3, 0xa5, 0x18b, 0x104, 0x59, 0xfe, 0x1a9, 0x15a, 0x123, 0xb0, 0x81, 0x108, 0x71, 0x1a7, 0x109, 0x7b, 0x1b2, 0xb3, 0x40, 0x31, 0x65, 0x18f, 0x19, 0x2a, 0x92, 0x3c, 0x120, 0x12, 0xed, 0x192, 0x78, 0xa, 0xdd, 0x30, 0x1a2, 0x14, 0xf9, 0x1ba, 0x7f, 0x42, 0x1d8, 0x181, 0x85, 0xd4, 0x1fc, 0x1ba, 0x28, 0xc1, 0x1c0, 0x8a, 0x18, 0xfa, 0x1a8, 0x133, 0x2c, 0x19, 0xc5, 0x8a, 0x10d, 0x6e, 0x19e, 0x50, 0xa4, 0x105, 0x58, 0x18f, 0x19d, 0x144, 0x1c7, 0x49, 0x1b5, 0x18c, 0x5b, 0x114, 0x88, 0x1d4, 0x167, 0x10b, 0x172, 0x80, 0xcd, 0x110, 0x88, 0x1d4, 0x165, 0x118, 0x77, 0x40, 0x1c6, 0x1b7, 0x1b7, 0x11c, 0x6a, 0x119, 0x75, 0x163, 0x10c, 0x19f, 0x1f2, 0x3e, 0x39, 0x1bf, 0x78, 0x1a5, 0x8, 0x15e, 0xd6, 0x29, 0x93, 0xa6, 0x180, 0x8e, 0xf0, 0x17f, 0xc5, 0x113, 0xa2, 0x181, 0x180, 0x8, 0xd1, 0x1b4, 0xe0, 0x12d, 0x9, 0xd6, 0xee, 0x118, 0x5d, 0xbd, 0xa5, 0x105, 0x59, 0xff, 0x1f9, 0x19d, 0x76, 0xea, 0x198, 0x105, 0x49, 0x1d3, 0x126, 0x88, 0xfc, 0xee, 0x154, 0xf, 0x49, 0x1d3, 0x126, 0x97, 0xfc, 0xef, 0x15c, 0xce, 0x1cb, 0x1d1, 0x127, 0x1bc, 0x2c, 0x1e5, 0x18e, 0xc9, 0x1da, 0x168, 0x131, 0x1f2, 0x138, 0x123, 0x18a, 0x84, 0xd4, 0x17b, 0x13c, 0xc2, 0x1e6, 0x14e, 0x1ce, 0xad, 0x8f, 0x1dc, 0x12b, 0xc5, 0x1c2, 0x11e, 0x1ce, 0xad, 0x8f, 0xd3, 0x1eb, 0xe0, 0x18d, 0x136, 0x1c9, 0xab, 0x9b, 0xfb, 0x1f4, 0xa8, 0x82, 0x1a1, 0xf6, 0xec, 0x195, 0xe8, 0x1bc, 0x194, 0x59, 0x185, 0x91, 0x1a1, 0xb5, 0x4d, 0x19d, 0x158, 0x16b, 0x3, 0x13d, 0x1ee};
    // /* Reduced precision header */const unsigned short whitening_sequence_sf9_implicit[361] = {27, 103, 63, 47, 107, 15, 39, 59, 76, 475, 119, 430, 226, 412, 429, 375, 95, 510, 311, 299, 209, 454, 143, 289, 383, 443, 311, 46, 208, 482, 31, 43, 363, 278, 108, 137, 195, 482, 274, 188, 64, 326, 69, 408, 75, 451, 322, 407, 384, 193, 323, 326, 109, 409, 74, 401, 390, 196, 458, 342, 34, 157, 201, 401, 257, 70, 463, 348, 53, 143, 490, 263, 297, 18, 493, 347, 118, 431, 308, 261, 366, 284, 233, 400, 355, 300, 313, 368, 331, 341, 120, 432, 312, 0, 510, 121, 267, 87, 356, 280, 61, 155, 498, 40, 296, 18, 492, 265, 183, 186, 354, 9, 383, 318, 181, 427, 400, 99, 354, 76, 342, 367, 28, 185, 401, 103, 295, 71, 470, 357, 264, 81, 389, 110, 7, 1, 505, 305, 294, 69, 261, 78, 134, 265, 303, 27, 114, 173, 272, 192, 166, 398, 271, 90, 253, 440, 345, 288, 179, 130, 283, 114, 420, 281, 120, 433, 182, 67, 17, 98, 396, 9, 40, 145, 55, 353, 21, 238, 407, 107, 13, 222, 19, 423, 20, 250, 447, 126, 71, 475, 128, 140, 221, 511, 447, 40, 64, 451, 137, 24, 255, 441, 306, 45, 25, 198, 137, 271, 111, 411, 112, 167, 260, 89, 396, 414, 327, 452, 72, 438, 389, 90, 277, 153, 471, 356, 265, 369, 131, 196, 304, 153, 471, 356, 281, 119, 65, 453, 434, 434, 276, 106, 283, 117, 354, 269, 410, 503, 62, 57, 444, 120, 428, 8, 347, 213, 41, 144, 163, 129, 139, 209, 381, 199, 273, 161, 128, 129, 8, 210, 437, 227, 300, 9, 215, 234, 281, 93, 191, 167, 260, 89, 253, 504, 415, 118, 235, 392, 261, 73, 465, 290, 152, 244, 234, 348, 15, 73, 465, 290, 150, 244, 238, 349, 207, 457, 464, 294, 436, 44, 487, 399, 203, 478, 376, 307, 502, 296, 289, 398, 140, 220, 378, 317, 195, 482, 335, 458, 172, 142, 468, 298, 199, 454, 287, 458, 172, 142, 210, 490, 225, 396, 311, 456, 170, 154, 250, 508, 169, 134, 419, 242, 429, 180, 200, 412, 392, 72, 386, 54, 407};
    // const unsigned short whitening_sequence_sf10_implicit[329] = {0x313, 0xc1, 0x233, 0x2f9, 0xad, 0x29f, 0x1cf, 0x1a5, 0xc7, 0x20c, 0x39b, 0xb7, 0x2, 0x1c2, 0x1e5, 0x2b3, 0x326, 0x1cf, 0x1c, 0x3be, 0x165, 0x10b, 0x365, 0x2b6, 0x3c5, 0x20d, 0x39a, 0xbd, 0x276, 0x45, 0x1ba, 0x33e, 0x2a3, 0x2c7, 0xb, 0x39c, 0x2f8, 0x271, 0x241, 0xfd, 0x28c, 0x298, 0x2b0, 0xa0, 0x85, 0x3cb, 0xe4, 0x3b3, 0x395, 0x2af, 0x2dd, 0x2a8, 0x371, 0x5, 0x23f, 0xbd, 0x8e, 0x29c, 0x2bb, 0x27c, 0x19d, 0x3f9, 0xda, 0x3b4, 0x252, 0x12d, 0x2d8, 0x2b6, 0x36a, 0x3f, 0x79, 0x90, 0x2ae, 0x2dc, 0x138, 0x353, 0x2e6, 0x24c, 0x268, 0x2e0, 0x18d, 0x28b, 0x295, 0xbb, 0x2f5, 0x258, 0xbe, 0x234, 0x216, 0x1a6, 0x2ca, 0x292, 0xfb, 0x37f, 0x31b, 0x2f3, 0x1c4, 0x219, 0x3b5, 0x26b, 0x36b, 0x76, 0x18d, 0x332, 0x366, 0x144, 0xa, 0x39b, 0x2f6, 0x249, 0x5, 0xf1, 0xa3, 0x240, 0x101, 0x18c, 0x3f9, 0x27c, 0x245, 0x2ad, 0x47, 0x10b, 0x2b0, 0xa7, 0x2f8, 0x277, 0x2fc, 0x212, 0x35, 0x1ef, 0x15a, 0x3b0, 0x281, 0x240, 0x1b8, 0x3ed, 0x21b, 0x1bf, 0x3e8, 0x70, 0x2d1, 0x1, 0x14c, 0x194, 0x3de, 0x233, 0x3e5, 0x25a, 0xeb, 0x351, 0x162, 0x81, 0xeb, 0x270, 0x21, 0x347, 0x267, 0x4b, 0x37e, 0x3a6, 0x136, 0x1e9, 0x5c, 0x1af, 0xe0, 0x343, 0x1e3, 0x36, 0x15e, 0x132, 0x3ec, 0x5a, 0x331, 0xc2, 0x268, 0x272, 0x13a, 0x1f0, 0x162, 0x34c, 0x2ef, 0x23b, 0x3b5, 0x35f, 0x344, 0x118, 0x3b2, 0x6a, 0x97, 0x3cd, 0x29f, 0x1c1, 0x2b7, 0x2ec, 0x149, 0x39c, 0x27e, 0x39, 0xc2, 0x2c, 0x2c9, 0x211, 0x2e3, 0xc1, 0x38e, 0x2f2, 0x135, 0x35a, 0x3ae, 0x2d9, 0x3d, 0x379, 0x387, 0x298, 0x42, 0x4c, 0x3d2, 0x22a, 0x2db, 0xb4, 0x2e4, 0x20d, 0x338, 0x3e4, 0x2fd, 0x27e, 0x7f, 0x377, 0x1e5, 0x344, 0x389, 0x31, 0x2bb, 0x2f5, 0x7b, 0x173, 0x71, 0x14d, 0x294, 0x3c1, 0xca, 0x21f, 0x2a9, 0x51, 0x18, 0x1f1, 0x1da, 0xe4, 0x23, 0x1c5, 0x1a, 0x3b1, 0x316, 0x8a, 0x339, 0x33f, 0x247, 0x107, 0x38a, 0x92, 0x1ff, 0x33e, 0x9f, 0x173, 0x3a0, 0x247, 0x107, 0x38a, 0x1c, 0x1fc, 0x31d, 0x53, 0x390, 0x2e6, 0x41, 0x18a, 0x11b, 0x1bb, 0x88, 0x3f7, 0x197, 0x2b8, 0x2f3, 0x6e, 0x26e, 0x34, 0x3, 0x91, 0x14b, 0x11a, 0x2ba, 0x27b, 0x186, 0x3c2, 0x295, 0x392, 0x70, 0x162, 0x158, 0x39c, 0x31, 0x185, 0x2d8, 0x18e, 0x169, 0x175, 0x162, 0x158, 0x37a, 0x36, 0x2a9, 0xe, 0x135, 0x1ff, 0x17c, 0x164, 0xee, 0x370, 0x1cb, 0x26c, 0x25d, 0x132, 0x3ef, 0x5c, 0x121, 0x147, 0x22f, 0x3fb, 0x2e3};
    // /* Reduced precision header */const unsigned short whitening_sequence_sf10_implicit[177] = {0, 0, 0, 3, 6, 101, 109, 203, 477, 319, 381, 876, 127, 319, 477, 199, 524, 923, 183, 2, 450, 485, 691, 807, 463, 28, 958, 357, 265, 871, 694, 967, 525, 922, 188, 630, 69, 443, 831, 675, 711, 11, 924, 760, 625, 577, 255, 652, 664, 688, 161, 135, 970, 229, 947, 917, 687, 733, 680, 883, 5, 575, 188, 143, 668, 699, 636, 412, 1017, 222, 948, 594, 300, 728, 694, 878, 63, 121, 145, 686, 732, 296, 849, 742, 588, 616, 736, 388, 651, 661, 184, 757, 600, 187, 564, 534, 423, 714, 658, 254, 892, 798, 755, 460, 539, 949, 619, 872, 119, 396, 822, 871, 325, 14, 922, 759, 587, 7, 240, 161, 704, 256, 388, 1017, 628, 583, 687, 69, 267, 656, 166, 744, 630, 765, 531, 55, 493, 346, 945, 640, 704, 441, 1005, 539, 445, 1000, 112, 720, 0, 332, 412, 990, 563, 997, 603, 233, 849, 354, 131, 235, 624, 33, 839, 615, 75, 894, 934, 794, 1005, 6, 489, 973, 591, 173, 916, 917, 183};
    // const unsigned short whitening_sequence_sf11_implicit[311] = {0x500, 0x50c, 0x518, 0x120, 0x150, 0x493, 0x741, 0x6b3, 0x679, 0x42d, 0x61f, 0x8f, 0x45, 0xa2, 0xa2, 0x48f, 0x31e, 0x31e, 0x541, 0x172, 0x172, 0x1ab, 0x151, 0x4a6, 0x34f, 0x7b8, 0x5f6, 0x16c, 0x21a, 0x758, 0x93, 0x122, 0x122, 0x40f, 0x40f, 0x4d8, 0x1ad, 0x703, 0x405, 0x209, 0x413, 0x413, 0x627, 0x612, 0x4a1, 0x4e0, 0x740, 0x380, 0x603, 0x777, 0x4a4, 0x304, 0xa8, 0x6e9, 0x3d0, 0x5a3, 0x146, 0x5d, 0x5f, 0x5c4, 0x1a9, 0xb1, 0x765, 0x4cb, 0x1b1, 0x1b1, 0x5a8, 0x1a0, 0x747, 0x6b9, 0x351, 0x4a0, 0x4a0, 0x519, 0xf1, 0x141, 0x501, 0x9, 0x617, 0x439, 0x439, 0x7f9, 0x531, 0x531, 0x4f9, 0x4f9, 0x291, 0x64e, 0x695, 0x4fc, 0x4fc, 0x3fb, 0x6e1, 0x1a3, 0x544, 0x49f, 0x49f, 0x4bc, 0x4bc, 0x507, 0xbb, 0x6bb, 0x351, 0xe0, 0xe0, 0x41e, 0x41e, 0x279, 0x6a9, 0x42d, 0x64b, 0x4b1, 0x361, 0x48a, 0x31d, 0x2d, 0x7, 0x7, 0x13b, 0x650, 0x7e7, 0x2a1, 0x706, 0x190, 0x190, 0x5ce, 0x598, 0x133, 0x133, 0x607, 0x647, 0x4fd, 0x1ab, 0x1ab, 0x167, 0xd8, 0x96, 0xc, 0x20e, 0x2be, 0x6b7, 0x547, 0x498, 0x117, 0x326, 0xa2, 0x306, 0x17e, 0x42f, 0xd6, 0xd6, 0x3a9, 0x4ae, 0x50e, 0x59, 0x540, 0x540, 0x1b4, 0x16c, 0x4da, 0xbc, 0x4e1, 0x4e1, 0x5d0, 0x5c5, 0x1a9, 0x176, 0xe3, 0xe3, 0x6ae, 0x75a, 0x75e, 0x27e, 0x3b6, 0xca, 0x19f, 0x19f, 0x76e, 0x450, 0x60d, 0x542, 0x60e, 0x61e, 0x230, 0x56d, 0x404, 0x404, 0x4a7, 0xd3, 0x8f, 0x714, 0x627, 0x64b, 0x5c6, 0x100, 0x100, 0x1a9, 0x1a9, 0x1c2, 0x58f, 0x58f, 0x44f, 0x44f, 0x5b8, 0x1b4, 0x1d5, 0x5ad, 0x148, 0x192, 0x7c8, 0x5b1, 0xf2, 0x36e, 0x5a1, 0x140, 0x18c, 0xb, 0xb, 0x78b, 0x533, 0x618, 0x472, 0x472, 0x141, 0x187, 0x54f, 0x54, 0x54, 0x80, 0x89, 0x335, 0x66d, 0x5c8, 0x5c8, 0x6aa, 0x3ed, 0x3e1, 0x78f, 0x10e, 0x417, 0x417, 0x375, 0x4a8, 0x4a8, 0x1d6, 0x66, 0x6c5, 0x18f, 0x20e, 0x514, 0xf9, 0xf9, 0x5a3, 0x51a, 0x36, 0x667, 0x5cc, 0x5e4, 0x119, 0x702, 0x46b, 0x1c3, 0x188, 0x188, 0x629, 0x4c, 0x4c, 0x642, 0x9e, 0x76b, 0xf5, 0x1ed, 0xc9, 0x692, 0x7e2, 0x20d, 0x787, 0x59, 0x6b4, 0x372, 0x5eb, 0x6ab, 0x75c, 0x305, 0x7a, 0x1b9, 0x179, 0x6f9, 0x4f4, 0x2d, 0x2d, 0x48, 0x511, 0x511, 0x157, 0xbd, 0xbd, 0x315, 0x479, 0x304, 0x1cf, 0x357, 0x529, 0x142, 0x33e, 0x444, 0x200, 0x64c, 0x17d, 0x17d, 0x4e};
    // const unsigned short whitening_sequence_sf12_implicit[288] = {0x900, 0x900, 0x90c, 0x918, 0x378, 0x332, 0x591, 0x43, 0xbb1, 0xe7b, 0x1af, 0xf5d, 0x22d, 0x397, 0x851, 0x9a2, 0xc42, 0x18d, 0x2d0, 0x460, 0x67b, 0x12d, 0xeeb, 0x4dc, 0x6a8, 0x451, 0x18e, 0xc9d, 0x8b3, 0x509, 0xb38, 0x151, 0x1a6, 0x649, 0x280, 0xc02, 0xb86, 0x6fc, 0xf31, 0xf61, 0xd43, 0xe80, 0xb1c, 0x2f, 0x930, 0xa4f, 0x512, 0x12b, 0xf5f, 0xfbb, 0x430, 0x964, 0xbdb, 0x1f4, 0x940, 0x184, 0xc0b, 0xf14, 0x8b4, 0x76d, 0xc7d, 0xb2c, 0x584, 0x219, 0x53c, 0xb6e, 0x785, 0x204, 0xd4a, 0xf41, 0xf53, 0xfa2, 0xc41, 0x184, 0xd42, 0xe00, 0x71d, 0x701, 0xb48, 0x192, 0xe2f, 0xb5b, 0x8fc, 0x7ff, 0xca5, 0x85a, 0x644, 0x988, 0xc3f, 0xb6e, 0x46d, 0x8df, 0x30f, 0x5f1, 0xfba, 0xc51, 0x7e7, 0x4c3, 0x195, 0xdb8, 0xc91, 0xe48, 0xe15, 0xb2f, 0xf4a, 0x1b3, 0x543, 0xb, 0x90c, 0x919, 0x463, 0x9c9, 0x9e, 0xc2b, 0x51b, 0x1b1, 0x6fe, 0x54e, 0xb69, 0x1d0, 0x2e4, 0x4c5, 0x143, 0xf03, 0x39c, 0xef3, 0xb5f, 0x1b5, 0xc6e, 0xbc9, 0xeb, 0x4d2, 0x6b3, 0x100, 0x59, 0xbbf, 0xc7b, 0xbd7, 0xf49, 0xeb5, 0x7d8, 0x72e, 0x9e9, 0x2f0, 0x8eb, 0x4c8, 0xa2c, 0x9d2, 0xfc9, 0xa69, 0x495, 0x638, 0x577, 0x9e9, 0x143, 0xf00, 0x75a, 0x94d, 0x431, 0x969, 0x3d4, 0x2bb, 0xb5b, 0x94, 0xefa, 0x159, 0xf34, 0xf6f, 0x3d8, 0xc9f, 0xa3b, 0x9e8, 0x37, 0x9b5, 0x21c, 0xb2a, 0xf4a, 0xf92, 0x784, 0x30f, 0xa91, 0x7d5, 0xe0, 0x4c3, 0x898, 0xc10, 0x1c6, 0xc1a, 0x86f, 0x66c, 0x8fe, 0x6f0, 0x8a0, 0x64c, 0xc6b, 0xadc, 0x9de, 0x6d, 0xfea, 0xcf7, 0x6a2, 0x6c4, 0x7cd, 0x394, 0xeba, 0x30c, 0xc45, 0xb92, 0xe3f, 0x956, 0x98d, 0x2b1, 0x278, 0xb2, 0xb6d, 0x1d4, 0xad, 0x44b, 0x9d1, 0x239, 0x480, 0xbb9, 0xd4b, 0xf8e, 0xc37, 0xb22, 0x7cb, 0x2bf, 0x26d, 0xff8, 0xa1d, 0x935, 0xf6d, 0xbc2, 0x8e8, 0x6d2, 0x8a2, 0x31b, 0x350, 0xfe2, 0x2ce, 0xc92, 0x2a2, 0x4ca, 0xd87, 0xa26, 0x4c7, 0x698, 0xa38, 0xb69, 0x287, 0xc05, 0xf5b, 0xd5a, 0xc72, 0xbfc, 0x2d3, 0x6e0, 0xb1, 0x46d, 0xd59, 0xa0c, 0x676, 0x9e8, 0xe9, 0x4f3, 0xd70, 0xe38, 0xc3a, 0x379, 0x2a7, 0x452, 0x7aa, 0x47e, 0x516, 0x1a8, 0x50d, 0x68e, 0x5ab, 0x68a, 0x8ec, 0x194, 0x5a4, 0x963, 0xf40, 0x6a2, 0x4b9};
  }
}

#endif