/*
 * Copyright (C) 2013 Christoph Leitner <c.leitner@student.uibk.ac.at>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef INCLUDED_FOO_PACKET_DROPPER_IMPL_H
#define INCLUDED_FOO_PACKET_DROPPER_IMPL_H

#include <foo/packet_dropper.h>
#include <random>

namespace gr {
namespace foo {
	class packet_dropper_impl : public packet_dropper {
		private:
			double d_drop_rate;
			std::default_random_engine d_generator;
			std::uniform_real_distribution<double> d_distribution;
			void msg_handler(pmt::pmt_t msg);
		public:
			packet_dropper_impl(double drop_rate, unsigned long seed);
	};
}
}

#endif /* INCLUDED_FOO_PACKET_DROPPER_IMPL_H */
