/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * gr-baz by Balint Seeber (http://spench.net/contact)
 * Information, documentation & samples: http://wiki.spench.net/wiki/gr-baz
 */

/*
 * config.h is generated by configure.  It contains the results
 * of probing for features, options etc.  It should be the first
 * file included in your .cc file.
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <baz_tag_to_msg.h>
#include <gnuradio/io_signature.h>
#include <stdio.h>

/*
 * Create a new instance of baz_tag_to_msg and return
 * a boost shared_ptr.  This is effectively the public constructor.
 */
baz_tag_to_msg_sptr 
baz_make_tag_to_msg (int item_size, gr::msg_queue::sptr msgq, const char* append /*= NULL*//*, int initial_buffer_size *//*= 64*/)
{
	return baz_tag_to_msg_sptr (new baz_tag_to_msg (item_size, msgq, append/*, initial_buffer_size*/));
}

/*
 * Specify constraints on number of input and output streams.
 * This info is used to construct the input and output signatures
 * (2nd & 3rd args to gr::block's constructor).  The input and
 * output signatures are used by the runtime system to
 * check that a valid number and type of inputs and outputs
 * are connected to this block.  In this case, we accept
 * only 1 input and 1 output.
 */
static const int MIN_IN = 1;	// mininum number of input streams
static const int MAX_IN = 1;	// maximum number of input streams
static const int MIN_OUT = 0;	// minimum number of output streams
static const int MAX_OUT = 0;	// maximum number of output streams

/*
 * The private constructor
 */
baz_tag_to_msg::baz_tag_to_msg (int item_size, gr::msg_queue::sptr msgq, const char* append/*, int initial_buffer_size*/)
	: gr::sync_block ("tag_to_msg",
		gr::io_signature::make (MIN_IN, MAX_IN, item_size),
		gr::io_signature::make (MIN_OUT, MAX_OUT, 0))
	, d_msgq(msgq)
	//, d_buffer(NULL)
	//, d_buffer_size(initial_buffer_size)
{
	/*if (initial_buffer_size <= 0)
		d_buffer_size = 64;
	d_buffer = (char*)malloc(d_buffer_size);
	assert(d_buffer != NULL);*/
	
	d_appended = append;
}

/*
 * Our virtual destructor.
 */
baz_tag_to_msg::~baz_tag_to_msg ()
{
}

void baz_tag_to_msg::set_msgq(gr::msg_queue::sptr msgq)
{
	d_msgq = msgq;
}

void baz_tag_to_msg::set_appended_string(const char* append)
{
	d_appended = append;
}

int baz_tag_to_msg::work (int noutput_items,
	gr_vector_const_void_star &input_items,
	gr_vector_void_star &output_items)
{
	//const float *in = (const float *) input_items[0];
	//float *out = (float *) output_items[0];

	//for (int i = 0; i < noutput_items; i++) {
	//}
	
	std::vector<gr::tag_t> tags;
	const uint64_t nread = nitems_read(0);
	get_tags_in_range(tags, 0, nread, nread+noutput_items);
	if (tags.size() > 0)
	{
		std::string id_str, key_str, value_str;
//		fprintf(stderr, "[%s] Tags: %d\n", name().c_str(), tags.size());
		
		for (int i = 0; i < tags.size(); ++i) {
			const gr::tag_t& tag = tags[i];
			id_str = pmt::write_string(tag.srcid);
			key_str = pmt::write_string(tag.key);
			value_str = pmt::write_string(tag.value);
			
			//if (key_str == "squelch")
			//fprintf(stderr, "[%s] Tag #%d %s %s %s %s\n", name().c_str(), i, id_str.c_str(), key_str.c_str(), value_str.c_str(), d_appended.c_str());

			int message_data_length =
				sizeof(uint64_t) +
				id_str.size() + 1 +
				key_str.size() + 1 +
				value_str.size() + 1 +
				d_appended.size() + 1;
			
			/*if (message_data_length > d_buffer_size)
			{
				d_buffer_size = message_data_length;
				d_buffer = (char*)realloc(d_buffer, d_buffer_size);
				assert(d_buffer != NULL);
			}*/

			gr::message::sptr msg = gr::message::make(0, 0.0, 0.0, message_data_length);
			int data_index = 0;
			
			memcpy(msg->msg() + data_index, &tag.offset, sizeof(uint64_t));
			data_index += sizeof(uint64_t);
			
			memcpy(msg->msg() + data_index, id_str.c_str(), id_str.size() + 1);
			data_index += (id_str.size() + 1);
			
			memcpy(msg->msg() + data_index, key_str.c_str(), key_str.size() + 1);
			data_index += (key_str.size() + 1);
			
			memcpy(msg->msg() + data_index, value_str.c_str(), value_str.size() + 1);
			data_index += (value_str.size() + 1);
			
			memcpy(msg->msg() + data_index, d_appended.c_str(), d_appended.size() + 1);
			data_index += (d_appended.size() + 1);
			
			if (d_msgq->full_p())
			{
				//fprintf(stderr, "[tag_to_msg] Queue full!\n");
			}
			else
			{
				//fprintf(stderr, "[tag_to_msg] Handling message (%i/%i in queue)\n", d_msgq->count(), d_msgq->limit());
				d_msgq->/*insert_tail*/handle(msg);	// 'handle' blocks too
			}
			//if (d_msgq->full_p())
			//	fprintf(stderr, "[tag_to_msg] Queue still full!\n");
			msg.reset();
		}
	}

	return noutput_items;	// Tell runtime system how many output items we produced.
}
