#line 2 "../gotwebd/pages.tmpl"
/*
* Copyright (c) 2022 Omar Polo <op@openbsd.org>
* Copyright (c) 2016, 2019, 2020-2022 Tracey Emery <tracey@traceyemery.net>
*
* Permission to use, copy, modify, and distribute this software for any
* purpose with or without fee is hereby granted, provided that the above
* copyright notice and this permission notice appear in all copies.
*
* THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
* WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
* ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
* ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
* OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/
#line 19 "../gotwebd/pages.tmpl"
#include "got_compat.h"
#line 21 "../gotwebd/pages.tmpl"
#include <sys/types.h>
#include <sys/queue.h>
#include <sys/stat.h>
#line 25 "../gotwebd/pages.tmpl"
#include <ctype.h>
#include <event.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <imsg.h>
#line 33 "../gotwebd/pages.tmpl"
#include "got_error.h"
#include "got_object.h"
#include "got_reference.h"
#line 37 "../gotwebd/pages.tmpl"
#include "gotwebd.h"
#include "tmpl.h"
#line 40 "../gotwebd/pages.tmpl"
enum gotweb_ref_tm {
TM_DIFF,
TM_LONG,
};
#line 45 "../gotwebd/pages.tmpl"
static int datetime(struct template *, time_t, int);
static int gotweb_render_blob_line(struct template *, const char *, size_t);
static int gotweb_render_tree_item(struct template *, struct got_tree_entry *);
static int blame_line(struct template *, const char *, struct blame_line *,
int, int);
#line 51 "../gotwebd/pages.tmpl"
static inline int gotweb_render_more(struct template *, int);
#line 53 "../gotwebd/pages.tmpl"
static inline int diff_line(struct template *, char *);
static inline int tag_item(struct template *, struct repo_tag *);
static inline int branch(struct template *, struct got_reflist_entry *);
static inline int rss_tag_item(struct template *, struct repo_tag *);
static inline int rss_author(struct template *, char *);
#line 61 "../gotwebd/pages.tmpl"
int
datetime(struct template *tp, time_t t, int fmt)
{
int tp_ret = 0;
#line 63 "../gotwebd/pages.tmpl"
struct tm tm;
char rfc3339[64];
char datebuf[64];
#line 67 "../gotwebd/pages.tmpl"
if (gmtime_r(&t, &tm) == NULL)
return -1;
#line 70 "../gotwebd/pages.tmpl"
if (strftime(rfc3339, sizeof(rfc3339), "%FT%TZ", &tm) == 0)
return -1;
#line 73 "../gotwebd/pages.tmpl"
if (fmt != TM_DIFF && asctime_r(&tm, datebuf) == NULL)
return -1;
#line 76 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<time datetime=\"", 16)) == -1) goto err;
#line 76 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rfc3339)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 77 "../gotwebd/pages.tmpl"
if (fmt == TM_DIFF) {
if ((tp_ret = gotweb_render_age(tp, t)) == -1) goto err;
} else {
if ((tp_ret = tp_htmlescape(tp, datebuf)) == -1)
goto err;
#line 80 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " UTC")) == -1)
goto err;
}
#line 83 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</time>", 7)) == -1) goto err;
err:
return tp_ret;
}
#line 86 "../gotwebd/pages.tmpl"
int
gotweb_render_page(struct template *tp, int (*body)(struct template *))
{
int tp_ret = 0;
#line 88 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct querystring *qs = c->t->qs;
struct gotweb_url u_path;
const char *prfx = c->document_uri;
const char *css = srv->custom_css;
#line 95 "../gotwebd/pages.tmpl"
memset(&u_path, 0, sizeof(u_path));
u_path.index_page = -1;
u_path.page = -1;
u_path.action = SUMMARY;
#line 104 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<!doctype html><html><head><meta charset=\"utf-8\" /><title>", 58)) == -1) goto err;
#line 104 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_name)) == -1)
goto err;
#line 108 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><meta name=\"viewport\" content=\"initial-scale=1.0\" /><meta name=\"msapplication-TileColor\" content=\"#da532c\" /><meta name=\"theme-color\" content=\"#ffffff\"/><link rel=\"apple-touch-icon\" sizes=\"180x180\" href=\"", 212)) == -1) goto err;
#line 108 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "apple-touch-icon.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"32x32\" href=\"", 78)) == -1) goto err;
#line 109 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-32x32.png\" /><link rel=\"icon\" type=\"image/png\" sizes=\"16x16\" href=\"", 75)) == -1) goto err;
#line 110 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "favicon-16x16.png\" /><link rel=\"manifest\" href=\"", 48)) == -1) goto err;
#line 111 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "site.webmanifest\"/><link rel=\"mask-icon\" href=\"", 47)) == -1) goto err;
#line 112 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "safari-pinned-tab.svg\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"", 70)) == -1) goto err;
#line 113 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 113 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, css)) == -1)
goto err;
#line 118 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></head><body><header id=\"header\"><div id=\"got_link\"><a href=\"", 65)) == -1) goto err;
#line 118 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo_url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\" target=\"_blank\"><img src=\"", 28)) == -1) goto err;
#line 119 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, prfx)) == -1)
goto err;
#line 119 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->logo)) == -1)
goto err;
#line 125 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\" /></a></div></header><nav id=\"site_path\"><div id=\"site_link\"><a href=\"?index_page=", 84)) == -1) goto err;
#line 125 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%d", qs->index_page) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 126 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, srv->site_link)) == -1)
goto err;
#line 128 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 128 "../gotwebd/pages.tmpl"
if (qs->path) {
u_path.path = qs->path; 
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 131 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &u_path)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 132 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, qs->path)) == -1)
goto err;
#line 134 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
}
if (qs->action != INDEX) {
if ((tp_ret = tp_htmlescape(tp, " / ")) == -1)
goto err;
#line 136 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, gotweb_action_name(qs->action))) == -1)
goto err;
}
#line 141 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></nav><main>", 18)) == -1) goto err;
#line 141 "../gotwebd/pages.tmpl"
if ((tp_ret = body(tp)) == -1) goto err;
#line 145 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</main><footer id=\"site_owner_wrapper\"><p id=\"site_owner\">", 58)) == -1) goto err;
#line 145 "../gotwebd/pages.tmpl"
if (srv->show_site_owner) {
if ((tp_ret = tp_htmlescape(tp, srv->site_owner)) == -1)
goto err;
}
#line 152 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</p></footer></body></html>", 27)) == -1) goto err;
err:
return tp_ret;
}
#line 154 "../gotwebd/pages.tmpl"
int
gotweb_render_error(struct template *tp)
{
int tp_ret = 0;
#line 156 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
#line 160 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">", 22)) == -1) goto err;
#line 160 "../gotwebd/pages.tmpl"
if (t->error) {
if ((tp_ret = tp_htmlescape(tp, t->error->msg)) == -1)
goto err;
} else {
#line 164 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "See daemon logs for details", 27)) == -1) goto err;
}
#line 166 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 168 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_table_hdr(struct template *tp)
{
int tp_ret = 0;
#line 170 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
#line 177 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"index_header\"><div class=\"index_project\">Project</div>", 63)) == -1) goto err;
#line 177 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 181 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">Description</div>", 56)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 186 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">Owner</div>", 44)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 191 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">Last Change</div>", 48)) == -1) goto err;
}
#line 193 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 195 "../gotwebd/pages.tmpl"
int
gotweb_render_repo_fragment(struct template *tp, struct repo_dir *repo_dir)
{
int tp_ret = 0;
#line 197 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, briefs = {
.action = BRIEFS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, commits = {
.action = COMMITS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tags = {
.action = TAGS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, tree = {
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
}, rss = {
.action = RSS,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_wrapper\"><div class=\"index_project\"><a href=\"", 63)) == -1) goto err;
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 233 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 235 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div>", 10)) == -1) goto err;
#line 235 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 237 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_description\">", 39)) == -1) goto err;
#line 237 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
#line 239 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 242 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_owner\">", 33)) == -1) goto err;
#line 242 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->owner)) == -1)
goto err;
#line 244 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 247 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"index_project_age\">", 31)) == -1) goto err;
#line 247 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, repo_dir->age, TM_DIFF)) == -1) goto err;
#line 249 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
}
#line 252 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 53)) == -1) goto err;
#line 252 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &summary)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 253 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 254 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &briefs)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">briefs</a>", 12)) == -1) goto err;
#line 255 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 256 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &commits)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 257 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 258 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tags)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tags</a>", 10)) == -1) goto err;
#line 259 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 260 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tree</a>", 10)) == -1) goto err;
#line 261 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 262 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &rss)) == -1) goto err;
#line 267 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">rss</a></div><hr /></div></div>", 33)) == -1) goto err;
err:
return tp_ret;
}
#line 269 "../gotwebd/pages.tmpl"
int
gotweb_render_briefs(struct template *tp)
{
int tp_ret = 0;
#line 271 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = c->t->qs;
struct repo_commit *rc;
struct repo_dir *repo_dir = t->repo_dir;
struct gotweb_url diff_url, tree_url;
char *tmp;
#line 279 "../gotwebd/pages.tmpl"
diff_url = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
tree_url = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.headref = qs->headref,
};
#line 298 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Commit Briefs</h2></header><div id=\"briefs_content\">", 81)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 300 "../gotwebd/pages.tmpl"
diff_url.commit = rc->commit_id;
tree_url.commit = rc->commit_id;
#line 303 "../gotwebd/pages.tmpl"
tmp = strchr(rc->committer, '<');
if (tmp)
*tmp = '\0';
#line 307 "../gotwebd/pages.tmpl"
tmp = strchr(rc->commit_msg, '\n');
if (tmp)
*tmp = '\0';
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class='brief'><p class='brief_meta'><span class='briefs_age'>", 66)) == -1) goto err;
#line 314 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_DIFF)) == -1) goto err;
#line 316 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 316 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 318 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"briefs_author\">", 28)) == -1) goto err;
#line 318 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
#line 322 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></p><p class=\"briefs_log\"><a href=\"", 42)) == -1) goto err;
#line 322 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 323 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 325 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a>", 4)) == -1) goto err;
#line 325 "../gotwebd/pages.tmpl"
if (rc->refs_str) {
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 326 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 326 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->refs_str)) == -1)
goto err;
if ((tp_ret = tp_write(tp, ")</span>", 8)) == -1) goto err;
}
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></p></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 67)) == -1) goto err;
#line 333 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &diff_url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 334 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 335 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(tp->tp_arg, &tree_url)) == -1) goto err;
#line 339 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, BRIEFS)) == -1) goto err;
#line 342 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 344 "../gotwebd/pages.tmpl"
int
gotweb_render_more(struct template *tp, int action)
{
int tp_ret = 0;
#line 346 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct gotweb_url more = {
.action = action,
.index_page = -1,
.path = qs->path,
.commit = t->more_id,
.headref = qs->headref,
.file = qs->file,
};
#line 358 "../gotwebd/pages.tmpl"
if (t->more_id) {
#line 361 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_more\"><a href=\"", 49)) == -1) goto err;
#line 361 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &more)) == -1) goto err;
#line 366 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">More&nbsp;&darr;</a></div></div>", 34)) == -1) goto err;
}
err:
return tp_ret;
}
#line 369 "../gotwebd/pages.tmpl"
int
gotweb_render_navs(struct template *tp)
{
int tp_ret = 0;
#line 371 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct gotweb_url prev, next;
int have_prev, have_next;
#line 376 "../gotwebd/pages.tmpl"
gotweb_get_navs(c, &prev, &have_prev, &next, &have_next);
#line 380 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"np_wrapper\"><div id=\"nav_prev\">", 40)) == -1) goto err;
#line 380 "../gotwebd/pages.tmpl"
if (have_prev) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 381 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &prev)) == -1) goto err;
#line 384 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Previous</a>", 14)) == -1) goto err;
}
#line 387 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div id=\"nav_next\">", 25)) == -1) goto err;
#line 387 "../gotwebd/pages.tmpl"
if (have_next) {
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 388 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &next)) == -1) goto err;
#line 391 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">Next</a>", 10)) == -1) goto err;
}
#line 394 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></div>", 12)) == -1) goto err;
#line 394 "../gotwebd/pages.tmpl"
err:
#line 396 "../gotwebd/pages.tmpl"
free(t->next_id);
t->next_id = NULL;
free(t->prev_id);
t->prev_id = NULL;
return tp_ret;
}
#line 403 "../gotwebd/pages.tmpl"
int
gotweb_render_commits(struct template *tp)
{
int tp_ret = 0;
#line 405 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_commit *rc;
struct gotweb_url diff, tree;
#line 411 "../gotwebd/pages.tmpl"
diff = (struct gotweb_url){
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
tree = (struct gotweb_url){
.action = TREE,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 428 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commits</h2></header><div class=\"commits_content\">", 79)) == -1) goto err;
TAILQ_FOREACH(rc, &t->repo_commits, entry) {
#line 430 "../gotwebd/pages.tmpl"
diff.commit = rc->commit_id;
tree.commit = rc->commit_id;
#line 436 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"commits_header_wrapper\"><dl class=\"commits_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 107)) == -1) goto err;
#line 436 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 438 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 438 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 439 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 441 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 441 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 445 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 445 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 451 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><div class=\"commit\">", 42)) == -1) goto err;
#line 451 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 456 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 59)) == -1) goto err;
#line 456 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &diff)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">diff</a>", 10)) == -1) goto err;
#line 457 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 458 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &tree)) == -1) goto err;
#line 462 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">tree</a></div></div><hr />", 28)) == -1) goto err;
}
if ((tp_ret = gotweb_render_more(tp, COMMITS)) == -1) goto err;
#line 465 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 467 "../gotwebd/pages.tmpl"
int
gotweb_render_blob(struct template *tp)
{
int tp_ret = 0;
#line 469 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct got_blob_object *blob = t->blob;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 482 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blob</h2></header><div id=\"blob_content\"><div id=\"blob_header_wrapper\"><dl id=\"blob_header\"><dt>Date:</dt><dd>", 139)) == -1) goto err;
#line 482 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 485 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 485 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 491 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><div id=\"blob\"><pre>", 42)) == -1) goto err;
#line 491 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_blob_by_lines(tp, blob, gotweb_render_blob_line)) == -1) goto err;
#line 495 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 498 "../gotwebd/pages.tmpl"
int
gotweb_render_blob_line(struct template *tp, const char *line, size_t no)
{
int tp_ret = 0;
#line 500 "../gotwebd/pages.tmpl"
char lineno[16];
int r;
#line 503 "../gotwebd/pages.tmpl"
r = snprintf(lineno, sizeof(lineno), "%zu", no);
if (r < 0 || (size_t)r >= sizeof(lineno))
return -1;
#line 507 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blob_line\" id=\"line", 31)) == -1) goto err;
#line 507 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "\"><a href=\"#line", 16)) == -1) goto err;
#line 508 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
#line 508 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 508 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, lineno)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</a><span class=\"blob_code\">", 28)) == -1) goto err;
#line 509 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 511 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span></div>", 13)) == -1) goto err;
err:
return tp_ret;
}
#line 513 "../gotwebd/pages.tmpl"
int
gotweb_render_tree(struct template *tp)
{
int tp_ret = 0;
#line 515 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 526 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tree</h2></header><div id=\"tree_content\"><div id=\"tree_header_wrapper\"><dl id=\"tree_header\"><dt>Tree:</dt><dd><code class=\"commit-id\">", 163)) == -1) goto err;
#line 526 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->tree_id)) == -1)
goto err;
#line 529 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>Date:</dt><dd>", 30)) == -1) goto err;
#line 529 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 532 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 532 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 537 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><table id=\"tree\">", 39)) == -1) goto err;
#line 537 "../gotwebd/pages.tmpl"
if ((tp_ret = got_output_repo_tree(c, gotweb_render_tree_item)) == -1) goto err;
#line 540 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</table></div>", 14)) == -1) goto err;
err:
return tp_ret;
}
#line 543 "../gotwebd/pages.tmpl"
int
gotweb_render_tree_item(struct template *tp, struct got_tree_entry *te)
{
int tp_ret = 0;
#line 545 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
const char *modestr = "";
const char *name;
const char *folder;
char *dir = NULL;
mode_t mode;
struct gotweb_url url = {
.index_page = -1,
.page = -1,
.commit = rc->commit_id,
.path = qs->path,
};
#line 561 "../gotwebd/pages.tmpl"
name = got_tree_entry_get_name(te);
mode = got_tree_entry_get_mode(te);
#line 564 "../gotwebd/pages.tmpl"
folder = qs->folder ? qs->folder : "";
if (S_ISDIR(mode)) {
if (asprintf(&dir, "%s/%s", folder, name) == -1)
return (-1);
#line 569 "../gotwebd/pages.tmpl"
url.action = TREE;
url.folder = dir;
} else {
url.action = BLOB;
url.folder = folder;
url.file = name;
}
#line 577 "../gotwebd/pages.tmpl"
if (got_object_tree_entry_is_submodule(te))
modestr = "$";
else if (S_ISLNK(mode))
modestr = "@";
else if (S_ISDIR(mode))
modestr = "/";
else if (mode & S_IXUSR)
modestr = "*";
#line 587 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<tr class=\"tree_wrapper\">", 25)) == -1) goto err;
#line 587 "../gotwebd/pages.tmpl"
if (S_ISDIR(mode)) {
#line 589 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\" colspan=2><a href=\"", 41)) == -1) goto err;
#line 589 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 590 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 590 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 593 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td>", 9)) == -1) goto err;
#line 593 "../gotwebd/pages.tmpl"
} else {
#line 595 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<td class=\"tree_line\"><a href=\"", 31)) == -1) goto err;
#line 595 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 596 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, name)) == -1)
goto err;
#line 596 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, modestr)) == -1)
goto err;
#line 600 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></td><td class=\"tree_line_blank\">", 37)) == -1) goto err;
#line 600 "../gotwebd/pages.tmpl"
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 601 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 604 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a>", 13)) == -1) goto err;
#line 604 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BLAME; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 606 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 610 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">blame</a></td>", 16)) == -1) goto err;
}
#line 612 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</tr>", 5)) == -1) goto err;
#line 612 "../gotwebd/pages.tmpl"
err:
#line 614 "../gotwebd/pages.tmpl"
free(dir);
return tp_ret;
}
#line 618 "../gotwebd/pages.tmpl"
int
gotweb_render_tags(struct template *tp)
{
int tp_ret = 0;
#line 620 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct querystring *qs = t->qs;
struct repo_tag *rt;
int commit_found;
#line 626 "../gotwebd/pages.tmpl"
commit_found = qs->commit == NULL;
#line 632 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Tags</h2></header><div id=\"tags_content\">", 70)) == -1) goto err;
#line 632 "../gotwebd/pages.tmpl"
if (t->tag_count == 0) {
#line 636 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div id=\"err_content\">This repository contains no tags</div>", 60)) == -1) goto err;
#line 636 "../gotwebd/pages.tmpl"
} else {
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 638 "../gotwebd/pages.tmpl"
if (commit_found ||!strcmp(qs->commit, rt->commit_id)) {
commit_found = 1; 
if ((tp_ret = tag_item(tp, rt)) == -1) goto err;
}
}
#line 643 "../gotwebd/pages.tmpl"
if (t->next_id ||t->prev_id) {
qs->action = TAGS; 
if ((tp_ret = gotweb_render_navs(tp)) == -1) goto err;
}
}
#line 649 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 651 "../gotwebd/pages.tmpl"
int
tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 653 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *tag_name = rt->tag_name;
char *msg = rt->tag_commit;
char *nl;
struct gotweb_url url = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 667 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 670 "../gotwebd/pages.tmpl"
if (msg) {
nl = strchr(msg, '\n');
if (nl)
*nl = '\0';
}
#line 677 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"tag_age\">", 21)) == -1) goto err;
#line 677 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rt->tagger_time, TM_DIFF)) == -1) goto err;
#line 679 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_name\">", 28)) == -1) goto err;
#line 679 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 681 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"tag_log\"><a href=\"", 36)) == -1) goto err;
#line 681 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 682 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, msg)) == -1)
goto err;
#line 687 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 687 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">tag</a>", 9)) == -1) goto err;
#line 688 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 690 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 691 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 693 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 697 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr />", 31)) == -1) goto err;
err:
return tp_ret;
}
#line 699 "../gotwebd/pages.tmpl"
int
gotweb_render_tag(struct template *tp)
{
int tp_ret = 0;
#line 701 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_tag *rt;
const char *tag_name;
#line 706 "../gotwebd/pages.tmpl"
rt = TAILQ_LAST(&t->repo_tags, repo_tags_head);
tag_name = rt->tag_name;
#line 709 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/", 5) == 0)
tag_name += 5;
#line 720 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Tag</h2></header><div id=\"tags_content\"><div id=\"tag_header_wrapper\"><dl id=\"tag_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 162)) == -1) goto err;
#line 720 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</code>", 7)) == -1) goto err;
#line 721 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
if ((tp_ret = tp_write(tp, "<span class=\"refs_str\">(", 24)) == -1) goto err;
#line 722 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 725 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</span></dd><dt>Tagger:</dt><dd>", 33)) == -1) goto err;
#line 725 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tagger)) == -1)
goto err;
#line 728 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Date:</dt><dd>", 23)) == -1) goto err;
#line 728 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rt->tagger_time, TM_LONG)) == -1) goto err;
#line 731 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 731 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_msg)) == -1)
goto err;
#line 735 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl><hr /><pre id=\"tag_commit\">", 37)) == -1) goto err;
#line 735 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 739 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div></div>", 18)) == -1) goto err;
err:
return tp_ret;
}
#line 741 "../gotwebd/pages.tmpl"
int
gotweb_render_diff(struct template *tp)
{
int tp_ret = 0;
#line 743 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
FILE *fp = t->fp;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
char *line = NULL;
size_t linesize = 0;
ssize_t linelen;
#line 758 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Commit Diff</h2></header><div id=\"diff_content\"><div id=\"diff_header_wrapper\"><dl id=\"diff_header\"><dt>Commit:</dt><dd><code class=\"commit-id\">", 172)) == -1) goto err;
#line 758 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_id)) == -1)
goto err;
#line 760 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</code></dd><dt>From:</dt><dd>", 30)) == -1) goto err;
#line 760 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->author)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
#line 761 "../gotwebd/pages.tmpl"
if (strcmp(rc->committer, rc->author) != 0) {
#line 763 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Via:</dt><dd>", 17)) == -1) goto err;
#line 763 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->committer)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
#line 767 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Date:</dt><dd>", 18)) == -1) goto err;
#line 767 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 770 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 770 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 775 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><pre id=\"diff\">", 37)) == -1) goto err;
while ((linelen = getline(&line, &linesize, fp)) != -1) {
if ((tp_ret = diff_line(tp, line)) == -1) goto err;
}
#line 780 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
#line 780 "../gotwebd/pages.tmpl"
err:
free(line); 
return tp_ret;
}
#line 784 "../gotwebd/pages.tmpl"
int
diff_line(struct template *tp, char *line )
{
int tp_ret = 0;
#line 786 "../gotwebd/pages.tmpl"
const char *color = NULL;
char *nl;
#line 789 "../gotwebd/pages.tmpl"
if (!strncmp(line, "-", 1))
color = "diff_minus";
else if (!strncmp(line, "+", 1))
color = "diff_plus";
else if (!strncmp(line, "@@", 2))
color = "diff_chunk_header";
else if (!strncmp(line, "commit +", 8) ||
!strncmp(line, "commit -", 8) ||
!strncmp(line, "blob +", 6) ||
!strncmp(line, "blob -", 6) ||
!strncmp(line, "file +", 6) ||
!strncmp(line, "file -", 6))
color = "diff_meta";
else if (!strncmp(line, "from:", 5) || !strncmp(line, "via:", 4))
color = "diff_author";
else if (!strncmp(line, "date:", 5))
color = "diff_date";
#line 807 "../gotwebd/pages.tmpl"
nl = strchr(line, '\n');
if (nl)
*nl = '\0';
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<span class=\"diff_line ", 23)) == -1) goto err;
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, color)) == -1)
goto err;
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</span>", 7)) == -1) goto err;
#line 811 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, "\n")) == -1)
goto err;
err:
return tp_ret;
}
#line 815 "../gotwebd/pages.tmpl"
int
gotweb_render_branches(struct template *tp, struct got_reflist_head *refs)
{
int tp_ret = 0;
#line 817 "../gotwebd/pages.tmpl"
struct got_reflist_entry *re;
#line 823 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class='subtitle'><h2>Branches</h2></header><div id=\"branches_content\">", 78)) == -1) goto err;
TAILQ_FOREACH(re, refs, entry) {
if (!got_ref_is_symbolic(re->ref)) {
if ((tp_ret = branch(tp, re)) == -1) goto err;
}
}
#line 829 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div>", 6)) == -1) goto err;
err:
return tp_ret;
}
#line 831 "../gotwebd/pages.tmpl"
int
branch(struct template *tp, struct got_reflist_entry *re)
{
int tp_ret = 0;
#line 833 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct querystring *qs = c->t->qs;
const char *refname;
time_t age;
struct gotweb_url url = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = qs->path,
};
#line 845 "../gotwebd/pages.tmpl"
refname = got_ref_get_name(re->ref);
#line 847 "../gotwebd/pages.tmpl"
err = got_get_repo_age(&age, c, refname);
if (err) {
log_warnx("%s: %s", __func__, err->msg);
return -1;
}
#line 853 "../gotwebd/pages.tmpl"
if (strncmp(refname, "refs/heads/", 11) == 0)
refname += 11;
#line 856 "../gotwebd/pages.tmpl"
url.headref = refname;
#line 860 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<section class=\"branches_wrapper\"><div class=\"branches_age\">", 60)) == -1) goto err;
#line 860 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, age, TM_DIFF)) == -1) goto err;
#line 863 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"branch\"><a href=\"", 35)) == -1) goto err;
#line 863 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 863 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 863 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, refname)) == -1)
goto err;
#line 867 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"navs_wrapper\"><div class=\"navs\"><a href=\"", 63)) == -1) goto err;
#line 867 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">summary</a>", 13)) == -1) goto err;
#line 868 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = BRIEFS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 870 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">commit briefs</a>", 19)) == -1) goto err;
#line 871 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " | ")) == -1)
goto err;
url.action = COMMITS; 
if ((tp_ret = tp_write(tp, "<a href=\"", 9)) == -1) goto err;
#line 873 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
#line 878 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "\">commits</a></div></div><hr /></section>", 41)) == -1) goto err;
err:
return tp_ret;
}
#line 880 "../gotwebd/pages.tmpl"
int
gotweb_render_summary(struct template *tp)
{
int tp_ret = 0;
#line 882 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct got_reflist_head *refs = &t->refs;
#line 888 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dl id=\"summary_wrapper\">", 25)) == -1) goto err;
#line 888 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
#line 890 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Description:</dt><dd>", 25)) == -1) goto err;
#line 890 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_owner) {
#line 894 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Owner:</dt><dd>", 19)) == -1) goto err;
#line 894 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->owner)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_age) {
#line 899 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Last Change:</dt><dd>", 25)) == -1) goto err;
#line 899 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, t->repo_dir->age, TM_DIFF)) == -1) goto err;
#line 901 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd>", 5)) == -1) goto err;
}
if (srv->show_repo_cloneurl) {
#line 904 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<dt>Clone URL:</dt><dd><pre class=\"clone-url\">", 46)) == -1) goto err;
#line 904 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, t->repo_dir->url)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</pre></dd>", 11)) == -1) goto err;
}
#line 907 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dl>", 5)) == -1) goto err;
#line 907 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_briefs(tp)) == -1) goto err;
if ((tp_ret = gotweb_render_tags(tp)) == -1) goto err;
if ((tp_ret = gotweb_render_branches(tp, refs)) == -1) goto err;
err:
return tp_ret;
}
#line 912 "../gotwebd/pages.tmpl"
int
gotweb_render_blame(struct template *tp)
{
int tp_ret = 0;
#line 914 "../gotwebd/pages.tmpl"
const struct got_error *err;
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_commit *rc = TAILQ_FIRST(&t->repo_commits);
#line 927 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<header class=\"subtitle\"><h2>Blame</h2></header><div id=\"blame_content\"><div id=\"blame_header_wrapper\"><dl id=\"blame_header\"><dt>Date:</dt><dd>", 143)) == -1) goto err;
#line 927 "../gotwebd/pages.tmpl"
if ((tp_ret = datetime(tp, rc->committer_time, TM_LONG)) == -1) goto err;
#line 930 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd><dt>Message:</dt><dd class=\"commit-msg\">", 45)) == -1) goto err;
#line 930 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rc->commit_msg)) == -1)
goto err;
#line 935 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</dd></dl></div><hr /><pre id=\"blame\">", 38)) == -1) goto err;
err = got_output_file_blame(c, &blame_line);
if (err && err->code != GOT_ERR_CANCELLED)
log_warnx("%s: got_output_file_blame: %s", __func__,
err->msg);
if (err)
return (-1);
#line 945 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 948 "../gotwebd/pages.tmpl"
int
blame_line(struct template *tp, const char *line, struct blame_line *bline, int lprec, int lcur)
{
int tp_ret = 0;
#line 950 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
char *committer, *s;
struct gotweb_url url = {
.action = DIFF,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = bline->id_str,
};
#line 962 "../gotwebd/pages.tmpl"
s = strchr(bline->committer, '<');
committer = s ? s + 1 : bline->committer;
#line 965 "../gotwebd/pages.tmpl"
s = strchr(committer, '@');
if (s)
*s = '\0';
#line 970 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<div class=\"blame_wrapper\"><div class=\"blame_number\">", 53)) == -1) goto err;
#line 970 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.*d", lprec, lcur) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 972 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_hash\"><a href=\"", 39)) == -1) goto err;
#line 972 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_url(c, &url)) == -1) goto err;
if ((tp_ret = tp_write(tp, "\">", 2)) == -1) goto err;
#line 973 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.8s", bline->id_str) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
#line 976 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</a></div><div class=\"blame_date\">", 34)) == -1) goto err;
#line 976 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, bline->datebuf)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_author\">", 32)) == -1) goto err;
#line 977 "../gotwebd/pages.tmpl"
if (asprintf(&tp->tp_tmp,  "%.9s", committer) == -1)
goto err;
if ((tp_ret = tp_htmlescape(tp, tp->tp_tmp)) == -1)
goto err;
free(tp->tp_tmp);
tp->tp_tmp = NULL;
if ((tp_ret = tp_write(tp, "</div><div class=\"blame_code\">", 30)) == -1) goto err;
#line 978 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, line)) == -1)
goto err;
#line 980 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</div></div>", 12)) == -1) goto err;
err:
return tp_ret;
}
#line 982 "../gotwebd/pages.tmpl"
int
gotweb_render_rss(struct template *tp)
{
int tp_ret = 0;
#line 984 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct server *srv = c->srv;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct repo_tag *rt;
struct gotweb_url summary = {
.action = SUMMARY,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
};
#line 999 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><rss version=\"2.0\" xmlns:content=\"http://purl.org/rss/1.0/modules/content/\"><channel><title>Tags of ", 138)) == -1) goto err;
#line 999 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 1002 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 1002 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &summary)) == -1) goto err;
#line 1005 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link>", 10)) == -1) goto err;
#line 1005 "../gotwebd/pages.tmpl"
if (srv->show_repo_description) {
if ((tp_ret = tp_write(tp, "<description>", 13)) == -1) goto err;
#line 1006 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->description)) == -1)
goto err;
if ((tp_ret = tp_write(tp, "</description>", 14)) == -1) goto err;
}
TAILQ_FOREACH(rt, &t->repo_tags, entry) {
#line 1009 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_tag_item(tp, rt)) == -1) goto err;
}
#line 1013 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</channel></rss>", 16)) == -1) goto err;
err:
return tp_ret;
}
#line 1015 "../gotwebd/pages.tmpl"
int
rss_tag_item(struct template *tp, struct repo_tag *rt)
{
int tp_ret = 0;
#line 1017 "../gotwebd/pages.tmpl"
struct request *c = tp->tp_arg;
struct transport *t = c->t;
struct repo_dir *repo_dir = t->repo_dir;
struct tm tm;
char rfc822[128];
int r;
char *tag_name = rt->tag_name;
struct gotweb_url tag = {
.action = TAG,
.index_page = -1,
.page = -1,
.path = repo_dir->name,
.commit = rt->commit_id,
};
#line 1032 "../gotwebd/pages.tmpl"
if (strncmp(tag_name, "refs/tags/", 10) == 0)
tag_name += 10;
#line 1035 "../gotwebd/pages.tmpl"
if (gmtime_r(&rt->tagger_time, &tm) == NULL)
return -1;
r = strftime(rfc822, sizeof(rfc822), "%a, %d %b %Y %H:%M:%S GMT", &tm);
if (r == 0)
return 0;
#line 1042 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<item><title>", 13)) == -1) goto err;
#line 1042 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, repo_dir->name)) == -1)
goto err;
#line 1042 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1042 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, tag_name)) == -1)
goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</title><link><![CDATA[", 23)) == -1) goto err;
#line 1045 "../gotwebd/pages.tmpl"
if ((tp_ret = gotweb_render_absolute_url(c, &tag)) == -1) goto err;
#line 1049 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "]]></link><description><![CDATA[<pre>", 37)) == -1) goto err;
#line 1049 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->tag_commit)) == -1)
goto err;
#line 1051 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pre>]]></description>", 23)) == -1) goto err;
#line 1051 "../gotwebd/pages.tmpl"
if ((tp_ret = rss_author(tp, rt->tagger)) == -1) goto err;
if ((tp_ret = tp_write(tp, "<guid isPermaLink=\"false\">", 26)) == -1) goto err;
#line 1052 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rt->commit_id)) == -1)
goto err;
#line 1054 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</guid><pubDate>", 16)) == -1) goto err;
#line 1054 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, rfc822)) == -1)
goto err;
#line 1057 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "</pubDate></item>", 17)) == -1) goto err;
err:
return tp_ret;
}
#line 1059 "../gotwebd/pages.tmpl"
int
rss_author(struct template *tp, char *author)
{
int tp_ret = 0;
#line 1061 "../gotwebd/pages.tmpl"
char *t, *mail;
#line 1063 "../gotwebd/pages.tmpl"
/* what to do if the author name contains a paren? */
if (strchr(author, '(') != NULL || strchr(author, ')') != NULL)
return 0;
#line 1067 "../gotwebd/pages.tmpl"
t = strchr(author, '<');
if (t == NULL)
return 0;
*t = '\0';
mail = t+1;
#line 1073 "../gotwebd/pages.tmpl"
while (isspace((unsigned char)*--t))
*t = '\0';
#line 1076 "../gotwebd/pages.tmpl"
t = strchr(mail, '>');
if (t == NULL)
return 0;
*t = '\0';
#line 1082 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "<author>", 8)) == -1) goto err;
#line 1082 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, mail)) == -1)
goto err;
#line 1082 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, " ")) == -1)
goto err;
#line 1082 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, "(", 1)) == -1) goto err;
#line 1082 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_htmlescape(tp, author)) == -1)
goto err;
#line 1084 "../gotwebd/pages.tmpl"
if ((tp_ret = tp_write(tp, ")</author>", 10)) == -1) goto err;
err:
return tp_ret;
}
