/* original parser id follows */
/* yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93" */
/* (use YYMAJOR/YYMINOR for ifdefs dependent on parser version) */

#define YYBYACC 1
#define YYMAJOR 2
#define YYMINOR 0
#define YYPATCH 20230201

#define YYEMPTY        (-1)
#define yyclearin      (yychar = YYEMPTY)
#define yyerrok        (yyerrflag = 0)
#define YYRECOVERING() (yyerrflag != 0)
#define YYENOMEM       (-2)
#define YYEOF          0
#undef YYBTYACC
#define YYBTYACC 0
#define YYDEBUGSTR YYPREFIX "debug"
#define YYPREFIX "yy"

#define YYPURE 0

#line 25 "parse.y"
#include <sys/types.h>
#include <sys/queue.h>

#include <netdb.h>

#include <ctype.h>
#include <err.h>
#include <errno.h>
#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "got_compat.h"

#include "got_error.h"
#include "gotconfig.h"

static struct file {
	FILE			*stream;
	const char		*name;
	size_t	 		 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
} *file;
static const struct got_error*	newfile(struct file**, const char *, int *);
static void	closefile(struct file *);
int		 yyparse(void);
int		 yylex(void);
int		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);
static int	 parseport(char *, long long *);

TAILQ_HEAD(symhead, sym)	 symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*nam;
	char			*val;
};

int	 symset(const char *, const char *, int);
int	 cmdline_symset(char *);
char	*symget(const char *);

static int	 atoul(char *, u_long *);

static const struct got_error* gerror;
static struct gotconfig_remote_repo *remote;
static struct gotconfig gotconfig;
static const struct got_error* new_remote(struct gotconfig_remote_repo **);
static const struct got_error* new_fetch_config(struct fetch_config **);
static const struct got_error* new_send_config(struct send_config **);

typedef struct {
	union {
		long long	 number;
		char		*string;
		struct node_branch *branch;
		struct node_ref *ref;
	} v;
	int lineno;
} YYSTYPE;

#if defined(__APPLE__) && !defined(YYSTYPE)
#warning "Setting YYSTYPE - is GNU Bison installed?"
#define YYSTYPE YYSTYPE
#endif
#line 104 "parse.c"

/* compatibility with bison */
#ifdef YYPARSE_PARAM
/* compatibility with FreeBSD */
# ifdef YYPARSE_PARAM_TYPE
#  define YYPARSE_DECL() yyparse(YYPARSE_PARAM_TYPE YYPARSE_PARAM)
# else
#  define YYPARSE_DECL() yyparse(void *YYPARSE_PARAM)
# endif
#else
# define YYPARSE_DECL() yyparse(void)
#endif

/* Parameters sent to lex. */
#ifdef YYLEX_PARAM
# define YYLEX_DECL() yylex(void *YYLEX_PARAM)
# define YYLEX yylex(YYLEX_PARAM)
#else
# define YYLEX_DECL() yylex(void)
# define YYLEX yylex()
#endif

#if !(defined(yylex) || defined(YYSTATE))
int YYLEX_DECL();
#endif

/* Parameters sent to yyerror. */
#ifndef YYERROR_DECL
#define YYERROR_DECL() yyerror(const char *s)
#endif
#ifndef YYERROR_CALL
#define YYERROR_CALL(msg) yyerror(msg)
#endif

extern int YYPARSE_DECL();

#define ERROR 257
#define REMOTE 258
#define REPOSITORY 259
#define SERVER 260
#define PORT 261
#define PROTOCOL 262
#define MIRROR_REFERENCES 263
#define BRANCH 264
#define AUTHOR 265
#define ALLOWED_SIGNERS 266
#define REVOKED_SIGNERS 267
#define SIGNER_ID 268
#define FETCH_ALL_BRANCHES 269
#define REFERENCE 270
#define FETCH 271
#define SEND 272
#define STRING 273
#define NUMBER 274
#define YYERRCODE 256
typedef int YYINT;
static const YYINT yylhs[] = {                           -1,
    0,    0,    0,    0,    0,    0,    0,    1,    3,    3,
    2,    4,    4,    4,    5,    6,    6,    7,    7,    7,
    8,    9,    9,   17,   17,   18,   18,   18,   18,   18,
   18,   18,   18,   20,   18,   22,   18,   21,   21,   24,
   24,   25,   25,   25,   25,   25,   23,   23,   26,   26,
   27,   27,   27,   27,   27,   28,   11,   10,   12,   13,
   14,   15,   15,   19,   16,   16,
};
static const YYINT yylen[] = {                            2,
    0,    2,    3,    3,    3,    3,    3,    1,    1,    1,
    1,    0,    1,    4,    1,    2,    4,    0,    1,    4,
    1,    2,    4,    3,    2,    2,    2,    2,    2,    2,
    2,    2,    2,    0,    6,    0,    6,    0,    1,    3,
    2,    2,    2,    2,    2,    2,    0,    1,    3,    2,
    2,    2,    2,    2,    2,    0,    7,    2,    2,    2,
    2,    2,    0,    2,    1,    0,
};
static const YYINT yydefred[] = {                         1,
    0,    0,    0,    0,    0,    0,    2,    0,    0,    0,
    0,    0,   56,   58,   59,   60,   61,    3,    4,    5,
    6,    7,    0,    0,    0,    0,   62,    0,    0,    0,
    0,    0,    0,    0,    0,   34,   36,    0,    0,   26,
   27,   10,    9,   31,   11,   28,    8,   29,   15,    0,
   32,   13,   30,   21,    0,   33,   19,    0,    0,   57,
    0,   25,    0,    0,    0,    0,    0,   24,    0,    0,
    0,    0,    0,    0,   64,   16,   14,   65,    0,   22,
   20,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   42,   43,   45,   44,   46,   35,    0,   41,   51,   52,
   54,   53,   55,   37,    0,   50,   17,   23,   40,   49,
};
#if defined(YYDESTRUCT_CALL) || defined(YYSTYPE_TOSTRING)
static const YYINT yystos[] = {                           0,
  276,  258,  265,  266,  267,  268,   10,  286,  287,  288,
  289,  290,  273,  273,  273,  273,  273,   10,   10,   10,
   10,   10,  304,  123,   10,  291,  291,  259,  260,  261,
  262,  263,  264,  269,  270,  271,  272,  293,  294,  273,
  273,  273,  274,  278,  279,  273,  273,  277,  273,  123,
  280,  281,  277,  273,  123,  283,  284,  296,  298,  125,
  294,  291,  291,  291,  123,  123,   10,  295,  281,  282,
  284,  285,  291,  291,  291,  291,  125,   44,  292,  291,
  125,  292,  259,  260,  261,  262,  264,  297,  300,  301,
  259,  260,  261,  262,  264,  299,  302,  303,  281,  284,
  273,  273,  278,  273,  280,  125,  301,  291,  273,  273,
  278,  273,  280,  125,  303,  291,  291,  291,  295,  295,
};
#endif /* YYDESTRUCT_CALL || YYSTYPE_TOSTRING */
static const YYINT yydgoto[] = {                          1,
   48,   44,   45,   51,   52,   70,   56,   57,   72,    8,
    9,   10,   11,   12,   26,   79,   38,   39,   68,   58,
   88,   59,   96,   89,   90,   97,   98,   23,
};
static const YYINT yysindex[] = {                         0,
   12, -260, -258, -256, -246, -245,    0,   19,   21,   23,
   24,   26,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -80,   34,   34, -196,    0, -228, -220, -250,
 -219, -218, -120, -218, -119,    0,    0, -104,   34,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   34,
    0,    0,    0,    0,   34,    0,    0,  -72,  -64,    0,
   51,    0, -204, -203,   34,   34,   34,    0,   34,  -39,
   34,  -38, -222, -212,    0,    0,    0,    0, -204,    0,
    0, -203, -202, -201, -250, -195, -120,  -48, -222,   34,
 -194, -193, -250, -189, -120,  -40, -212,   34,   34,   34,
    0,    0,    0,    0,    0,    0,   51,    0,    0,    0,
    0,    0,    0,    0,   51,    0,    0,    0,    0,    0,
};
static const YYINT yyrindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, -167,  -43,    0,    0,    0,    0,    0,
    0,    0,  -10,    0,    4,    0,    0,    0,  -90,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -185,
    0,    0,    0,    0, -185,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -118, -118,  -90,    0,  -42, -175,
  -42, -175,  -26,  -25,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   22,    0,  -24, -118,
    0,    0,    0,    0,   22,    0,  -19, -118,  -42,  -42,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
#if YYBTYACC
static const YYINT yycindex[] = {                         0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
};
#endif
static const YYINT yygindex[] = {                         0,
   73,  -75,    0,  -76,  -54,    0,    0,  -56,    0,    0,
    0,    0,    0,    0,   -9,   36,    0,   71,  -95,    0,
    0,    0,    0,    0,   25,    0,   13,    0,
};
#define YYTABLESIZE 286
static const YYINT yytable[] = {                         12,
   63,   63,   50,   55,   78,   78,   63,   71,   69,  103,
  105,  119,   13,   18,   14,   27,   15,  111,  113,  120,
   60,    7,   42,   43,   99,  100,   16,   17,   18,   62,
   19,   12,   20,   21,   63,   22,   83,   84,   85,   86,
   63,   87,   24,   25,   40,   64,   91,   92,   93,   94,
   65,   95,   41,   46,   47,   73,   74,   75,   66,   76,
   67,   80,   28,   29,   30,   31,   32,   33,   49,   54,
  101,  102,   34,   35,   36,   37,  106,  104,  109,  110,
  108,   63,   63,  112,  114,   77,   81,   63,  116,  117,
  118,   63,   63,   63,   63,   63,   63,   66,   38,   47,
   39,   63,   63,   63,   63,   48,   53,   82,   61,  115,
    0,    0,    0,  107,   12,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   18,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   63,   63,   63,   63,    0,   63,   12,    0,    0,    0,
    0,    0,   49,   54,   28,   29,   30,   31,   32,   33,
    0,    0,    0,    0,   34,   35,   36,   37,   63,   63,
   63,   63,   63,   63,    0,    0,    0,    0,   63,   63,
   63,   63,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   63,   63,   63,   63,   63,
   63,    0,    0,    0,    0,   63,   63,   63,   63,   63,
   63,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   12,   12,
   12,   12,   12,   12,    0,    0,    0,    0,   12,   12,
   12,   12,   18,   18,   18,   18,   18,   18,    0,    2,
    0,    0,   18,   18,   18,   18,    3,    4,    5,    6,
   12,   12,   12,   12,    0,   12,
};
static const YYINT yycheck[] = {                         10,
   44,   44,  123,  123,   44,   44,  125,   64,   63,   85,
   87,  107,  273,   10,  273,   25,  273,   93,   95,  115,
  125,   10,  273,  274,   79,   82,  273,  273,   10,   39,
   10,   10,   10,   10,  125,   10,  259,  260,  261,  262,
   50,  264,  123,   10,  273,   55,  259,  260,  261,  262,
  123,  264,  273,  273,  273,   65,   66,   67,  123,   69,
   10,   71,  259,  260,  261,  262,  263,  264,  273,  273,
  273,  273,  269,  270,  271,  272,  125,  273,  273,  273,
   90,  125,  125,  273,  125,  125,  125,  273,   98,   99,
  100,  259,  260,  261,  262,  263,  264,  273,  125,  125,
  125,  269,  270,  271,  272,  125,   34,   72,   38,   97,
   -1,   -1,   -1,   89,  125,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  125,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  259,  260,  261,  262,   -1,  264,  125,   -1,   -1,   -1,
   -1,   -1,  273,  273,  259,  260,  261,  262,  263,  264,
   -1,   -1,   -1,   -1,  269,  270,  271,  272,  259,  260,
  261,  262,  263,  264,   -1,   -1,   -1,   -1,  269,  270,
  271,  272,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,  259,  260,  261,  262,  263,
  264,   -1,   -1,   -1,   -1,  269,  270,  271,  272,  273,
  273,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  259,  260,
  261,  262,  263,  264,   -1,   -1,   -1,   -1,  269,  270,
  271,  272,  259,  260,  261,  262,  263,  264,   -1,  258,
   -1,   -1,  269,  270,  271,  272,  265,  266,  267,  268,
  259,  260,  261,  262,   -1,  264,
};
#if YYBTYACC
static const YYINT yyctable[] = {                        -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,
};
#endif
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 274
#define YYUNDFTOKEN 305
#define YYTRANSLATE(a) ((a) > YYMAXTOKEN ? YYUNDFTOKEN : (a))
#if YYDEBUG
static const char *const yyname[] = {

"$end",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,"','",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"error","ERROR",
"REMOTE","REPOSITORY","SERVER","PORT","PROTOCOL","MIRROR_REFERENCES","BRANCH",
"AUTHOR","ALLOWED_SIGNERS","REVOKED_SIGNERS","SIGNER_ID","FETCH_ALL_BRANCHES",
"REFERENCE","FETCH","SEND","STRING","NUMBER","$accept","grammar","boolean",
"portplain","numberstring","branch","xbranch","branch_list","ref","xref",
"ref_list","author","remote","allowed_signers","revoked_signers","signer_id",
"optnl","comma","remoteopts2","remoteopts1","nl","$$1","fetchempty","$$2",
"sendempty","fetchopts2","fetchopts1","sendopts2","sendopts1","$$3",
"illegal-symbol",
};
static const char *const yyrule[] = {
"$accept : grammar",
"grammar :",
"grammar : grammar '\\n'",
"grammar : grammar author '\\n'",
"grammar : grammar remote '\\n'",
"grammar : grammar allowed_signers '\\n'",
"grammar : grammar revoked_signers '\\n'",
"grammar : grammar signer_id '\\n'",
"boolean : STRING",
"numberstring : NUMBER",
"numberstring : STRING",
"portplain : numberstring",
"branch :",
"branch : xbranch",
"branch : '{' optnl branch_list '}'",
"xbranch : STRING",
"branch_list : xbranch optnl",
"branch_list : branch_list comma xbranch optnl",
"ref :",
"ref : xref",
"ref : '{' optnl ref_list '}'",
"xref : STRING",
"ref_list : xref optnl",
"ref_list : ref_list comma xref optnl",
"remoteopts2 : remoteopts2 remoteopts1 nl",
"remoteopts2 : remoteopts1 optnl",
"remoteopts1 : REPOSITORY STRING",
"remoteopts1 : SERVER STRING",
"remoteopts1 : PROTOCOL STRING",
"remoteopts1 : MIRROR_REFERENCES boolean",
"remoteopts1 : FETCH_ALL_BRANCHES boolean",
"remoteopts1 : PORT portplain",
"remoteopts1 : BRANCH branch",
"remoteopts1 : REFERENCE ref",
"$$1 :",
"remoteopts1 : FETCH $$1 '{' optnl fetchempty '}'",
"$$2 :",
"remoteopts1 : SEND $$2 '{' optnl sendempty '}'",
"fetchempty :",
"fetchempty : fetchopts2",
"fetchopts2 : fetchopts2 fetchopts1 nl",
"fetchopts2 : fetchopts1 optnl",
"fetchopts1 : REPOSITORY STRING",
"fetchopts1 : SERVER STRING",
"fetchopts1 : PROTOCOL STRING",
"fetchopts1 : PORT portplain",
"fetchopts1 : BRANCH branch",
"sendempty :",
"sendempty : sendopts2",
"sendopts2 : sendopts2 sendopts1 nl",
"sendopts2 : sendopts1 optnl",
"sendopts1 : REPOSITORY STRING",
"sendopts1 : SERVER STRING",
"sendopts1 : PROTOCOL STRING",
"sendopts1 : PORT portplain",
"sendopts1 : BRANCH branch",
"$$3 :",
"remote : REMOTE STRING $$3 '{' optnl remoteopts2 '}'",
"author : AUTHOR STRING",
"allowed_signers : ALLOWED_SIGNERS STRING",
"revoked_signers : REVOKED_SIGNERS STRING",
"signer_id : SIGNER_ID STRING",
"optnl : '\\n' optnl",
"optnl :",
"nl : '\\n' optnl",
"comma : ','",
"comma :",

};
#endif

#if YYDEBUG
int      yydebug;
#endif

int      yyerrflag;
int      yychar;
YYSTYPE  yyval;
YYSTYPE  yylval;
int      yynerrs;

/* define the initial stack-sizes */
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH  YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH  10000
#endif
#endif

#define YYINITSTACKSIZE 200

typedef struct {
    unsigned stacksize;
    YYINT    *s_base;
    YYINT    *s_mark;
    YYINT    *s_last;
    YYSTYPE  *l_base;
    YYSTYPE  *l_mark;
} YYSTACKDATA;
/* variables for the parser stack */
static YYSTACKDATA yystack;
#line 340 "parse.y"

struct keywords {
	const char	*k_name;
	int		 k_val;
};

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*msg;
	char		*err = NULL;

	va_start(ap, fmt);
	if (vasprintf(&msg, fmt, ap) == -1) {
		gerror =  got_error_from_errno("vasprintf");
		return 0;
	}
	va_end(ap);
	if (asprintf(&err, "%s: line %d: %s", file->name, yylval.lineno,
	    msg) == -1) {
		gerror = got_error_from_errno("asprintf");
		return(0);
	}
	gerror = got_error_msg(GOT_ERR_PARSE_CONFIG, err);
	free(msg);
	return(0);
}
int
kw_cmp(const void *k, const void *e)
{
	return (strcmp(k, ((const struct keywords *)e)->k_name));
}

int
lookup(char *s)
{
	/* This has to be sorted always. */
	static const struct keywords keywords[] = {
		{"allowed_signers",	ALLOWED_SIGNERS},
		{"author",		AUTHOR},
		{"branch",		BRANCH},
		{"fetch",		FETCH},
		{"fetch-all-branches",	FETCH_ALL_BRANCHES}, /* deprecated */
		{"fetch_all_branches",	FETCH_ALL_BRANCHES},
		{"mirror-references",	MIRROR_REFERENCES}, /* deprecated */
		{"mirror_references",	MIRROR_REFERENCES},
		{"port",		PORT},
		{"protocol",		PROTOCOL},
		{"reference",		REFERENCE},
		{"remote",		REMOTE},
		{"repository",		REPOSITORY},
		{"revoked_signers",	REVOKED_SIGNERS},
		{"send",		SEND},
		{"server",		SERVER},
		{"signer_id",		SIGNER_ID},
	};
	const struct keywords	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return (p->k_val);
	else
		return (STRING);
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return (c);
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		c = igetc();
		if (c == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
		}
		return (c);
	}

	c = igetc();
	while (c == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	return (c);
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			err(1, "%s", __func__);
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* Skip to either EOF or the first real EOL. */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return (ERROR);
}

static long long
getservice(char *n)
{
	struct servent	*s;
	u_long		 ulval;

	if (atoul(n, &ulval) == 0) {
		if (ulval == 0 || ulval > 65535) {
			yyerror("illegal port value %lu", ulval);
			return (-1);
		}
		return ulval;
	} else {
		s = getservbyname(n, "tcp");
		if (s == NULL)
			s = getservbyname(n, "udp");
		if (s == NULL) {
			yyerror("unknown port %s", n);
			return (-1);
		}
		return (s->s_port);
	}
}

static int
parseport(char *port, long long *pn)
{
	if ((*pn = getservice(port)) == -1) {
		*pn = 0LL;
		return (-1);
	}
	return (0);
}


int
yylex(void)
{
	char	 buf[8096];
	char	*p, *val;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	c = lgetc(0);
	while (c == ' ' || c == '\t')
		c = lgetc(0); /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#') {
		c = lgetc(0);
		while (c != '\n' && c != EOF)
			c = lgetc(0); /* nothing */
	}
	if (c == '$' && !expanding) {
		while (1) {
			c = lgetc(0);
			if (c == EOF)
				return (0);

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return (findeol());
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc((unsigned char)*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			c = lgetc(quotec);
			if (c == EOF)
				return (0);
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				next = lgetc(quotec);
				if (next == EOF)
					return (0);
				if (next == quotec || c == ' ' || c == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("syntax error");
				return (findeol());
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return (findeol());
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			err(1, "%s", __func__);
		return (STRING);
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return (findeol());
			}
			return (NUMBER);
		} else {
nodigits:
			while (p > buf + 1)
				lungetc((unsigned char)*--p);
			c = (unsigned char)*--p;
			if (c == '-')
				return (c);
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && \
	x != '!' && x != '=' && x != '#' && \
	x != ','))

	if (isalnum(c) || c == ':' || c == '_') {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return (findeol());
			}
			c = lgetc(0);
		} while (c != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		token = lookup(buf);
		if (token == STRING) {
			yylval.v.string = strdup(buf);
			if (yylval.v.string == NULL)
				err(1, "%s", __func__);
		}
		return (token);
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return (0);
	return (c);
}

static const struct got_error*
newfile(struct file **nfile, const char *filename, int *fd)
{
	const struct got_error* error = NULL;

	(*nfile) = calloc(1, sizeof(struct file));
	if ((*nfile) == NULL)
		return got_error_from_errno("calloc");
	(*nfile)->stream = fdopen(*fd, "r");
	if ((*nfile)->stream == NULL) {
		error = got_error_from_errno("fdopen");
		free((*nfile));
		return error;
	}
	*fd = -1; /* Stream owns the file descriptor now. */
	(*nfile)->name = filename;
	(*nfile)->lineno = 1;
	(*nfile)->ungetsize = 16;
	(*nfile)->ungetbuf = malloc((*nfile)->ungetsize);
	if ((*nfile)->ungetbuf == NULL) {
		error = got_error_from_errno("malloc");
		fclose((*nfile)->stream);
		free((*nfile));
		return error;
	}
	return NULL;
}

static const struct got_error*
new_remote(struct gotconfig_remote_repo **remote)
{
	const struct got_error *error = NULL;

	*remote = calloc(1, sizeof(**remote));
	if (*remote == NULL)
		error = got_error_from_errno("calloc");
	return error;
}

static const struct got_error*
new_fetch_config(struct fetch_config **fetch_config)
{
	const struct got_error *error = NULL;

	*fetch_config = calloc(1, sizeof(**fetch_config));
	if (*fetch_config == NULL)
		error = got_error_from_errno("calloc");
	return error;
}

static const struct got_error*
new_send_config(struct send_config **send_config)
{
	const struct got_error *error = NULL;

	*send_config = calloc(1, sizeof(**send_config));
	if (*send_config == NULL)
		error = got_error_from_errno("calloc");
	return error;
}

static void
closefile(struct file *file)
{
	fclose(file->stream);
	free(file->ungetbuf);
	free(file);
}

const struct got_error *
gotconfig_parse(struct gotconfig **conf, const char *filename, int *fd)
{
	const struct got_error *err = NULL;
	struct sym	*sym, *next;

	*conf = NULL;

	err = newfile(&file, filename, fd);
	if (err)
		return err;

	TAILQ_INIT(&gotconfig.remotes);

	yyparse();
	closefile(file);

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		if (!sym->persist) {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (gerror == NULL)
		*conf = &gotconfig;
	return gerror;
}

static void
free_fetch_config(struct fetch_config *fetch_config)
{
	free(remote->fetch_config->repository);
	free(remote->fetch_config->server);
	free(remote->fetch_config->protocol);
	free(remote->fetch_config);
}

static void
free_send_config(struct send_config *send_config)
{
	free(remote->send_config->repository);
	free(remote->send_config->server);
	free(remote->send_config->protocol);
	free(remote->send_config);
}

void
gotconfig_free(struct gotconfig *conf)
{
	struct gotconfig_remote_repo *remote;

	free(conf->author);
	free(conf->allowed_signers_file);
	free(conf->revoked_signers_file);
	free(conf->signer_id);
	while (!TAILQ_EMPTY(&conf->remotes)) {
		remote = TAILQ_FIRST(&conf->remotes);
		TAILQ_REMOVE(&conf->remotes, remote, entry);
		if (remote->fetch_config != NULL)
			free_fetch_config(remote->fetch_config);
		if (remote->send_config != NULL)
			free_send_config(remote->send_config);
		free(remote->name);
		free(remote->repository);
		free(remote->server);
		free(remote->protocol);
		free(remote);
	}
}

int
symset(const char *nam, const char *val, int persist)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0)
			break;
	}

	if (sym != NULL) {
		if (sym->persist == 1)
			return (0);
		else {
			free(sym->nam);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}
	sym = calloc(1, sizeof(*sym));
	if (sym == NULL)
		return (-1);

	sym->nam = strdup(nam);
	if (sym->nam == NULL) {
		free(sym);
		return (-1);
	}
	sym->val = strdup(val);
	if (sym->val == NULL) {
		free(sym->nam);
		free(sym);
		return (-1);
	}
	sym->used = 0;
	sym->persist = persist;
	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return (0);
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	ret;
	size_t	len;

	val = strrchr(s, '=');
	if (val == NULL)
		return (-1);

	len = strlen(s) - strlen(val) + 1;
	sym = malloc(len);
	if (sym == NULL)
		errx(1, "cmdline_symset: malloc");

	strlcpy(sym, s, len);

	ret = symset(sym, val + 1, 1);
	free(sym);

	return (ret);
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->nam) == 0) {
			sym->used = 1;
			return (sym->val);
		}
	}
	return (NULL);
}

static int
atoul(char *s, u_long *ulvalp)
{
	u_long	 ulval;
	char	*ep;

	errno = 0;
	ulval = strtoul(s, &ep, 0);
	if (s[0] == '\0' || *ep != '\0')
		return (-1);
	if (errno == ERANGE && ulval == ULONG_MAX)
		return (-1);
	*ulvalp = ulval;
	return (0);
}
#line 1086 "parse.c"

#if YYDEBUG
#include <stdio.h>	/* needed for printf */
#endif

#include <stdlib.h>	/* needed for malloc, etc */
#include <string.h>	/* needed for memset */

/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(YYSTACKDATA *data)
{
    int i;
    unsigned newsize;
    YYINT *newss;
    YYSTYPE *newvs;

    if ((newsize = data->stacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return YYENOMEM;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;

    i = (int) (data->s_mark - data->s_base);
    newss = (YYINT *)realloc(data->s_base, newsize * sizeof(*newss));
    if (newss == NULL)
        return YYENOMEM;

    data->s_base = newss;
    data->s_mark = newss + i;

    newvs = (YYSTYPE *)realloc(data->l_base, newsize * sizeof(*newvs));
    if (newvs == NULL)
        return YYENOMEM;

    data->l_base = newvs;
    data->l_mark = newvs + i;

    data->stacksize = newsize;
    data->s_last = data->s_base + newsize - 1;
    return 0;
}

#if YYPURE || defined(YY_NO_LEAKS)
static void yyfreestack(YYSTACKDATA *data)
{
    free(data->s_base);
    free(data->l_base);
    memset(data, 0, sizeof(*data));
}
#else
#define yyfreestack(data) /* nothing */
#endif

#define YYABORT  goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR  goto yyerrlab

int
YYPARSE_DECL()
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")) != NULL)
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    /* yym is set below */
    /* yyn is set below */
    yynerrs = 0;
    yyerrflag = 0;
    yychar = YYEMPTY;
    yystate = 0;

#if YYPURE
    memset(&yystack, 0, sizeof(yystack));
#endif

    if (yystack.s_base == NULL && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    yystack.s_mark = yystack.s_base;
    yystack.l_mark = yystack.l_base;
    yystate = 0;
    *yystack.s_mark = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        yychar = YYLEX;
        if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if (((yyn = yysindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
        yystate = yytable[yyn];
        *++yystack.s_mark = yytable[yyn];
        *++yystack.l_mark = yylval;
        yychar = YYEMPTY;
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if (((yyn = yyrindex[yystate]) != 0) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag != 0) goto yyinrecovery;

    YYERROR_CALL("syntax error");

    goto yyerrlab; /* redundant goto avoids 'unused label' warning */
yyerrlab:
    ++yynerrs;

yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if (((yyn = yysindex[*yystack.s_mark]) != 0) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yystack.s_mark, yytable[yyn]);
#endif
                if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
                yystate = yytable[yyn];
                *++yystack.s_mark = yytable[yyn];
                *++yystack.l_mark = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yystack.s_mark);
#endif
                if (yystack.s_mark <= yystack.s_base) goto yyabort;
                --yystack.s_mark;
                --yystack.l_mark;
            }
        }
    }
    else
    {
        if (yychar == YYEOF) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = YYEMPTY;
        goto yyloop;
    }

yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym > 0)
        yyval = yystack.l_mark[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);

    switch (yyn)
    {
case 8:
#line 127 "parse.y"
	{
			if (strcasecmp(yystack.l_mark[0].v.string, "true") == 0 ||
			    strcasecmp(yystack.l_mark[0].v.string, "yes") == 0)
				yyval.v.number = 1;
			else if (strcasecmp(yystack.l_mark[0].v.string, "false") == 0 ||
			    strcasecmp(yystack.l_mark[0].v.string, "no") == 0)
				yyval.v.number = 0;
			else {
				yyerror("invalid boolean value '%s'", yystack.l_mark[0].v.string);
				free(yystack.l_mark[0].v.string);
				YYERROR;
			}
			free(yystack.l_mark[0].v.string);
		}
#line 1301 "parse.c"
break;
case 9:
#line 142 "parse.y"
	{
			char	*s;
			if (asprintf(&s, "%lld", yystack.l_mark[0].v.number) == -1) {
				yyerror("string: asprintf");
				YYERROR;
			}
			yyval.v.string = s;
		}
#line 1313 "parse.c"
break;
case 11:
#line 152 "parse.y"
	{
			if (parseport(yystack.l_mark[0].v.string, &yyval.v.number) == -1) {
				free(yystack.l_mark[0].v.string);
				YYERROR;
			}
			free(yystack.l_mark[0].v.string);
		}
#line 1324 "parse.c"
break;
case 12:
#line 160 "parse.y"
	{ yyval.v.branch = NULL; }
#line 1329 "parse.c"
break;
case 13:
#line 161 "parse.y"
	{ yyval.v.branch = yystack.l_mark[0].v.branch; }
#line 1334 "parse.c"
break;
case 14:
#line 162 "parse.y"
	{ yyval.v.branch = yystack.l_mark[-1].v.branch; }
#line 1339 "parse.c"
break;
case 15:
#line 164 "parse.y"
	{
			yyval.v.branch = calloc(1, sizeof(struct node_branch));
			if (yyval.v.branch == NULL) {
				yyerror("calloc");
				YYERROR;
			}
			yyval.v.branch->branch_name = yystack.l_mark[0].v.string;
			yyval.v.branch->tail = yyval.v.branch;
		}
#line 1352 "parse.c"
break;
case 16:
#line 174 "parse.y"
	{ yyval.v.branch = yystack.l_mark[-1].v.branch; }
#line 1357 "parse.c"
break;
case 17:
#line 175 "parse.y"
	{
			yystack.l_mark[-3].v.branch->tail->next = yystack.l_mark[-1].v.branch;
			yystack.l_mark[-3].v.branch->tail = yystack.l_mark[-1].v.branch;
			yyval.v.branch = yystack.l_mark[-3].v.branch;
		}
#line 1366 "parse.c"
break;
case 18:
#line 181 "parse.y"
	{ yyval.v.ref = NULL; }
#line 1371 "parse.c"
break;
case 19:
#line 182 "parse.y"
	{ yyval.v.ref = yystack.l_mark[0].v.ref; }
#line 1376 "parse.c"
break;
case 20:
#line 183 "parse.y"
	{ yyval.v.ref = yystack.l_mark[-1].v.ref; }
#line 1381 "parse.c"
break;
case 21:
#line 185 "parse.y"
	{
			yyval.v.ref = calloc(1, sizeof(struct node_ref));
			if (yyval.v.ref == NULL) {
				yyerror("calloc");
				YYERROR;
			}
			yyval.v.ref->ref_name = yystack.l_mark[0].v.string;
			yyval.v.ref->tail = yyval.v.ref;
		}
#line 1394 "parse.c"
break;
case 22:
#line 195 "parse.y"
	{ yyval.v.ref = yystack.l_mark[-1].v.ref; }
#line 1399 "parse.c"
break;
case 23:
#line 196 "parse.y"
	{
			yystack.l_mark[-3].v.ref->tail->next = yystack.l_mark[-1].v.ref;
			yystack.l_mark[-3].v.ref->tail = yystack.l_mark[-1].v.ref;
			yyval.v.ref = yystack.l_mark[-3].v.ref;
		}
#line 1408 "parse.c"
break;
case 26:
#line 205 "parse.y"
	{
			remote->repository = yystack.l_mark[0].v.string;
		}
#line 1415 "parse.c"
break;
case 27:
#line 208 "parse.y"
	{
			remote->server = yystack.l_mark[0].v.string;
		}
#line 1422 "parse.c"
break;
case 28:
#line 211 "parse.y"
	{
			remote->protocol = yystack.l_mark[0].v.string;
		}
#line 1429 "parse.c"
break;
case 29:
#line 214 "parse.y"
	{
			remote->mirror_references = yystack.l_mark[0].v.number;
		}
#line 1436 "parse.c"
break;
case 30:
#line 217 "parse.y"
	{
			remote->fetch_all_branches = yystack.l_mark[0].v.number;
		}
#line 1443 "parse.c"
break;
case 31:
#line 220 "parse.y"
	{
			remote->port = yystack.l_mark[0].v.number;
		}
#line 1450 "parse.c"
break;
case 32:
#line 223 "parse.y"
	{
			remote->branch = yystack.l_mark[0].v.branch;
		}
#line 1457 "parse.c"
break;
case 33:
#line 226 "parse.y"
	{
			remote->fetch_ref = yystack.l_mark[0].v.ref;
		}
#line 1464 "parse.c"
break;
case 34:
#line 229 "parse.y"
	{
			static const struct got_error* error;

			if (remote->fetch_config != NULL) {
				yyerror("fetch block already exists");
				YYERROR;
			}
			error = new_fetch_config(&remote->fetch_config);
			if (error) {
				yyerror("%s", error->msg);
				YYERROR;
			}
		}
#line 1481 "parse.c"
break;
case 36:
#line 242 "parse.y"
	{
			static const struct got_error* error;

			if (remote->send_config != NULL) {
				yyerror("send block already exists");
				YYERROR;
			}
			error = new_send_config(&remote->send_config);
			if (error) {
				yyerror("%s", error->msg);
				YYERROR;
			}
		}
#line 1498 "parse.c"
break;
case 42:
#line 262 "parse.y"
	{
			remote->fetch_config->repository = yystack.l_mark[0].v.string;
		}
#line 1505 "parse.c"
break;
case 43:
#line 265 "parse.y"
	{
			remote->fetch_config->server = yystack.l_mark[0].v.string;
		}
#line 1512 "parse.c"
break;
case 44:
#line 268 "parse.y"
	{
			remote->fetch_config->protocol = yystack.l_mark[0].v.string;
		}
#line 1519 "parse.c"
break;
case 45:
#line 271 "parse.y"
	{
			remote->fetch_config->port = yystack.l_mark[0].v.number;
		}
#line 1526 "parse.c"
break;
case 46:
#line 274 "parse.y"
	{
			remote->fetch_config->branch = yystack.l_mark[0].v.branch;
		}
#line 1533 "parse.c"
break;
case 51:
#line 284 "parse.y"
	{
			remote->send_config->repository = yystack.l_mark[0].v.string;
		}
#line 1540 "parse.c"
break;
case 52:
#line 287 "parse.y"
	{
			remote->send_config->server = yystack.l_mark[0].v.string;
		}
#line 1547 "parse.c"
break;
case 53:
#line 290 "parse.y"
	{
			remote->send_config->protocol = yystack.l_mark[0].v.string;
		}
#line 1554 "parse.c"
break;
case 54:
#line 293 "parse.y"
	{
			remote->send_config->port = yystack.l_mark[0].v.number;
		}
#line 1561 "parse.c"
break;
case 55:
#line 296 "parse.y"
	{
			remote->send_config->branch = yystack.l_mark[0].v.branch;
		}
#line 1568 "parse.c"
break;
case 56:
#line 300 "parse.y"
	{
			static const struct got_error* error;

			error = new_remote(&remote);
			if (error) {
				free(yystack.l_mark[0].v.string);
				yyerror("%s", error->msg);
				YYERROR;
			}
			remote->name = yystack.l_mark[0].v.string;
		}
#line 1583 "parse.c"
break;
case 57:
#line 310 "parse.y"
	{
			TAILQ_INSERT_TAIL(&gotconfig.remotes, remote, entry);
			gotconfig.nremotes++;
		}
#line 1591 "parse.c"
break;
case 58:
#line 315 "parse.y"
	{
			gotconfig.author = yystack.l_mark[0].v.string;
		}
#line 1598 "parse.c"
break;
case 59:
#line 319 "parse.y"
	{
			gotconfig.allowed_signers_file = yystack.l_mark[0].v.string;
		}
#line 1605 "parse.c"
break;
case 60:
#line 323 "parse.y"
	{
			gotconfig.revoked_signers_file = yystack.l_mark[0].v.string;
		}
#line 1612 "parse.c"
break;
case 61:
#line 327 "parse.y"
	{
			gotconfig.signer_id = yystack.l_mark[0].v.string;
		}
#line 1619 "parse.c"
break;
#line 1621 "parse.c"
    }
    yystack.s_mark -= yym;
    yystate = *yystack.s_mark;
    yystack.l_mark -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yystack.s_mark = YYFINAL;
        *++yystack.l_mark = yyval;
        if (yychar < 0)
        {
            yychar = YYLEX;
            if (yychar < 0) yychar = YYEOF;
#if YYDEBUG
            if (yydebug)
            {
                if ((yys = yyname[YYTRANSLATE(yychar)]) == NULL) yys = yyname[YYUNDFTOKEN];
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == YYEOF) goto yyaccept;
        goto yyloop;
    }
    if (((yyn = yygindex[yym]) != 0) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == (YYINT) yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yystack.s_mark, yystate);
#endif
    if (yystack.s_mark >= yystack.s_last && yygrowstack(&yystack) == YYENOMEM) goto yyoverflow;
    *++yystack.s_mark = (YYINT) yystate;
    *++yystack.l_mark = yyval;
    goto yyloop;

yyoverflow:
    YYERROR_CALL("yacc stack overflow");

yyabort:
    yyfreestack(&yystack);
    return (1);

yyaccept:
    yyfreestack(&yystack);
    return (0);
}
