"""Generated message classes for cloudsecuritycompliance version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudsecuritycompliance'


class AggregateFrameworkComplianceReportResponse(_messages.Message):
  r"""The response message for AggregateFrameworkComplianceReport.

  Fields:
    aggregatedComplianceReports: The list of aggregated compliance reports.
  """

  aggregatedComplianceReports = _messages.MessageField('AggregatedComplianceReport', 1, repeated=True)


class AggregatedComplianceReport(_messages.Message):
  r"""The aggregated compliance report.

  Fields:
    controlAssessmentDetails: The control assessment details of the framework.
    reportTime: The report time of the aggregated compliance report.
  """

  controlAssessmentDetails = _messages.MessageField('ControlAssessmentDetails', 1)
  reportTime = _messages.StringField(2)


class AllowedValues(_messages.Message):
  r"""The allowed set of values for the parameter.

  Fields:
    values: Required. The list of allowed values for the parameter.
  """

  values = _messages.MessageField('ParamValue', 1, repeated=True)


class AttributeSubstitutionRule(_messages.Message):
  r"""The attribute at the given path that's substituted entirely.

  Fields:
    attribute: The fully qualified proto attribute path, in dot notation. For
      example: `rules[0].cel_expression.resource_types_values`
  """

  attribute = _messages.StringField(1)


class AuditConfig(_messages.Message):
  r"""The audit configuration for Compliance Manager.

  Fields:
    destinations: Required. The list of destinations that can be selected for
      uploading audit reports to.
  """

  destinations = _messages.MessageField('CmEligibleDestination', 1, repeated=True)


class BucketDestination(_messages.Message):
  r"""A Cloud Storage bucket destination.

  Enums:
    FrameworkAuditFormatValueValuesEnum: Optional. The format of the framework
      audit.

  Fields:
    bucketUri: Required. The URI of the Cloud Storage bucket.
    frameworkAuditFormat: Optional. The format of the framework audit.
  """

  class FrameworkAuditFormatValueValuesEnum(_messages.Enum):
    r"""Optional. The format of the framework audit.

    Values:
      FORMAT_UNSPECIFIED: Default value. This value is unused.
      ODF: The format for the framework audit report is Open Document.
    """
    FORMAT_UNSPECIFIED = 0
    ODF = 1

  bucketUri = _messages.StringField(1)
  frameworkAuditFormat = _messages.EnumField('FrameworkAuditFormatValueValuesEnum', 2)


class CELExpression(_messages.Message):
  r"""A Common Expression Language (CEL) expression that's used to create a
  rule.

  Fields:
    expression: Required. The logical expression in CEL. The maximum length of
      the condition is 1000 characters. For more information, see [CEL
      expression](https://cloud.google.com/security-command-
      center/docs/compliance-manager-write-cel-expressions).
    resourceTypesValues: The resource instance types on which this expression
      is defined. The format is `/`. For example:
      `compute.googleapis.com/Instance`
  """

  expression = _messages.StringField(1)
  resourceTypesValues = _messages.MessageField('StringList', 2)


class CalculateEffectiveCmEnrollmentResponse(_messages.Message):
  r"""The response message for CalculateEffectiveCmEnrollment.

  Fields:
    cmEnrollment: The effective Compliance Manager enrollment for the
      resource.
  """

  cmEnrollment = _messages.MessageField('CmEnrollment', 1)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudControl(_messages.Message):
  r"""A cloud control is a set of rules and associated metadata that you can
  use to define your organization's security or compliance intent.

  Enums:
    CategoriesValueListEntryValuesEnum:
    SeverityValueValuesEnum: Optional. The severity of the findings that are
      generated by the cloud control.
    SupportedCloudProvidersValueListEntryValuesEnum:
    SupportedEnforcementModesValueListEntryValuesEnum:
    SupportedTargetResourceTypesValueListEntryValuesEnum:

  Fields:
    categories: Optional. The categories for the cloud control.
    createTime: Output only. The time that the cloud control was last updated.
      `create_time` is used because a new cloud control is created whenever an
      existing cloud control is updated.
    description: Optional. A description of the cloud control. The maximum
      length is 2000 characters.
    displayName: Optional. The friendly name of the cloud control. The maximum
      length is 200 characters.
    findingCategory: Optional. The finding category for the cloud control
      findings. The maximum length is 255 characters.
    majorRevisionId: Output only. The major version of the cloud control,
      which is incremented in ascending order.
    name: Required. Identifier. The name of the cloud control, in the format `
      organizations/{organization}/locations/{location}/cloudControls/{cloud_c
      ontrol_id}`. The only supported location is `global`.
    parameterSpec: Optional. The parameter specifications for the cloud
      control.
    relatedFrameworks: Output only. The frameworks that include this cloud
      control.
    remediationSteps: Optional. The remediation steps for the cloud control
      findings. The maximum length is 400 characters.
    rules: Optional. The rules that you can enforce to meet your security or
      compliance intent.
    severity: Optional. The severity of the findings that are generated by the
      cloud control.
    supportedCloudProviders: Optional. The supported cloud providers.
    supportedEnforcementModes: Output only. The supported enforcement modes
      for the cloud control.
    supportedTargetResourceTypes: Optional. The target resource types that are
      supported by the cloud control.
  """

  class CategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""CategoriesValueListEntryValuesEnum enum type.

    Values:
      CLOUD_CONTROL_CATEGORY_UNSPECIFIED: Default value. This value is unused.
      CC_CATEGORY_INFRASTRUCTURE: The infrastructure security category.
      CC_CATEGORY_ARTIFICIAL_INTELLIGENCE: The artificial intelligence
        category.
      CC_CATEGORY_PHYSICAL_SECURITY: The physical security category.
      CC_CATEGORY_DATA_SECURITY: The data security category.
      CC_CATEGORY_NETWORK_SECURITY: The network security category.
      CC_CATEGORY_INCIDENT_MANAGEMENT: The incident management category.
      CC_CATEGORY_IDENTITY_AND_ACCESS_MANAGEMENT: The identity and access
        management category.
      CC_CATEGORY_ENCRYPTION: The encryption category.
      CC_CATEGORY_LOGS_MANAGEMENT_AND_INFRASTRUCTURE: The logs management and
        infrastructure category.
      CC_CATEGORY_HR_ADMIN_AND_PROCESSES: The HR, admin, and processes
        category.
      CC_CATEGORY_THIRD_PARTY_AND_SUB_PROCESSOR_MANAGEMENT: The third-party
        and sub-processor management category.
      CC_CATEGORY_LEGAL_AND_DISCLOSURES: The legal and disclosures category.
      CC_CATEGORY_VULNERABILITY_MANAGEMENT: The vulnerability management
        category.
      CC_CATEGORY_PRIVACY: The privacy category.
      CC_CATEGORY_BCDR: The business continuity and disaster recovery (BCDR)
        category.
    """
    CLOUD_CONTROL_CATEGORY_UNSPECIFIED = 0
    CC_CATEGORY_INFRASTRUCTURE = 1
    CC_CATEGORY_ARTIFICIAL_INTELLIGENCE = 2
    CC_CATEGORY_PHYSICAL_SECURITY = 3
    CC_CATEGORY_DATA_SECURITY = 4
    CC_CATEGORY_NETWORK_SECURITY = 5
    CC_CATEGORY_INCIDENT_MANAGEMENT = 6
    CC_CATEGORY_IDENTITY_AND_ACCESS_MANAGEMENT = 7
    CC_CATEGORY_ENCRYPTION = 8
    CC_CATEGORY_LOGS_MANAGEMENT_AND_INFRASTRUCTURE = 9
    CC_CATEGORY_HR_ADMIN_AND_PROCESSES = 10
    CC_CATEGORY_THIRD_PARTY_AND_SUB_PROCESSOR_MANAGEMENT = 11
    CC_CATEGORY_LEGAL_AND_DISCLOSURES = 12
    CC_CATEGORY_VULNERABILITY_MANAGEMENT = 13
    CC_CATEGORY_PRIVACY = 14
    CC_CATEGORY_BCDR = 15

  class SeverityValueValuesEnum(_messages.Enum):
    r"""Optional. The severity of the findings that are generated by the cloud
    control.

    Values:
      SEVERITY_UNSPECIFIED: Default value. This value is unused.
      CRITICAL: A critical vulnerability is easily discoverable by an external
        actor, exploitable, and results in the direct ability to execute
        arbitrary code, exfiltrate data, and otherwise gain additional access
        and privileges to cloud resources and workloads. Examples include
        publicly accessible unprotected user data and public SSH access with
        weak or no passwords. A critical threat is a threat that can access,
        modify, or delete data or execute unauthorized code within existing
        resources.
      HIGH: A high-risk vulnerability can be easily discovered and exploited
        in combination with other vulnerabilities to gain direct access and
        the ability to execute arbitrary code, exfiltrate data, and otherwise
        gain additional access and privileges to cloud resources and
        workloads. An example is a database with weak or no passwords that is
        only accessible internally. This database could easily be compromised
        by an actor that had access to the internal network. A high-risk
        threat is a threat that can create new computational resources in an
        environment but can't access data or execute code in existing
        resources.
      MEDIUM: A medium-risk vulnerability can be used by an actor to gain
        access to resources or privileges that enable them to eventually
        (through multiple steps or a complex exploit) gain access and the
        ability to execute arbitrary code or exfiltrate data. An example is a
        service account with access to more projects than it should have. If
        an actor gains access to the service account, they could potentially
        use that access to manipulate a project the service account was not
        intended to. A medium-risk threat can cause operational impact but
        might not access data or execute unauthorized code.
      LOW: A low-risk vulnerability hampers a security organization's ability
        to detect vulnerabilities or active threats in their deployment, or
        prevents the root cause investigation of security issues. An example
        is monitoring and logs being disabled for resource configurations and
        access. A low-risk threat is a threat that has obtained minimal access
        to an environment but can't access data, execute code, or create
        resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  class SupportedCloudProvidersValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedCloudProvidersValueListEntryValuesEnum enum type.

    Values:
      CLOUD_PROVIDER_UNSPECIFIED: Default value. This value is unused.
      AWS: Amazon Web Services (AWS).
      AZURE: Microsoft Azure.
      GCP: Google Cloud.
    """
    CLOUD_PROVIDER_UNSPECIFIED = 0
    AWS = 1
    AZURE = 2
    GCP = 3

  class SupportedEnforcementModesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedEnforcementModesValueListEntryValuesEnum enum type.

    Values:
      ENFORCEMENT_MODE_UNSPECIFIED: Default value. This value is unused.
      PREVENTIVE: The cloud control is enforced to prevent non-compliance.
      DETECTIVE: The cloud control is enforced to detect non-compliance.
      AUDIT: The cloud control is enforced to audit for non-compliance.
    """
    ENFORCEMENT_MODE_UNSPECIFIED = 0
    PREVENTIVE = 1
    DETECTIVE = 2
    AUDIT = 3

  class SupportedTargetResourceTypesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedTargetResourceTypesValueListEntryValuesEnum enum type.

    Values:
      TARGET_RESOURCE_TYPE_UNSPECIFIED: Default value. This value is unused.
      TARGET_RESOURCE_CRM_TYPE_ORG: The target resource is a Google Cloud
        organization.
      TARGET_RESOURCE_CRM_TYPE_FOLDER: The target resource is a folder.
      TARGET_RESOURCE_CRM_TYPE_PROJECT: The target resource is a project.
      TARGET_RESOURCE_TYPE_APPLICATION: The target resource is an application
        in App Hub.
    """
    TARGET_RESOURCE_TYPE_UNSPECIFIED = 0
    TARGET_RESOURCE_CRM_TYPE_ORG = 1
    TARGET_RESOURCE_CRM_TYPE_FOLDER = 2
    TARGET_RESOURCE_CRM_TYPE_PROJECT = 3
    TARGET_RESOURCE_TYPE_APPLICATION = 4

  categories = _messages.EnumField('CategoriesValueListEntryValuesEnum', 1, repeated=True)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  findingCategory = _messages.StringField(5)
  majorRevisionId = _messages.IntegerField(6)
  name = _messages.StringField(7)
  parameterSpec = _messages.MessageField('ParameterSpec', 8, repeated=True)
  relatedFrameworks = _messages.StringField(9, repeated=True)
  remediationSteps = _messages.StringField(10)
  rules = _messages.MessageField('Rule', 11, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 12)
  supportedCloudProviders = _messages.EnumField('SupportedCloudProvidersValueListEntryValuesEnum', 13, repeated=True)
  supportedEnforcementModes = _messages.EnumField('SupportedEnforcementModesValueListEntryValuesEnum', 14, repeated=True)
  supportedTargetResourceTypes = _messages.EnumField('SupportedTargetResourceTypesValueListEntryValuesEnum', 15, repeated=True)


class CloudControlAssessmentDetails(_messages.Message):
  r"""The cloud control assessment details for non-manual cloud controls.

  Enums:
    EvaluationStateValueValuesEnum: Output only. The evaluation status of the
      cloud control.

  Fields:
    evaluationState: Output only. The evaluation status of the cloud control.
    findingsCount: The number of findings for the cloud control.
  """

  class EvaluationStateValueValuesEnum(_messages.Enum):
    r"""Output only. The evaluation status of the cloud control.

    Values:
      EVALUATION_STATE_UNSPECIFIED: Default value. This value is unused.
      EVALUATION_STATE_PASSED: The control is passing.
      EVALUATION_STATE_FAILED: The control is failing.
      EVALUATION_STATE_NOT_ASSESSED: The control is not assessed.
    """
    EVALUATION_STATE_UNSPECIFIED = 0
    EVALUATION_STATE_PASSED = 1
    EVALUATION_STATE_FAILED = 2
    EVALUATION_STATE_NOT_ASSESSED = 3

  evaluationState = _messages.EnumField('EvaluationStateValueValuesEnum', 1)
  findingsCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class CloudControlAuditDetails(_messages.Message):
  r"""The details for a cloud control audit.

  Enums:
    ComplianceStateValueValuesEnum: Output only. The overall status of the
      findings for the control.

  Fields:
    cloudControl: Output only. The name of the cloud control.
    cloudControlDescription: Output only. The description of the cloud
      control.
    cloudControlId: Output only. The ID of the cloud control.
    complianceState: Output only. The overall status of the findings for the
      control.
    findings: Output only. The findings for the control.
    reportSummary: Output only. The summary of the report.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""Output only. The overall status of the findings for the control.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: Default value. This value is unused.
      COMPLIANT: The resource is compliant.
      VIOLATION: The resource has a violation.
      MANUAL_REVIEW_NEEDED: The resource requires manual review from you.
      ERROR: An error occurred while computing the resource status.
      AUDIT_NOT_SUPPORTED: The resource can't be audited.
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    VIOLATION = 2
    MANUAL_REVIEW_NEEDED = 3
    ERROR = 4
    AUDIT_NOT_SUPPORTED = 5

  cloudControl = _messages.StringField(1)
  cloudControlDescription = _messages.StringField(2)
  cloudControlId = _messages.StringField(3)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 4)
  findings = _messages.MessageField('FindingDetails', 5, repeated=True)
  reportSummary = _messages.MessageField('ReportSummary', 6)


class CloudControlDeployment(_messages.Message):
  r"""A cloud control deployment represents the deployment of a particular
  cloud control on a target resource. Supported target resources are
  `organizations/{organizationID}`, `folders/{folderID}`, and
  `projects/{projectID}`.

  Enums:
    DeploymentStateValueValuesEnum: Output only. The state of the cloud
      control deployment.

  Fields:
    cloudControlMetadata: Required. The deployment mode and parameters for the
      cloud control.
    createTime: Output only. The time when the resource was created.
    deploymentState: Output only. The state of the cloud control deployment.
    description: Optional. A friendly description for the cloud control
      deployment.
    etag: Optional. To prevent concurrent updates from overwriting each other,
      provide the `etag` when you update a cloud control deployment. You can
      also provide the `etag` when you delete a cloud control deployment to
      help ensure that you're deleting the intended version of the deployment.
    frameworkDeploymentReferences: Output only. The references to the
      framework deployments that this cloud control deployment is part of. A
      cloud control deployment can be part of multiple framework deployments.
    name: Identifier. The name for the cloud control deployment, in the format
      `organizations/{organization}/locations/{location}/cloudControlDeploymen
      ts/{cloud_control_deployment_id}`. The only supported location is
      `global`.
    parameterSubstitutedCloudControl: Output only. The cloud control after the
      given parameters are substituted.
    targetResource: Output only. The resource that the cloud control is
      deployed on, in one of the following formats: -
      `organizations/{organizationID}` - `folders/{folderID}` -
      `projects/{projectID}`
    targetResourceConfig: Required. The details of the target resource that
      the cloud control is deployed You can use an existing target resource or
      create a new target.
    targetResourceDisplayName: Output only. The display name of the target
      resource.
    updateTime: Output only. The time when the resource was last updated.
  """

  class DeploymentStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of the cloud control deployment.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      DEPLOYMENT_STATE_VALIDATING: Validating the deployment.
      DEPLOYMENT_STATE_CREATING: Deployment is being created.
      DEPLOYMENT_STATE_DELETING: Deployment is being deleted.
      DEPLOYMENT_STATE_FAILED: Deployment has failed. All the changes made by
        the deployment were successfully rolled back. You can retry or delete
        a deployment that's in this state.
      DEPLOYMENT_STATE_READY: Deployment is successful and ready to use.
      DEPLOYMENT_STATE_PARTIALLY_DEPLOYED: Deployment is partially deployed.
        All the cloud controls weren't deployed successfully. Retrying the
        operation resumes from the first failed step.
      DEPLOYMENT_STATE_PARTIALLY_DELETED: Deployment is partially deleted. All
        the cloud control deployments weren't deleted successfully. Retrying
        the operation resumes from the first failed step.
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    DEPLOYMENT_STATE_VALIDATING = 1
    DEPLOYMENT_STATE_CREATING = 2
    DEPLOYMENT_STATE_DELETING = 3
    DEPLOYMENT_STATE_FAILED = 4
    DEPLOYMENT_STATE_READY = 5
    DEPLOYMENT_STATE_PARTIALLY_DEPLOYED = 6
    DEPLOYMENT_STATE_PARTIALLY_DELETED = 7

  cloudControlMetadata = _messages.MessageField('CloudControlMetadata', 1)
  createTime = _messages.StringField(2)
  deploymentState = _messages.EnumField('DeploymentStateValueValuesEnum', 3)
  description = _messages.StringField(4)
  etag = _messages.StringField(5)
  frameworkDeploymentReferences = _messages.MessageField('FrameworkDeploymentReference', 6, repeated=True)
  name = _messages.StringField(7)
  parameterSubstitutedCloudControl = _messages.MessageField('CloudControl', 8)
  targetResource = _messages.StringField(9)
  targetResourceConfig = _messages.MessageField('TargetResourceConfig', 10)
  targetResourceDisplayName = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class CloudControlDeploymentReference(_messages.Message):
  r"""The reference to a cloud control deployment.

  Fields:
    cloudControlDeployment: Output only. The name of the
      CloudControlDeployment. The format is `organizations/{org}/locations/{lo
      cation}/cloudControlDeployments/{cloud_control_deployment_id}`. The only
      supported location is `global`.
  """

  cloudControlDeployment = _messages.StringField(1)


class CloudControlDetails(_messages.Message):
  r"""The details of a cloud control.

  Fields:
    majorRevisionId: Required. The major version of the cloud control.
    name: Required. The name of the cloud control, in the format
      `organizations/{organization}/locations/{location}/cloudControls/{cloud-
      control}`. The only supported location is `global`.
    parameters: Optional. Parameters are key-value pairs that let you provide
      your custom location requirements, environment requirements, or other
      settings that are relevant to the cloud control. An example parameter is
      `{"name": "location","value": "us-west-1"}`.
  """

  majorRevisionId = _messages.IntegerField(1)
  name = _messages.StringField(2)
  parameters = _messages.MessageField('Parameter', 3, repeated=True)


class CloudControlGroupAuditDetails(_messages.Message):
  r"""The details for a cloud control group.

  Enums:
    ComplianceStateValueValuesEnum: Output only. The compliance state of the
      control group.

  Fields:
    cloudControlDetails: Output only. The details for the cloud controls
      within this group.
    cloudControlGroupId: Output only. The ID of the cloud control group.
    complianceState: Output only. The compliance state of the control group.
    controlFamily: Output only. The control family.
    controlId: Output only. The ID of the regulatory control.
    customerResponsibilityDescription: Output only. The description of your
      responsibility.
    customerResponsibilityImplementation: Output only. The implementation of
      your responsibility.
    description: Output only. The description of the cloud control group.
    displayName: Output only. The display name of the cloud control group.
    googleResponsibilityDescription: Output only. The description of Google's
      responsibility.
    googleResponsibilityImplementation: Output only. The implementation of
      Google's responsibility.
    reportSummary: Output only. The summary of the report.
    responsibilityType: Output only. The responsibility type.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""Output only. The compliance state of the control group.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: Default value. This value is unused.
      COMPLIANT: The resource is compliant.
      VIOLATION: The resource has a violation.
      MANUAL_REVIEW_NEEDED: The resource requires manual review from you.
      ERROR: An error occurred while computing the resource status.
      AUDIT_NOT_SUPPORTED: The resource can't be audited.
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    VIOLATION = 2
    MANUAL_REVIEW_NEEDED = 3
    ERROR = 4
    AUDIT_NOT_SUPPORTED = 5

  cloudControlDetails = _messages.MessageField('CloudControlAuditDetails', 1, repeated=True)
  cloudControlGroupId = _messages.StringField(2)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 3)
  controlFamily = _messages.MessageField('ControlFamily', 4)
  controlId = _messages.StringField(5)
  customerResponsibilityDescription = _messages.StringField(6)
  customerResponsibilityImplementation = _messages.StringField(7)
  description = _messages.StringField(8)
  displayName = _messages.StringField(9)
  googleResponsibilityDescription = _messages.StringField(10)
  googleResponsibilityImplementation = _messages.StringField(11)
  reportSummary = _messages.MessageField('ReportSummary', 12)
  responsibilityType = _messages.StringField(13)


class CloudControlMetadata(_messages.Message):
  r"""The enforcement mode and parameters of a cloud control deployment.

  Enums:
    EnforcementModeValueValuesEnum: Required. The enforcement mode of the
      cloud control.

  Fields:
    cloudControlDetails: Required. The cloud control name and parameters.
    enforcementMode: Required. The enforcement mode of the cloud control.
  """

  class EnforcementModeValueValuesEnum(_messages.Enum):
    r"""Required. The enforcement mode of the cloud control.

    Values:
      ENFORCEMENT_MODE_UNSPECIFIED: Default value. This value is unused.
      PREVENTIVE: The cloud control is enforced to prevent non-compliance.
      DETECTIVE: The cloud control is enforced to detect non-compliance.
      AUDIT: The cloud control is enforced to audit for non-compliance.
    """
    ENFORCEMENT_MODE_UNSPECIFIED = 0
    PREVENTIVE = 1
    DETECTIVE = 2
    AUDIT = 3

  cloudControlDetails = _messages.MessageField('CloudControlDetails', 1)
  enforcementMode = _messages.EnumField('EnforcementModeValueValuesEnum', 2)


class CloudControlReport(_messages.Message):
  r"""The cloud control report.

  Enums:
    CloudControlTypeValueValuesEnum: The type of the cloud control.
    EnforcementModeValueValuesEnum: The enforcement mode of the cloud control.
    FindingSeverityValueValuesEnum: The severity of the finding.

  Fields:
    categories: The list of categories for the cloud control.
    cloudControl: The name of the cloud control.
    cloudControlAssessmentDetails: The details of a cloud control assessment.
    cloudControlDeployment: The name of the cloud control deployment.
    cloudControlType: The type of the cloud control.
    description: The description of the cloud control.
    displayName: The display name of the cloud control.
    enforcementMode: The enforcement mode of the cloud control.
    findingCategory: The category of the finding.
    findingSeverity: The severity of the finding.
    frameworkMajorRevisionIds: The major revision IDs of the frameworks that
      the cloud control belongs to.
    majorRevisionId: The major revision ID of the cloud control.
    manualCloudControlAssessmentDetails: The details of a manual cloud control
      assessment.
    minorRevisionId: The minor revision ID of the cloud control.
    rules: The list of rules that correspond to the cloud control.
    similarControls: The list of similar controls.
  """

  class CloudControlTypeValueValuesEnum(_messages.Enum):
    r"""The type of the cloud control.

    Values:
      TYPE_UNSPECIFIED: Default value. This value is unused.
      CUSTOM: A cloud control that's created and managed by you.
      BUILT_IN: A cloud control that's provided and managed by Google.
    """
    TYPE_UNSPECIFIED = 0
    CUSTOM = 1
    BUILT_IN = 2

  class EnforcementModeValueValuesEnum(_messages.Enum):
    r"""The enforcement mode of the cloud control.

    Values:
      ENFORCEMENT_MODE_UNSPECIFIED: Default value. This value is unused.
      PREVENTIVE: The cloud control is enforced to prevent non-compliance.
      DETECTIVE: The cloud control is enforced to detect non-compliance.
      AUDIT: The cloud control is enforced to audit for non-compliance.
    """
    ENFORCEMENT_MODE_UNSPECIFIED = 0
    PREVENTIVE = 1
    DETECTIVE = 2
    AUDIT = 3

  class FindingSeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding.

    Values:
      SEVERITY_UNSPECIFIED: Default value. This value is unused.
      CRITICAL: A critical vulnerability is easily discoverable by an external
        actor, exploitable, and results in the direct ability to execute
        arbitrary code, exfiltrate data, and otherwise gain additional access
        and privileges to cloud resources and workloads. Examples include
        publicly accessible unprotected user data and public SSH access with
        weak or no passwords. A critical threat is a threat that can access,
        modify, or delete data or execute unauthorized code within existing
        resources.
      HIGH: A high-risk vulnerability can be easily discovered and exploited
        in combination with other vulnerabilities to gain direct access and
        the ability to execute arbitrary code, exfiltrate data, and otherwise
        gain additional access and privileges to cloud resources and
        workloads. An example is a database with weak or no passwords that is
        only accessible internally. This database could easily be compromised
        by an actor that had access to the internal network. A high-risk
        threat is a threat that can create new computational resources in an
        environment but can't access data or execute code in existing
        resources.
      MEDIUM: A medium-risk vulnerability can be used by an actor to gain
        access to resources or privileges that enable them to eventually
        (through multiple steps or a complex exploit) gain access and the
        ability to execute arbitrary code or exfiltrate data. An example is a
        service account with access to more projects than it should have. If
        an actor gains access to the service account, they could potentially
        use that access to manipulate a project the service account was not
        intended to. A medium-risk threat can cause operational impact but
        might not access data or execute unauthorized code.
      LOW: A low-risk vulnerability hampers a security organization's ability
        to detect vulnerabilities or active threats in their deployment, or
        prevents the root cause investigation of security issues. An example
        is monitoring and logs being disabled for resource configurations and
        access. A low-risk threat is a threat that has obtained minimal access
        to an environment but can't access data, execute code, or create
        resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  categories = _messages.StringField(1, repeated=True)
  cloudControl = _messages.StringField(2)
  cloudControlAssessmentDetails = _messages.MessageField('CloudControlAssessmentDetails', 3)
  cloudControlDeployment = _messages.StringField(4)
  cloudControlType = _messages.EnumField('CloudControlTypeValueValuesEnum', 5)
  description = _messages.StringField(6)
  displayName = _messages.StringField(7)
  enforcementMode = _messages.EnumField('EnforcementModeValueValuesEnum', 8)
  findingCategory = _messages.StringField(9)
  findingSeverity = _messages.EnumField('FindingSeverityValueValuesEnum', 10)
  frameworkMajorRevisionIds = _messages.IntegerField(11, repeated=True)
  majorRevisionId = _messages.IntegerField(12)
  manualCloudControlAssessmentDetails = _messages.MessageField('ManualCloudControlAssessmentDetails', 13)
  minorRevisionId = _messages.IntegerField(14)
  rules = _messages.MessageField('Rule', 15, repeated=True)
  similarControls = _messages.MessageField('SimilarControls', 16, repeated=True)


class CloudsecuritycomplianceFoldersLocationsCmEnrollmentCalculateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsCmEnrollmentCalculateRequest
  object.

  Fields:
    name: Required. The name of the Compliance Manager enrollment to
      calculate. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceFoldersLocationsFindingSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFindingSummariesListRequest
  object.

  Fields:
    endTime: Optional. The end time of the finding summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkAuditScopeReportsGener
  ateFrameworkAuditScopeReportRequest object.

  Fields:
    generateFrameworkAuditScopeReportRequest: A
      GenerateFrameworkAuditScopeReportRequest resource to be passed as the
      request body.
    scope: Required. The organization, folder, or project for the audit
      report. Supported formats are the following: *
      `projects/{project_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `organizations/{organization_id}/locations/{location}`
  """

  generateFrameworkAuditScopeReportRequest = _messages.MessageField('GenerateFrameworkAuditScopeReportRequest', 1)
  scope = _messages.StringField(2, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkAuditsCreateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkAuditsCreateRequest
  object.

  Fields:
    frameworkAudit: A FrameworkAudit resource to be passed as the request
      body.
    frameworkAuditId: Optional. The ID to use for the framework audit. The ID
      becomes the final component of the framework audit's full resource name.
      The ID must be between 4 and 63 characters and can contain lowercase
      letters, numbers, and hyphens.
    parent: Required. The parent resource where this framework audit is
      created. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  frameworkAudit = _messages.MessageField('FrameworkAudit', 1)
  frameworkAuditId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkAuditsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkAuditsGetRequest
  object.

  Fields:
    name: Required. The name of the framework audit to retrieve. Supported
      formats are the following: * `organizations/{organization_id}/locations/
      {location}/frameworkAudits/{frameworkAuditName}` * `folders/{folder_id}/
      locations/{location}/frameworkAudits/{frameworkAuditName}` * `projects/{
      project_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkAuditsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkAuditsListRequest
  object.

  Fields:
    filter: Optional. The filters to apply to the framework audits. Supported
      filters are `compliance_framework`, `compliance_state`, `create_time,`
      and `framework_audit_name`. If the filter is invalid, an invalid
      argument error is returned. For syntax details, see AIP-160.
    pageSize: Optional. The maximum number of framework audits to return. The
      service might return fewer audits than this value. If unspecified, a
      maximum of 10 framework audits are returned. The maximum value is 50;
      values above 50 are limited to 50.
    pageToken: Optional. The `next_page_token` value that's returned from a
      previous list request, if any.
    parent: Required. The parent resource where the framework audits are
      listed. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggregateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggre
  gateRequest object.

  Fields:
    filter: Optional. The filtering results.
    interval_endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    interval_startTime: Optional. Inclusive start of the interval. If
      specified, a Timestamp matching this interval will have to be the same
      or after the start.
    name: Required. The name of the aggregated compliance report over time to
      retrieve. The supported format is: `organizations/{organization_id}/loca
      tions/{location}/frameworkComplianceReports/{framework_compliance_report
      }`
  """

  filter = _messages.StringField(1)
  interval_endTime = _messages.StringField(2)
  interval_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsContr
  olComplianceSummariesListRequest object.

  Fields:
    endTime: Optional. The end time of the control compliance summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsFetchRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsFetch
  Request object.

  Fields:
    endTime: Optional. The end time of the report.
    filter: Optional. The filtering results.
    name: Required. The name of the framework compliance report to retrieve.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)


class CloudsecuritycomplianceFoldersLocationsFrameworkComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsFrameworkComplianceSummariesLis
  tRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Specifies the level of detail to return in
      the response.

  Fields:
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework compliance summary.
    view: Optional. Specifies the level of detail to return in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the level of detail to return in the response.

    Values:
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED: The default / unset
        value. The API will default to the BASIC view.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC: Includes basic compliance
        metadata, but omits trend data.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL: Includes all information,
        including finding_count and controls_passing_trend. Trend data is
        provided for the last 30 days.
    """
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED = 0
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC = 1
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class CloudsecuritycomplianceFoldersLocationsOperationDetailsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsOperationDetailsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceFoldersLocationsUpdateCmEnrollmentRequest(_messages.Message):
  r"""A CloudsecuritycomplianceFoldersLocationsUpdateCmEnrollmentRequest
  object.

  Fields:
    cmEnrollment: A CmEnrollment resource to be passed as the request body.
    name: Identifier. The name of the Compliance Manager enrollment. Supported
      formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
    updateMask: Optional. The list of fields that you want to update.
  """

  cmEnrollment = _messages.MessageField('CmEnrollment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsGe
  tRequest object.

  Fields:
    name: Required. The name for the cloud control deployment, in the format `
      organizations/{organization}/locations/{location}/cloudControlDeployment
      s/{cloud_control_deployment_id}`. The only supported location is
      `global`.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsCloudControlDeploymentsLi
  stRequest object.

  Fields:
    filter: Optional. The filter to apply on the resource, as defined by
      [AIP-160: Filtering](https://google.aip.dev/160).
    orderBy: Optional. The sort order for the results. The following values
      are supported: * `name` * `name desc` If you do not specify a value,
      then the results are not sorted.
    pageSize: Optional. The requested page size. The server might return fewer
      items than you requested. If unspecified, the server picks an
      appropriate default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent resource for the cloud control deployment, in
      the format `organizations/{organization}/locations/{location}`. The only
      supported location is `global`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlsCreateRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsCloudControlsCreateRequest
  object.

  Fields:
    cloudControl: A CloudControl resource to be passed as the request body.
    cloudControlId: Required. The identifier for the cloud control, which is
      the last segment of the cloud control name. The format is
      `^a-zA-Z{0,61}[a-zA-Z0-9]$`.
    parent: Required. The parent resource name, in the format
      `organizations/{organization}/locations/{location}`. The only supported
      location is `global`.
  """

  cloudControl = _messages.MessageField('CloudControl', 1)
  cloudControlId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlsDeleteRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsCloudControlsDeleteRequest
  object.

  Fields:
    name: Required. The name of the cloud control to delete, in the format `or
      ganizations/{organization}/locations/{location}/CloudControls/{CloudCont
      rol}`. The only supported location is `global`.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsCloudControlsGetRequest
  object.

  Fields:
    majorRevisionId: Optional. The major version of the cloud control to
      retrieve. If not specified, the most recently updated `revision_id` is
      retrieved.
    name: Required. The name of the cloud control to retrieve, in the format `
      organizations/{organization}/locations/{location}/cloudControls/{cloud_c
      ontrol}`. The only supported location is `global`.
  """

  majorRevisionId = _messages.IntegerField(1)
  name = _messages.StringField(2, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsCloudControlsListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of cloud controls to return. The
      default value is `500`. If you exceed the maximum value of `1000`, then
      the service uses the maximum value.
    pageToken: Optional. A pagination token that's returned from a previous
      request to list cloud controls. Provide this token to retrieve the next
      page of results. When paginating, the parent that you provide to the
      ListCloudControls request must match the call that provided the page
      token.
    parent: Required. The parent resource name, in the format
      `organizations/{organization}/locations/{location}`. The only supported
      location is `global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsCloudControlsPatchRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsCloudControlsPatchRequest
  object.

  Fields:
    cloudControl: A CloudControl resource to be passed as the request body.
    name: Required. Identifier. The name of the cloud control, in the format `
      organizations/{organization}/locations/{location}/cloudControls/{cloud_c
      ontrol_id}`. The only supported location is `global`.
    updateMask: Optional. Use a field mask to specify the fields to be
      overwritten in the cloud control during the update. The fields that you
      specify in the `update_mask` are relative to the cloud control, not the
      full request. A field is overwritten if it is in the mask. If you don't
      provide a mask, all fields in the request are updated. You can update
      the following fields: - Display name - Description - Parameters - Rules
      - Parameter specification
  """

  cloudControl = _messages.MessageField('CloudControl', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudsecuritycomplianceOrganizationsLocationsCmEnrollmentCalculateRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsCmEnrollmentCalculateRequest
  object.

  Fields:
    name: Required. The name of the Compliance Manager enrollment to
      calculate. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFindingSummariesListRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsFindingSummariesListRequest
  object.

  Fields:
    endTime: Optional. The end time of the finding summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditScopeReport
  sGenerateFrameworkAuditScopeReportRequest object.

  Fields:
    generateFrameworkAuditScopeReportRequest: A
      GenerateFrameworkAuditScopeReportRequest resource to be passed as the
      request body.
    scope: Required. The organization, folder, or project for the audit
      report. Supported formats are the following: *
      `projects/{project_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `organizations/{organization_id}/locations/{location}`
  """

  generateFrameworkAuditScopeReportRequest = _messages.MessageField('GenerateFrameworkAuditScopeReportRequest', 1)
  scope = _messages.StringField(2, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsCreateRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsCreateRequest
  object.

  Fields:
    frameworkAudit: A FrameworkAudit resource to be passed as the request
      body.
    frameworkAuditId: Optional. The ID to use for the framework audit. The ID
      becomes the final component of the framework audit's full resource name.
      The ID must be between 4 and 63 characters and can contain lowercase
      letters, numbers, and hyphens.
    parent: Required. The parent resource where this framework audit is
      created. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  frameworkAudit = _messages.MessageField('FrameworkAudit', 1)
  frameworkAuditId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsGetRequest
  object.

  Fields:
    name: Required. The name of the framework audit to retrieve. Supported
      formats are the following: * `organizations/{organization_id}/locations/
      {location}/frameworkAudits/{frameworkAuditName}` * `folders/{folder_id}/
      locations/{location}/frameworkAudits/{frameworkAuditName}` * `projects/{
      project_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsListRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsFrameworkAuditsListRequest
  object.

  Fields:
    filter: Optional. The filters to apply to the framework audits. Supported
      filters are `compliance_framework`, `compliance_state`, `create_time,`
      and `framework_audit_name`. If the filter is invalid, an invalid
      argument error is returned. For syntax details, see AIP-160.
    pageSize: Optional. The maximum number of framework audits to return. The
      service might return fewer audits than this value. If unspecified, a
      maximum of 10 framework audits are returned. The maximum value is 50;
      values above 50 are limited to 50.
    pageToken: Optional. The `next_page_token` value that's returned from a
      previous list request, if any.
    parent: Required. The parent resource where the framework audits are
      listed. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsAggregateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReport
  sAggregateRequest object.

  Fields:
    filter: Optional. The filtering results.
    interval_endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    interval_startTime: Optional. Inclusive start of the interval. If
      specified, a Timestamp matching this interval will have to be the same
      or after the start.
    name: Required. The name of the aggregated compliance report over time to
      retrieve. The supported format is: `organizations/{organization_id}/loca
      tions/{location}/frameworkComplianceReports/{framework_compliance_report
      }`
  """

  filter = _messages.StringField(1)
  interval_endTime = _messages.StringField(2)
  interval_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReport
  sControlComplianceSummariesListRequest object.

  Fields:
    endTime: Optional. The end time of the control compliance summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsFetchRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReport
  sFetchRequest object.

  Fields:
    endTime: Optional. The end time of the report.
    filter: Optional. The filtering results.
    name: Required. The name of the framework compliance report to retrieve.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceSummar
  iesListRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Specifies the level of detail to return in
      the response.

  Fields:
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework compliance summary.
    view: Optional. Specifies the level of detail to return in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the level of detail to return in the response.

    Values:
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED: The default / unset
        value. The API will default to the BASIC view.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC: Includes basic compliance
        metadata, but omits trend data.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL: Includes all information,
        including finding_count and controls_passing_trend. Trend data is
        provided for the last 30 days.
    """
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED = 0
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC = 1
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsCreateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsCreat
  eRequest object.

  Fields:
    frameworkDeployment: A FrameworkDeployment resource to be passed as the
      request body.
    frameworkDeploymentId: Optional. An identifier for the framework
      deployment that's unique in scope of the parent. If you don't specify a
      value, then a random UUID is generated.
    parent: Required. The parent resource of the framework deployment in the
      format `organizations/{organization}/locations/{location}`. Only the
      global location is supported.
  """

  frameworkDeployment = _messages.MessageField('FrameworkDeployment', 1)
  frameworkDeploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsDeleteRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsDelet
  eRequest object.

  Fields:
    etag: Optional. An opaque identifier for the current version of the
      resource. If you provide this value, then it must match the existing
      value. If the values don't match, then the request fails with an
      `ABORTED` error. If you omit this value, then the resource is deleted
      regardless of its current `etag` value.
    name: Required. The name of the framework deployment that you want to
      delete, in the format `organizations/{organization}/locations/{location}
      /frameworkDeployments/{framework_deployment_id}`. The only supported
      location is `global`.
  """

  etag = _messages.StringField(1)
  name = _messages.StringField(2, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsGetRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsGetRequest
  object.

  Fields:
    name: Required. The name of the framework deployment, in the format `organ
      izations/{organization}/locations/{location}/frameworkDeployments/{frame
      work_deployment_id}`. The only supported location is `global`.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsListRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsFrameworkDeploymentsListRequest
  object.

  Fields:
    filter: Optional. The filter to be applied on the resource, as defined by
      [AIP-160: Filtering](https://google.aip.dev/160).
    orderBy: Optional. The sort order for the results. The following values
      are supported: * `name` * `name desc` If you do not specify a value,
      then the results are not sorted.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies a page of results the server
      should return.
    parent: Required. The parent resource of the framework deployment, in the
      format `organizations/{organization}/locations/{location}`. The only
      supported location is `global`.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworksCreateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworksCreateRequest
  object.

  Fields:
    framework: A Framework resource to be passed as the request body.
    frameworkId: Required. The identifier (ID) of the framework. The ID is not
      the full name of the framework; it's the last part of the full name of
      the framework.
    parent: Required. The parent resource name, in the format
      `organizations/{organization}/locations/{location}`. The only supported
      location is `global`.
  """

  framework = _messages.MessageField('Framework', 1)
  frameworkId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworksDeleteRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworksDeleteRequest
  object.

  Fields:
    name: Required. The name of the resource, in the format `organizations/{or
      ganization}/locations/{location}/frameworks/{framework}`. The only
      supported location is `global`.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworksGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworksGetRequest
  object.

  Fields:
    majorRevisionId: Optional. The framework major version to retrieve. If not
      specified, the most recently updated `revision_id` is retrieved.
    name: Required. The name of the framework to retrieve, in the format `orga
      nizations/{organization}/locations/{location}/frameworks/{framework_id}`
      The only supported location is `global`.
  """

  majorRevisionId = _messages.IntegerField(1)
  name = _messages.StringField(2, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworksListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworksListRequest
  object.

  Fields:
    pageSize: Optional. The maximum number of frameworks to return. The
      default value is `500`. If you exceed the maximum value of `1000`, then
      the service uses the maximum value.
    pageToken: Optional. A pagination token returned from a previous request
      to list frameworks. Provide this token to retrieve the next page of
      results.
    parent: Required. The parent resource name, in the format
      `organizations/{organization}/locations/{location}`. The only supported
      location is `global`.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceOrganizationsLocationsFrameworksPatchRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsFrameworksPatchRequest
  object.

  Fields:
    framework: A Framework resource to be passed as the request body.
    majorRevisionId: Optional. The major version ID of the framework to
      update.
    name: Required. Identifier. The name of the framework, in the format `orga
      nizations/{organization}/locations/{location}/frameworks/{framework_id}`
      . The only supported location is `global`.
    updateMask: Optional. A field mask is used to specify the fields to be
      overwritten in the framework resource by the update. The fields
      specified in the `update_mask` are relative to the resource, not the
      full request. A field is overwritten if it is in the mask. If you don't
      provide a mask then all fields present in the request will be
      overwritten.
  """

  framework = _messages.MessageField('Framework', 1)
  majorRevisionId = _messages.IntegerField(2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class CloudsecuritycomplianceOrganizationsLocationsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class CloudsecuritycomplianceOrganizationsLocationsOperationDetailsGetRequest(_messages.Message):
  r"""A
  CloudsecuritycomplianceOrganizationsLocationsOperationDetailsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsOperationsCancelRequest
  object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudsecuritycomplianceOrganizationsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsOperationsDeleteRequest
  object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsOperationsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceOrganizationsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsOperationsListRequest
  object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class CloudsecuritycomplianceOrganizationsLocationsUpdateCmEnrollmentRequest(_messages.Message):
  r"""A CloudsecuritycomplianceOrganizationsLocationsUpdateCmEnrollmentRequest
  object.

  Fields:
    cmEnrollment: A CmEnrollment resource to be passed as the request body.
    name: Identifier. The name of the Compliance Manager enrollment. Supported
      formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
    updateMask: Optional. The list of fields that you want to update.
  """

  cmEnrollment = _messages.MessageField('CmEnrollment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CloudsecuritycomplianceProjectsLocationsCmEnrollmentCalculateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsCmEnrollmentCalculateRequest
  object.

  Fields:
    name: Required. The name of the Compliance Manager enrollment to
      calculate. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceProjectsLocationsFindingSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFindingSummariesListRequest
  object.

  Fields:
    endTime: Optional. The end time of the finding summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkAuditScopeReportsGenerateFrameworkAuditScopeReportRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkAuditScopeReportsGene
  rateFrameworkAuditScopeReportRequest object.

  Fields:
    generateFrameworkAuditScopeReportRequest: A
      GenerateFrameworkAuditScopeReportRequest resource to be passed as the
      request body.
    scope: Required. The organization, folder, or project for the audit
      report. Supported formats are the following: *
      `projects/{project_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `organizations/{organization_id}/locations/{location}`
  """

  generateFrameworkAuditScopeReportRequest = _messages.MessageField('GenerateFrameworkAuditScopeReportRequest', 1)
  scope = _messages.StringField(2, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkAuditsCreateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkAuditsCreateRequest
  object.

  Fields:
    frameworkAudit: A FrameworkAudit resource to be passed as the request
      body.
    frameworkAuditId: Optional. The ID to use for the framework audit. The ID
      becomes the final component of the framework audit's full resource name.
      The ID must be between 4 and 63 characters and can contain lowercase
      letters, numbers, and hyphens.
    parent: Required. The parent resource where this framework audit is
      created. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  frameworkAudit = _messages.MessageField('FrameworkAudit', 1)
  frameworkAuditId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkAuditsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkAuditsGetRequest
  object.

  Fields:
    name: Required. The name of the framework audit to retrieve. Supported
      formats are the following: * `organizations/{organization_id}/locations/
      {location}/frameworkAudits/{frameworkAuditName}` * `folders/{folder_id}/
      locations/{location}/frameworkAudits/{frameworkAuditName}` * `projects/{
      project_id}/locations/{location}/frameworkAudits/{frameworkAuditName}`
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkAuditsListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkAuditsListRequest
  object.

  Fields:
    filter: Optional. The filters to apply to the framework audits. Supported
      filters are `compliance_framework`, `compliance_state`, `create_time,`
      and `framework_audit_name`. If the filter is invalid, an invalid
      argument error is returned. For syntax details, see AIP-160.
    pageSize: Optional. The maximum number of framework audits to return. The
      service might return fewer audits than this value. If unspecified, a
      maximum of 10 framework audits are returned. The maximum value is 50;
      values above 50 are limited to 50.
    pageToken: Optional. The `next_page_token` value that's returned from a
      previous list request, if any.
    parent: Required. The parent resource where the framework audits are
      listed. Supported formats are the following: *
      `organizations/{organization_id}/locations/{location}` *
      `folders/{folder_id}/locations/{location}` *
      `projects/{project_id}/locations/{location}`
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggregateRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggr
  egateRequest object.

  Fields:
    filter: Optional. The filtering results.
    interval_endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    interval_startTime: Optional. Inclusive start of the interval. If
      specified, a Timestamp matching this interval will have to be the same
      or after the start.
    name: Required. The name of the aggregated compliance report over time to
      retrieve. The supported format is: `organizations/{organization_id}/loca
      tions/{location}/frameworkComplianceReports/{framework_compliance_report
      }`
  """

  filter = _messages.StringField(1)
  interval_endTime = _messages.StringField(2)
  interval_startTime = _messages.StringField(3)
  name = _messages.StringField(4, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsControlComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsCont
  rolComplianceSummariesListRequest object.

  Fields:
    endTime: Optional. The end time of the control compliance summary.
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework overview page.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsFetchRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsFetc
  hRequest object.

  Fields:
    endTime: Optional. The end time of the report.
    filter: Optional. The filtering results.
    name: Required. The name of the framework compliance report to retrieve.
  """

  endTime = _messages.StringField(1)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)


class CloudsecuritycomplianceProjectsLocationsFrameworkComplianceSummariesListRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsFrameworkComplianceSummariesLi
  stRequest object.

  Enums:
    ViewValueValuesEnum: Optional. Specifies the level of detail to return in
      the response.

  Fields:
    filter: Optional. The filtering results.
    pageSize: Optional. The requested page size. The server might return fewer
      items than requested. If unspecified, the server picks an appropriate
      default.
    pageToken: Optional. A token that identifies the page of results that the
      server should return.
    parent: Required. The parent scope for the framework compliance summary.
    view: Optional. Specifies the level of detail to return in the response.
  """

  class ViewValueValuesEnum(_messages.Enum):
    r"""Optional. Specifies the level of detail to return in the response.

    Values:
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED: The default / unset
        value. The API will default to the BASIC view.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC: Includes basic compliance
        metadata, but omits trend data.
      FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL: Includes all information,
        including finding_count and controls_passing_trend. Trend data is
        provided for the last 30 days.
    """
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_UNSPECIFIED = 0
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_BASIC = 1
    FRAMEWORK_COMPLIANCE_SUMMARY_VIEW_FULL = 2

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)
  view = _messages.EnumField('ViewValueValuesEnum', 5)


class CloudsecuritycomplianceProjectsLocationsOperationDetailsGetRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsOperationDetailsGetRequest
  object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudsecuritycomplianceProjectsLocationsUpdateCmEnrollmentRequest(_messages.Message):
  r"""A CloudsecuritycomplianceProjectsLocationsUpdateCmEnrollmentRequest
  object.

  Fields:
    cmEnrollment: A CmEnrollment resource to be passed as the request body.
    name: Identifier. The name of the Compliance Manager enrollment. Supported
      formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
    updateMask: Optional. The list of fields that you want to update.
  """

  cmEnrollment = _messages.MessageField('CmEnrollment', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class CmEligibleDestination(_messages.Message):
  r"""The destination details where audit reports are uploaded.

  Fields:
    gcsBucket: The Cloud Storage bucket where audit reports and evidence can
      be uploaded. The format is `gs://{bucket_name}`.
  """

  gcsBucket = _messages.StringField(1)


class CmEnrollment(_messages.Message):
  r"""The settings for Compliance Manager at a specific resource scope.

  Fields:
    auditConfig: Optional. The audit configuration for Compliance Manager. If
      set at a scope, this configuration overrides any inherited audit
      configuration.
    enrolled: Optional. Whether the resource is enrolled in Compliance
      Manager. This setting is inherited by all descendants.
    name: Identifier. The name of the Compliance Manager enrollment. Supported
      formats are the following: *
      `organizations/{organization_id}/locations/{location}/cmEnrollment` *
      `folders/{folder_id}/locations/{location}/cmEnrollment` *
      `projects/{project_id}/locations/{location}/cmEnrollment`
  """

  auditConfig = _messages.MessageField('AuditConfig', 1)
  enrolled = _messages.BooleanField(2)
  name = _messages.StringField(3)


class ControlAssessmentDetails(_messages.Message):
  r"""The details for a control assessment.

  Fields:
    assessedPassingControls: The number of controls that were assessed and are
      passing.
    failingControls: The number of controls that are failing.
    notAssessedControls: The number of controls that aren't assessed because
      they require manual review.
    passingControls: The number of controls that are passing or not assessed.
  """

  assessedPassingControls = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  failingControls = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  notAssessedControls = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  passingControls = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ControlComplianceSummary(_messages.Message):
  r"""The details for control compliance.

  Enums:
    ControlResponsibilityTypeValueValuesEnum: The responsibility type for the
      control.
    OverallEvaluationStateValueValuesEnum: Output only. The overall evaluation
      status of the control.

  Fields:
    cloudControlReports: The list of cloud control reports.
    complianceFrameworks: The list of compliance frameworks that the control
      belongs to.
    control: The name of the control.
    controlResponsibilityType: The responsibility type for the control.
    description: The description of the control.
    displayName: The display name of the control.
    isFakeControl: Whether the control is a fake control. Fake controls are
      created and mapped to cloud controls that don't belong to a control
      group.
    name: Identifier. The name of the control compliance summary.
    overallEvaluationState: Output only. The overall evaluation status of the
      control.
    similarControls: The list of similar controls.
    totalFindingsCount: The total number of findings for the control.
  """

  class ControlResponsibilityTypeValueValuesEnum(_messages.Enum):
    r"""The responsibility type for the control.

    Values:
      REGULATORY_CONTROL_RESPONSIBILITY_TYPE_UNSPECIFIED: Default value. This
        value is unused.
      GOOGLE: Google's responsibility.
      CUSTOMER: Your responsibility.
      SHARED: Shared responsibility.
    """
    REGULATORY_CONTROL_RESPONSIBILITY_TYPE_UNSPECIFIED = 0
    GOOGLE = 1
    CUSTOMER = 2
    SHARED = 3

  class OverallEvaluationStateValueValuesEnum(_messages.Enum):
    r"""Output only. The overall evaluation status of the control.

    Values:
      EVALUATION_STATE_UNSPECIFIED: Default value. This value is unused.
      EVALUATION_STATE_PASSED: The control is passing.
      EVALUATION_STATE_FAILED: The control is failing.
      EVALUATION_STATE_NOT_ASSESSED: The control is not assessed.
    """
    EVALUATION_STATE_UNSPECIFIED = 0
    EVALUATION_STATE_PASSED = 1
    EVALUATION_STATE_FAILED = 2
    EVALUATION_STATE_NOT_ASSESSED = 3

  cloudControlReports = _messages.MessageField('CloudControlReport', 1, repeated=True)
  complianceFrameworks = _messages.StringField(2, repeated=True)
  control = _messages.StringField(3)
  controlResponsibilityType = _messages.EnumField('ControlResponsibilityTypeValueValuesEnum', 4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  isFakeControl = _messages.BooleanField(7)
  name = _messages.StringField(8)
  overallEvaluationState = _messages.EnumField('OverallEvaluationStateValueValuesEnum', 9)
  similarControls = _messages.MessageField('SimilarControls', 10, repeated=True)
  totalFindingsCount = _messages.IntegerField(11, variant=_messages.Variant.INT32)


class ControlFamily(_messages.Message):
  r"""The regulatory family of the control.

  Fields:
    displayName: The friendly name for the regulatory control family.
    familyId: The identifier for the regulatory control family.
  """

  displayName = _messages.StringField(1)
  familyId = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class EvidenceDetails(_messages.Message):
  r"""The evidence details for a finding.

  Fields:
    evidencePath: Output only. The path to the evidence.
    resource: Output only. The resource identifier.
    service: Output only. The service identifier.
  """

  evidencePath = _messages.StringField(1)
  resource = _messages.StringField(2)
  service = _messages.StringField(3)


class FindingDetails(_messages.Message):
  r"""The details for a finding.

  Enums:
    ComplianceStateValueValuesEnum: Output only. The compliance state of the
      finding.

  Fields:
    complianceState: Output only. The compliance state of the finding.
    evidence: Output only. The evidence details for the finding.
    name: Output only. The name of the finding.
    observation: Output only. The observation details for the finding.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""Output only. The compliance state of the finding.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: Default value. This value is unused.
      COMPLIANT: The resource is compliant.
      VIOLATION: The resource has a violation.
      MANUAL_REVIEW_NEEDED: The resource requires manual review from you.
      ERROR: An error occurred while computing the resource status.
      AUDIT_NOT_SUPPORTED: The resource can't be audited.
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    VIOLATION = 2
    MANUAL_REVIEW_NEEDED = 3
    ERROR = 4
    AUDIT_NOT_SUPPORTED = 5

  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 1)
  evidence = _messages.MessageField('EvidenceDetails', 2)
  name = _messages.StringField(3)
  observation = _messages.MessageField('ObservationDetails', 4)


class FindingSummary(_messages.Message):
  r"""The details for a finding.

  Enums:
    FindingClassValueValuesEnum: The class of the finding.
    SeverityValueValuesEnum: The severity of the finding.

  Fields:
    findingCategory: The category of the finding.
    findingClass: The class of the finding.
    findingCount: The count of the finding.
    name: Identifier. The name of the finding summary.
    relatedFrameworks: Optional. The list of compliance frameworks that the
      finding belongs to.
    severity: The severity of the finding.
    updateTime: Output only. The last updated time of the finding.
  """

  class FindingClassValueValuesEnum(_messages.Enum):
    r"""The class of the finding.

    Values:
      FINDING_CLASS_UNSPECIFIED: Default value. This value is unused.
      THREAT: The activity is unwanted or malicious.
      VULNERABILITY: A potential weakness in software that increases risk to
        confidentiality, integrity, and availability.
      MISCONFIGURATION: A potential weakness in a cloud resource or asset
        configuration that increases risk.
      OBSERVATION: A security observation that is for informational purposes.
      SCC_ERROR: An error that prevents Security Command Center from
        functioning properly.
      POSTURE_VIOLATION: A potential security risk that's due to a change in
        the security posture.
      TOXIC_COMBINATION: A combination of security issues that represent a
        more severe security problem when taken together.
      SENSITIVE_DATA_RISK: A potential security risk to data assets that
        contain sensitive data.
      CHOKEPOINT: A resource or resource group where high risk attack paths
        converge, based on attack path simulations (APS).
    """
    FINDING_CLASS_UNSPECIFIED = 0
    THREAT = 1
    VULNERABILITY = 2
    MISCONFIGURATION = 3
    OBSERVATION = 4
    SCC_ERROR = 5
    POSTURE_VIOLATION = 6
    TOXIC_COMBINATION = 7
    SENSITIVE_DATA_RISK = 8
    CHOKEPOINT = 9

  class SeverityValueValuesEnum(_messages.Enum):
    r"""The severity of the finding.

    Values:
      SEVERITY_UNSPECIFIED: Default value. This value is unused.
      CRITICAL: A critical vulnerability is easily discoverable by an external
        actor, exploitable, and results in the direct ability to execute
        arbitrary code, exfiltrate data, and otherwise gain additional access
        and privileges to cloud resources and workloads. Examples include
        publicly accessible unprotected user data and public SSH access with
        weak or no passwords. A critical threat is a threat that can access,
        modify, or delete data or execute unauthorized code within existing
        resources.
      HIGH: A high-risk vulnerability can be easily discovered and exploited
        in combination with other vulnerabilities to gain direct access and
        the ability to execute arbitrary code, exfiltrate data, and otherwise
        gain additional access and privileges to cloud resources and
        workloads. An example is a database with weak or no passwords that is
        only accessible internally. This database could easily be compromised
        by an actor that had access to the internal network. A high-risk
        threat is a threat that can create new computational resources in an
        environment but can't access data or execute code in existing
        resources.
      MEDIUM: A medium-risk vulnerability can be used by an actor to gain
        access to resources or privileges that enable them to eventually
        (through multiple steps or a complex exploit) gain access and the
        ability to execute arbitrary code or exfiltrate data. An example is a
        service account with access to more projects than it should have. If
        an actor gains access to the service account, they could potentially
        use that access to manipulate a project the service account was not
        intended to. A medium-risk threat can cause operational impact but
        might not access data or execute unauthorized code.
      LOW: A low-risk vulnerability hampers a security organization's ability
        to detect vulnerabilities or active threats in their deployment, or
        prevents the root cause investigation of security issues. An example
        is monitoring and logs being disabled for resource configurations and
        access. A low-risk threat is a threat that has obtained minimal access
        to an environment but can't access data, execute code, or create
        resources.
    """
    SEVERITY_UNSPECIFIED = 0
    CRITICAL = 1
    HIGH = 2
    MEDIUM = 3
    LOW = 4

  findingCategory = _messages.StringField(1)
  findingClass = _messages.EnumField('FindingClassValueValuesEnum', 2)
  findingCount = _messages.IntegerField(3)
  name = _messages.StringField(4)
  relatedFrameworks = _messages.StringField(5, repeated=True)
  severity = _messages.EnumField('SeverityValueValuesEnum', 6)
  updateTime = _messages.StringField(7)


class FolderCreationConfig(_messages.Message):
  r"""The configuration that's required to create a folder to be used as the
  target resource for a deployment.

  Fields:
    folderDisplayName: Required. The display name of the folder.
    parent: Required. The parent of the folder, in the format
      `organizations/{organizationID}` or `folders/{folderID}`.
  """

  folderDisplayName = _messages.StringField(1)
  parent = _messages.StringField(2)


class Framework(_messages.Message):
  r"""A framework is a collection of cloud controls and regulatory controls
  that represent security best practices or industry-defined standards such as
  FedRAMP or NIST.

  Enums:
    CategoryValueListEntryValuesEnum:
    SupportedCloudProvidersValueListEntryValuesEnum:
    SupportedEnforcementModesValueListEntryValuesEnum:
    SupportedTargetResourceTypesValueListEntryValuesEnum:
    TypeValueValuesEnum: Output only. The type of framework.

  Fields:
    category: Optional. The category of the framework.
    cloudControlDetails: Optional. The cloud control details that are directly
      added without any grouping in the framework.
    description: Optional. The description of the framework. The maximum
      length is 2000 characters.
    displayName: Optional. The friendly name of the framework. The maximum
      length is 200 characters.
    majorRevisionId: Output only. The major version of the framework, which is
      incremented in ascending order.
    name: Required. Identifier. The name of the framework, in the format `orga
      nizations/{organization}/locations/{location}/frameworks/{framework_id}`
      . The only supported location is `global`.
    supportedCloudProviders: Output only. The cloud providers that are
      supported by the framework.
    supportedEnforcementModes: Output only. The supported enforcement modes of
      the framework.
    supportedTargetResourceTypes: Output only. The target resource types that
      are supported by the framework.
    type: Output only. The type of framework.
  """

  class CategoryValueListEntryValuesEnum(_messages.Enum):
    r"""CategoryValueListEntryValuesEnum enum type.

    Values:
      FRAMEWORK_CATEGORY_UNSPECIFIED: Default value. This value is unused.
      INDUSTRY_DEFINED_STANDARD: An industry-defined framework.
      ASSURED_WORKLOADS: An Assured Workloads framework.
      DATA_SECURITY: A data security posture framework.
      GOOGLE_BEST_PRACTICES: A Google's best practices framework.
      CUSTOM_FRAMEWORK: A user-created framework.
    """
    FRAMEWORK_CATEGORY_UNSPECIFIED = 0
    INDUSTRY_DEFINED_STANDARD = 1
    ASSURED_WORKLOADS = 2
    DATA_SECURITY = 3
    GOOGLE_BEST_PRACTICES = 4
    CUSTOM_FRAMEWORK = 5

  class SupportedCloudProvidersValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedCloudProvidersValueListEntryValuesEnum enum type.

    Values:
      CLOUD_PROVIDER_UNSPECIFIED: Default value. This value is unused.
      AWS: Amazon Web Services (AWS).
      AZURE: Microsoft Azure.
      GCP: Google Cloud.
    """
    CLOUD_PROVIDER_UNSPECIFIED = 0
    AWS = 1
    AZURE = 2
    GCP = 3

  class SupportedEnforcementModesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedEnforcementModesValueListEntryValuesEnum enum type.

    Values:
      ENFORCEMENT_MODE_UNSPECIFIED: Default value. This value is unused.
      PREVENTIVE: The cloud control is enforced to prevent non-compliance.
      DETECTIVE: The cloud control is enforced to detect non-compliance.
      AUDIT: The cloud control is enforced to audit for non-compliance.
    """
    ENFORCEMENT_MODE_UNSPECIFIED = 0
    PREVENTIVE = 1
    DETECTIVE = 2
    AUDIT = 3

  class SupportedTargetResourceTypesValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedTargetResourceTypesValueListEntryValuesEnum enum type.

    Values:
      TARGET_RESOURCE_TYPE_UNSPECIFIED: Default value. This value is unused.
      TARGET_RESOURCE_CRM_TYPE_ORG: The target resource is a Google Cloud
        organization.
      TARGET_RESOURCE_CRM_TYPE_FOLDER: The target resource is a folder.
      TARGET_RESOURCE_CRM_TYPE_PROJECT: The target resource is a project.
      TARGET_RESOURCE_TYPE_APPLICATION: The target resource is an application
        in App Hub.
    """
    TARGET_RESOURCE_TYPE_UNSPECIFIED = 0
    TARGET_RESOURCE_CRM_TYPE_ORG = 1
    TARGET_RESOURCE_CRM_TYPE_FOLDER = 2
    TARGET_RESOURCE_CRM_TYPE_PROJECT = 3
    TARGET_RESOURCE_TYPE_APPLICATION = 4

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of framework.

    Values:
      FRAMEWORK_TYPE_UNSPECIFIED: Default value. This value is unused.
      BUILT_IN: A framework that's provided and managed by Google.
      CUSTOM: A framework that's created and managed by you.
    """
    FRAMEWORK_TYPE_UNSPECIFIED = 0
    BUILT_IN = 1
    CUSTOM = 2

  category = _messages.EnumField('CategoryValueListEntryValuesEnum', 1, repeated=True)
  cloudControlDetails = _messages.MessageField('CloudControlDetails', 2, repeated=True)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  majorRevisionId = _messages.IntegerField(5)
  name = _messages.StringField(6)
  supportedCloudProviders = _messages.EnumField('SupportedCloudProvidersValueListEntryValuesEnum', 7, repeated=True)
  supportedEnforcementModes = _messages.EnumField('SupportedEnforcementModesValueListEntryValuesEnum', 8, repeated=True)
  supportedTargetResourceTypes = _messages.EnumField('SupportedTargetResourceTypesValueListEntryValuesEnum', 9, repeated=True)
  type = _messages.EnumField('TypeValueValuesEnum', 10)


class FrameworkAudit(_messages.Message):
  r"""A framework audit.

  Enums:
    ComplianceStateValueValuesEnum: Output only. The overall compliance state
      of the audit.
    StateValueValuesEnum: Output only. The framework audit state of the audit.

  Fields:
    cloudControlAuditDetails: Optional. The details for the cloud controls
      within this audit.
    cloudControlGroupAuditDetails: Optional. The details for the cloud control
      groups within this audit.
    complianceFramework: Output only. The compliance framework used for the
      audit.
    complianceState: Output only. The overall compliance state of the audit.
    finishTime: Output only. The time that the audit finished.
    frameworkAuditDestination: Required. The destination for the audit
      reports.
    frameworkAuditId: Output only. The ID of the framework audit.
    name: Output only. Identifier. The name of the framework audit.
    operationId: Output only. The ID of the long-running operation.
    reportSummary: Output only. The summary of the report.
    scope: Output only. The scope of the audit.
    startTime: Output only. The time that the audit started.
    state: Output only. The framework audit state of the audit.
  """

  class ComplianceStateValueValuesEnum(_messages.Enum):
    r"""Output only. The overall compliance state of the audit.

    Values:
      COMPLIANCE_STATE_UNSPECIFIED: Default value. This value is unused.
      COMPLIANT: The resource is compliant.
      VIOLATION: The resource has a violation.
      MANUAL_REVIEW_NEEDED: The resource requires manual review from you.
      ERROR: An error occurred while computing the resource status.
      AUDIT_NOT_SUPPORTED: The resource can't be audited.
    """
    COMPLIANCE_STATE_UNSPECIFIED = 0
    COMPLIANT = 1
    VIOLATION = 2
    MANUAL_REVIEW_NEEDED = 3
    ERROR = 4
    AUDIT_NOT_SUPPORTED = 5

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The framework audit state of the audit.

    Values:
      STATE_UNSPECIFIED: Default value. This value is unused.
      SCHEDULED: The audit is scheduled.
      RUNNING: The audit is running.
      UPLOADING: The audit results are being uploaded.
      FAILED: The audit failed.
      SUCCEEDED: The audit completed successfully.
    """
    STATE_UNSPECIFIED = 0
    SCHEDULED = 1
    RUNNING = 2
    UPLOADING = 3
    FAILED = 4
    SUCCEEDED = 5

  cloudControlAuditDetails = _messages.MessageField('CloudControlAuditDetails', 1, repeated=True)
  cloudControlGroupAuditDetails = _messages.MessageField('CloudControlGroupAuditDetails', 2, repeated=True)
  complianceFramework = _messages.StringField(3)
  complianceState = _messages.EnumField('ComplianceStateValueValuesEnum', 4)
  finishTime = _messages.StringField(5)
  frameworkAuditDestination = _messages.MessageField('FrameworkAuditDestination', 6)
  frameworkAuditId = _messages.StringField(7)
  name = _messages.StringField(8)
  operationId = _messages.StringField(9)
  reportSummary = _messages.MessageField('ReportSummary', 10)
  scope = _messages.StringField(11)
  startTime = _messages.StringField(12)
  state = _messages.EnumField('StateValueValuesEnum', 13)


class FrameworkAuditDestination(_messages.Message):
  r"""A destination for the framework audit.

  Fields:
    bucket: The Cloud Storage bucket destination.
  """

  bucket = _messages.MessageField('BucketDestination', 1)


class FrameworkComplianceReport(_messages.Message):
  r"""The response message for GetFrameworkComplianceReport.

  Enums:
    FrameworkCategoriesValueListEntryValuesEnum:
    FrameworkTypeValueValuesEnum: The type of framework.
    SupportedCloudProvidersValueListEntryValuesEnum:

  Fields:
    controlAssessmentDetails: The control assessment details of the framework.
    framework: The name of the framework.
    frameworkCategories: The list of framework categories supported.
    frameworkDescription: The description of the framework.
    frameworkDisplayName: Optional. The display name for the framework.
    frameworkType: The type of framework.
    majorRevisionId: The latest major revision ID of the framework.
    minorRevisionId: The latest minor revision ID of the latest major revision
      of the framework.
    name: Identifier. The name of the framework compliance report.
    supportedCloudProviders: The list of cloud providers supported by the
      framework.
    targetResourceDetails: The target resource details of the framework.
    updateTime: Output only. The last updated time of the report.
  """

  class FrameworkCategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""FrameworkCategoriesValueListEntryValuesEnum enum type.

    Values:
      FRAMEWORK_CATEGORY_UNSPECIFIED: Default value. This value is unused.
      INDUSTRY_DEFINED_STANDARD: An industry-defined framework.
      ASSURED_WORKLOADS: An Assured Workloads framework.
      DATA_SECURITY: A data security posture framework.
      GOOGLE_BEST_PRACTICES: A Google's best practices framework.
      CUSTOM_FRAMEWORK: A user-created framework.
    """
    FRAMEWORK_CATEGORY_UNSPECIFIED = 0
    INDUSTRY_DEFINED_STANDARD = 1
    ASSURED_WORKLOADS = 2
    DATA_SECURITY = 3
    GOOGLE_BEST_PRACTICES = 4
    CUSTOM_FRAMEWORK = 5

  class FrameworkTypeValueValuesEnum(_messages.Enum):
    r"""The type of framework.

    Values:
      FRAMEWORK_TYPE_UNSPECIFIED: Default value. This value is unused.
      BUILT_IN: A framework that's provided and managed by Google.
      CUSTOM: A framework that's created and managed by you.
    """
    FRAMEWORK_TYPE_UNSPECIFIED = 0
    BUILT_IN = 1
    CUSTOM = 2

  class SupportedCloudProvidersValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedCloudProvidersValueListEntryValuesEnum enum type.

    Values:
      CLOUD_PROVIDER_UNSPECIFIED: Default value. This value is unused.
      AWS: Amazon Web Services (AWS).
      AZURE: Microsoft Azure.
      GCP: Google Cloud.
    """
    CLOUD_PROVIDER_UNSPECIFIED = 0
    AWS = 1
    AZURE = 2
    GCP = 3

  controlAssessmentDetails = _messages.MessageField('ControlAssessmentDetails', 1)
  framework = _messages.StringField(2)
  frameworkCategories = _messages.EnumField('FrameworkCategoriesValueListEntryValuesEnum', 3, repeated=True)
  frameworkDescription = _messages.StringField(4)
  frameworkDisplayName = _messages.StringField(5)
  frameworkType = _messages.EnumField('FrameworkTypeValueValuesEnum', 6)
  majorRevisionId = _messages.IntegerField(7)
  minorRevisionId = _messages.IntegerField(8)
  name = _messages.StringField(9)
  supportedCloudProviders = _messages.EnumField('SupportedCloudProvidersValueListEntryValuesEnum', 10, repeated=True)
  targetResourceDetails = _messages.MessageField('TargetResourceDetails', 11, repeated=True)
  updateTime = _messages.StringField(12)


class FrameworkComplianceSummary(_messages.Message):
  r"""The details for a framework compliance summary.

  Enums:
    FrameworkCategoriesValueListEntryValuesEnum:
    FrameworkTypeValueValuesEnum: The type of framework.
    SupportedCloudProvidersValueListEntryValuesEnum:

  Fields:
    controlAssessmentDetails: The control assessment details of the framework.
    controlsPassingTrend: Output only. The trend of controls that are passing
      for the given duration.
    findingCount: Output only. The count of the findings generated against the
      framework.
    framework: The name of the framework.
    frameworkCategories: The list of framework categories supported by the
      framework.
    frameworkDisplayName: Optional. The display name for the framework.
    frameworkType: The type of framework.
    majorRevisionId: The major revision ID of the framework.
    minorRevisionId: The minor revision ID of the framework.
    name: Identifier. The name of the framework compliance summary.
    supportedCloudProviders: The list of cloud providers supported by the
      framework.
    targetResourceDetails: The target resource details for the framework.
  """

  class FrameworkCategoriesValueListEntryValuesEnum(_messages.Enum):
    r"""FrameworkCategoriesValueListEntryValuesEnum enum type.

    Values:
      FRAMEWORK_CATEGORY_UNSPECIFIED: Default value. This value is unused.
      INDUSTRY_DEFINED_STANDARD: An industry-defined framework.
      ASSURED_WORKLOADS: An Assured Workloads framework.
      DATA_SECURITY: A data security posture framework.
      GOOGLE_BEST_PRACTICES: A Google's best practices framework.
      CUSTOM_FRAMEWORK: A user-created framework.
    """
    FRAMEWORK_CATEGORY_UNSPECIFIED = 0
    INDUSTRY_DEFINED_STANDARD = 1
    ASSURED_WORKLOADS = 2
    DATA_SECURITY = 3
    GOOGLE_BEST_PRACTICES = 4
    CUSTOM_FRAMEWORK = 5

  class FrameworkTypeValueValuesEnum(_messages.Enum):
    r"""The type of framework.

    Values:
      FRAMEWORK_TYPE_UNSPECIFIED: Default value. This value is unused.
      BUILT_IN: A framework that's provided and managed by Google.
      CUSTOM: A framework that's created and managed by you.
    """
    FRAMEWORK_TYPE_UNSPECIFIED = 0
    BUILT_IN = 1
    CUSTOM = 2

  class SupportedCloudProvidersValueListEntryValuesEnum(_messages.Enum):
    r"""SupportedCloudProvidersValueListEntryValuesEnum enum type.

    Values:
      CLOUD_PROVIDER_UNSPECIFIED: Default value. This value is unused.
      AWS: Amazon Web Services (AWS).
      AZURE: Microsoft Azure.
      GCP: Google Cloud.
    """
    CLOUD_PROVIDER_UNSPECIFIED = 0
    AWS = 1
    AZURE = 2
    GCP = 3

  controlAssessmentDetails = _messages.MessageField('ControlAssessmentDetails', 1)
  controlsPassingTrend = _messages.MessageField('Trend', 2)
  findingCount = _messages.IntegerField(3)
  framework = _messages.StringField(4)
  frameworkCategories = _messages.EnumField('FrameworkCategoriesValueListEntryValuesEnum', 5, repeated=True)
  frameworkDisplayName = _messages.StringField(6)
  frameworkType = _messages.EnumField('FrameworkTypeValueValuesEnum', 7)
  majorRevisionId = _messages.IntegerField(8)
  minorRevisionId = _messages.IntegerField(9)
  name = _messages.StringField(10)
  supportedCloudProviders = _messages.EnumField('SupportedCloudProvidersValueListEntryValuesEnum', 11, repeated=True)
  targetResourceDetails = _messages.MessageField('TargetResourceDetails', 12, repeated=True)


class FrameworkDeployment(_messages.Message):
  r"""Framework deployments represent the assignment of a framework to a
  target resource. Supported target resources are organizations, folders, and
  projects.

  Enums:
    DeploymentStateValueValuesEnum: Output only. The state for the framework
      deployment.

  Fields:
    cloudControlDeploymentReferences: Output only. The references to the cloud
      control deployments. The reference includes all the cloud control
      deployments that are in the framework or in a cloud control group. For
      example, if a framework deployment deploys two cloud controls, `cc-
      deployment-1` and `cc-deployment-2`, then the references are: ``` {
      cloud_control_deployment_reference: { cloud_control_deployment: "organiz
      ations/{organization}/locations/{location}/cloudControlDeployments/cc-
      deployment-1" }, cloud_control_deployment_reference: {
      cloud_control_deployment: "organizations/{organization}/locations/{locat
      ion}/cloudControlDeployments/cc-deployment-2" } ```
    cloudControlMetadata: Required. The deployment mode and parameters for
      each of the cloud controls in the framework. Every cloud control in the
      framework includes metadata.
    computedTargetResource: Output only. The target resource to deploy the
      framework to, in one the following formats: -
      `organizations/{organizationID}` - `folders/{folderID}` -
      `projects/{projectID}`
    createTime: Output only. The time at which the resource was created.
    deploymentState: Output only. The state for the framework deployment.
    description: Optional. A user-provided description of the framework
      deployment.
    etag: Optional. To prevent concurrent updates from overwriting each other,
      always provide the `etag` when you update a framework deployment. You
      can also provide the `etag` when you delete a framework deployment, to
      help ensure that you're deleting the intended version of the framework
      deployment.
    framework: Required. A reference to the framework that you're deploying.
    name: Identifier. The name of the framework deployment, in the format `org
      anizations/{organization}/locations/{location}/frameworkDeployments/{fra
      mework_deployment_id}`. The only supported location is `global`.
    targetResourceConfig: Required. The details of the target resource that
      you want to deploy the framework to. You can specify an existing
      resource, or create a new one.
    targetResourceDisplayName: Output only. The display name of the target
      resource.
    updateTime: Output only. The time at which the resource last updated.
  """

  class DeploymentStateValueValuesEnum(_messages.Enum):
    r"""Output only. The state for the framework deployment.

    Values:
      DEPLOYMENT_STATE_UNSPECIFIED: Default value. This value is unused.
      DEPLOYMENT_STATE_VALIDATING: Validating the deployment.
      DEPLOYMENT_STATE_CREATING: Deployment is being created.
      DEPLOYMENT_STATE_DELETING: Deployment is being deleted.
      DEPLOYMENT_STATE_FAILED: Deployment has failed. All the changes made by
        the deployment were successfully rolled back. You can retry or delete
        a deployment that's in this state.
      DEPLOYMENT_STATE_READY: Deployment is successful and ready to use.
      DEPLOYMENT_STATE_PARTIALLY_DEPLOYED: Deployment is partially deployed.
        All the cloud controls weren't deployed successfully. Retrying the
        operation resumes from the first failed step.
      DEPLOYMENT_STATE_PARTIALLY_DELETED: Deployment is partially deleted. All
        the cloud control deployments weren't deleted successfully. Retrying
        the operation resumes from the first failed step.
    """
    DEPLOYMENT_STATE_UNSPECIFIED = 0
    DEPLOYMENT_STATE_VALIDATING = 1
    DEPLOYMENT_STATE_CREATING = 2
    DEPLOYMENT_STATE_DELETING = 3
    DEPLOYMENT_STATE_FAILED = 4
    DEPLOYMENT_STATE_READY = 5
    DEPLOYMENT_STATE_PARTIALLY_DEPLOYED = 6
    DEPLOYMENT_STATE_PARTIALLY_DELETED = 7

  cloudControlDeploymentReferences = _messages.MessageField('CloudControlDeploymentReference', 1, repeated=True)
  cloudControlMetadata = _messages.MessageField('CloudControlMetadata', 2, repeated=True)
  computedTargetResource = _messages.StringField(3)
  createTime = _messages.StringField(4)
  deploymentState = _messages.EnumField('DeploymentStateValueValuesEnum', 5)
  description = _messages.StringField(6)
  etag = _messages.StringField(7)
  framework = _messages.MessageField('FrameworkReference', 8)
  name = _messages.StringField(9)
  targetResourceConfig = _messages.MessageField('TargetResourceConfig', 10)
  targetResourceDisplayName = _messages.StringField(11)
  updateTime = _messages.StringField(12)


class FrameworkDeploymentReference(_messages.Message):
  r"""The reference to a framework deployment.

  Fields:
    frameworkDeployment: Output only. The name of the framework deployment, in
      the format `organizations/{org}/locations/{location}/frameworkDeployment
      s/{framework_deployment_id}`. The only supported location is `global`.
    frameworkDisplayName: Optional. The display name of the framework that
      this framework deployment is for.
    frameworkReference: Optional. The reference to the framework that this
      deployment is for. For example: ``` { framework:
      "organizations/{org}/locations/{location}/frameworks/{framework}",
      major_revision_id: 1 } ``` The only supported location is `global`.
  """

  frameworkDeployment = _messages.StringField(1)
  frameworkDisplayName = _messages.StringField(2)
  frameworkReference = _messages.MessageField('FrameworkReference', 3)


class FrameworkReference(_messages.Message):
  r"""The reference of a framework, in the format
  `organizations/{organization}/locations/{location}/frameworks/{framework}`.
  The only supported location is `global`.

  Fields:
    framework: Required. The major version of the framework. If not specified,
      the version corresponds to the latest version of the framework.
    majorRevisionId: Optional. The major version of the framework. If not
      specified, the version corresponds to the latest version of the
      framework.
  """

  framework = _messages.StringField(1)
  majorRevisionId = _messages.IntegerField(2)


class GenerateFrameworkAuditScopeReportRequest(_messages.Message):
  r"""The request message for GenerateFrameworkAuditScopeReport.

  Enums:
    ReportFormatValueValuesEnum: Required. The format that the scope report is
      returned in.

  Fields:
    complianceFramework: Required. The compliance framework that the scope
      report is generated for.
    reportFormat: Required. The format that the scope report is returned in.
  """

  class ReportFormatValueValuesEnum(_messages.Enum):
    r"""Required. The format that the scope report is returned in.

    Values:
      FORMAT_UNSPECIFIED: Default value. This value is unused.
      ODF: The report format is the Open Document Format (ODF).
    """
    FORMAT_UNSPECIFIED = 0
    ODF = 1

  complianceFramework = _messages.StringField(1)
  reportFormat = _messages.EnumField('ReportFormatValueValuesEnum', 2)


class GenerateFrameworkAuditScopeReportResponse(_messages.Message):
  r"""The response message for GenerateFrameworkAuditScopeReport.

  Fields:
    complianceFramework: Required. The compliance framework that the audit
      scope report is generated for.
    name: Identifier. The name of the audit report, in the format that was
      given in the request.
    scopeReportContents: The audit scope report content in byte format.
  """

  complianceFramework = _messages.StringField(1)
  name = _messages.StringField(2)
  scopeReportContents = _messages.BytesField(3)


class IntRange(_messages.Message):
  r"""The number range for number parameters.

  Fields:
    max: Required. The maximum permitted value for the numeric parameter
      (inclusive).
    min: Required. The minimum permitted value for the numeric parameter
      (inclusive).
  """

  max = _messages.IntegerField(1)
  min = _messages.IntegerField(2)


class ListCloudControlDeploymentsResponse(_messages.Message):
  r"""The response message for ListCloudControlDeployments.

  Fields:
    cloudControlDeployments: The list of cloud control deployments.
    nextPageToken: A token that identifies the next page of results that the
      server should return.
  """

  cloudControlDeployments = _messages.MessageField('CloudControlDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCloudControlsResponse(_messages.Message):
  r"""The response message for ListCloudControls.

  Fields:
    cloudControls: The list of CloudControl resources.
    nextPageToken: A pagination token. To retrieve the next page of results,
      call the method again with this token.
  """

  cloudControls = _messages.MessageField('CloudControl', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListControlComplianceSummariesResponse(_messages.Message):
  r"""The response message for ListControlComplianceSummaries.

  Fields:
    controlComplianceSummaries: The list of control compliance details.
    nextPageToken: Output only. The token to retrieve the next page of
      results.
  """

  controlComplianceSummaries = _messages.MessageField('ControlComplianceSummary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFindingSummariesResponse(_messages.Message):
  r"""The response message for ListFindingSummaries.

  Fields:
    findingSummaries: List of finding summary by category.
    nextPageToken: Output only. The token to retrieve the next page of
      results.
  """

  findingSummaries = _messages.MessageField('FindingSummary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFrameworkAuditsResponse(_messages.Message):
  r"""The response message for ListFrameworkAudits.

  Fields:
    frameworkAudits: The framework audits.
    nextPageToken: A token, which you can send as the `page_token` to retrieve
      the next page. If this field is omitted, there are no subsequent pages.
  """

  frameworkAudits = _messages.MessageField('FrameworkAudit', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFrameworkComplianceSummariesResponse(_messages.Message):
  r"""The response message for ListFrameworkComplianceSummariesResponse.

  Fields:
    frameworkComplianceSummaries: The list of framework compliance summaries.
    nextPageToken: Output only. The token to retrieve the next page of
      results.
  """

  frameworkComplianceSummaries = _messages.MessageField('FrameworkComplianceSummary', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFrameworkDeploymentsResponse(_messages.Message):
  r"""The response message for ListFrameworkDeployments.

  Fields:
    frameworkDeployments: The list of framework deployments.
    nextPageToken: A token that identifies the next page of results that the
      server should return.
  """

  frameworkDeployments = _messages.MessageField('FrameworkDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListFrameworksResponse(_messages.Message):
  r"""The response message for ListFrameworks. Returns a paginated list of
  Framework resources.

  Fields:
    frameworks: The list of framework resources.
    nextPageToken: A pagination token. To retrieve the next page of results,
      call the method again with this token.
  """

  frameworks = _messages.MessageField('Framework', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class ManualCloudControlAssessmentDetails(_messages.Message):
  r"""The details for a manual cloud control assessment.

  Fields:
    manualCloudControlGuide: The guide for assessing a cloud control manually.
  """

  manualCloudControlGuide = _messages.StringField(1, repeated=True)


class ObservationDetails(_messages.Message):
  r"""The observation details for a finding.

  Fields:
    currentValue: Output only. The current value.
    expectedValue: Optional. The expected value.
    guidance: Output only. Any guidance for the observation.
  """

  currentValue = _messages.StringField(1)
  expectedValue = _messages.StringField(2)
  guidance = _messages.StringField(3)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class ParamValue(_messages.Message):
  r"""The possible parameter value types.

  Fields:
    boolValue: A boolean value.
    numberValue: A double value.
    oneofValue: Sub-parameter values.
    stringListValue: A repeated string.
    stringValue: A string value.
  """

  boolValue = _messages.BooleanField(1)
  numberValue = _messages.FloatField(2)
  oneofValue = _messages.MessageField('Parameter', 3)
  stringListValue = _messages.MessageField('StringList', 4)
  stringValue = _messages.StringField(5)


class Parameter(_messages.Message):
  r"""Parameters are key-value pairs that let you provide your custom location
  requirements, environment requirements, or other settings that are relevant
  to the cloud control.

  Fields:
    name: Required. The name or key of the parameter.
    parameterValue: Required. The value of the parameter.
  """

  name = _messages.StringField(1)
  parameterValue = _messages.MessageField('ParamValue', 2)


class ParameterSpec(_messages.Message):
  r"""The parameter specification for the cloud control.

  Enums:
    ValueTypeValueValuesEnum: Required. The parameter value type.

  Fields:
    defaultValue: Optional. The default value of the parameter.
    description: Optional. The description of the parameter. The maximum
      length is 2000 characters.
    displayName: Optional. The friendly name of the parameter. The maximum
      length is 200 characters.
    isRequired: Required. Whether the parameter is required.
    name: Required. The name of the parameter.
    subParameters: Optional. The parameter specification for `oneOf`
      attributes.
    substitutionRules: Optional. The list of parameter substitutions.
    validation: Optional. The permitted set of values for the parameter.
    valueType: Required. The parameter value type.
  """

  class ValueTypeValueValuesEnum(_messages.Enum):
    r"""Required. The parameter value type.

    Values:
      VALUE_TYPE_UNSPECIFIED: Default value. This value is unused.
      STRING: A string value.
      BOOLEAN: A boolean value.
      STRINGLIST: A string list value.
      NUMBER: A numeric value.
      ONEOF: A oneOf value.
    """
    VALUE_TYPE_UNSPECIFIED = 0
    STRING = 1
    BOOLEAN = 2
    STRINGLIST = 3
    NUMBER = 4
    ONEOF = 5

  defaultValue = _messages.MessageField('ParamValue', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  isRequired = _messages.BooleanField(4)
  name = _messages.StringField(5)
  subParameters = _messages.MessageField('ParameterSpec', 6, repeated=True)
  substitutionRules = _messages.MessageField('ParameterSubstitutionRule', 7, repeated=True)
  validation = _messages.MessageField('Validation', 8)
  valueType = _messages.EnumField('ValueTypeValueValuesEnum', 9)


class ParameterSubstitutionRule(_messages.Message):
  r"""The parameter substitution rules.

  Fields:
    attributeSubstitutionRule: The attribute substitution rule.
    placeholderSubstitutionRule: The placeholder substitution rule.
  """

  attributeSubstitutionRule = _messages.MessageField('AttributeSubstitutionRule', 1)
  placeholderSubstitutionRule = _messages.MessageField('PlaceholderSubstitutionRule', 2)


class PlaceholderSubstitutionRule(_messages.Message):
  r"""The placeholder that's substituted in the rendered string.

  Fields:
    attribute: The fully qualified proto attribute path, in dot notation.
  """

  attribute = _messages.StringField(1)


class ProjectCreationConfig(_messages.Message):
  r"""The configuration that's required to create a project to be used as the
  target resource of a deployment.

  Fields:
    billingAccountId: Required. The billing account ID for the project.
    parent: Required. The parent of the project, in the format
      `organizations/{organizationID}` or `folders/{folderID}`.
    projectDisplayName: Required. The display name of the project.
  """

  billingAccountId = _messages.StringField(1)
  parent = _messages.StringField(2)
  projectDisplayName = _messages.StringField(3)


class RegexpPattern(_messages.Message):
  r"""The regular expression (regex) validator for parameter values.

  Fields:
    pattern: Required. The regex pattern to match the values of the parameter
      with.
  """

  pattern = _messages.StringField(1)


class ReportSummary(_messages.Message):
  r"""Additional information for an audit operation.

  Fields:
    compliantCount: Output only. The number of compliant checks.
    errorCount: Output only. The number of checks that can't be performed due
      to errors.
    manualReviewNeededCount: Output only. The number of checks with "manual
      review needed" status.
    totalCount: Output only. The total number of checks.
    violationCount: Output only. The number of checks with violations.
  """

  compliantCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  errorCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  manualReviewNeededCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  totalCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  violationCount = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class Rule(_messages.Message):
  r"""A rule in the cloud control.

  Enums:
    RuleActionTypesValueListEntryValuesEnum:

  Fields:
    celExpression: The rule's logic expression in Common Expression Language
      (CEL).
    description: Optional. The rule description. The maximum length is 2000
      characters.
    ruleActionTypes: Required. The functionality that's enabled by the rule.
  """

  class RuleActionTypesValueListEntryValuesEnum(_messages.Enum):
    r"""RuleActionTypesValueListEntryValuesEnum enum type.

    Values:
      RULE_ACTION_TYPE_UNSPECIFIED: Default value. This value is unused.
      RULE_ACTION_TYPE_PREVENTIVE: The rule is intended to prevent non-
        compliance.
      RULE_ACTION_TYPE_DETECTIVE: The rule is intended to detect non-
        compliance.
      RULE_ACTION_TYPE_AUDIT: The rule is intended to audit non-compliance.
    """
    RULE_ACTION_TYPE_UNSPECIFIED = 0
    RULE_ACTION_TYPE_PREVENTIVE = 1
    RULE_ACTION_TYPE_DETECTIVE = 2
    RULE_ACTION_TYPE_AUDIT = 3

  celExpression = _messages.MessageField('CELExpression', 1)
  description = _messages.StringField(2)
  ruleActionTypes = _messages.EnumField('RuleActionTypesValueListEntryValuesEnum', 3, repeated=True)


class SimilarControls(_messages.Message):
  r"""The similar controls.

  Fields:
    controlId: The ID of the control.
    framework: The name of the framework.
  """

  controlId = _messages.StringField(1)
  framework = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringList(_messages.Message):
  r"""A list of strings for the parameter value.

  Fields:
    values: Required. The strings in the list.
  """

  values = _messages.StringField(1, repeated=True)


class TargetResourceConfig(_messages.Message):
  r"""The name of the target resource or the configuration that's required to
  create a new target resource.

  Fields:
    existingTargetResource: Optional. The resource hierarchy node, in one of
      the following formats: - `organizations/{organizationID}` -
      `folders/{folderID}` - `projects/{projectID}`
    targetResourceCreationConfig: Optional. The details that are required to
      create a resource and use that resource as the target resource for
      deployment.
  """

  existingTargetResource = _messages.StringField(1)
  targetResourceCreationConfig = _messages.MessageField('TargetResourceCreationConfig', 2)


class TargetResourceCreationConfig(_messages.Message):
  r"""The configuration that's required to create a target resource.

  Fields:
    folderCreationConfig: Optional. The configuration that's required to
      create a folder.
    projectCreationConfig: Optional. The configuration that's required to
      create a project.
  """

  folderCreationConfig = _messages.MessageField('FolderCreationConfig', 1)
  projectCreationConfig = _messages.MessageField('ProjectCreationConfig', 2)


class TargetResourceDetails(_messages.Message):
  r"""The details for a target resource.

  Fields:
    createTime: The create time of the target resource.
    frameworkDeployment: The framework deployment name for the target
      resource. For example, `organizations/{organization_id}/locations/{locat
      ion}/frameworkDeployments/{framework_deployment_id}`
    majorRevisionId: The major revision ID of the framework for the target
      resource.
    minorRevisionId: The minor revision ID of the framework for the target
      resource.
    targetResource: The target resource. For example,
      `organizations/1234567890`, `projects/1234567890`, or
      `folders/1234567890`.
    targetResourceDisplayName: The display name of the target resource. For
      example, `google.com`, `staging-project`, or `development-folder`.
    updateTime: The update time of the target resource.
  """

  createTime = _messages.StringField(1)
  frameworkDeployment = _messages.StringField(2)
  majorRevisionId = _messages.IntegerField(3)
  minorRevisionId = _messages.IntegerField(4)
  targetResource = _messages.StringField(5)
  targetResourceDisplayName = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class Trend(_messages.Message):
  r"""The trend of a compliance metric.

  Fields:
    duration: Output only. The duration for the trend.
    valuePercent: Output only. The trend value as a percentage. The value can
      be positive or negative.
  """

  duration = _messages.StringField(1)
  valuePercent = _messages.FloatField(2)


class Validation(_messages.Message):
  r"""The validation of the parameter.

  Fields:
    allowedValues: The permitted set of values for the parameter.
    intRange: The permitted range for numeric parameters.
    regexpPattern: The regular expression for string parameters.
  """

  allowedValues = _messages.MessageField('AllowedValues', 1)
  intRange = _messages.MessageField('IntRange', 2)
  regexpPattern = _messages.MessageField('RegexpPattern', 3)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggregateRequest, 'interval_endTime', 'interval.endTime')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceFoldersLocationsFrameworkComplianceReportsAggregateRequest, 'interval_startTime', 'interval.startTime')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsAggregateRequest, 'interval_endTime', 'interval.endTime')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceOrganizationsLocationsFrameworkComplianceReportsAggregateRequest, 'interval_startTime', 'interval.startTime')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggregateRequest, 'interval_endTime', 'interval.endTime')
encoding.AddCustomJsonFieldMapping(
    CloudsecuritycomplianceProjectsLocationsFrameworkComplianceReportsAggregateRequest, 'interval_startTime', 'interval.startTime')
