"""Generated client library for iam version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from samples.iam_sample.iam_v1 import iam_v1_messages as messages


class IamV1(base_api.BaseApiClient):
  """Generated client library for service iam version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://iam.googleapis.com/'
  MTLS_BASE_URL = ''

  _PACKAGE = 'iam'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = 'IamV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new iam handle."""
    url = url or self.BASE_URL
    super(IamV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.iamPolicies = self.IamPoliciesService(self)
    self.projects_serviceAccounts_keys = self.ProjectsServiceAccountsKeysService(self)
    self.projects_serviceAccounts = self.ProjectsServiceAccountsService(self)
    self.projects = self.ProjectsService(self)
    self.roles = self.RolesService(self)

  class IamPoliciesService(base_api.BaseApiService):
    """Service class for the iamPolicies resource."""

    _NAME = 'iamPolicies'

    def __init__(self, client):
      super(IamV1.IamPoliciesService, self).__init__(client)
      self._upload_configs = {
          }

    def GetPolicyDetails(self, request, global_params=None):
      r"""Returns the current IAM policy and the policies on the inherited resources.
that the user has access to.

      Args:
        request: (GetPolicyDetailsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GetPolicyDetailsResponse) The response message.
      """
      config = self.GetMethodConfig('GetPolicyDetails')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetPolicyDetails.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='iam.iamPolicies.getPolicyDetails',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/iamPolicies:getPolicyDetails',
        request_field='<request>',
        request_type_name='GetPolicyDetailsRequest',
        response_type_name='GetPolicyDetailsResponse',
        supports_download=False,
    )

  class ProjectsServiceAccountsKeysService(base_api.BaseApiService):
    """Service class for the projects_serviceAccounts_keys resource."""

    _NAME = 'projects_serviceAccounts_keys'

    def __init__(self, client):
      super(IamV1.ProjectsServiceAccountsKeysService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a ServiceAccountKey.
and returns it.

      Args:
        request: (IamProjectsServiceAccountsKeysCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountKey) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.keys.create',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/keys',
        request_field='createServiceAccountKeyRequest',
        request_type_name='IamProjectsServiceAccountsKeysCreateRequest',
        response_type_name='ServiceAccountKey',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ServiceAccountKey.

      Args:
        request: (IamProjectsServiceAccountsKeysDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}',
        http_method='DELETE',
        method_id='iam.projects.serviceAccounts.keys.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='IamProjectsServiceAccountsKeysDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the ServiceAccountKey.
by key id.

      Args:
        request: (IamProjectsServiceAccountsKeysGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccountKey) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys/{keysId}',
        http_method='GET',
        method_id='iam.projects.serviceAccounts.keys.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['publicKeyType'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='IamProjectsServiceAccountsKeysGetRequest',
        response_type_name='ServiceAccountKey',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceAccountKeys.

      Args:
        request: (IamProjectsServiceAccountsKeysListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountKeysResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}/keys',
        http_method='GET',
        method_id='iam.projects.serviceAccounts.keys.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['keyTypes'],
        relative_path='v1/{+name}/keys',
        request_field='',
        request_type_name='IamProjectsServiceAccountsKeysListRequest',
        response_type_name='ListServiceAccountKeysResponse',
        supports_download=False,
    )

  class ProjectsServiceAccountsService(base_api.BaseApiService):
    """Service class for the projects_serviceAccounts resource."""

    _NAME = 'projects_serviceAccounts'

    def __init__(self, client):
      super(IamV1.ProjectsServiceAccountsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a ServiceAccount.
and returns it.

      Args:
        request: (IamProjectsServiceAccountsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.create',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}/serviceAccounts',
        request_field='createServiceAccountRequest',
        request_type_name='IamProjectsServiceAccountsCreateRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a ServiceAccount.

      Args:
        request: (IamProjectsServiceAccountsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method='DELETE',
        method_id='iam.projects.serviceAccounts.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='IamProjectsServiceAccountsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets a ServiceAccount.

      Args:
        request: (IamProjectsServiceAccountsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method='GET',
        method_id='iam.projects.serviceAccounts.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='IamProjectsServiceAccountsGetRequest',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns the IAM access control policy for specified IAM resource.

      Args:
        request: (IamProjectsServiceAccountsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:getIamPolicy',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='IamProjectsServiceAccountsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists ServiceAccounts for a project.

      Args:
        request: (IamProjectsServiceAccountsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListServiceAccountsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts',
        http_method='GET',
        method_id='iam.projects.serviceAccounts.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['pageSize', 'pageToken', 'removeDeletedServiceAccounts'],
        relative_path='v1/{+name}/serviceAccounts',
        request_field='',
        request_type_name='IamProjectsServiceAccountsListRequest',
        response_type_name='ListServiceAccountsResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the IAM access control policy for the specified IAM resource.

      Args:
        request: (IamProjectsServiceAccountsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:setIamPolicy',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='IamProjectsServiceAccountsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def SignBlob(self, request, global_params=None):
      r"""Signs a blob using a service account's system-managed private key.

      Args:
        request: (IamProjectsServiceAccountsSignBlobRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignBlobResponse) The response message.
      """
      config = self.GetMethodConfig('SignBlob')
      return self._RunMethod(
          config, request, global_params=global_params)

    SignBlob.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signBlob',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.signBlob',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:signBlob',
        request_field='signBlobRequest',
        request_type_name='IamProjectsServiceAccountsSignBlobRequest',
        response_type_name='SignBlobResponse',
        supports_download=False,
    )

    def SignJwt(self, request, global_params=None):
      r"""Signs a JWT using a service account's system-managed private key.

If no `exp` (expiry) time is contained in the claims, we will
provide an expiry of one hour in the future. If an expiry
of more than one hour in the future is requested, the request
will fail.

      Args:
        request: (IamProjectsServiceAccountsSignJwtRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SignJwtResponse) The response message.
      """
      config = self.GetMethodConfig('SignJwt')
      return self._RunMethod(
          config, request, global_params=global_params)

    SignJwt.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:signJwt',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.signJwt',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:signJwt',
        request_field='signJwtRequest',
        request_type_name='IamProjectsServiceAccountsSignJwtRequest',
        response_type_name='SignJwtResponse',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests the specified permissions against the IAM access control policy.
for the specified IAM resource.

      Args:
        request: (IamProjectsServiceAccountsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}:testIamPermissions',
        http_method='POST',
        method_id='iam.projects.serviceAccounts.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='IamProjectsServiceAccountsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a ServiceAccount.

Currently, only the following fields are updatable:
`display_name` .
The `etag` is mandatory.

      Args:
        request: (ServiceAccount) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ServiceAccount) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/serviceAccounts/{serviceAccountsId}',
        http_method='PUT',
        method_id='iam.projects.serviceAccounts.update',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='<request>',
        request_type_name='ServiceAccount',
        response_type_name='ServiceAccount',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(IamV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }

  class RolesService(base_api.BaseApiService):
    """Service class for the roles resource."""

    _NAME = 'roles'

    def __init__(self, client):
      super(IamV1.RolesService, self).__init__(client)
      self._upload_configs = {
          }

    def QueryGrantableRoles(self, request, global_params=None):
      r"""Queries roles that can be granted on a particular resource.

      Args:
        request: (QueryGrantableRolesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (QueryGrantableRolesResponse) The response message.
      """
      config = self.GetMethodConfig('QueryGrantableRoles')
      return self._RunMethod(
          config, request, global_params=global_params)

    QueryGrantableRoles.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='iam.roles.queryGrantableRoles',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='v1/roles:queryGrantableRoles',
        request_field='<request>',
        request_type_name='QueryGrantableRolesRequest',
        response_type_name='QueryGrantableRolesResponse',
        supports_download=False,
    )
