"""Generated client library for cloudaicompanion version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudaicompanion.v1alpha import cloudaicompanion_v1alpha_messages as messages


class CloudaicompanionV1alpha(base_api.BaseApiClient):
  """Generated client library for service cloudaicompanion version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudaicompanion.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudaicompanion.mtls.googleapis.com/'

  _PACKAGE = 'cloudaicompanion'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudaicompanionV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudaicompanion handle."""
    url = url or self.BASE_URL
    super(CloudaicompanionV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_codeRepositoryIndexes_repositoryGroups = self.ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService(self)
    self.projects_locations_codeRepositoryIndexes = self.ProjectsLocationsCodeRepositoryIndexesService(self)
    self.projects_locations_enablements = self.ProjectsLocationsEnablementsService(self)
    self.projects_locations_instances = self.ProjectsLocationsInstancesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService(base_api.BaseApiService):
    """Service class for the projects_locations_codeRepositoryIndexes_repositoryGroups resource."""

    _NAME = 'projects_locations_codeRepositoryIndexes_repositoryGroups'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsCodeRepositoryIndexesRepositoryGroupsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new RepositoryGroup in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['repositoryGroupId', 'requestId'],
        relative_path='v1alpha/{+parent}/repositoryGroups',
        request_field='repositoryGroup',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RepositoryGroup) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest',
        response_type_name='RepositoryGroup',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:getIamPolicy',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists RepositoryGroups in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRepositoryGroupsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/repositoryGroups',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest',
        response_type_name='ListRepositoryGroupsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single RepositoryGroup.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='repositoryGroup',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:setIamPolicy',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}/repositoryGroups/{repositoryGroupsId}:testIamPermissions',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.repositoryGroups.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsCodeRepositoryIndexesService(base_api.BaseApiService):
    """Service class for the projects_locations_codeRepositoryIndexes resource."""

    _NAME = 'projects_locations_codeRepositoryIndexes'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsCodeRepositoryIndexesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new CodeRepositoryIndex in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['codeRepositoryIndexId', 'requestId'],
        relative_path='v1alpha/{+parent}/codeRepositoryIndexes',
        request_field='codeRepositoryIndex',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CodeRepositoryIndex) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest',
        response_type_name='CodeRepositoryIndex',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CodeRepositoryIndexes in a given project and location.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCodeRepositoryIndexesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/codeRepositoryIndexes',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest',
        response_type_name='ListCodeRepositoryIndexesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single CodeRepositoryIndex.

      Args:
        request: (CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/codeRepositoryIndexes/{codeRepositoryIndexesId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.codeRepositoryIndexes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='codeRepositoryIndex',
        request_type_name='CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsEnablementsService(base_api.BaseApiService):
    """Service class for the projects_locations_enablements resource."""

    _NAME = 'projects_locations_enablements'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsEnablementsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new enablement.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Enablement) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.enablements.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['enablementId'],
        relative_path='v1alpha/{+parent}/enablements',
        request_field='enablement',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsCreateRequest',
        response_type_name='Enablement',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an enablement. See https://google.aip.dev/164 for reference.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Enablement) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements/{enablementsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.enablements.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsDeleteRequest',
        response_type_name='Enablement',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets an enablement.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Enablement) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements/{enablementsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.enablements.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsGetRequest',
        response_type_name='Enablement',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists enablements.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEnablementsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.enablements.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'showDeleted'],
        relative_path='v1alpha/{+parent}/enablements',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsListRequest',
        response_type_name='ListEnablementsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an enablement.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Enablement) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements/{enablementsId}',
        http_method='PATCH',
        method_id='cloudaicompanion.projects.locations.enablements.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='enablement',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsPatchRequest',
        response_type_name='Enablement',
        supports_download=False,
    )

    def Undelete(self, request, global_params=None):
      r"""Undeletes an enablement. See https://google.aip.dev/164 for reference.

      Args:
        request: (CloudaicompanionProjectsLocationsEnablementsUndeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Enablement) The response message.
      """
      config = self.GetMethodConfig('Undelete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Undelete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/enablements/{enablementsId}:undelete',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.enablements.undelete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:undelete',
        request_field='undeleteEnablementRequest',
        request_type_name='CloudaicompanionProjectsLocationsEnablementsUndeleteRequest',
        response_type_name='Enablement',
        supports_download=False,
    )

  class ProjectsLocationsInstancesService(base_api.BaseApiService):
    """Service class for the projects_locations_instances resource."""

    _NAME = 'projects_locations_instances'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsInstancesService, self).__init__(client)
      self._upload_configs = {
          }

    def CompleteChat(self, request, global_params=None):
      r"""Completes a task based on some specification and context.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesCompleteChatRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaskCompletionResponse) The response message.
      """
      config = self.GetMethodConfig('CompleteChat')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteChat.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:completeChat',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.completeChat',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:completeChat',
        request_field='taskCompletionRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesCompleteChatRequest',
        response_type_name='TaskCompletionResponse',
        supports_download=False,
    )

    def CompleteCode(self, request, global_params=None):
      r"""Low latency code completion based on a prompt and some context.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CodeCompletionResponse) The response message.
      """
      config = self.GetMethodConfig('CompleteCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:completeCode',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.completeCode',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:completeCode',
        request_field='codeCompletionRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesCompleteCodeRequest',
        response_type_name='CodeCompletionResponse',
        supports_download=False,
    )

    def CompleteTask(self, request, global_params=None):
      r"""Completes a task based on some specification and context.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaskCompletionResponse) The response message.
      """
      config = self.GetMethodConfig('CompleteTask')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteTask.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:completeTask',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.completeTask',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:completeTask',
        request_field='taskCompletionRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesCompleteTaskRequest',
        response_type_name='TaskCompletionResponse',
        supports_download=False,
    )

    def GenerateCode(self, request, global_params=None):
      r"""Generate code based on a prompt and some context. This RPC has different latency profiles than code completion, if you need low latency code completion - consider using CompleteCode() instead.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CodeGenerationResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generateCode',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generateCode',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generateCode',
        request_field='codeGenerationRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGenerateCodeRequest',
        response_type_name='CodeGenerationResponse',
        supports_download=False,
    )

    def GenerateDataInsights(self, request, global_params=None):
      r"""Data Summarization: go/anarres-data-summarization Generates a summary with insights for the data passed in the request.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGenerateDataInsightsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateDataInsightsResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateDataInsights')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateDataInsights.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generateDataInsights',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generateDataInsights',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generateDataInsights',
        request_field='generateDataInsightsRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGenerateDataInsightsRequest',
        response_type_name='GenerateDataInsightsResponse',
        supports_download=False,
    )

    def GeneratePython(self, request, global_params=None):
      r"""NL2Python RPC to generate python code in response to a natural language request.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGeneratePythonRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GeneratePythonResponse) The response message.
      """
      config = self.GetMethodConfig('GeneratePython')
      return self._RunMethod(
          config, request, global_params=global_params)

    GeneratePython.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generatePython',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generatePython',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generatePython',
        request_field='generatePythonRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGeneratePythonRequest',
        response_type_name='GeneratePythonResponse',
        supports_download=False,
    )

    def GenerateSql(self, request, global_params=None):
      r"""NL2SQL RPC to generate a googlesql query response to a natural language request.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGenerateSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SqlGenResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generateSql',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generateSql',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generateSql',
        request_field='sqlGenRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGenerateSqlRequest',
        response_type_name='SqlGenResponse',
        supports_download=False,
    )

    def GenerateText(self, request, global_params=None):
      r"""Generates text based on a prompt and some context.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGenerateTextRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TextGenerationResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateText')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateText.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generateText',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generateText',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generateText',
        request_field='textGenerationRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGenerateTextRequest',
        response_type_name='TextGenerationResponse',
        supports_download=False,
    )

    def GenerateVisual(self, request, global_params=None):
      r"""NL2Chart: go/anarres-visualgen-dna-tech-talk Generates visual content (e.g., charts) from a natural language request.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesGenerateVisualRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (VisualGenResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateVisual')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateVisual.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:generateVisual',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.generateVisual',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:generateVisual',
        request_field='visualGenRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesGenerateVisualRequest',
        response_type_name='VisualGenResponse',
        supports_download=False,
    )

    def SummarizeData(self, request, global_params=None):
      r"""Data Summarization: go/anarres-data-summarization Generates a summary for the data/chart data passed in the request.

      Args:
        request: (CloudaicompanionProjectsLocationsInstancesSummarizeDataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SummarizeDataResponse) The response message.
      """
      config = self.GetMethodConfig('SummarizeData')
      return self._RunMethod(
          config, request, global_params=global_params)

    SummarizeData.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/instances/{instancesId}:summarizeData',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.instances.summarizeData',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:summarizeData',
        request_field='summarizeDataRequest',
        request_type_name='CloudaicompanionProjectsLocationsInstancesSummarizeDataRequest',
        response_type_name='SummarizeDataResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='CloudaicompanionProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='cloudaicompanion.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (CloudaicompanionProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def CompleteChat(self, request, global_params=None):
      r"""Completes a task based on some specification and context.

      Args:
        request: (CloudaicompanionProjectsLocationsCompleteChatRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TaskCompletionResponse) The response message.
      """
      config = self.GetMethodConfig('CompleteChat')
      return self._RunMethod(
          config, request, global_params=global_params)

    CompleteChat.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}:completeChat',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.completeChat',
        ordered_params=['instance'],
        path_params=['instance'],
        query_params=[],
        relative_path='v1alpha/{+instance}:completeChat',
        request_field='taskCompletionRequest',
        request_type_name='CloudaicompanionProjectsLocationsCompleteChatRequest',
        response_type_name='TaskCompletionResponse',
        supports_download=False,
    )

    def GenerateChat(self, request, global_params=None):
      r"""GenerateChat provides the chat experience.

      Args:
        request: (CloudaicompanionProjectsLocationsGenerateChatRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateChatResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateChat')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateChat.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}:generateChat',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.generateChat',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}:generateChat',
        request_field='generateChatRequest',
        request_type_name='CloudaicompanionProjectsLocationsGenerateChatRequest',
        response_type_name='GenerateChatResponse',
        supports_download=False,
    )

    def GenerateCode(self, request, global_params=None):
      r"""GenerateCode generates code given a prompt.

      Args:
        request: (CloudaicompanionProjectsLocationsGenerateCodeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (GenerateCodeResponse) The response message.
      """
      config = self.GetMethodConfig('GenerateCode')
      return self._RunMethod(
          config, request, global_params=global_params)

    GenerateCode.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}:generateCode',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.generateCode',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}:generateCode',
        request_field='generateCodeRequest',
        request_type_name='CloudaicompanionProjectsLocationsGenerateCodeRequest',
        response_type_name='GenerateCodeResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (CloudaicompanionProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def InferSchema(self, request, global_params=None):
      r"""RPC to infer schema upon raw file contents.

      Args:
        request: (CloudaicompanionProjectsLocationsInferSchemaRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InferSchemaResponse) The response message.
      """
      config = self.GetMethodConfig('InferSchema')
      return self._RunMethod(
          config, request, global_params=global_params)

    InferSchema.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}:inferSchema',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.inferSchema',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}:inferSchema',
        request_field='inferSchemaRequest',
        request_type_name='CloudaicompanionProjectsLocationsInferSchemaRequest',
        response_type_name='InferSchemaResponse',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (CloudaicompanionProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='cloudaicompanion.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='CloudaicompanionProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

    def TranslateSql(self, request, global_params=None):
      r"""RPC to translate sql query from different dialect.

      Args:
        request: (CloudaicompanionProjectsLocationsTranslateSqlRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SqlTranslateResponse) The response message.
      """
      config = self.GetMethodConfig('TranslateSql')
      return self._RunMethod(
          config, request, global_params=global_params)

    TranslateSql.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}:translateSql',
        http_method='POST',
        method_id='cloudaicompanion.projects.locations.translateSql',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=[],
        relative_path='v1alpha/{+parent}:translateSql',
        request_field='sqlTranslateRequest',
        request_type_name='CloudaicompanionProjectsLocationsTranslateSqlRequest',
        response_type_name='SqlTranslateResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudaicompanionV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
